/*
 * Decompiled with CFR 0.152.
 */
package org.osiam.auth.token;

import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import org.osiam.auth.oauth_client.ClientRepository;
import org.osiam.client.oauth.AccessToken;
import org.osiam.client.oauth.Scope;
import org.osiam.resources.provisioning.SCIMUserProvisioning;
import org.osiam.resources.scim.User;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.oauth2.common.DefaultOAuth2AccessToken;
import org.springframework.security.oauth2.common.OAuth2AccessToken;
import org.springframework.security.oauth2.provider.OAuth2Authentication;
import org.springframework.security.oauth2.provider.OAuth2Request;
import org.springframework.security.oauth2.provider.token.TokenStore;
import org.springframework.stereotype.Service;

@Service
public class TokenService {
    private final TokenStore tokenStore;
    private final SCIMUserProvisioning userProvisioning;
    private final ClientRepository clientRepository;

    @Autowired
    public TokenService(TokenStore tokenStore, SCIMUserProvisioning userProvisioning, ClientRepository clientRepository) {
        this.tokenStore = tokenStore;
        this.userProvisioning = userProvisioning;
        this.clientRepository = clientRepository;
    }

    public AccessToken validateToken(String token) {
        OAuth2Authentication auth = this.tokenStore.readAuthentication(token);
        OAuth2AccessToken accessToken = this.tokenStore.getAccessToken(auth);
        OAuth2Request authReq = auth.getOAuth2Request();
        AccessToken.Builder tokenBuilder = new AccessToken.Builder(token).setClientId(authReq.getClientId());
        if (auth.getUserAuthentication() != null && auth.getPrincipal() instanceof User) {
            User user = (User)auth.getPrincipal();
            tokenBuilder.setUserName(user.getUserName());
            tokenBuilder.setUserId(user.getId());
        }
        tokenBuilder.setExpiresAt(accessToken.getExpiration());
        for (String scopeString : authReq.getScope()) {
            tokenBuilder.addScope(new Scope(scopeString));
        }
        return tokenBuilder.build();
    }

    public void revokeToken(String token) {
        this.tokenStore.removeAccessToken((OAuth2AccessToken)new DefaultOAuth2AccessToken(token));
    }

    public void revokeAllTokensOfUser(String userId) {
        User user = this.userProvisioning.getById(userId);
        String searchKey = new User.Builder(user.getUserName()).setId(userId).build().toString();
        List clientIds = this.clientRepository.findAllClientIds();
        LinkedList tokens = new LinkedList();
        for (String clientId : clientIds) {
            Collection tokenForClient = this.tokenStore.findTokensByClientIdAndUserName(clientId, searchKey);
            tokens.addAll(tokenForClient);
        }
        for (OAuth2AccessToken token : tokens) {
            this.tokenStore.removeAccessToken(token);
        }
    }
}

