/*
 * Decompiled with CFR 0.152.
 */
package org.osiam.configuration;

import java.util.Arrays;
import org.osiam.auth.login.oauth.OsiamResourceOwnerPasswordTokenGranter;
import org.osiam.auth.token.OsiamTokenEnhancer;
import org.osiam.security.authentication.OsiamClientDetailsService;
import org.osiam.security.authorization.OsiamUserApprovalHandler;
import org.osiam.security.helper.LessStrictRedirectUriAuthorizationCodeTokenGranter;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.security.authentication.AuthenticationManager;
import org.springframework.security.oauth2.config.annotation.configurers.ClientDetailsServiceConfigurer;
import org.springframework.security.oauth2.config.annotation.web.configuration.AuthorizationServerConfigurerAdapter;
import org.springframework.security.oauth2.config.annotation.web.configuration.EnableAuthorizationServer;
import org.springframework.security.oauth2.config.annotation.web.configurers.AuthorizationServerEndpointsConfigurer;
import org.springframework.security.oauth2.config.annotation.web.configurers.AuthorizationServerSecurityConfigurer;
import org.springframework.security.oauth2.provider.ClientDetailsService;
import org.springframework.security.oauth2.provider.CompositeTokenGranter;
import org.springframework.security.oauth2.provider.OAuth2RequestFactory;
import org.springframework.security.oauth2.provider.TokenGranter;
import org.springframework.security.oauth2.provider.approval.UserApprovalHandler;
import org.springframework.security.oauth2.provider.client.ClientCredentialsTokenGranter;
import org.springframework.security.oauth2.provider.code.AuthorizationCodeServices;
import org.springframework.security.oauth2.provider.code.InMemoryAuthorizationCodeServices;
import org.springframework.security.oauth2.provider.refresh.RefreshTokenGranter;
import org.springframework.security.oauth2.provider.request.DefaultOAuth2RequestFactory;
import org.springframework.security.oauth2.provider.token.AuthorizationServerTokenServices;
import org.springframework.security.oauth2.provider.token.DefaultTokenServices;
import org.springframework.security.oauth2.provider.token.TokenEnhancer;
import org.springframework.security.oauth2.provider.token.TokenStore;
import org.springframework.security.oauth2.provider.token.store.InMemoryTokenStore;

@Configuration
@EnableAuthorizationServer
public class OAuth2AuthorizationServerConfig
extends AuthorizationServerConfigurerAdapter {
    @Autowired
    private AuthenticationManager authenticationManager;
    @Autowired
    private OsiamClientDetailsService osiamClientDetailsService;
    @Autowired
    private OsiamUserApprovalHandler userApprovalHandler;

    public void configure(AuthorizationServerEndpointsConfigurer endpoints) throws Exception {
        endpoints.userApprovalHandler((UserApprovalHandler)this.userApprovalHandler).requestFactory(this.oAuth2RequestFactory()).authorizationCodeServices(this.authorizationCodeServices()).tokenServices((AuthorizationServerTokenServices)this.tokenServices()).tokenEnhancer(this.osiamTokenEnhancer()).tokenGranter(this.tokenGranter());
    }

    public void configure(ClientDetailsServiceConfigurer clients) throws Exception {
        clients.withClientDetails((ClientDetailsService)this.osiamClientDetailsService).build();
    }

    public void configure(AuthorizationServerSecurityConfigurer security) throws Exception {
        security.allowFormAuthenticationForClients();
    }

    @Bean
    public TokenGranter tokenGranter() throws Exception {
        return new CompositeTokenGranter(Arrays.asList(new ClientCredentialsTokenGranter((AuthorizationServerTokenServices)this.tokenServices(), (ClientDetailsService)this.osiamClientDetailsService, this.oAuth2RequestFactory()), new OsiamResourceOwnerPasswordTokenGranter(this.authenticationManager, (AuthorizationServerTokenServices)this.tokenServices(), (ClientDetailsService)this.osiamClientDetailsService, this.oAuth2RequestFactory()), new RefreshTokenGranter((AuthorizationServerTokenServices)this.tokenServices(), (ClientDetailsService)this.osiamClientDetailsService, this.oAuth2RequestFactory()), new LessStrictRedirectUriAuthorizationCodeTokenGranter((AuthorizationServerTokenServices)this.tokenServices(), this.authorizationCodeServices(), (ClientDetailsService)this.osiamClientDetailsService, this.oAuth2RequestFactory())));
    }

    @Bean
    public OAuth2RequestFactory oAuth2RequestFactory() {
        return new DefaultOAuth2RequestFactory((ClientDetailsService)this.osiamClientDetailsService);
    }

    @Bean
    public AuthorizationCodeServices authorizationCodeServices() {
        return new InMemoryAuthorizationCodeServices();
    }

    @Bean
    public DefaultTokenServices tokenServices() throws Exception {
        DefaultTokenServices tokenServices = new DefaultTokenServices();
        tokenServices.setTokenStore(this.tokenStore());
        tokenServices.setSupportRefreshToken(true);
        tokenServices.setReuseRefreshToken(true);
        tokenServices.setClientDetailsService((ClientDetailsService)this.osiamClientDetailsService);
        tokenServices.setTokenEnhancer(this.osiamTokenEnhancer());
        tokenServices.afterPropertiesSet();
        return tokenServices;
    }

    @Bean
    public TokenEnhancer osiamTokenEnhancer() {
        return new OsiamTokenEnhancer();
    }

    @Bean
    public TokenStore tokenStore() {
        return new InMemoryTokenStore();
    }
}

