/*
 * Decompiled with CFR 0.152.
 */
package org.osiam.resources.controller;

import java.io.IOException;
import java.util.Map;
import javax.validation.Valid;
import org.osiam.resources.controller.ResourceController;
import org.osiam.resources.provisioning.SCIMGroupProvisioning;
import org.osiam.resources.scim.Group;
import org.osiam.resources.scim.Resource;
import org.osiam.resources.scim.SCIMSearchResult;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.http.converter.json.MappingJacksonValue;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.util.UriComponentsBuilder;

@RequestMapping(value={"/Groups"})
@Transactional
@RestController
public class GroupController
extends ResourceController<Group> {
    private final SCIMGroupProvisioning scimGroupProvisioning;

    @Autowired
    public GroupController(SCIMGroupProvisioning scimGroupProvisioning) {
        this.scimGroupProvisioning = scimGroupProvisioning;
    }

    @RequestMapping(method={RequestMethod.POST})
    public ResponseEntity<MappingJacksonValue> create(@RequestBody @Valid Group group, @RequestParam(required=false) String attributes, UriComponentsBuilder builder) throws IOException {
        Group createdGroup = this.scimGroupProvisioning.create(group);
        return this.buildResponseWithLocation((Resource)createdGroup, builder, HttpStatus.CREATED, attributes);
    }

    @RequestMapping(value={"/{id}"}, method={RequestMethod.GET})
    public MappingJacksonValue get(@PathVariable String id, @RequestParam(required=false) String attributes) {
        Group group = this.scimGroupProvisioning.getById(id);
        return this.buildResponse((Object)group, attributes);
    }

    @RequestMapping(value={"/{id}"}, method={RequestMethod.DELETE})
    @ResponseStatus(value=HttpStatus.OK)
    public void delete(@PathVariable String id) {
        this.scimGroupProvisioning.delete(id);
    }

    @RequestMapping(value={"/{id}"}, method={RequestMethod.PUT})
    public ResponseEntity<MappingJacksonValue> replace(@PathVariable String id, @RequestBody @Valid Group group, @RequestParam(required=false) String attributes, UriComponentsBuilder builder) throws IOException {
        Group updatedGroup = this.scimGroupProvisioning.replace(id, group);
        return this.buildResponseWithLocation((Resource)updatedGroup, builder, HttpStatus.OK, attributes);
    }

    @RequestMapping(value={"/{id}"}, method={RequestMethod.PATCH})
    public ResponseEntity<MappingJacksonValue> update(@PathVariable String id, @RequestBody Group group, UriComponentsBuilder builder) throws IOException {
        Group updatedGroup = this.scimGroupProvisioning.update(id, group);
        return this.buildResponseWithLocation((Resource)updatedGroup, builder, HttpStatus.OK, "");
    }

    @RequestMapping(method={RequestMethod.GET})
    public MappingJacksonValue searchWithGet(@RequestParam Map<String, String> requestParameters) {
        return this.searchWithPost(requestParameters);
    }

    @RequestMapping(value={"/.search"}, method={RequestMethod.POST})
    public MappingJacksonValue searchWithPost(@RequestParam Map<String, String> requestParameters) {
        SCIMSearchResult scimSearchResult = this.scimGroupProvisioning.search(requestParameters.get("filter"), requestParameters.get("sortBy"), requestParameters.getOrDefault("sortOrder", "ascending"), Integer.parseInt(requestParameters.getOrDefault("count", "100")), Integer.parseInt(requestParameters.getOrDefault("startIndex", "1")));
        String attributes = requestParameters.containsKey("attributes") ? requestParameters.get("attributes") : "";
        return this.buildResponse((Object)scimSearchResult, attributes);
    }
}

