/*
 * Decompiled with CFR 0.152.
 */
package org.osiam.resources.controller;

import java.io.IOException;
import java.util.Map;
import javax.validation.Valid;
import org.osiam.auth.token.TokenService;
import org.osiam.resources.controller.ResourceController;
import org.osiam.resources.provisioning.SCIMUserProvisioning;
import org.osiam.resources.scim.Resource;
import org.osiam.resources.scim.SCIMSearchResult;
import org.osiam.resources.scim.User;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.http.converter.json.MappingJacksonValue;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.util.UriComponentsBuilder;

@RestController
@RequestMapping(value={"/Users"})
@Transactional
public class UserController
extends ResourceController<User> {
    private final SCIMUserProvisioning scimUserProvisioning;
    private final TokenService tokenService;

    @Autowired
    public UserController(SCIMUserProvisioning scimUserProvisioning, TokenService tokenService) {
        this.scimUserProvisioning = scimUserProvisioning;
        this.tokenService = tokenService;
    }

    @RequestMapping(value={"/{id}"}, method={RequestMethod.GET})
    public MappingJacksonValue getUser(@PathVariable String id, @RequestParam(required=false) String attributes) {
        User user = this.scimUserProvisioning.getById(id);
        return this.buildResponse((Object)user, attributes);
    }

    @RequestMapping(method={RequestMethod.POST})
    public ResponseEntity<MappingJacksonValue> create(@RequestBody @Valid User user, @RequestParam(required=false) String attributes, UriComponentsBuilder builder) throws IOException {
        User createdUser = this.scimUserProvisioning.create(user);
        return this.buildResponseWithLocation((Resource)createdUser, builder, HttpStatus.CREATED, attributes);
    }

    @RequestMapping(value={"/{id}"}, method={RequestMethod.PUT})
    public ResponseEntity<MappingJacksonValue> replace(@PathVariable String id, @RequestBody @Valid User user, @RequestParam(required=false) String attributes, UriComponentsBuilder builder) throws IOException {
        User createdUser = this.scimUserProvisioning.replace(id, user);
        this.checkAndHandleDeactivation(id, user);
        return this.buildResponseWithLocation((Resource)createdUser, builder, HttpStatus.OK, attributes);
    }

    @RequestMapping(value={"/{id}"}, method={RequestMethod.PATCH})
    public ResponseEntity<MappingJacksonValue> update(@PathVariable String id, @RequestBody User user, UriComponentsBuilder builder) throws IOException {
        User createdUser = this.scimUserProvisioning.update(id, user);
        this.checkAndHandleDeactivation(id, user);
        return this.buildResponseWithLocation((Resource)createdUser, builder, HttpStatus.OK, "");
    }

    @RequestMapping(value={"/{id}"}, method={RequestMethod.DELETE})
    @ResponseStatus(value=HttpStatus.OK)
    public void delete(@PathVariable String id) {
        this.tokenService.revokeAllTokensOfUser(id);
        this.scimUserProvisioning.delete(id);
    }

    @RequestMapping(method={RequestMethod.GET})
    public MappingJacksonValue searchWithGet(@RequestParam Map<String, String> requestParameters) {
        return this.searchWithPost(requestParameters);
    }

    @RequestMapping(value={"/.search"}, method={RequestMethod.POST})
    public MappingJacksonValue searchWithPost(@RequestParam Map<String, String> requestParameters) {
        SCIMSearchResult scimSearchResult = this.scimUserProvisioning.search(requestParameters.get("filter"), requestParameters.get("sortBy"), requestParameters.getOrDefault("sortOrder", "ascending"), Integer.parseInt(requestParameters.getOrDefault("count", "100")), Integer.parseInt(requestParameters.getOrDefault("startIndex", "1")));
        String attributes = requestParameters.containsKey("attributes") ? requestParameters.get("attributes") : "";
        return this.buildResponse((Object)scimSearchResult, attributes);
    }

    private void checkAndHandleDeactivation(String id, User updateUser) {
        if (updateUser.isActive() != null && !updateUser.isActive().booleanValue()) {
            this.tokenService.revokeAllTokensOfUser(id);
        }
    }
}

