/*
 * Decompiled with CFR 0.152.
 */
package org.osiam.resources.converter;

import java.net.URI;
import java.net.URISyntaxException;
import org.osiam.resources.converter.Converter;
import org.osiam.resources.exception.OsiamException;
import org.osiam.resources.scim.Photo;
import org.osiam.storage.entities.PhotoEntity;
import org.springframework.stereotype.Service;

@Service
public class PhotoConverter
implements Converter<Photo, PhotoEntity> {
    public PhotoEntity fromScim(Photo scim) {
        PhotoEntity photoEntity = new PhotoEntity();
        photoEntity.setValue(scim.getValueAsURI().toString());
        photoEntity.setType(scim.getType());
        photoEntity.setPrimary(scim.isPrimary());
        photoEntity.setDisplay(scim.getDisplay());
        return photoEntity;
    }

    public Photo toScim(PhotoEntity entity) {
        Photo scimPhoto;
        try {
            scimPhoto = new Photo.Builder().setType(entity.getType()).setValue(new URI(entity.getValue())).setPrimary(entity.isPrimary()).setDisplay(entity.getDisplay()).build();
        }
        catch (URISyntaxException e) {
            throw new OsiamException(e.getMessage(), (Throwable)e);
        }
        return scimPhoto;
    }
}

