/*
 * Decompiled with CFR 0.152.
 */
package org.osiam.resources.data;

import com.google.common.base.Strings;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import javax.xml.bind.DatatypeConverter;
import org.apache.tika.Tika;
import org.apache.tika.io.IOUtils;
import org.osiam.resources.exception.SCIMDataValidationException;

public class DataURI {
    public static final String DATA = "data:";
    public static final String BASE64 = ";base64,";
    private URI dataUri;

    public DataURI(String dataUri) {
        if (Strings.isNullOrEmpty((String)dataUri)) {
            throw new SCIMDataValidationException("The given string can't be null or empty.");
        }
        if (!dataUri.startsWith(DATA) || !dataUri.contains(BASE64)) {
            throw new SCIMDataValidationException("The given string '" + dataUri + "' is not a data URI.");
        }
        try {
            this.dataUri = new URI(dataUri);
        }
        catch (URISyntaxException e) {
            throw new SCIMDataValidationException(e.getMessage(), (Throwable)e);
        }
    }

    public DataURI(URI dataUri) {
        if (dataUri == null) {
            throw new SCIMDataValidationException("The given dataUri can't be null.");
        }
        if (!dataUri.toString().startsWith(DATA) || !dataUri.toString().contains(BASE64)) {
            throw new SCIMDataValidationException("The given URI '" + dataUri.toString() + "' is not a data URI.");
        }
        this.dataUri = dataUri;
    }

    public DataURI(InputStream inputStream) throws IOException {
        if (inputStream == null) {
            throw new SCIMDataValidationException("The given inputStream can't be null.");
        }
        String mimeType = new Tika().detect(inputStream);
        this.dataUri = this.convertInputStreamToDataURI(inputStream, mimeType);
    }

    private URI convertInputStreamToDataURI(InputStream inputStream, String mimeType) throws IOException {
        URI retDataUri;
        byte[] byteArrayPhoto = IOUtils.toByteArray((InputStream)inputStream);
        String base64Photo = DatatypeConverter.printBase64Binary((byte[])byteArrayPhoto);
        StringBuilder uriStringBuilder = new StringBuilder();
        uriStringBuilder.append(DATA).append(mimeType).append(BASE64).append(base64Photo);
        try {
            retDataUri = new URI(uriStringBuilder.toString());
        }
        catch (URISyntaxException e) {
            throw new SCIMDataValidationException(e.getMessage(), (Throwable)e);
        }
        return retDataUri;
    }

    public URI getAsURI() {
        return this.dataUri;
    }

    public InputStream getAsInputStream() {
        String imageCode = this.dataUri.toString().substring(this.dataUri.toString().indexOf(BASE64) + BASE64.length());
        byte[] decodedBytes = DatatypeConverter.parseBase64Binary((String)imageCode);
        return new ByteArrayInputStream(decodedBytes);
    }

    public String getMimeType() {
        String uriString = this.dataUri.toString();
        return uriString.substring(DATA.length(), uriString.indexOf(BASE64));
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + (this.dataUri == null ? 0 : this.dataUri.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        DataURI other = (DataURI)obj;
        return !(this.dataUri == null ? other.dataUri != null : !this.dataUri.equals(other.dataUri));
    }

    public String toString() {
        return this.dataUri.toString();
    }
}

