/*
 * Decompiled with CFR 0.152.
 */
package org.osiam.resources.provisioning.update;

import com.google.common.base.Strings;
import java.util.List;
import java.util.Set;
import org.osiam.resources.converter.EmailConverter;
import org.osiam.resources.scim.Email;
import org.osiam.storage.entities.EmailEntity;
import org.osiam.storage.entities.UserEntity;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
class EmailUpdater {
    private final EmailConverter emailConverter;

    @Autowired
    public EmailUpdater(EmailConverter emailConverter) {
        this.emailConverter = emailConverter;
    }

    void update(List<Email> emails, UserEntity userEntity, Set<String> attributes) {
        if (attributes.contains("emails")) {
            userEntity.removeAllEmails();
        }
        if (emails != null) {
            for (Email scimEmail : emails) {
                EmailEntity emailEntity = this.emailConverter.fromScim(scimEmail);
                userEntity.removeEmail(emailEntity);
                if (!Strings.isNullOrEmpty((String)scimEmail.getOperation()) && scimEmail.getOperation().equalsIgnoreCase("delete")) continue;
                this.ensureOnlyOnePrimaryEmailExists(emailEntity, userEntity.getEmails());
                userEntity.addEmail(emailEntity);
            }
        }
    }

    private void ensureOnlyOnePrimaryEmailExists(EmailEntity newEmail, Set<EmailEntity> emails) {
        if (newEmail.isPrimary()) {
            for (EmailEntity exisitngEmailEntity : emails) {
                if (!exisitngEmailEntity.isPrimary()) continue;
                exisitngEmailEntity.setPrimary(false);
            }
        }
    }
}

