/*
 * Decompiled with CFR 0.152.
 */
package org.osiam.resources.provisioning.update;

import com.google.common.base.Strings;
import java.util.HashSet;
import java.util.Set;
import org.osiam.resources.exception.OsiamException;
import org.osiam.resources.exception.ResourceExistsException;
import org.osiam.resources.provisioning.update.AddressUpdater;
import org.osiam.resources.provisioning.update.EmailUpdater;
import org.osiam.resources.provisioning.update.EntitlementsUpdater;
import org.osiam.resources.provisioning.update.ExtensionUpdater;
import org.osiam.resources.provisioning.update.ImUpdater;
import org.osiam.resources.provisioning.update.NameUpdater;
import org.osiam.resources.provisioning.update.PhoneNumberUpdater;
import org.osiam.resources.provisioning.update.PhotoUpdater;
import org.osiam.resources.provisioning.update.ResourceUpdater;
import org.osiam.resources.provisioning.update.RoleUpdater;
import org.osiam.resources.provisioning.update.X509CertificateUpdater;
import org.osiam.resources.scim.Resource;
import org.osiam.resources.scim.User;
import org.osiam.storage.dao.UserDao;
import org.osiam.storage.entities.ResourceEntity;
import org.osiam.storage.entities.UserEntity;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.crypto.bcrypt.BCryptPasswordEncoder;
import org.springframework.stereotype.Service;

@Service
public class UserUpdater {
    private final UserDao userDao;
    private final ResourceUpdater resourceUpdater;
    private final NameUpdater nameUpdater;
    private final EmailUpdater emailUpdater;
    private final PhoneNumberUpdater phoneNumberUpdater;
    private final ImUpdater imUpdater;
    private final PhotoUpdater photoUpdater;
    private final EntitlementsUpdater entitlementUpdater;
    private final RoleUpdater roleUpdater;
    private final X509CertificateUpdater x509CertificateUpdater;
    private final AddressUpdater addressUpdater;
    private final BCryptPasswordEncoder bCryptPasswordEncoder;
    private final ExtensionUpdater extensionUpdater;

    @Autowired
    public UserUpdater(UserDao userDao, ResourceUpdater resourceUpdater, NameUpdater nameUpdater, EmailUpdater emailUpdater, PhoneNumberUpdater phoneNumberUpdater, ImUpdater imUpdater, PhotoUpdater photoUpdater, EntitlementsUpdater entitlementUpdater, RoleUpdater roleUpdater, X509CertificateUpdater x509CertificateUpdater, AddressUpdater addressUpdater, BCryptPasswordEncoder bCryptPasswordEncoder, ExtensionUpdater extensionUpdater) {
        this.userDao = userDao;
        this.resourceUpdater = resourceUpdater;
        this.nameUpdater = nameUpdater;
        this.emailUpdater = emailUpdater;
        this.phoneNumberUpdater = phoneNumberUpdater;
        this.imUpdater = imUpdater;
        this.photoUpdater = photoUpdater;
        this.entitlementUpdater = entitlementUpdater;
        this.roleUpdater = roleUpdater;
        this.x509CertificateUpdater = x509CertificateUpdater;
        this.addressUpdater = addressUpdater;
        this.bCryptPasswordEncoder = bCryptPasswordEncoder;
        this.extensionUpdater = extensionUpdater;
    }

    public void update(User user, UserEntity userEntity) {
        this.resourceUpdater.update((Resource)user, (ResourceEntity)userEntity);
        Set attributes = new HashSet();
        if (user.getMeta() != null && user.getMeta().getAttributes() != null) {
            attributes = user.getMeta().getAttributes();
        }
        this.updateUserName(user, userEntity, attributes);
        this.nameUpdater.update(user.getName(), userEntity, attributes);
        this.updateDisplayName(user, userEntity, attributes);
        this.updateNickName(user, userEntity, attributes);
        this.updateProfileUrl(user, userEntity, attributes);
        this.updateTitle(user, userEntity, attributes);
        this.updateUserType(user, userEntity, attributes);
        this.updatePreferredLanguage(user, userEntity, attributes);
        this.updateLocale(user, userEntity, attributes);
        this.updateTimezone(user, userEntity, attributes);
        this.updateActive(user, userEntity, attributes);
        this.updatePassword(user, userEntity, attributes);
        this.emailUpdater.update(user.getEmails(), userEntity, attributes);
        this.phoneNumberUpdater.update(user.getPhoneNumbers(), userEntity, attributes);
        this.imUpdater.update(user.getIms(), userEntity, attributes);
        this.photoUpdater.update(user.getPhotos(), userEntity, attributes);
        this.addressUpdater.update(user.getAddresses(), userEntity, attributes);
        this.updateGroups(user, attributes);
        this.entitlementUpdater.update(user.getEntitlements(), userEntity, attributes);
        this.roleUpdater.update(user.getRoles(), userEntity, attributes);
        this.x509CertificateUpdater.update(user.getX509Certificates(), userEntity, attributes);
        this.extensionUpdater.update(user.getExtensions(), userEntity, attributes);
    }

    private void updateUserName(User user, UserEntity userEntity, Set<String> attributes) {
        if (attributes.contains("userName")) {
            throw new OsiamException("Attribute 'userName' cannot be deleted.");
        }
        String userName = user.getUserName();
        if (!Strings.isNullOrEmpty((String)userName)) {
            if (this.userDao.isUserNameAlreadyTaken(userName, userEntity.getId().toString())) {
                throw new ResourceExistsException(String.format("User with userName '%s' already exists", userName));
            }
            userEntity.setUserName(userName);
        }
    }

    private void updateDisplayName(User user, UserEntity userEntity, Set<String> attributes) {
        if (attributes.contains("displayName")) {
            userEntity.setDisplayName(null);
        }
        if (!Strings.isNullOrEmpty((String)user.getDisplayName())) {
            userEntity.setDisplayName(user.getDisplayName());
        }
    }

    private void updateNickName(User user, UserEntity userEntity, Set<String> attributes) {
        if (attributes.contains("nickName")) {
            userEntity.setNickName(null);
        }
        if (!Strings.isNullOrEmpty((String)user.getNickName())) {
            userEntity.setNickName(user.getNickName());
        }
    }

    private void updateProfileUrl(User user, UserEntity userEntity, Set<String> attributes) {
        if (attributes.contains("profileUrl")) {
            userEntity.setProfileUrl(null);
        }
        if (!Strings.isNullOrEmpty((String)user.getProfileUrl())) {
            userEntity.setProfileUrl(user.getProfileUrl());
        }
    }

    private void updateTitle(User user, UserEntity userEntity, Set<String> attributes) {
        if (attributes.contains("title")) {
            userEntity.setTitle(null);
        }
        if (!Strings.isNullOrEmpty((String)user.getTitle())) {
            userEntity.setTitle(user.getTitle());
        }
    }

    private void updateUserType(User user, UserEntity userEntity, Set<String> attributes) {
        if (attributes.contains("userType")) {
            userEntity.setUserType(null);
        }
        if (!Strings.isNullOrEmpty((String)user.getUserType())) {
            userEntity.setUserType(user.getUserType());
        }
    }

    private void updatePreferredLanguage(User user, UserEntity userEntity, Set<String> attributes) {
        if (attributes.contains("preferredLanguage")) {
            userEntity.setPreferredLanguage(null);
        }
        if (!Strings.isNullOrEmpty((String)user.getPreferredLanguage())) {
            userEntity.setPreferredLanguage(user.getPreferredLanguage());
        }
    }

    private void updateLocale(User user, UserEntity userEntity, Set<String> attributes) {
        if (attributes.contains("locale")) {
            userEntity.setLocale(null);
        }
        if (!Strings.isNullOrEmpty((String)user.getLocale())) {
            userEntity.setLocale(user.getLocale());
        }
    }

    private void updateTimezone(User user, UserEntity userEntity, Set<String> attributes) {
        if (attributes.contains("timezone")) {
            userEntity.setTimezone(null);
        }
        if (!Strings.isNullOrEmpty((String)user.getTimezone())) {
            userEntity.setTimezone(user.getTimezone());
        }
    }

    private void updateActive(User user, UserEntity userEntity, Set<String> attributes) {
        if (attributes.contains("active")) {
            userEntity.setActive(null);
        }
        if (user.isActive() != null) {
            userEntity.setActive(user.isActive());
        }
    }

    private void updatePassword(User user, UserEntity userEntity, Set<String> attributes) {
        if (attributes.contains("password")) {
            throw new OsiamException("Attribute 'password' cannot be deleted.");
        }
        if (!Strings.isNullOrEmpty((String)user.getPassword())) {
            String hashedPassword = this.bCryptPasswordEncoder.encode((CharSequence)user.getPassword());
            userEntity.setPassword(hashedPassword);
        }
    }

    private void updateGroups(User user, Set<String> attributes) {
        if (attributes.contains("groups") || user.getGroups().size() > 0) {
            throw new OsiamException("The membership to a group can't be modified. Please use the group update.");
        }
    }
}

