/*
 * Decompiled with CFR 0.152.
 */
package org.osiam.security.authentication;

import org.osiam.auth.oauth_client.ClientEntity;
import org.osiam.auth.oauth_client.ClientRepository;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.oauth2.provider.ClientDetails;
import org.springframework.security.oauth2.provider.ClientDetailsService;
import org.springframework.security.oauth2.provider.NoSuchClientException;
import org.springframework.stereotype.Service;

@Service
public class OsiamClientDetailsService
implements ClientDetailsService {
    private final ClientRepository clientRepository;

    @Autowired
    public OsiamClientDetailsService(ClientRepository clientRepository) {
        this.clientRepository = clientRepository;
    }

    public ClientDetails loadClientByClientId(String clientId) {
        ClientEntity client = this.clientRepository.findById(clientId);
        if (client == null) {
            throw new NoSuchClientException(String.format("OsiamClientDetailsService failed to load client with id %s: no client found", clientId));
        }
        return client;
    }
}

