/*
 * Decompiled with CFR 0.152.
 */
package org.osiam.security.controller;

import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.oauth2.provider.AuthorizationRequest;
import org.springframework.security.oauth2.provider.ClientDetails;
import org.springframework.security.oauth2.provider.ClientDetailsService;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.SessionAttributes;
import org.springframework.web.servlet.ModelAndView;

@Controller
@SessionAttributes(value={"authorizationRequest"})
@RequestMapping(value={"/oauth"})
public class AccessConfirmationController {
    private final ClientDetailsService clientDetailsService;

    @Autowired
    public AccessConfirmationController(ClientDetailsService clientDetailsService) {
        this.clientDetailsService = clientDetailsService;
    }

    @RequestMapping(value={"/confirm_access"})
    public ModelAndView getAccessConfirmation(Map<String, Object> model) {
        AuthorizationRequest clientAuth = (AuthorizationRequest)model.remove("authorizationRequest");
        if (clientAuth == null) {
            return new ModelAndView("redirect:/oauth/error");
        }
        String clientId = clientAuth.getClientId();
        ClientDetails client = this.clientDetailsService.loadClientByClientId(clientId);
        if (client == null) {
            return new ModelAndView("redirect:/oauth/error");
        }
        model.put("auth_request", clientAuth);
        model.put("client", client);
        model.put("loginError", false);
        return new ModelAndView("access_confirmation", model);
    }

    @RequestMapping(value={"/error"})
    public String handleError() {
        return "oauth_error";
    }
}

