/*
 * Decompiled with CFR 0.152.
 */
package org.osiam.storage.dao;

import org.antlr.v4.runtime.tree.ParseTree;
import org.osiam.resources.exception.ResourceNotFoundException;
import org.osiam.storage.dao.GenericDao;
import org.osiam.storage.dao.ResourceDao;
import org.osiam.storage.dao.SearchResult;
import org.osiam.storage.entities.GroupEntity;
import org.osiam.storage.entities.GroupEntity_;
import org.osiam.storage.entities.ResourceEntity;
import org.osiam.storage.query.FilterParser;
import org.osiam.storage.query.GroupFilterParser;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;

@Repository
public class GroupDao
implements GenericDao<GroupEntity> {
    private final GroupFilterParser filterParser;
    private final ResourceDao resourceDao;

    @Autowired
    public GroupDao(ResourceDao resourceDao, GroupFilterParser filterParser) {
        this.resourceDao = resourceDao;
        this.filterParser = filterParser;
    }

    public void create(GroupEntity group) {
        this.resourceDao.create((ResourceEntity)group);
    }

    public GroupEntity getById(String id) {
        try {
            return (GroupEntity)this.resourceDao.getById(id, GroupEntity.class);
        }
        catch (ResourceNotFoundException rnfe) {
            throw new ResourceNotFoundException(String.format("Group with id '%s' not found", id), (Throwable)rnfe);
        }
    }

    public long count() {
        return this.resourceDao.count(GroupEntity.class);
    }

    public boolean isDisplayNameAlreadyTaken(String displayName) {
        return this.isDisplayNameAlreadyTaken(displayName, null);
    }

    public boolean isDisplayNameAlreadyTaken(String displayName, String id) {
        return this.resourceDao.isUniqueAttributeAlreadyTaken(displayName, id, GroupEntity_.displayName, GroupEntity.class);
    }

    public boolean isExternalIdAlreadyTaken(String externalId) {
        return this.resourceDao.isExternalIdAlreadyTaken(externalId);
    }

    public boolean isExternalIdAlreadyTaken(String externalId, String id) {
        return this.resourceDao.isExternalIdAlreadyTaken(externalId, id);
    }

    public void delete(String id) {
        try {
            this.resourceDao.delete(id);
        }
        catch (ResourceNotFoundException rnfe) {
            throw new ResourceNotFoundException(String.format("Group with id '%s' not found", id), (Throwable)rnfe);
        }
    }

    public GroupEntity update(GroupEntity entity) {
        return (GroupEntity)this.resourceDao.update((ResourceEntity)entity);
    }

    public SearchResult<GroupEntity> search(ParseTree filterTree, String sortBy, String sortOrder, int count, int startIndex) {
        return this.resourceDao.search(GroupEntity.class, filterTree, count, startIndex, sortBy, sortOrder, (FilterParser)this.filterParser);
    }
}

