/*
 * Decompiled with CFR 0.152.
 */
package org.osiam.storage.entities;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import javax.persistence.Basic;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.Index;
import javax.persistence.ManyToOne;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import org.osiam.resources.scim.ExtensionFieldType;
import org.osiam.storage.entities.ExtensionEntity;
import org.osiam.storage.entities.ExtensionFieldEntity;

@Entity
@Table(name="scim_extension_field", indexes={@Index(unique=true, columnList="extension, name")})
public class ExtensionFieldEntity {
    private static final int SEQUENCE_ALLOCATION_SIZE = 1;
    private static final int SEQUENCE_INITIAL_VALUE = 100;
    private static Set<ConstraintAndType> invalidTypeForConstraint = new HashSet<ConstraintAndType>(Arrays.asList(new ConstraintAndType(ExtensionFieldType.INTEGER, "co", null), new ConstraintAndType(ExtensionFieldType.INTEGER, "sw", null), new ConstraintAndType(ExtensionFieldType.DECIMAL, "co", null), new ConstraintAndType(ExtensionFieldType.DECIMAL, "sw", null), new ConstraintAndType(ExtensionFieldType.BOOLEAN, "co", null), new ConstraintAndType(ExtensionFieldType.BOOLEAN, "sw", null), new ConstraintAndType(ExtensionFieldType.BOOLEAN, "gt", null), new ConstraintAndType(ExtensionFieldType.BOOLEAN, "ge", null), new ConstraintAndType(ExtensionFieldType.BOOLEAN, "lt", null), new ConstraintAndType(ExtensionFieldType.BOOLEAN, "le", null), new ConstraintAndType(ExtensionFieldType.DATE_TIME, "co", null), new ConstraintAndType(ExtensionFieldType.DATE_TIME, "sw", null), new ConstraintAndType(ExtensionFieldType.BINARY, "eq", null), new ConstraintAndType(ExtensionFieldType.BINARY, "co", null), new ConstraintAndType(ExtensionFieldType.BINARY, "sw", null), new ConstraintAndType(ExtensionFieldType.BINARY, "gt", null), new ConstraintAndType(ExtensionFieldType.BINARY, "ge", null), new ConstraintAndType(ExtensionFieldType.BINARY, "lt", null), new ConstraintAndType(ExtensionFieldType.BINARY, "le", null), new ConstraintAndType(ExtensionFieldType.REFERENCE, "gt", null), new ConstraintAndType(ExtensionFieldType.REFERENCE, "ge", null), new ConstraintAndType(ExtensionFieldType.REFERENCE, "lt", null), new ConstraintAndType(ExtensionFieldType.REFERENCE, "le", null)));
    @Id
    @SequenceGenerator(name="sequence_scim_extension_field", sequenceName="resource_server_sequence_scim_extension_field", allocationSize=1, initialValue=100)
    @GeneratedValue(generator="sequence_scim_extension_field")
    private long internalId;
    private String name;
    @Basic(optional=false)
    private ExtensionFieldType<?> type;
    private boolean required;
    @ManyToOne
    private ExtensionEntity extension;

    public ExtensionEntity getExtension() {
        return this.extension;
    }

    public void setExtension(ExtensionEntity extension) {
        this.extension = extension;
    }

    public long getInternalId() {
        return this.internalId;
    }

    public void setInternalId(long internalId) {
        this.internalId = internalId;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public ExtensionFieldType<?> getType() {
        return this.type;
    }

    public void setType(ExtensionFieldType<?> type) {
        this.type = type;
    }

    public boolean isRequired() {
        return this.required;
    }

    public void setRequired(boolean required) {
        this.required = required;
    }

    public boolean isConstrainedValid(String constraint) {
        return !invalidTypeForConstraint.contains(new ConstraintAndType(this.type, constraint, null));
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + (this.extension == null ? 0 : this.extension.hashCode());
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ExtensionFieldEntity other = (ExtensionFieldEntity)obj;
        if (this.extension == null ? other.extension != null : !this.extension.equals((Object)other.extension)) {
            return false;
        }
        return !(this.name == null ? other.name != null : !this.name.equals(other.name));
    }

    public String toString() {
        return "ExtensionFieldEntity [name=" + this.name + ", type=" + this.type + ", isRequired=" + this.required + "]";
    }
}

