/*
 * Decompiled with CFR 0.152.
 */
package org.osiam.storage.entities;

import com.google.common.collect.ImmutableSet;
import java.util.Collection;
import java.util.GregorianCalendar;
import java.util.HashSet;
import java.util.Set;
import java.util.UUID;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.Inheritance;
import javax.persistence.InheritanceType;
import javax.persistence.ManyToMany;
import javax.persistence.OneToOne;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.persistence.Transient;
import org.osiam.resources.scim.MemberRef;
import org.osiam.storage.entities.GroupEntity;
import org.osiam.storage.entities.MetaEntity;

@Entity
@Table(name="scim_id")
@Inheritance(strategy=InheritanceType.JOINED)
public abstract class ResourceEntity {
    private static final int SEQUENCE_ALLOCATION_SIZE = 1;
    private static final int SEQUENCE_INITIAL_VALUE = 100;
    @Column(unique=true, nullable=false)
    private String id;
    @Id
    @SequenceGenerator(name="sequence_scim_id", sequenceName="resource_server_sequence_scim_id", allocationSize=1, initialValue=100)
    @GeneratedValue(generator="sequence_scim_id")
    private long internalId;
    @Column(unique=true)
    private String externalId;
    @OneToOne(cascade={CascadeType.ALL})
    private MetaEntity meta = new MetaEntity(GregorianCalendar.getInstance());
    @ManyToMany(mappedBy="members")
    private Set<GroupEntity> groups = new HashSet();

    public UUID getId() {
        return UUID.fromString(this.id != null ? this.id : "");
    }

    public void setId(UUID id) {
        this.id = id.toString();
    }

    public long getInternalId() {
        return this.internalId;
    }

    public void setInternalId(long internalId) {
        this.internalId = internalId;
    }

    public String getExternalId() {
        return this.externalId;
    }

    public void setExternalId(String externalId) {
        this.externalId = externalId;
    }

    public abstract String getDisplayName();

    public abstract MemberRef.Type getType();

    public void touch() {
        this.getMeta().setLastModified(GregorianCalendar.getInstance().getTime());
    }

    public Set<GroupEntity> getGroups() {
        return ImmutableSet.copyOf((Collection)this.groups);
    }

    public void addToGroup(GroupEntity group) {
        if (this.groups.contains(group)) {
            return;
        }
        this.groups.add(group);
        group.addMember(this);
    }

    public void removeFromGroup(GroupEntity group) {
        if (!this.groups.contains(group)) {
            return;
        }
        this.groups.remove(group);
        group.removeMember(this);
    }

    @Transient
    public String getValue() {
        return this.id;
    }

    public void setValue(String value) {
        this.id = value;
    }

    public MetaEntity getMeta() {
        return this.meta;
    }

    public void setMeta(MetaEntity meta) {
        this.meta = meta;
    }

    public String toString() {
        return "ResourceEntity [id=" + this.id + ", internalId=" + this.internalId + ", getClass()=" + this.getClass() + "]";
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + (this.id == null ? 0 : this.id.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ResourceEntity other = (ResourceEntity)obj;
        return !(this.id == null ? other.id != null : !this.id.equals(other.id));
    }
}

