/*
 * Decompiled with CFR 0.152.
 */
package org.osiam.storage.query;

import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.Predicate;
import javax.persistence.criteria.Root;
import org.osiam.resources.exception.InvalidFilterException;
import org.osiam.resources.exception.OsiamException;
import org.osiam.storage.ExtensionRepository;
import org.osiam.storage.entities.ExtensionEntity;
import org.osiam.storage.entities.ExtensionFieldEntity;
import org.osiam.storage.entities.UserEntity;
import org.osiam.storage.query.ExtensionQueryField;
import org.osiam.storage.query.FilterChain;
import org.osiam.storage.query.FilterExpression;
import org.osiam.storage.query.QueryField;

public class UserSimpleFilterChain
implements FilterChain<UserEntity> {
    private final FilterExpression<UserEntity> filterExpression;
    private final QueryField<UserEntity> userFilterField;
    private final ExtensionRepository extensionRepository;
    private final CriteriaBuilder criteriaBuilder;
    private final ExtensionQueryField extensionFilterField;

    public UserSimpleFilterChain(CriteriaBuilder criteriaBuilder, ExtensionRepository extensionRepository, FilterExpression<UserEntity> filterExpression) {
        this.criteriaBuilder = criteriaBuilder;
        this.filterExpression = filterExpression;
        this.extensionRepository = extensionRepository;
        if (filterExpression.getField().isExtension()) {
            this.extensionFilterField = this.getExtensionFilterField(filterExpression);
            this.userFilterField = null;
        } else {
            this.userFilterField = filterExpression.getField().getQueryField();
            this.extensionFilterField = null;
        }
    }

    private ExtensionQueryField getExtensionFilterField(FilterExpression<UserEntity> filterExpression) {
        ExtensionEntity extension;
        String urn = filterExpression.getField().getUrn();
        try {
            extension = this.extensionRepository.findByUrnIgnoreCase(urn);
        }
        catch (OsiamException osiamException) {
            throw new InvalidFilterException(String.format("Filtering not possible. Field '%s' not available.", filterExpression.getField()));
        }
        ExtensionFieldEntity fieldEntity = extension.getFieldForName(filterExpression.getField().getName(), true);
        return new ExtensionQueryField(urn, fieldEntity);
    }

    public Predicate createPredicateAndJoin(Root<UserEntity> root) {
        if (this.userFilterField != null) {
            return this.userFilterField.addFilter(root, this.filterExpression.getConstraint(), this.filterExpression.getValue(), this.criteriaBuilder);
        }
        return this.extensionFilterField.addFilter(root, this.filterExpression.getConstraint(), this.filterExpression.getValue(), this.criteriaBuilder);
    }
}

