/*
 * Decompiled with CFR 0.152.
 */
package cn.bugstack.openai.executor.parameter;

import cn.bugstack.openai.executor.parameter.Message;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.io.Serializable;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class CompletionRequest
implements Serializable {
    private static final Logger log = LoggerFactory.getLogger(CompletionRequest.class);
    private static final long serialVersionUID = 2447852191771534038L;
    private String model = Model.GPT_3_5_TURBO.getCode();
    private List<Message> messages;
    private double temperature;
    @JsonProperty(value="top_p")
    private Double topP;
    private Integer n;
    private boolean stream;
    private List<String> stop;
    @JsonProperty(value="max_tokens")
    private Integer maxTokens;
    @JsonProperty(value="frequency_penalty")
    private double frequencyPenalty;
    @JsonProperty(value="presence_penalty")
    private double presencePenalty;
    @JsonProperty(value="logit_bias")
    private Map logitBias;
    private String user;

    private static double $default$temperature() {
        return 0.2;
    }

    private static Double $default$topP() {
        return 1.0;
    }

    private static Integer $default$n() {
        return 1;
    }

    private static boolean $default$stream() {
        return false;
    }

    private static Integer $default$maxTokens() {
        return 2048;
    }

    private static double $default$frequencyPenalty() {
        return 0.0;
    }

    private static double $default$presencePenalty() {
        return 0.0;
    }

    public static CompletionRequestBuilder builder() {
        return new CompletionRequestBuilder();
    }

    public String getModel() {
        return this.model;
    }

    public List<Message> getMessages() {
        return this.messages;
    }

    public double getTemperature() {
        return this.temperature;
    }

    public Double getTopP() {
        return this.topP;
    }

    public Integer getN() {
        return this.n;
    }

    public boolean isStream() {
        return this.stream;
    }

    public List<String> getStop() {
        return this.stop;
    }

    public Integer getMaxTokens() {
        return this.maxTokens;
    }

    public double getFrequencyPenalty() {
        return this.frequencyPenalty;
    }

    public double getPresencePenalty() {
        return this.presencePenalty;
    }

    public Map getLogitBias() {
        return this.logitBias;
    }

    public String getUser() {
        return this.user;
    }

    public void setModel(String model) {
        this.model = model;
    }

    public void setMessages(List<Message> messages) {
        this.messages = messages;
    }

    public void setTemperature(double temperature) {
        this.temperature = temperature;
    }

    @JsonProperty(value="top_p")
    public void setTopP(Double topP) {
        this.topP = topP;
    }

    public void setN(Integer n) {
        this.n = n;
    }

    public void setStream(boolean stream) {
        this.stream = stream;
    }

    public void setStop(List<String> stop) {
        this.stop = stop;
    }

    @JsonProperty(value="max_tokens")
    public void setMaxTokens(Integer maxTokens) {
        this.maxTokens = maxTokens;
    }

    @JsonProperty(value="frequency_penalty")
    public void setFrequencyPenalty(double frequencyPenalty) {
        this.frequencyPenalty = frequencyPenalty;
    }

    @JsonProperty(value="presence_penalty")
    public void setPresencePenalty(double presencePenalty) {
        this.presencePenalty = presencePenalty;
    }

    @JsonProperty(value="logit_bias")
    public void setLogitBias(Map logitBias) {
        this.logitBias = logitBias;
    }

    public void setUser(String user) {
        this.user = user;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof CompletionRequest)) {
            return false;
        }
        CompletionRequest other = (CompletionRequest)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (Double.compare(this.getTemperature(), other.getTemperature()) != 0) {
            return false;
        }
        if (this.isStream() != other.isStream()) {
            return false;
        }
        if (Double.compare(this.getFrequencyPenalty(), other.getFrequencyPenalty()) != 0) {
            return false;
        }
        if (Double.compare(this.getPresencePenalty(), other.getPresencePenalty()) != 0) {
            return false;
        }
        Double this$topP = this.getTopP();
        Double other$topP = other.getTopP();
        if (this$topP == null ? other$topP != null : !((Object)this$topP).equals(other$topP)) {
            return false;
        }
        Integer this$n = this.getN();
        Integer other$n = other.getN();
        if (this$n == null ? other$n != null : !((Object)this$n).equals(other$n)) {
            return false;
        }
        Integer this$maxTokens = this.getMaxTokens();
        Integer other$maxTokens = other.getMaxTokens();
        if (this$maxTokens == null ? other$maxTokens != null : !((Object)this$maxTokens).equals(other$maxTokens)) {
            return false;
        }
        String this$model = this.getModel();
        String other$model = other.getModel();
        if (this$model == null ? other$model != null : !this$model.equals(other$model)) {
            return false;
        }
        List<Message> this$messages = this.getMessages();
        List<Message> other$messages = other.getMessages();
        if (this$messages == null ? other$messages != null : !((Object)this$messages).equals(other$messages)) {
            return false;
        }
        List<String> this$stop = this.getStop();
        List<String> other$stop = other.getStop();
        if (this$stop == null ? other$stop != null : !((Object)this$stop).equals(other$stop)) {
            return false;
        }
        Map this$logitBias = this.getLogitBias();
        Map other$logitBias = other.getLogitBias();
        if (this$logitBias == null ? other$logitBias != null : !((Object)this$logitBias).equals(other$logitBias)) {
            return false;
        }
        String this$user = this.getUser();
        String other$user = other.getUser();
        return !(this$user == null ? other$user != null : !this$user.equals(other$user));
    }

    protected boolean canEqual(Object other) {
        return other instanceof CompletionRequest;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $temperature = Double.doubleToLongBits(this.getTemperature());
        result = result * 59 + (int)($temperature >>> 32 ^ $temperature);
        result = result * 59 + (this.isStream() ? 79 : 97);
        long $frequencyPenalty = Double.doubleToLongBits(this.getFrequencyPenalty());
        result = result * 59 + (int)($frequencyPenalty >>> 32 ^ $frequencyPenalty);
        long $presencePenalty = Double.doubleToLongBits(this.getPresencePenalty());
        result = result * 59 + (int)($presencePenalty >>> 32 ^ $presencePenalty);
        Double $topP = this.getTopP();
        result = result * 59 + ($topP == null ? 43 : ((Object)$topP).hashCode());
        Integer $n = this.getN();
        result = result * 59 + ($n == null ? 43 : ((Object)$n).hashCode());
        Integer $maxTokens = this.getMaxTokens();
        result = result * 59 + ($maxTokens == null ? 43 : ((Object)$maxTokens).hashCode());
        String $model = this.getModel();
        result = result * 59 + ($model == null ? 43 : $model.hashCode());
        List<Message> $messages = this.getMessages();
        result = result * 59 + ($messages == null ? 43 : ((Object)$messages).hashCode());
        List<String> $stop = this.getStop();
        result = result * 59 + ($stop == null ? 43 : ((Object)$stop).hashCode());
        Map $logitBias = this.getLogitBias();
        result = result * 59 + ($logitBias == null ? 43 : ((Object)$logitBias).hashCode());
        String $user = this.getUser();
        result = result * 59 + ($user == null ? 43 : $user.hashCode());
        return result;
    }

    public String toString() {
        return "CompletionRequest(model=" + this.getModel() + ", messages=" + this.getMessages() + ", temperature=" + this.getTemperature() + ", topP=" + this.getTopP() + ", n=" + this.getN() + ", stream=" + this.isStream() + ", stop=" + this.getStop() + ", maxTokens=" + this.getMaxTokens() + ", frequencyPenalty=" + this.getFrequencyPenalty() + ", presencePenalty=" + this.getPresencePenalty() + ", logitBias=" + this.getLogitBias() + ", user=" + this.getUser() + ")";
    }

    public CompletionRequest() {
        this.temperature = CompletionRequest.$default$temperature();
        this.topP = CompletionRequest.$default$topP();
        this.n = CompletionRequest.$default$n();
        this.stream = CompletionRequest.$default$stream();
        this.maxTokens = CompletionRequest.$default$maxTokens();
        this.frequencyPenalty = CompletionRequest.$default$frequencyPenalty();
        this.presencePenalty = CompletionRequest.$default$presencePenalty();
    }

    public CompletionRequest(String model, List<Message> messages, double temperature, Double topP, Integer n, boolean stream, List<String> stop, Integer maxTokens, double frequencyPenalty, double presencePenalty, Map logitBias, String user) {
        this.model = model;
        this.messages = messages;
        this.temperature = temperature;
        this.topP = topP;
        this.n = n;
        this.stream = stream;
        this.stop = stop;
        this.maxTokens = maxTokens;
        this.frequencyPenalty = frequencyPenalty;
        this.presencePenalty = presencePenalty;
        this.logitBias = logitBias;
        this.user = user;
    }

    public static class CompletionRequestBuilder {
        private String model;
        private List<Message> messages;
        private boolean temperature$set;
        private double temperature$value;
        private boolean topP$set;
        private Double topP$value;
        private boolean n$set;
        private Integer n$value;
        private boolean stream$set;
        private boolean stream$value;
        private List<String> stop;
        private boolean maxTokens$set;
        private Integer maxTokens$value;
        private boolean frequencyPenalty$set;
        private double frequencyPenalty$value;
        private boolean presencePenalty$set;
        private double presencePenalty$value;
        private Map logitBias;
        private String user;

        CompletionRequestBuilder() {
        }

        public CompletionRequestBuilder model(String model) {
            this.model = model;
            return this;
        }

        public CompletionRequestBuilder messages(List<Message> messages) {
            this.messages = messages;
            return this;
        }

        public CompletionRequestBuilder temperature(double temperature) {
            this.temperature$value = temperature;
            this.temperature$set = true;
            return this;
        }

        @JsonProperty(value="top_p")
        public CompletionRequestBuilder topP(Double topP) {
            this.topP$value = topP;
            this.topP$set = true;
            return this;
        }

        public CompletionRequestBuilder n(Integer n) {
            this.n$value = n;
            this.n$set = true;
            return this;
        }

        public CompletionRequestBuilder stream(boolean stream) {
            this.stream$value = stream;
            this.stream$set = true;
            return this;
        }

        public CompletionRequestBuilder stop(List<String> stop) {
            this.stop = stop;
            return this;
        }

        @JsonProperty(value="max_tokens")
        public CompletionRequestBuilder maxTokens(Integer maxTokens) {
            this.maxTokens$value = maxTokens;
            this.maxTokens$set = true;
            return this;
        }

        @JsonProperty(value="frequency_penalty")
        public CompletionRequestBuilder frequencyPenalty(double frequencyPenalty) {
            this.frequencyPenalty$value = frequencyPenalty;
            this.frequencyPenalty$set = true;
            return this;
        }

        @JsonProperty(value="presence_penalty")
        public CompletionRequestBuilder presencePenalty(double presencePenalty) {
            this.presencePenalty$value = presencePenalty;
            this.presencePenalty$set = true;
            return this;
        }

        @JsonProperty(value="logit_bias")
        public CompletionRequestBuilder logitBias(Map logitBias) {
            this.logitBias = logitBias;
            return this;
        }

        public CompletionRequestBuilder user(String user) {
            this.user = user;
            return this;
        }

        public CompletionRequest build() {
            double temperature$value = this.temperature$value;
            if (!this.temperature$set) {
                temperature$value = CompletionRequest.$default$temperature();
            }
            Double topP$value = this.topP$value;
            if (!this.topP$set) {
                topP$value = CompletionRequest.$default$topP();
            }
            Integer n$value = this.n$value;
            if (!this.n$set) {
                n$value = CompletionRequest.$default$n();
            }
            boolean stream$value = this.stream$value;
            if (!this.stream$set) {
                stream$value = CompletionRequest.$default$stream();
            }
            Integer maxTokens$value = this.maxTokens$value;
            if (!this.maxTokens$set) {
                maxTokens$value = CompletionRequest.$default$maxTokens();
            }
            double frequencyPenalty$value = this.frequencyPenalty$value;
            if (!this.frequencyPenalty$set) {
                frequencyPenalty$value = CompletionRequest.$default$frequencyPenalty();
            }
            double presencePenalty$value = this.presencePenalty$value;
            if (!this.presencePenalty$set) {
                presencePenalty$value = CompletionRequest.$default$presencePenalty();
            }
            return new CompletionRequest(this.model, this.messages, temperature$value, topP$value, n$value, stream$value, this.stop, maxTokens$value, frequencyPenalty$value, presencePenalty$value, this.logitBias, this.user);
        }

        public String toString() {
            return "CompletionRequest.CompletionRequestBuilder(model=" + this.model + ", messages=" + this.messages + ", temperature$value=" + this.temperature$value + ", topP$value=" + this.topP$value + ", n$value=" + this.n$value + ", stream$value=" + this.stream$value + ", stop=" + this.stop + ", maxTokens$value=" + this.maxTokens$value + ", frequencyPenalty$value=" + this.frequencyPenalty$value + ", presencePenalty$value=" + this.presencePenalty$value + ", logitBias=" + this.logitBias + ", user=" + this.user + ")";
        }
    }

    public static enum Model {
        GPT_3_5_TURBO("gpt-3.5-turbo"),
        GPT_3_5_TURBO_1106("gpt-3.5-turbo-1106"),
        GPT_3_5_TURBO_16K("gpt-3.5-turbo-16k"),
        GPT_4("gpt-4"),
        GPT_4_32K("gpt-4-32k"),
        DALL_E_2("dall-e-2"),
        DALL_E_3("dall-e-3"),
        CHATGLM_TURBO("chatglm_turbo"),
        XUNFEI("xunfei");

        private final String code;

        public String getCode() {
            return this.code;
        }

        private Model(String code) {
            this.code = code;
        }
    }

    public static enum Role {
        SYSTEM("system"),
        USER("user"),
        ASSISTANT("assistant");

        private final String code;

        public String getCode() {
            return this.code;
        }

        private Role(String code) {
            this.code = code;
        }
    }
}

