/*
 * Decompiled with CFR 0.152.
 */
package cn.bugstack.openai.executor.model.tencent.valobj;

import java.util.ArrayList;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;

public class CanonicalRequest {
    private String httpRequestMethod;
    private String canonicalURI;
    private String canonicalQueryString;
    private Map<String, String> canonicalHeaders;
    private Set<String> signedHeaders;
    private String hashedRequestPayload;

    public static String formatCanonicalHeaders(Map<String, String> headers) {
        TreeMap<String, String> sortedHeaders = new TreeMap<String, String>(String.CASE_INSENSITIVE_ORDER);
        sortedHeaders.putAll(headers);
        StringBuilder stringBuilder = new StringBuilder();
        for (Map.Entry entry : sortedHeaders.entrySet()) {
            String key = ((String)entry.getKey()).toLowerCase().trim();
            String value = ((String)entry.getValue()).toLowerCase().trim();
            stringBuilder.append(key).append(":").append(value).append("\n");
        }
        return stringBuilder.toString();
    }

    public static String formatSignedHeaders(Set<String> headerskeySet) {
        StringBuilder sb = new StringBuilder();
        ArrayList<String> lowercaseKeys = new ArrayList<String>(headerskeySet);
        lowercaseKeys.sort(String.CASE_INSENSITIVE_ORDER);
        for (String header : lowercaseKeys) {
            sb.append(header.toLowerCase()).append(";");
        }
        if (sb.length() > 0) {
            sb.deleteCharAt(sb.length() - 1);
        }
        return sb.toString();
    }

    public String toString() {
        return this.httpRequestMethod + "\n" + this.canonicalURI + "\n" + this.canonicalQueryString + "\n" + CanonicalRequest.formatCanonicalHeaders(this.canonicalHeaders) + "\n" + CanonicalRequest.formatSignedHeaders(this.signedHeaders) + "\n" + this.hashedRequestPayload;
    }

    public static CanonicalRequestBuilder builder() {
        return new CanonicalRequestBuilder();
    }

    public CanonicalRequest() {
    }

    public CanonicalRequest(String httpRequestMethod, String canonicalURI, String canonicalQueryString, Map<String, String> canonicalHeaders, Set<String> signedHeaders, String hashedRequestPayload) {
        this.httpRequestMethod = httpRequestMethod;
        this.canonicalURI = canonicalURI;
        this.canonicalQueryString = canonicalQueryString;
        this.canonicalHeaders = canonicalHeaders;
        this.signedHeaders = signedHeaders;
        this.hashedRequestPayload = hashedRequestPayload;
    }

    public static class CanonicalRequestBuilder {
        private String httpRequestMethod;
        private String canonicalURI;
        private String canonicalQueryString;
        private Map<String, String> canonicalHeaders;
        private Set<String> signedHeaders;
        private String hashedRequestPayload;

        CanonicalRequestBuilder() {
        }

        public CanonicalRequestBuilder httpRequestMethod(String httpRequestMethod) {
            this.httpRequestMethod = httpRequestMethod;
            return this;
        }

        public CanonicalRequestBuilder canonicalURI(String canonicalURI) {
            this.canonicalURI = canonicalURI;
            return this;
        }

        public CanonicalRequestBuilder canonicalQueryString(String canonicalQueryString) {
            this.canonicalQueryString = canonicalQueryString;
            return this;
        }

        public CanonicalRequestBuilder canonicalHeaders(Map<String, String> canonicalHeaders) {
            this.canonicalHeaders = canonicalHeaders;
            return this;
        }

        public CanonicalRequestBuilder signedHeaders(Set<String> signedHeaders) {
            this.signedHeaders = signedHeaders;
            return this;
        }

        public CanonicalRequestBuilder hashedRequestPayload(String hashedRequestPayload) {
            this.hashedRequestPayload = hashedRequestPayload;
            return this;
        }

        public CanonicalRequest build() {
            return new CanonicalRequest(this.httpRequestMethod, this.canonicalURI, this.canonicalQueryString, this.canonicalHeaders, this.signedHeaders, this.hashedRequestPayload);
        }

        public String toString() {
            return "CanonicalRequest.CanonicalRequestBuilder(httpRequestMethod=" + this.httpRequestMethod + ", canonicalURI=" + this.canonicalURI + ", canonicalQueryString=" + this.canonicalQueryString + ", canonicalHeaders=" + this.canonicalHeaders + ", signedHeaders=" + this.signedHeaders + ", hashedRequestPayload=" + this.hashedRequestPayload + ")";
        }
    }
}

