/*
 * Decompiled with CFR 0.152.
 */
package cn.bugstack.openai.executor.model.xunfei;

import cn.bugstack.openai.executor.Executor;
import cn.bugstack.openai.executor.model.xunfei.config.XunFeiConfig;
import cn.bugstack.openai.executor.model.xunfei.utils.URLAuthUtils;
import cn.bugstack.openai.executor.model.xunfei.valobj.Chat;
import cn.bugstack.openai.executor.model.xunfei.valobj.Choices;
import cn.bugstack.openai.executor.model.xunfei.valobj.Message;
import cn.bugstack.openai.executor.model.xunfei.valobj.Text;
import cn.bugstack.openai.executor.model.xunfei.valobj.Usage;
import cn.bugstack.openai.executor.model.xunfei.valobj.XunFeiCompletionRequest;
import cn.bugstack.openai.executor.model.xunfei.valobj.XunFeiCompletionResponse;
import cn.bugstack.openai.executor.parameter.ChatChoice;
import cn.bugstack.openai.executor.parameter.CompletionRequest;
import cn.bugstack.openai.executor.parameter.CompletionResponse;
import cn.bugstack.openai.executor.parameter.ImageRequest;
import cn.bugstack.openai.executor.parameter.ImageResponse;
import cn.bugstack.openai.executor.parameter.ParameterHandler;
import cn.bugstack.openai.session.Configuration;
import com.alibaba.fastjson.JSON;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.CountDownLatch;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Response;
import okhttp3.WebSocket;
import okhttp3.WebSocketListener;
import okhttp3.sse.EventSource;
import okhttp3.sse.EventSourceListener;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class XunFeiModelExecutor
implements Executor,
ParameterHandler<XunFeiCompletionRequest> {
    private static final Logger log = LoggerFactory.getLogger(XunFeiModelExecutor.class);
    private final XunFeiConfig xunFeiConfig;
    private final OkHttpClient okHttpClient;
    private String appid;

    public XunFeiModelExecutor(Configuration configuration) {
        this.xunFeiConfig = configuration.getXunFeiConfig();
        this.okHttpClient = configuration.getOkHttpClient();
    }

    @Override
    public EventSource completions(CompletionRequest completionRequest, EventSourceListener eventSourceListener) throws Exception {
        return this.completions(null, null, completionRequest, eventSourceListener);
    }

    @Override
    public EventSource completions(String apiHostByUser, String apiKeyByUser, CompletionRequest completionRequest, EventSourceListener eventSourceListener) throws Exception {
        if (!completionRequest.isStream()) {
            throw new RuntimeException("illegal parameter stream is false!");
        }
        String apiHost = null == apiHostByUser ? this.xunFeiConfig.getApiHost() : apiHostByUser;
        String authURL = null;
        if (apiKeyByUser == null) {
            authURL = URLAuthUtils.getAuthURl(apiHost, this.xunFeiConfig.getApiKey(), this.xunFeiConfig.getApiSecret());
            this.appid = this.xunFeiConfig.getAppid();
        } else {
            String[] configs = apiKeyByUser.split(".");
            this.appid = configs[0];
            authURL = URLAuthUtils.getAuthURl(apiHost, configs[1], configs[2]);
        }
        XunFeiCompletionRequest xunFeiCompletionRequest = this.getParameterObject(completionRequest);
        final Request request = new Request.Builder().url(authURL).build();
        final WebSocket webSocket = this.okHttpClient.newWebSocket(request, (WebSocketListener)new BigModelWebSocketListener(xunFeiCompletionRequest, eventSourceListener));
        return new EventSource(){

            @NotNull
            public Request request() {
                return request;
            }

            public void cancel() {
                webSocket.cancel();
            }
        };
    }

    @Override
    public ImageResponse genImages(ImageRequest imageRequest) {
        return null;
    }

    @Override
    public ImageResponse genImages(String apiHostByUser, String apiKeyByUser, ImageRequest imageRequest) {
        return null;
    }

    @Override
    public XunFeiCompletionRequest getParameterObject(CompletionRequest completionRequest) {
        XunFeiCompletionRequest.Header header = XunFeiCompletionRequest.Header.builder().appid(this.xunFeiConfig.getAppid()).uid(UUID.randomUUID().toString().substring(0, 10)).build();
        XunFeiCompletionRequest.Parameter parameter = XunFeiCompletionRequest.Parameter.builder().chat(Chat.builder().domain("generalv2").temperature(completionRequest.getTemperature()).maxTokens(completionRequest.getMaxTokens()).build()).build();
        ArrayList<Text> texts = new ArrayList<Text>();
        List<cn.bugstack.openai.executor.parameter.Message> messages = completionRequest.getMessages();
        for (cn.bugstack.openai.executor.parameter.Message message : messages) {
            texts.add(Text.builder().role(Text.Role.USER.getName()).content(message.getContent()).build());
        }
        XunFeiCompletionRequest.Payload payload = XunFeiCompletionRequest.Payload.builder().message(Message.builder().text(texts).build()).build();
        return XunFeiCompletionRequest.builder().header(header).parameter(parameter).payload(payload).build();
    }

    protected static class BigModelWebSocketListener
    extends WebSocketListener {
        private final XunFeiCompletionRequest request;
        private final EventSourceListener eventSourceListener;
        private final CountDownLatch countDownLatch = new CountDownLatch(1);
        private final EventSource eventSource;

        public BigModelWebSocketListener(XunFeiCompletionRequest request, EventSourceListener eventSourceListener) {
            this.request = request;
            this.eventSourceListener = eventSourceListener;
            this.eventSource = new EventSource(){

                public Request request() {
                    return this.request();
                }

                public void cancel() {
                    this.cancel();
                }
            };
        }

        public void onOpen(@NotNull WebSocket webSocket, @NotNull Response response) {
            new Thread(() -> {
                webSocket.send(JSON.toJSONString((Object)this.request));
                try {
                    this.countDownLatch.await();
                }
                catch (InterruptedException e) {
                    throw new RuntimeException(e);
                }
                webSocket.close(1000, "");
            }).start();
        }

        public void onMessage(WebSocket webSocket, String text) {
            XunFeiCompletionResponse response = (XunFeiCompletionResponse)JSON.parseObject((String)text, XunFeiCompletionResponse.class);
            XunFeiCompletionResponse.Header header = response.getHeader();
            int code = header.getCode();
            if (XunFeiCompletionResponse.Header.Code.SUCCESS.getValue() != code) {
                this.countDownLatch.countDown();
                return;
            }
            CompletionResponse completionResponse = new CompletionResponse();
            ArrayList<ChatChoice> chatChoices = new ArrayList<ChatChoice>();
            ChatChoice chatChoice = new ChatChoice();
            XunFeiCompletionResponse.Payload payload = response.getPayload();
            Choices choices = payload.getChoices();
            List<Text> texts = choices.getText();
            for (Text t : texts) {
                chatChoice.setDelta(cn.bugstack.openai.executor.parameter.Message.builder().name("").role(CompletionRequest.Role.SYSTEM).content(t.getContent()).build());
                chatChoices.add(chatChoice);
            }
            completionResponse.setChoices(chatChoices);
            int status = header.getStatus();
            if (XunFeiCompletionResponse.Header.Status.START.getValue() == status) {
                this.eventSourceListener.onEvent(this.eventSource, null, null, JSON.toJSONString((Object)completionResponse));
            } else if (XunFeiCompletionResponse.Header.Status.ING.getValue() == status) {
                this.eventSourceListener.onEvent(this.eventSource, null, null, JSON.toJSONString((Object)completionResponse));
            } else if (XunFeiCompletionResponse.Header.Status.END.getValue() == status) {
                Usage usage = payload.getUsage();
                Usage.Text usageText = usage.getText();
                cn.bugstack.openai.executor.parameter.Usage openaiUsage = new cn.bugstack.openai.executor.parameter.Usage();
                openaiUsage.setPromptTokens(usageText.getPromptTokens().intValue());
                openaiUsage.setCompletionTokens(usageText.getCompletionTokens().intValue());
                openaiUsage.setTotalTokens(usageText.getTotalTokens().intValue());
                completionResponse.setUsage(openaiUsage);
                completionResponse.setCreated(System.currentTimeMillis());
                chatChoice.setFinishReason("stop");
                chatChoices.add(chatChoice);
                this.eventSourceListener.onEvent(this.eventSource, null, null, JSON.toJSONString((Object)completionResponse));
                this.countDownLatch.countDown();
            }
        }

        public void onClosed(WebSocket webSocket, int code, String reason) {
            this.eventSourceListener.onClosed(this.eventSource);
        }

        public void onFailure(WebSocket webSocket, Throwable t, @Nullable Response response) {
            this.eventSourceListener.onFailure(this.eventSource, t, response);
        }
    }
}

