/*
 * Decompiled with CFR 0.152.
 */
package cn.bugstack.openai.session.defaults;

import cn.bugstack.openai.executor.Executor;
import cn.bugstack.openai.executor.parameter.ChatChoice;
import cn.bugstack.openai.executor.parameter.CompletionRequest;
import cn.bugstack.openai.executor.parameter.CompletionResponse;
import cn.bugstack.openai.executor.parameter.ImageRequest;
import cn.bugstack.openai.executor.parameter.ImageResponse;
import cn.bugstack.openai.executor.parameter.Message;
import cn.bugstack.openai.session.Configuration;
import cn.bugstack.openai.session.OpenAiSession;
import com.alibaba.fastjson.JSON;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import okhttp3.OkHttpClient;
import okhttp3.Response;
import okhttp3.sse.EventSource;
import okhttp3.sse.EventSourceListener;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.Nullable;

public class DefaultOpenAiSession
implements OpenAiSession {
    private final Configuration configuration;
    private final Map<String, Executor> executorGroup;

    public DefaultOpenAiSession(Configuration configuration, Map<String, Executor> executorGroup) {
        this.configuration = configuration;
        this.executorGroup = executorGroup;
    }

    @Override
    public EventSource completions(CompletionRequest completionRequest, EventSourceListener eventSourceListener) throws Exception {
        return this.completions(null, null, completionRequest, eventSourceListener);
    }

    @Override
    public EventSource completions(String apiHostByUser, String apiKeyByUser, CompletionRequest completionRequest, EventSourceListener eventSourceListener) throws Exception {
        Executor executor = this.executorGroup.get(completionRequest.getModel());
        if (null == executor) {
            throw new RuntimeException(completionRequest.getModel() + " \u6a21\u578b\u6267\u884c\u5668\u5c1a\u672a\u5b9e\u73b0\uff01");
        }
        return executor.completions(apiHostByUser, apiKeyByUser, completionRequest, eventSourceListener);
    }

    @Override
    public CompletableFuture<String> completions(CompletionRequest completionRequest) throws Exception {
        return this.completions(null, null, completionRequest);
    }

    @Override
    public CompletableFuture<String> completions(String apiHostByUser, String apiKeyByUser, CompletionRequest completionRequest) throws Exception {
        final CompletableFuture<String> future = new CompletableFuture<String>();
        final StringBuffer dataBuffer = new StringBuffer();
        this.completions(apiHostByUser, apiKeyByUser, completionRequest, new EventSourceListener(){

            public void onEvent(EventSource eventSource, @Nullable String id, @Nullable String type, String data) {
                if ("[DONE]".equalsIgnoreCase(data)) {
                    future.complete(dataBuffer.toString());
                    return;
                }
                CompletionResponse chatCompletionResponse = (CompletionResponse)JSON.parseObject((String)data, CompletionResponse.class);
                List<ChatChoice> choices = chatCompletionResponse.getChoices();
                for (ChatChoice chatChoice : choices) {
                    Message delta = chatChoice.getDelta();
                    if (CompletionRequest.Role.ASSISTANT.getCode().equals(delta.getRole())) continue;
                    String finishReason = chatChoice.getFinishReason();
                    if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{finishReason}) && "stop".equalsIgnoreCase(finishReason)) {
                        future.complete(dataBuffer.toString());
                        return;
                    }
                    dataBuffer.append(delta.getContent());
                }
            }

            public void onClosed(EventSource eventSource) {
                future.completeExceptionally(new RuntimeException("Request closed before completion"));
            }

            public void onFailure(EventSource eventSource, @Nullable Throwable t, @Nullable Response response) {
                future.completeExceptionally(new RuntimeException("Request closed before completion"));
            }
        });
        return future;
    }

    @Override
    public ImageResponse genImages(ImageRequest imageRequest) throws Exception {
        return this.executorGroup.get(imageRequest.getModel()).genImages(imageRequest);
    }

    @Override
    public ImageResponse genImages(String apiHostByUser, String apiKeyByUser, ImageRequest imageRequest) throws Exception {
        return this.executorGroup.get(imageRequest.getModel()).genImages(apiHostByUser, apiKeyByUser, imageRequest);
    }

    @Override
    public OkHttpClient getClient() {
        return this.configuration.getOkHttpClient();
    }
}

