/*
 * Decompiled with CFR 0.152.
 */
package cn.bugstack.openai.executor.model.chatgpt;

import cn.bugstack.openai.executor.Executor;
import cn.bugstack.openai.executor.model.chatgpt.config.ChatGPTConfig;
import cn.bugstack.openai.executor.model.chatgpt.valobj.ChatGPTCompletionRequest;
import cn.bugstack.openai.executor.model.chatgpt.valobj.ChatGPTImageRequest;
import cn.bugstack.openai.executor.model.chatgpt.valobj.Message;
import cn.bugstack.openai.executor.parameter.CompletionRequest;
import cn.bugstack.openai.executor.parameter.ImageRequest;
import cn.bugstack.openai.executor.parameter.ImageResponse;
import cn.bugstack.openai.executor.parameter.ParameterHandler;
import cn.bugstack.openai.executor.parameter.PictureRequest;
import cn.bugstack.openai.executor.result.ResultHandler;
import cn.bugstack.openai.session.Configuration;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import okhttp3.Call;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import okhttp3.ResponseBody;
import okhttp3.sse.EventSource;
import okhttp3.sse.EventSourceListener;

public class ChatGPTModelExecutor
implements Executor,
ParameterHandler<ChatGPTCompletionRequest>,
ResultHandler {
    private final ChatGPTConfig chatGPTConfig;
    private final EventSource.Factory factory;
    private final OkHttpClient okHttpClient;

    public ChatGPTModelExecutor(Configuration configuration) {
        this.chatGPTConfig = configuration.getChatGPTConfig();
        this.factory = configuration.createRequestFactory();
        this.okHttpClient = configuration.getOkHttpClient();
    }

    @Override
    public EventSource completions(CompletionRequest completionRequest, EventSourceListener eventSourceListener) throws Exception {
        return this.completions(null, null, completionRequest, eventSourceListener);
    }

    @Override
    public EventSource completions(String apiHostByUser, String apiKeyByUser, CompletionRequest completionRequest, EventSourceListener eventSourceListener) throws Exception {
        if (!completionRequest.isStream()) {
            throw new RuntimeException("illegal parameter stream is false!");
        }
        String apiHost = null == apiHostByUser ? this.chatGPTConfig.getApiHost() : apiHostByUser;
        String apiKey = null == apiKeyByUser ? this.chatGPTConfig.getApiKey() : apiKeyByUser;
        ChatGPTCompletionRequest chatGPTCompletionRequest = this.getParameterObject(completionRequest);
        Request request = new Request.Builder().header("Authorization", "Bearer " + apiKey).url(apiHost.concat(this.chatGPTConfig.getV1_chat_completions())).post(RequestBody.create((MediaType)MediaType.parse((String)"application/json"), (String)new ObjectMapper().writeValueAsString((Object)chatGPTCompletionRequest))).build();
        return this.factory.newEventSource(request, eventSourceListener);
    }

    @Override
    public ImageResponse genImages(ImageRequest imageRequest) throws Exception {
        return this.genImages(null, null, imageRequest);
    }

    @Override
    public ImageResponse genImages(String apiHostByUser, String apiKeyByUser, ImageRequest imageRequest) throws Exception {
        ChatGPTImageRequest chatGPTImageRequest = ChatGPTImageRequest.builder().n(imageRequest.getN()).size(imageRequest.getSize()).prompt(imageRequest.getPrompt()).model(imageRequest.getModel()).build();
        String apiHost = null == apiHostByUser ? this.chatGPTConfig.getApiHost() : apiHostByUser;
        String apiKey = null == apiKeyByUser ? this.chatGPTConfig.getApiKey() : apiKeyByUser;
        Request request = new Request.Builder().url(apiHost.concat(this.chatGPTConfig.getV1_images_completions())).header("Authorization", "Bearer " + apiKey).post(RequestBody.create((MediaType)MediaType.parse((String)"application/json"), (String)new ObjectMapper().writeValueAsString((Object)chatGPTImageRequest))).build();
        Call call = this.okHttpClient.newCall(request);
        Response execute = call.execute();
        ResponseBody body = execute.body();
        if (execute.isSuccessful() && body != null) {
            String responseBody = body.string();
            ObjectMapper objectMapper = new ObjectMapper();
            return (ImageResponse)objectMapper.readValue(responseBody, ImageResponse.class);
        }
        throw new IOException("Failed to get image response");
    }

    @Override
    public EventSource pictureUnderstanding(PictureRequest pictureRequest, EventSourceListener eventSourceListener) throws Exception {
        return null;
    }

    @Override
    public EventSource pictureUnderstanding(String apiHostByUser, String apiKeyByUser, PictureRequest pictureRequest, EventSourceListener eventSourceListener) throws Exception {
        return null;
    }

    @Override
    public ChatGPTCompletionRequest getParameterObject(CompletionRequest completionRequest) {
        ArrayList<Message> chatGPTMessages = new ArrayList<Message>();
        List<cn.bugstack.openai.executor.parameter.Message> messages = completionRequest.getMessages();
        for (cn.bugstack.openai.executor.parameter.Message message : messages) {
            Message messageVO = new Message();
            messageVO.setContent(message.getContent());
            messageVO.setName(message.getName());
            messageVO.setRole(message.getRole());
            chatGPTMessages.add(messageVO);
        }
        ChatGPTCompletionRequest chatGPTCompletionRequest = new ChatGPTCompletionRequest();
        chatGPTCompletionRequest.setModel(completionRequest.getModel());
        chatGPTCompletionRequest.setTemperature(completionRequest.getTemperature());
        chatGPTCompletionRequest.setTopP(completionRequest.getTopP());
        chatGPTCompletionRequest.setStream(completionRequest.isStream());
        chatGPTCompletionRequest.setMessages(chatGPTMessages);
        return chatGPTCompletionRequest;
    }

    @Override
    public EventSourceListener eventSourceListener(EventSourceListener eventSourceListener) {
        return eventSourceListener;
    }
}

