/*
 * Decompiled with CFR 0.152.
 */
package cn.bugstack.openai.executor.model.xunfei.utils;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.text.SimpleDateFormat;
import java.util.Base64;
import java.util.Date;
import java.util.Locale;
import java.util.Objects;
import java.util.TimeZone;
import java.util.concurrent.TimeUnit;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import okhttp3.HttpUrl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class URLAuthUtils {
    private static final Logger log = LoggerFactory.getLogger(URLAuthUtils.class);
    private static final int expireMillis = 1800000;
    public static Cache<String, String> cache = CacheBuilder.newBuilder().expireAfterWrite(1740000L, TimeUnit.MILLISECONDS).build();

    public static String getAuthURl(String hostUrl, String apiKey, String apiSecret) throws Exception {
        return URLAuthUtils.getAuthURl(hostUrl, apiKey, apiSecret, "GET", Boolean.TRUE);
    }

    public static String getAuthURl(String hostUrl, String apiKey, String apiSecret, String httpMethod, Boolean webSocket) throws Exception {
        String token = (String)cache.getIfPresent((Object)apiKey);
        if (null != token) {
            return token;
        }
        URL url = new URL(hostUrl);
        SimpleDateFormat format = new SimpleDateFormat("EEE, dd MMM yyyy HH:mm:ss z", Locale.US);
        format.setTimeZone(TimeZone.getTimeZone("GMT"));
        String date = format.format(new Date());
        String preStr = "host: " + url.getHost() + "\ndate: " + date + "\n" + httpMethod + " " + url.getPath() + " HTTP/1.1";
        Mac mac = Mac.getInstance("hmacsha256");
        SecretKeySpec spec = new SecretKeySpec(apiSecret.getBytes(StandardCharsets.UTF_8), "hmacsha256");
        mac.init(spec);
        byte[] hexDigits = mac.doFinal(preStr.getBytes(StandardCharsets.UTF_8));
        String sha = Base64.getEncoder().encodeToString(hexDigits);
        String authorization = String.format("api_key=\"%s\", algorithm=\"%s\", headers=\"%s\", signature=\"%s\"", apiKey, "hmac-sha256", "host date request-line", sha);
        HttpUrl authURL = Objects.requireNonNull(HttpUrl.parse((String)("https://" + url.getHost() + url.getPath()))).newBuilder().addQueryParameter("authorization", Base64.getEncoder().encodeToString(authorization.getBytes(StandardCharsets.UTF_8))).addQueryParameter("date", date).addQueryParameter("host", url.getHost()).build();
        String httpURL = authURL.toString();
        if (webSocket.booleanValue()) {
            httpURL = authURL.toString().replace("http://", "ws://").replace("https://", "wss://");
        }
        cache.put((Object)apiKey, (Object)httpURL);
        return httpURL;
    }
}

