/*
 * Decompiled with CFR 0.152.
 */
package cn.bugstack.openai.executor.model.google.valobj.model;

import cn.bugstack.openai.executor.model.google.config.Const;
import cn.bugstack.openai.executor.model.google.valobj.model.Model;
import cn.bugstack.openai.executor.model.google.valobj.model.SupportMethod;

public enum GeminiProModel {
    TEXT(Const.TEXT_GEMINI_PRO_CODE, GeminiProModel.initTextModel()),
    TEXT_STREAM(Const.TEXT_GEMINI_PRO_CHAT_CODE, GeminiProModel.initTextStreamModel());

    private final String code;
    private final Model model;

    private GeminiProModel(String code, Model model) {
        this.code = code;
        this.model = model;
    }

    public static Model getModel(String code) {
        for (GeminiProModel value : GeminiProModel.values()) {
            if (!value.getCode().equals(code)) continue;
            return value.getModel();
        }
        return null;
    }

    private static Model initTextModel() {
        return Model.builder().name("models/gemini-pro").displayName("Gemini Pro").version("001").description("The best model for scaling across a wide range of tasks").supportMethod(SupportMethod.builder().generateMethod("generateContent").build()).build();
    }

    private static Model initTextStreamModel() {
        return Model.builder().name("models/gemini-pro").displayName("Gemini Pro").version("001").description("The best model for scaling across a wide range of tasks").supportMethod(SupportMethod.builder().generateMethod("streamGenerateContent").build()).build();
    }

    public String getCode() {
        return this.code;
    }

    public Model getModel() {
        return this.model;
    }
}

