/*
 * Decompiled with CFR 0.152.
 */
package cn.bugstack.openai.executor.model.google.valobj.model;

import cn.bugstack.openai.executor.model.google.config.Const;
import cn.bugstack.openai.executor.model.google.valobj.model.Model;
import cn.bugstack.openai.executor.model.google.valobj.model.SupportMethod;

public enum PalmModel {
    TEXT(Const.TEXT_MODEL_CODE, PalmModel.initTextModel()),
    CHAT(Const.CHAT_MODEL_CODE, PalmModel.initChatModel());

    private final String code;
    private final Model model;

    private PalmModel(String code, Model model) {
        this.code = code;
        this.model = model;
    }

    public static Model getModel(String code) {
        for (PalmModel value : PalmModel.values()) {
            if (!value.getCode().equals(code)) continue;
            return value.getModel();
        }
        return null;
    }

    private static Model initTextModel() {
        return Model.builder().name(Const.TEXT_MODEL_CODE).displayName("Text Bison").version("001").description("Model targeted for text generation.").inputTokenLimit(8196).outputTokenLimit(1024).supportMethod(SupportMethod.builder().generateMethod("generateText").build()).build();
    }

    private static Model initChatModel() {
        return Model.builder().name(Const.CHAT_MODEL_CODE).displayName("Chat Bison").version("001").description("Chat-optimized generative language model.").inputTokenLimit(4096).outputTokenLimit(1024).supportMethod(new SupportMethod("generateMessage", "countMessageTokens")).build();
    }

    public String getCode() {
        return this.code;
    }

    public Model getModel() {
        return this.model;
    }
}

