/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.codegen.model.config.templates;

import com.amazonaws.codegen.internal.ClassLoaderHelper;
import com.amazonaws.codegen.internal.Jackson;
import com.amazonaws.codegen.model.config.templates.ChildTemplate;
import com.amazonaws.codegen.model.config.templates.TopLevelTemplate;
import com.amazonaws.codegen.model.intermediate.Protocol;
import java.io.InputStream;
import java.util.LinkedList;
import java.util.List;

public class CodeGenTemplatesConfig {
    private TopLevelTemplate syncClient;
    private TopLevelTemplate asyncClient;
    private TopLevelTemplate syncAbstractClass;
    private TopLevelTemplate asyncAbstractClass;
    private TopLevelTemplate syncInterface;
    private TopLevelTemplate asyncInterface;
    private TopLevelTemplate requestClass;
    private TopLevelTemplate responseClass;
    private TopLevelTemplate modelClass;
    private TopLevelTemplate modelEnum;
    private TopLevelTemplate modelUnmarshaller;
    private TopLevelTemplate modelMarshaller;
    private TopLevelTemplate exceptionClass;
    private TopLevelTemplate exceptionUnmarshaller;
    private TopLevelTemplate policyActionClass;
    private TopLevelTemplate packageInfo;
    private List<ChildTemplate> commonChildTemplates;

    public static CodeGenTemplatesConfig load(Protocol protocol) {
        String protocolConfigFilePath = String.format("/protocol-config/%s.json", protocol.getValue());
        InputStream input = ClassLoaderHelper.getResourceAsStream(protocolConfigFilePath, CodeGenTemplatesConfig.class);
        if (input == null) {
            input = ClassLoaderHelper.getResourceAsStream("/" + protocolConfigFilePath, CodeGenTemplatesConfig.class);
        }
        try {
            return Jackson.load(CodeGenTemplatesConfig.class, input);
        }
        catch (Exception e) {
            throw new RuntimeException("Unable to load the protocol specific config file from the location " + protocolConfigFilePath, e);
        }
    }

    public static CodeGenTemplatesConfig merge(CodeGenTemplatesConfig config, CodeGenTemplatesConfig override) {
        CodeGenTemplatesConfig merged = new CodeGenTemplatesConfig();
        merged.setSyncClient(TopLevelTemplate.merge(config.getSyncClient(), override.getSyncClient()));
        merged.setAsyncClient(TopLevelTemplate.merge(config.getAsyncClient(), override.getAsyncClient()));
        merged.setSyncAbstractClass(TopLevelTemplate.merge(config.getSyncAbstractClass(), override.getSyncAbstractClass()));
        merged.setAsyncAbstractClass(TopLevelTemplate.merge(config.getAsyncAbstractClass(), override.getAsyncAbstractClass()));
        merged.setSyncInterface(TopLevelTemplate.merge(config.getSyncInterface(), override.getSyncInterface()));
        merged.setAsyncInterface(TopLevelTemplate.merge(config.getAsyncInterface(), override.getAsyncInterface()));
        merged.setRequestClass(TopLevelTemplate.merge(config.getRequestClass(), override.getRequestClass()));
        merged.setResponseClass(TopLevelTemplate.merge(config.getResponseClass(), override.getResponseClass()));
        merged.setModelClass(TopLevelTemplate.merge(config.getModelClass(), override.getModelClass()));
        merged.setModelEnum(TopLevelTemplate.merge(config.getModelEnum(), override.getModelEnum()));
        merged.setModelUnmarshaller(TopLevelTemplate.merge(config.getModelUnmarshaller(), override.getModelUnmarshaller()));
        merged.setModelMarshaller(TopLevelTemplate.merge(config.getModelMarshaller(), override.getModelMarshaller()));
        merged.setExceptionClass(TopLevelTemplate.merge(config.getExceptionClass(), override.getExceptionClass()));
        merged.setExceptionUnmarshaller(TopLevelTemplate.merge(config.getExceptionUnmarshaller(), override.getExceptionUnmarshaller()));
        merged.setPolicyActionClass(TopLevelTemplate.merge(config.getPolicyActionClass(), override.getPolicyActionClass()));
        merged.setPackageInfo(TopLevelTemplate.merge(config.getPackageInfo(), override.getPackageInfo()));
        LinkedList<ChildTemplate> commonChildTemplates = new LinkedList<ChildTemplate>();
        if (config.getCommonChildTemplates() != null) {
            commonChildTemplates.addAll(config.getCommonChildTemplates());
        }
        if (override.getCommonChildTemplates() != null) {
            commonChildTemplates.addAll(override.getCommonChildTemplates());
        }
        merged.setCommonChildTemplates(commonChildTemplates);
        return merged;
    }

    public TopLevelTemplate getSyncClient() {
        return this.syncClient;
    }

    public void setSyncClient(TopLevelTemplate syncClient) {
        this.syncClient = syncClient;
    }

    public TopLevelTemplate getAsyncClient() {
        return this.asyncClient;
    }

    public void setAsyncClient(TopLevelTemplate asyncClient) {
        this.asyncClient = asyncClient;
    }

    public TopLevelTemplate getSyncAbstractClass() {
        return this.syncAbstractClass;
    }

    public void setSyncAbstractClass(TopLevelTemplate syncAbstractClass) {
        this.syncAbstractClass = syncAbstractClass;
    }

    public TopLevelTemplate getAsyncAbstractClass() {
        return this.asyncAbstractClass;
    }

    public void setAsyncAbstractClass(TopLevelTemplate asyncAbstractClass) {
        this.asyncAbstractClass = asyncAbstractClass;
    }

    public TopLevelTemplate getSyncInterface() {
        return this.syncInterface;
    }

    public void setSyncInterface(TopLevelTemplate syncInterface) {
        this.syncInterface = syncInterface;
    }

    public TopLevelTemplate getAsyncInterface() {
        return this.asyncInterface;
    }

    public void setAsyncInterface(TopLevelTemplate asyncInterface) {
        this.asyncInterface = asyncInterface;
    }

    public TopLevelTemplate getRequestClass() {
        return this.requestClass;
    }

    public void setRequestClass(TopLevelTemplate requestClass) {
        this.requestClass = requestClass;
    }

    public TopLevelTemplate getResponseClass() {
        return this.responseClass;
    }

    public void setResponseClass(TopLevelTemplate responseClass) {
        this.responseClass = responseClass;
    }

    public TopLevelTemplate getModelClass() {
        return this.modelClass;
    }

    public void setModelClass(TopLevelTemplate modelClass) {
        this.modelClass = modelClass;
    }

    public TopLevelTemplate getModelEnum() {
        return this.modelEnum;
    }

    public void setModelEnum(TopLevelTemplate modelEnum) {
        this.modelEnum = modelEnum;
    }

    public TopLevelTemplate getModelUnmarshaller() {
        return this.modelUnmarshaller;
    }

    public void setModelUnmarshaller(TopLevelTemplate modelUnmarshaller) {
        this.modelUnmarshaller = modelUnmarshaller;
    }

    public TopLevelTemplate getModelMarshaller() {
        return this.modelMarshaller;
    }

    public void setModelMarshaller(TopLevelTemplate modelMarshaller) {
        this.modelMarshaller = modelMarshaller;
    }

    public TopLevelTemplate getExceptionClass() {
        return this.exceptionClass;
    }

    public void setExceptionClass(TopLevelTemplate exceptionClass) {
        this.exceptionClass = exceptionClass;
    }

    public TopLevelTemplate getExceptionUnmarshaller() {
        return this.exceptionUnmarshaller;
    }

    public void setExceptionUnmarshaller(TopLevelTemplate exceptionUnmarshaller) {
        this.exceptionUnmarshaller = exceptionUnmarshaller;
    }

    public List<ChildTemplate> getCommonChildTemplates() {
        return this.commonChildTemplates;
    }

    public void setCommonChildTemplates(List<ChildTemplate> commonChildTemplates) {
        this.commonChildTemplates = commonChildTemplates;
    }

    public TopLevelTemplate getPolicyActionClass() {
        return this.policyActionClass;
    }

    public void setPolicyActionClass(TopLevelTemplate policyActionClass) {
        this.policyActionClass = policyActionClass;
    }

    public TopLevelTemplate getPackageInfo() {
        return this.packageInfo;
    }

    public void setPackageInfo(TopLevelTemplate packageInfo) {
        this.packageInfo = packageInfo;
    }
}

