/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.codegen.model.intermediate;

import com.amazonaws.codegen.internal.Constants;
import com.amazonaws.codegen.internal.DocumentationUtils;
import com.amazonaws.codegen.internal.Utils;
import com.amazonaws.codegen.model.intermediate.ArgumentModel;
import com.amazonaws.codegen.model.intermediate.DocumentationModel;
import com.amazonaws.codegen.model.intermediate.ExceptionModel;
import com.amazonaws.codegen.model.intermediate.Metadata;
import com.amazonaws.codegen.model.intermediate.ReturnTypeModel;
import com.amazonaws.codegen.model.intermediate.ShapeModel;
import com.amazonaws.codegen.model.intermediate.SimpleMethodFormModel;
import com.amazonaws.codegen.model.intermediate.VariableModel;
import com.amazonaws.codegen.model.service.EndpointDiscovery;
import com.amazonaws.codegen.model.service.EndpointTrait;
import com.amazonaws.codegen.model.service.HostPrefixProcessor;
import com.amazonaws.codegen.naming.DefaultNamingStrategy;
import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;

public class OperationModel
extends DocumentationModel {
    private String operationName;
    private boolean deprecated;
    private VariableModel input;
    private String inputStreamPropertyName;
    private ReturnTypeModel returnType;
    private List<ExceptionModel> exceptions;
    private List<SimpleMethodFormModel> simpleMethods;
    private boolean hasBlobMemberAsPayload;
    private boolean isAuthenticated = true;
    private EndpointDiscovery endpointDiscovery;
    private boolean endpointOperation;
    private boolean endpointCacheRequired;
    private EndpointTrait endpointTrait;
    @JsonIgnore
    private ShapeModel inputShape;
    @JsonIgnore
    private ShapeModel outputShape;

    public String getOperationName() {
        return this.operationName;
    }

    public void setOperationName(String operationName) {
        this.operationName = operationName;
    }

    public String getMethodName() {
        String sanitizedOperationName = Utils.unCapitialize(Utils.sanitize(this.operationName).collect(Collectors.joining()));
        if (!DefaultNamingStrategy.isJavaKeyword(this.operationName)) {
            return sanitizedOperationName;
        }
        return sanitizedOperationName + "Operation";
    }

    public boolean isDeprecated() {
        return this.deprecated;
    }

    public void setDeprecated(boolean deprecated) {
        this.deprecated = deprecated;
    }

    public String getSyncDocumentation(Metadata md) {
        return this.getDocumentation(MethodType.SYNC, md);
    }

    public String getAsyncDocumentation(Metadata md) {
        return this.getDocumentation(MethodType.ASYNC, md);
    }

    public String getAsyncDocumentationWithHandler(Metadata md) {
        return this.getDocumentation(MethodType.ASYNC_WITH_HANDLER, md);
    }

    public boolean isAuthenticated() {
        return this.isAuthenticated;
    }

    public void setIsAuthenticated(boolean isAuthenticated) {
        this.isAuthenticated = isAuthenticated;
    }

    public ShapeModel getInputShape() {
        return this.inputShape;
    }

    public void setInputShape(ShapeModel inputShape) {
        this.inputShape = inputShape;
    }

    public ShapeModel getOutputShape() {
        return this.outputShape;
    }

    public void setOutputShape(ShapeModel outputShape) {
        this.outputShape = outputShape;
    }

    private String getDocumentation(MethodType methodType, Metadata md) {
        StringBuilder docBuilder = new StringBuilder("/**");
        if (this.documentation != null) {
            docBuilder.append(this.documentation);
        } else {
            docBuilder.append("Invokes the ").append(this.operationName).append(" operation");
            if (methodType.isAsync()) {
                docBuilder.append(" asynchronously");
            }
            docBuilder.append(".");
        }
        if (this.input != null) {
            docBuilder.append(Constants.LINE_SEPARATOR).append("@param ").append(this.input.getVariableName()).append(" ").append(DocumentationUtils.stripHTMLTags(this.input.getDocumentation()));
        }
        if (methodType == MethodType.ASYNC_WITH_HANDLER) {
            docBuilder.append(Constants.LINE_SEPARATOR).append("@param asyncHandler Asynchronous callback handler for events in the lifecycle of the request. Users can provide an implementation of the callback methods in this interface to receive notification of successful or unsuccessful completion of the operation.");
        }
        if (this.returnType != null) {
            docBuilder.append(Constants.LINE_SEPARATOR).append("@return ");
            if (methodType.isAsync()) {
                docBuilder.append("A Java Future containing the result of the %s operation returned by the service.".replace("%s", this.operationName));
            } else {
                docBuilder.append("Result of the %s operation returned by the service.".replace("%s", this.operationName));
            }
        }
        if (!methodType.isAsync() && this.exceptions != null && !this.exceptions.isEmpty()) {
            for (ExceptionModel exception : this.exceptions) {
                docBuilder.append(Constants.LINE_SEPARATOR).append("@throws ").append(exception.getExceptionName()).append(" ").append(DocumentationUtils.stripHTMLTags(exception.getDocumentation()));
            }
        }
        docBuilder.append(this.getSampleTagForMethodType(methodType, md));
        String crosslink = DocumentationUtils.createLinkToServiceDocumentation(md, this.operationName);
        if (!crosslink.isEmpty()) {
            docBuilder.append(Constants.LINE_SEPARATOR).append(crosslink);
        }
        docBuilder.append("*/");
        return docBuilder.toString();
    }

    private String getSampleTagForMethodType(MethodType methodType, Metadata md) {
        StringBuilder sb = new StringBuilder();
        sb.append(Constants.LINE_SEPARATOR).append("@sample ");
        if (methodType == MethodType.SYNC) {
            sb.append(md.getSyncInterface());
        } else if (methodType == MethodType.ASYNC) {
            sb.append(md.getAsyncInterface());
        } else if (methodType == MethodType.ASYNC_WITH_HANDLER) {
            sb.append(md.getAsyncInterface() + "Handler");
        }
        sb.append(".").append(this.operationName);
        return sb.toString();
    }

    public VariableModel getInput() {
        return this.input;
    }

    public void setInput(VariableModel input) {
        this.input = input;
    }

    public String getInputStreamPropertyName() {
        return this.inputStreamPropertyName;
    }

    public void setInputStreamPropertyName(String inputStreamPropertyName) {
        this.inputStreamPropertyName = inputStreamPropertyName;
    }

    public ReturnTypeModel getReturnType() {
        return this.returnType;
    }

    public void setReturnType(ReturnTypeModel returnType) {
        this.returnType = returnType;
    }

    private String getBaseReturnType(boolean async) {
        if (this.returnType == null) {
            if (async) {
                return "Void";
            }
            return "void";
        }
        return this.returnType.getReturnType();
    }

    public String getSyncReturnType() {
        return this.getBaseReturnType(false);
    }

    public String getAsyncReturnType() {
        return this.getBaseReturnType(true);
    }

    public String getAsyncFutureType() {
        return "java.util.concurrent.Future<" + this.getAsyncReturnType() + ">";
    }

    public String getAsyncCallableType() {
        return "java.util.concurrent.Callable<" + this.getAsyncReturnType() + ">";
    }

    public String getAsyncHandlerType() {
        return "com.amazonaws.handlers.AsyncHandler<" + this.input.getVariableType() + ", " + this.getAsyncReturnType() + ">";
    }

    public List<ExceptionModel> getExceptions() {
        return this.exceptions;
    }

    public void setExceptions(List<ExceptionModel> exceptions) {
        this.exceptions = exceptions;
    }

    public void addException(ExceptionModel exception) {
        if (this.exceptions == null) {
            this.exceptions = new ArrayList<ExceptionModel>();
        }
        this.exceptions.add(exception);
    }

    @JsonIgnore
    public List<SimpleMethodFormModel> getSimpleMethodForms() {
        return this.simpleMethods;
    }

    public void addSimpleMethodForm(List<ArgumentModel> arguments, boolean deprecated) {
        if (this.simpleMethods == null) {
            this.simpleMethods = new ArrayList<SimpleMethodFormModel>();
        }
        SimpleMethodFormModel form = new SimpleMethodFormModel();
        form.setArguments(arguments);
        form.setDeprecated(deprecated);
        this.simpleMethods.add(form);
    }

    public boolean getHasBlobMemberAsPayload() {
        return this.hasBlobMemberAsPayload;
    }

    public void setHasBlobMemberAsPayload(boolean hasBlobMemberAsPayload) {
        this.hasBlobMemberAsPayload = hasBlobMemberAsPayload;
    }

    public EndpointDiscovery getEndpointDiscovery() {
        return this.endpointDiscovery;
    }

    public void setEndpointDiscovery(EndpointDiscovery endpointDiscovery) {
        this.endpointDiscovery = endpointDiscovery;
    }

    public boolean isEndpointOperation() {
        return this.endpointOperation;
    }

    public void setEndpointOperation(boolean endpointOperation) {
        this.endpointOperation = endpointOperation;
    }

    public boolean isEndpointCacheRequired() {
        return this.endpointCacheRequired;
    }

    public void setEndpointCacheRequired(boolean endpointCacheRequired) {
        this.endpointCacheRequired = endpointCacheRequired;
    }

    public EndpointTrait getEndpointTrait() {
        return this.endpointTrait;
    }

    public HostPrefixProcessor getHostPrefixProcessor() {
        return this.endpointTrait != null ? new HostPrefixProcessor(this.endpointTrait.getHostPrefix()) : null;
    }

    public void setEndpointTrait(EndpointTrait endpointTrait) {
        this.endpointTrait = endpointTrait;
    }

    public boolean hasRequiresLengthInInput() {
        return this.inputShape != null && this.inputShape.isHasRequiresLengthMember();
    }

    private static enum MethodType {
        SYNC(false),
        ASYNC(true),
        ASYNC_WITH_HANDLER(true);

        private final boolean async;

        private MethodType(boolean async) {
            this.async = async;
        }

        public boolean isAsync() {
            return this.async;
        }
    }
}

