/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.elastictranscoder.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.services.elastictranscoder.model.ListPresetsRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;
import java.io.ByteArrayInputStream;
import java.io.InputStream;

public class ListPresetsRequestMarshaller
implements Marshaller<Request<ListPresetsRequest>, ListPresetsRequest> {
    private static final String DEFAULT_CONTENT_TYPE = "";

    public Request<ListPresetsRequest> marshall(ListPresetsRequest listPresetsRequest) {
        String pageToken;
        String ascending;
        if (listPresetsRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)listPresetsRequest, "AmazonElasticTranscoder");
        request.setHttpMethod(HttpMethodName.GET);
        String uriResourcePath = "/2012-09-25/presets";
        request.setResourcePath(uriResourcePath);
        String string = ascending = listPresetsRequest.getAscending() == null ? null : StringUtils.fromString((String)listPresetsRequest.getAscending());
        if (ascending != null) {
            request.addParameter("Ascending", ascending);
        }
        String string2 = pageToken = listPresetsRequest.getPageToken() == null ? null : StringUtils.fromString((String)listPresetsRequest.getPageToken());
        if (pageToken != null) {
            request.addParameter("PageToken", pageToken);
        }
        request.setContent((InputStream)new ByteArrayInputStream(new byte[0]));
        if (!request.getHeaders().containsKey("Content-Type")) {
            request.addHeader("Content-Type", DEFAULT_CONTENT_TYPE);
        }
        return request;
    }
}

