/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.elastictranscoder.model;

import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.internal.SdkInternalMap;
import com.amazonaws.services.elastictranscoder.model.JobInput;
import com.amazonaws.services.elastictranscoder.model.JobOutput;
import com.amazonaws.services.elastictranscoder.model.Playlist;
import com.amazonaws.services.elastictranscoder.model.Timing;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;
import java.util.Map;

public class Job
implements Serializable,
Cloneable {
    private String id;
    private String arn;
    private String pipelineId;
    private JobInput input;
    private SdkInternalList<JobInput> inputs;
    private JobOutput output;
    private SdkInternalList<JobOutput> outputs;
    private String outputKeyPrefix;
    private SdkInternalList<Playlist> playlists;
    private String status;
    private SdkInternalMap<String, String> userMetadata;
    private Timing timing;

    public void setId(String id) {
        this.id = id;
    }

    public String getId() {
        return this.id;
    }

    public Job withId(String id) {
        this.setId(id);
        return this;
    }

    public void setArn(String arn) {
        this.arn = arn;
    }

    public String getArn() {
        return this.arn;
    }

    public Job withArn(String arn) {
        this.setArn(arn);
        return this;
    }

    public void setPipelineId(String pipelineId) {
        this.pipelineId = pipelineId;
    }

    public String getPipelineId() {
        return this.pipelineId;
    }

    public Job withPipelineId(String pipelineId) {
        this.setPipelineId(pipelineId);
        return this;
    }

    public void setInput(JobInput input) {
        this.input = input;
    }

    public JobInput getInput() {
        return this.input;
    }

    public Job withInput(JobInput input) {
        this.setInput(input);
        return this;
    }

    public List<JobInput> getInputs() {
        if (this.inputs == null) {
            this.inputs = new SdkInternalList();
        }
        return this.inputs;
    }

    public void setInputs(Collection<JobInput> inputs) {
        if (inputs == null) {
            this.inputs = null;
            return;
        }
        this.inputs = new SdkInternalList(inputs);
    }

    public Job withInputs(JobInput ... inputs) {
        if (this.inputs == null) {
            this.setInputs((Collection<JobInput>)new SdkInternalList(inputs.length));
        }
        for (JobInput ele : inputs) {
            this.inputs.add((Object)ele);
        }
        return this;
    }

    public Job withInputs(Collection<JobInput> inputs) {
        this.setInputs(inputs);
        return this;
    }

    public void setOutput(JobOutput output) {
        this.output = output;
    }

    public JobOutput getOutput() {
        return this.output;
    }

    public Job withOutput(JobOutput output) {
        this.setOutput(output);
        return this;
    }

    public List<JobOutput> getOutputs() {
        if (this.outputs == null) {
            this.outputs = new SdkInternalList();
        }
        return this.outputs;
    }

    public void setOutputs(Collection<JobOutput> outputs) {
        if (outputs == null) {
            this.outputs = null;
            return;
        }
        this.outputs = new SdkInternalList(outputs);
    }

    public Job withOutputs(JobOutput ... outputs) {
        if (this.outputs == null) {
            this.setOutputs((Collection<JobOutput>)new SdkInternalList(outputs.length));
        }
        for (JobOutput ele : outputs) {
            this.outputs.add((Object)ele);
        }
        return this;
    }

    public Job withOutputs(Collection<JobOutput> outputs) {
        this.setOutputs(outputs);
        return this;
    }

    public void setOutputKeyPrefix(String outputKeyPrefix) {
        this.outputKeyPrefix = outputKeyPrefix;
    }

    public String getOutputKeyPrefix() {
        return this.outputKeyPrefix;
    }

    public Job withOutputKeyPrefix(String outputKeyPrefix) {
        this.setOutputKeyPrefix(outputKeyPrefix);
        return this;
    }

    public List<Playlist> getPlaylists() {
        if (this.playlists == null) {
            this.playlists = new SdkInternalList();
        }
        return this.playlists;
    }

    public void setPlaylists(Collection<Playlist> playlists) {
        if (playlists == null) {
            this.playlists = null;
            return;
        }
        this.playlists = new SdkInternalList(playlists);
    }

    public Job withPlaylists(Playlist ... playlists) {
        if (this.playlists == null) {
            this.setPlaylists((Collection<Playlist>)new SdkInternalList(playlists.length));
        }
        for (Playlist ele : playlists) {
            this.playlists.add((Object)ele);
        }
        return this;
    }

    public Job withPlaylists(Collection<Playlist> playlists) {
        this.setPlaylists(playlists);
        return this;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public String getStatus() {
        return this.status;
    }

    public Job withStatus(String status) {
        this.setStatus(status);
        return this;
    }

    public Map<String, String> getUserMetadata() {
        if (this.userMetadata == null) {
            this.userMetadata = new SdkInternalMap();
        }
        return this.userMetadata;
    }

    public void setUserMetadata(Map<String, String> userMetadata) {
        this.userMetadata = userMetadata == null ? null : new SdkInternalMap(userMetadata);
    }

    public Job withUserMetadata(Map<String, String> userMetadata) {
        this.setUserMetadata(userMetadata);
        return this;
    }

    public Job addUserMetadataEntry(String key, String value) {
        if (null == this.userMetadata) {
            this.userMetadata = new SdkInternalMap();
        }
        if (this.userMetadata.containsKey((Object)key)) {
            throw new IllegalArgumentException("Duplicated keys (" + key.toString() + ") are provided.");
        }
        this.userMetadata.put((Object)key, (Object)value);
        return this;
    }

    public Job clearUserMetadataEntries() {
        this.userMetadata = null;
        return this;
    }

    public void setTiming(Timing timing) {
        this.timing = timing;
    }

    public Timing getTiming() {
        return this.timing;
    }

    public Job withTiming(Timing timing) {
        this.setTiming(timing);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getId() != null) {
            sb.append("Id: " + this.getId() + ",");
        }
        if (this.getArn() != null) {
            sb.append("Arn: " + this.getArn() + ",");
        }
        if (this.getPipelineId() != null) {
            sb.append("PipelineId: " + this.getPipelineId() + ",");
        }
        if (this.getInput() != null) {
            sb.append("Input: " + this.getInput() + ",");
        }
        if (this.getInputs() != null) {
            sb.append("Inputs: " + this.getInputs() + ",");
        }
        if (this.getOutput() != null) {
            sb.append("Output: " + this.getOutput() + ",");
        }
        if (this.getOutputs() != null) {
            sb.append("Outputs: " + this.getOutputs() + ",");
        }
        if (this.getOutputKeyPrefix() != null) {
            sb.append("OutputKeyPrefix: " + this.getOutputKeyPrefix() + ",");
        }
        if (this.getPlaylists() != null) {
            sb.append("Playlists: " + this.getPlaylists() + ",");
        }
        if (this.getStatus() != null) {
            sb.append("Status: " + this.getStatus() + ",");
        }
        if (this.getUserMetadata() != null) {
            sb.append("UserMetadata: " + this.getUserMetadata() + ",");
        }
        if (this.getTiming() != null) {
            sb.append("Timing: " + this.getTiming());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Job)) {
            return false;
        }
        Job other = (Job)obj;
        if (other.getId() == null ^ this.getId() == null) {
            return false;
        }
        if (other.getId() != null && !other.getId().equals(this.getId())) {
            return false;
        }
        if (other.getArn() == null ^ this.getArn() == null) {
            return false;
        }
        if (other.getArn() != null && !other.getArn().equals(this.getArn())) {
            return false;
        }
        if (other.getPipelineId() == null ^ this.getPipelineId() == null) {
            return false;
        }
        if (other.getPipelineId() != null && !other.getPipelineId().equals(this.getPipelineId())) {
            return false;
        }
        if (other.getInput() == null ^ this.getInput() == null) {
            return false;
        }
        if (other.getInput() != null && !other.getInput().equals(this.getInput())) {
            return false;
        }
        if (other.getInputs() == null ^ this.getInputs() == null) {
            return false;
        }
        if (other.getInputs() != null && !other.getInputs().equals(this.getInputs())) {
            return false;
        }
        if (other.getOutput() == null ^ this.getOutput() == null) {
            return false;
        }
        if (other.getOutput() != null && !other.getOutput().equals(this.getOutput())) {
            return false;
        }
        if (other.getOutputs() == null ^ this.getOutputs() == null) {
            return false;
        }
        if (other.getOutputs() != null && !other.getOutputs().equals(this.getOutputs())) {
            return false;
        }
        if (other.getOutputKeyPrefix() == null ^ this.getOutputKeyPrefix() == null) {
            return false;
        }
        if (other.getOutputKeyPrefix() != null && !other.getOutputKeyPrefix().equals(this.getOutputKeyPrefix())) {
            return false;
        }
        if (other.getPlaylists() == null ^ this.getPlaylists() == null) {
            return false;
        }
        if (other.getPlaylists() != null && !other.getPlaylists().equals(this.getPlaylists())) {
            return false;
        }
        if (other.getStatus() == null ^ this.getStatus() == null) {
            return false;
        }
        if (other.getStatus() != null && !other.getStatus().equals(this.getStatus())) {
            return false;
        }
        if (other.getUserMetadata() == null ^ this.getUserMetadata() == null) {
            return false;
        }
        if (other.getUserMetadata() != null && !other.getUserMetadata().equals(this.getUserMetadata())) {
            return false;
        }
        if (other.getTiming() == null ^ this.getTiming() == null) {
            return false;
        }
        return other.getTiming() == null || other.getTiming().equals(this.getTiming());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getId() == null ? 0 : this.getId().hashCode());
        hashCode = 31 * hashCode + (this.getArn() == null ? 0 : this.getArn().hashCode());
        hashCode = 31 * hashCode + (this.getPipelineId() == null ? 0 : this.getPipelineId().hashCode());
        hashCode = 31 * hashCode + (this.getInput() == null ? 0 : this.getInput().hashCode());
        hashCode = 31 * hashCode + (this.getInputs() == null ? 0 : this.getInputs().hashCode());
        hashCode = 31 * hashCode + (this.getOutput() == null ? 0 : this.getOutput().hashCode());
        hashCode = 31 * hashCode + (this.getOutputs() == null ? 0 : this.getOutputs().hashCode());
        hashCode = 31 * hashCode + (this.getOutputKeyPrefix() == null ? 0 : this.getOutputKeyPrefix().hashCode());
        hashCode = 31 * hashCode + (this.getPlaylists() == null ? 0 : this.getPlaylists().hashCode());
        hashCode = 31 * hashCode + (this.getStatus() == null ? 0 : this.getStatus().hashCode());
        hashCode = 31 * hashCode + (this.getUserMetadata() == null ? 0 : this.getUserMetadata().hashCode());
        hashCode = 31 * hashCode + (this.getTiming() == null ? 0 : this.getTiming().hashCode());
        return hashCode;
    }

    public Job clone() {
        try {
            return (Job)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }
}

