/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.elastictranscoder.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.internal.ListWithAutoConstructFlag;
import com.amazonaws.services.elastictranscoder.model.Artwork;
import com.amazonaws.services.elastictranscoder.model.CaptionFormat;
import com.amazonaws.services.elastictranscoder.model.CaptionSource;
import com.amazonaws.services.elastictranscoder.model.Captions;
import com.amazonaws.services.elastictranscoder.model.Clip;
import com.amazonaws.services.elastictranscoder.model.CreateJobOutput;
import com.amazonaws.services.elastictranscoder.model.CreateJobPlaylist;
import com.amazonaws.services.elastictranscoder.model.CreateJobRequest;
import com.amazonaws.services.elastictranscoder.model.Encryption;
import com.amazonaws.services.elastictranscoder.model.JobAlbumArt;
import com.amazonaws.services.elastictranscoder.model.JobInput;
import com.amazonaws.services.elastictranscoder.model.JobWatermark;
import com.amazonaws.services.elastictranscoder.model.TimeSpan;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringInputStream;
import com.amazonaws.util.StringUtils;
import com.amazonaws.util.json.JSONWriter;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public class CreateJobRequestMarshaller
implements Marshaller<Request<CreateJobRequest>, CreateJobRequest> {
    private static final String RESOURCE_PATH_TEMPLATE;
    private static final Map<String, String> STATIC_QUERY_PARAMS;
    private static final Map<String, String> DYNAMIC_QUERY_PARAMS;

    public Request<CreateJobRequest> marshall(CreateJobRequest createJobRequest) {
        if (createJobRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)createJobRequest, "AmazonElasticTranscoder");
        String target = "EtsCustomerService.CreateJob";
        request.addHeader("X-Amz-Target", target);
        request.setHttpMethod(HttpMethodName.POST);
        String uriResourcePath = RESOURCE_PATH_TEMPLATE;
        request.setResourcePath(uriResourcePath.replaceAll("//", "/"));
        for (Map.Entry<String, String> entry : STATIC_QUERY_PARAMS.entrySet()) {
            request.addParameter(entry.getKey(), entry.getValue());
        }
        try {
            ListWithAutoConstructFlag playlistsList;
            ListWithAutoConstructFlag outputsList;
            Encryption encryption;
            Encryption encryption2;
            CreateJobOutput output;
            JobInput input;
            StringWriter stringWriter = new StringWriter();
            JSONWriter jsonWriter = new JSONWriter((Writer)stringWriter);
            jsonWriter.object();
            if (createJobRequest.getPipelineId() != null) {
                jsonWriter.key("PipelineId").value((Object)createJobRequest.getPipelineId());
            }
            if ((input = createJobRequest.getInput()) != null) {
                Encryption encryption3;
                jsonWriter.key("Input");
                jsonWriter.object();
                if (input.getKey() != null) {
                    jsonWriter.key("Key").value((Object)input.getKey());
                }
                if (input.getFrameRate() != null) {
                    jsonWriter.key("FrameRate").value((Object)input.getFrameRate());
                }
                if (input.getResolution() != null) {
                    jsonWriter.key("Resolution").value((Object)input.getResolution());
                }
                if (input.getAspectRatio() != null) {
                    jsonWriter.key("AspectRatio").value((Object)input.getAspectRatio());
                }
                if (input.getInterlaced() != null) {
                    jsonWriter.key("Interlaced").value((Object)input.getInterlaced());
                }
                if (input.getContainer() != null) {
                    jsonWriter.key("Container").value((Object)input.getContainer());
                }
                if ((encryption3 = input.getEncryption()) != null) {
                    jsonWriter.key("Encryption");
                    jsonWriter.object();
                    if (encryption3.getMode() != null) {
                        jsonWriter.key("Mode").value((Object)encryption3.getMode());
                    }
                    if (encryption3.getKey() != null) {
                        jsonWriter.key("Key").value((Object)encryption3.getKey());
                    }
                    if (encryption3.getKeyMd5() != null) {
                        jsonWriter.key("KeyMd5").value((Object)encryption3.getKeyMd5());
                    }
                    if (encryption3.getInitializationVector() != null) {
                        jsonWriter.key("InitializationVector").value((Object)encryption3.getInitializationVector());
                    }
                    jsonWriter.endObject();
                }
                jsonWriter.endObject();
            }
            if ((output = createJobRequest.getOutput()) != null) {
                Encryption encryption4;
                Captions captions;
                ListWithAutoConstructFlag compositionList;
                JobAlbumArt albumArt;
                ListWithAutoConstructFlag watermarksList;
                Encryption thumbnailEncryption;
                jsonWriter.key("Output");
                jsonWriter.object();
                if (output.getKey() != null) {
                    jsonWriter.key("Key").value((Object)output.getKey());
                }
                if (output.getThumbnailPattern() != null) {
                    jsonWriter.key("ThumbnailPattern").value((Object)output.getThumbnailPattern());
                }
                if ((thumbnailEncryption = output.getThumbnailEncryption()) != null) {
                    jsonWriter.key("ThumbnailEncryption");
                    jsonWriter.object();
                    if (thumbnailEncryption.getMode() != null) {
                        jsonWriter.key("Mode").value((Object)thumbnailEncryption.getMode());
                    }
                    if (thumbnailEncryption.getKey() != null) {
                        jsonWriter.key("Key").value((Object)thumbnailEncryption.getKey());
                    }
                    if (thumbnailEncryption.getKeyMd5() != null) {
                        jsonWriter.key("KeyMd5").value((Object)thumbnailEncryption.getKeyMd5());
                    }
                    if (thumbnailEncryption.getInitializationVector() != null) {
                        jsonWriter.key("InitializationVector").value((Object)thumbnailEncryption.getInitializationVector());
                    }
                    jsonWriter.endObject();
                }
                if (output.getRotate() != null) {
                    jsonWriter.key("Rotate").value((Object)output.getRotate());
                }
                if (output.getPresetId() != null) {
                    jsonWriter.key("PresetId").value((Object)output.getPresetId());
                }
                if (output.getSegmentDuration() != null) {
                    jsonWriter.key("SegmentDuration").value((Object)output.getSegmentDuration());
                }
                if (!((watermarksList = (ListWithAutoConstructFlag)output.getWatermarks()) == null || watermarksList.isAutoConstruct() && watermarksList.isEmpty())) {
                    jsonWriter.key("Watermarks");
                    jsonWriter.array();
                    for (JobWatermark watermarksListValue : watermarksList) {
                        Encryption encryption5;
                        if (watermarksListValue == null) continue;
                        jsonWriter.object();
                        if (watermarksListValue.getPresetWatermarkId() != null) {
                            jsonWriter.key("PresetWatermarkId").value((Object)watermarksListValue.getPresetWatermarkId());
                        }
                        if (watermarksListValue.getInputKey() != null) {
                            jsonWriter.key("InputKey").value((Object)watermarksListValue.getInputKey());
                        }
                        if ((encryption5 = watermarksListValue.getEncryption()) != null) {
                            jsonWriter.key("Encryption");
                            jsonWriter.object();
                            if (encryption5.getMode() != null) {
                                jsonWriter.key("Mode").value((Object)encryption5.getMode());
                            }
                            if (encryption5.getKey() != null) {
                                jsonWriter.key("Key").value((Object)encryption5.getKey());
                            }
                            if (encryption5.getKeyMd5() != null) {
                                jsonWriter.key("KeyMd5").value((Object)encryption5.getKeyMd5());
                            }
                            if (encryption5.getInitializationVector() != null) {
                                jsonWriter.key("InitializationVector").value((Object)encryption5.getInitializationVector());
                            }
                            jsonWriter.endObject();
                        }
                        jsonWriter.endObject();
                    }
                    jsonWriter.endArray();
                }
                if ((albumArt = output.getAlbumArt()) != null) {
                    ListWithAutoConstructFlag artworkList;
                    jsonWriter.key("AlbumArt");
                    jsonWriter.object();
                    if (albumArt.getMergePolicy() != null) {
                        jsonWriter.key("MergePolicy").value((Object)albumArt.getMergePolicy());
                    }
                    if (!((artworkList = (ListWithAutoConstructFlag)albumArt.getArtwork()) == null || artworkList.isAutoConstruct() && artworkList.isEmpty())) {
                        jsonWriter.key("Artwork");
                        jsonWriter.array();
                        for (Artwork artworkListValue : artworkList) {
                            Encryption encryption6;
                            if (artworkListValue == null) continue;
                            jsonWriter.object();
                            if (artworkListValue.getInputKey() != null) {
                                jsonWriter.key("InputKey").value((Object)artworkListValue.getInputKey());
                            }
                            if (artworkListValue.getMaxWidth() != null) {
                                jsonWriter.key("MaxWidth").value((Object)artworkListValue.getMaxWidth());
                            }
                            if (artworkListValue.getMaxHeight() != null) {
                                jsonWriter.key("MaxHeight").value((Object)artworkListValue.getMaxHeight());
                            }
                            if (artworkListValue.getSizingPolicy() != null) {
                                jsonWriter.key("SizingPolicy").value((Object)artworkListValue.getSizingPolicy());
                            }
                            if (artworkListValue.getPaddingPolicy() != null) {
                                jsonWriter.key("PaddingPolicy").value((Object)artworkListValue.getPaddingPolicy());
                            }
                            if (artworkListValue.getAlbumArtFormat() != null) {
                                jsonWriter.key("AlbumArtFormat").value((Object)artworkListValue.getAlbumArtFormat());
                            }
                            if ((encryption6 = artworkListValue.getEncryption()) != null) {
                                jsonWriter.key("Encryption");
                                jsonWriter.object();
                                if (encryption6.getMode() != null) {
                                    jsonWriter.key("Mode").value((Object)encryption6.getMode());
                                }
                                if (encryption6.getKey() != null) {
                                    jsonWriter.key("Key").value((Object)encryption6.getKey());
                                }
                                if (encryption6.getKeyMd5() != null) {
                                    jsonWriter.key("KeyMd5").value((Object)encryption6.getKeyMd5());
                                }
                                if (encryption6.getInitializationVector() != null) {
                                    jsonWriter.key("InitializationVector").value((Object)encryption6.getInitializationVector());
                                }
                                jsonWriter.endObject();
                            }
                            jsonWriter.endObject();
                        }
                        jsonWriter.endArray();
                    }
                    jsonWriter.endObject();
                }
                if (!((compositionList = (ListWithAutoConstructFlag)output.getComposition()) == null || compositionList.isAutoConstruct() && compositionList.isEmpty())) {
                    jsonWriter.key("Composition");
                    jsonWriter.array();
                    for (Clip compositionListValue : compositionList) {
                        if (compositionListValue == null) continue;
                        jsonWriter.object();
                        TimeSpan timeSpan = compositionListValue.getTimeSpan();
                        if (timeSpan != null) {
                            jsonWriter.key("TimeSpan");
                            jsonWriter.object();
                            if (timeSpan.getStartTime() != null) {
                                jsonWriter.key("StartTime").value((Object)timeSpan.getStartTime());
                            }
                            if (timeSpan.getDuration() != null) {
                                jsonWriter.key("Duration").value((Object)timeSpan.getDuration());
                            }
                            jsonWriter.endObject();
                        }
                        jsonWriter.endObject();
                    }
                    jsonWriter.endArray();
                }
                if ((captions = output.getCaptions()) != null) {
                    ListWithAutoConstructFlag captionFormatsList;
                    ListWithAutoConstructFlag captionSourcesList;
                    jsonWriter.key("Captions");
                    jsonWriter.object();
                    if (captions.getMergePolicy() != null) {
                        jsonWriter.key("MergePolicy").value((Object)captions.getMergePolicy());
                    }
                    if (!((captionSourcesList = (ListWithAutoConstructFlag)captions.getCaptionSources()) == null || captionSourcesList.isAutoConstruct() && captionSourcesList.isEmpty())) {
                        jsonWriter.key("CaptionSources");
                        jsonWriter.array();
                        for (CaptionSource captionSourcesListValue : captionSourcesList) {
                            if (captionSourcesListValue == null) continue;
                            jsonWriter.object();
                            if (captionSourcesListValue.getKey() != null) {
                                jsonWriter.key("Key").value((Object)captionSourcesListValue.getKey());
                            }
                            if (captionSourcesListValue.getLanguage() != null) {
                                jsonWriter.key("Language").value((Object)captionSourcesListValue.getLanguage());
                            }
                            if (captionSourcesListValue.getTimeOffset() != null) {
                                jsonWriter.key("TimeOffset").value((Object)captionSourcesListValue.getTimeOffset());
                            }
                            if (captionSourcesListValue.getLabel() != null) {
                                jsonWriter.key("Label").value((Object)captionSourcesListValue.getLabel());
                            }
                            if ((encryption2 = captionSourcesListValue.getEncryption()) != null) {
                                jsonWriter.key("Encryption");
                                jsonWriter.object();
                                if (encryption2.getMode() != null) {
                                    jsonWriter.key("Mode").value((Object)encryption2.getMode());
                                }
                                if (encryption2.getKey() != null) {
                                    jsonWriter.key("Key").value((Object)encryption2.getKey());
                                }
                                if (encryption2.getKeyMd5() != null) {
                                    jsonWriter.key("KeyMd5").value((Object)encryption2.getKeyMd5());
                                }
                                if (encryption2.getInitializationVector() != null) {
                                    jsonWriter.key("InitializationVector").value((Object)encryption2.getInitializationVector());
                                }
                                jsonWriter.endObject();
                            }
                            jsonWriter.endObject();
                        }
                        jsonWriter.endArray();
                    }
                    if (!((captionFormatsList = (ListWithAutoConstructFlag)captions.getCaptionFormats()) == null || captionFormatsList.isAutoConstruct() && captionFormatsList.isEmpty())) {
                        jsonWriter.key("CaptionFormats");
                        jsonWriter.array();
                        for (CaptionFormat captionFormatsListValue : captionFormatsList) {
                            if (captionFormatsListValue == null) continue;
                            jsonWriter.object();
                            if (captionFormatsListValue.getFormat() != null) {
                                jsonWriter.key("Format").value((Object)captionFormatsListValue.getFormat());
                            }
                            if (captionFormatsListValue.getPattern() != null) {
                                jsonWriter.key("Pattern").value((Object)captionFormatsListValue.getPattern());
                            }
                            if ((encryption = captionFormatsListValue.getEncryption()) != null) {
                                jsonWriter.key("Encryption");
                                jsonWriter.object();
                                if (encryption.getMode() != null) {
                                    jsonWriter.key("Mode").value((Object)encryption.getMode());
                                }
                                if (encryption.getKey() != null) {
                                    jsonWriter.key("Key").value((Object)encryption.getKey());
                                }
                                if (encryption.getKeyMd5() != null) {
                                    jsonWriter.key("KeyMd5").value((Object)encryption.getKeyMd5());
                                }
                                if (encryption.getInitializationVector() != null) {
                                    jsonWriter.key("InitializationVector").value((Object)encryption.getInitializationVector());
                                }
                                jsonWriter.endObject();
                            }
                            jsonWriter.endObject();
                        }
                        jsonWriter.endArray();
                    }
                    jsonWriter.endObject();
                }
                if ((encryption4 = output.getEncryption()) != null) {
                    jsonWriter.key("Encryption");
                    jsonWriter.object();
                    if (encryption4.getMode() != null) {
                        jsonWriter.key("Mode").value((Object)encryption4.getMode());
                    }
                    if (encryption4.getKey() != null) {
                        jsonWriter.key("Key").value((Object)encryption4.getKey());
                    }
                    if (encryption4.getKeyMd5() != null) {
                        jsonWriter.key("KeyMd5").value((Object)encryption4.getKeyMd5());
                    }
                    if (encryption4.getInitializationVector() != null) {
                        jsonWriter.key("InitializationVector").value((Object)encryption4.getInitializationVector());
                    }
                    jsonWriter.endObject();
                }
                jsonWriter.endObject();
            }
            if (!((outputsList = (ListWithAutoConstructFlag)createJobRequest.getOutputs()) == null || outputsList.isAutoConstruct() && outputsList.isEmpty())) {
                jsonWriter.key("Outputs");
                jsonWriter.array();
                for (CreateJobOutput outputsListValue : outputsList) {
                    Captions captions;
                    ListWithAutoConstructFlag compositionList;
                    JobAlbumArt albumArt;
                    ListWithAutoConstructFlag watermarksList;
                    Encryption thumbnailEncryption;
                    if (outputsListValue == null) continue;
                    jsonWriter.object();
                    if (outputsListValue.getKey() != null) {
                        jsonWriter.key("Key").value((Object)outputsListValue.getKey());
                    }
                    if (outputsListValue.getThumbnailPattern() != null) {
                        jsonWriter.key("ThumbnailPattern").value((Object)outputsListValue.getThumbnailPattern());
                    }
                    if ((thumbnailEncryption = outputsListValue.getThumbnailEncryption()) != null) {
                        jsonWriter.key("ThumbnailEncryption");
                        jsonWriter.object();
                        if (thumbnailEncryption.getMode() != null) {
                            jsonWriter.key("Mode").value((Object)thumbnailEncryption.getMode());
                        }
                        if (thumbnailEncryption.getKey() != null) {
                            jsonWriter.key("Key").value((Object)thumbnailEncryption.getKey());
                        }
                        if (thumbnailEncryption.getKeyMd5() != null) {
                            jsonWriter.key("KeyMd5").value((Object)thumbnailEncryption.getKeyMd5());
                        }
                        if (thumbnailEncryption.getInitializationVector() != null) {
                            jsonWriter.key("InitializationVector").value((Object)thumbnailEncryption.getInitializationVector());
                        }
                        jsonWriter.endObject();
                    }
                    if (outputsListValue.getRotate() != null) {
                        jsonWriter.key("Rotate").value((Object)outputsListValue.getRotate());
                    }
                    if (outputsListValue.getPresetId() != null) {
                        jsonWriter.key("PresetId").value((Object)outputsListValue.getPresetId());
                    }
                    if (outputsListValue.getSegmentDuration() != null) {
                        jsonWriter.key("SegmentDuration").value((Object)outputsListValue.getSegmentDuration());
                    }
                    if (!((watermarksList = (ListWithAutoConstructFlag)outputsListValue.getWatermarks()) == null || watermarksList.isAutoConstruct() && watermarksList.isEmpty())) {
                        jsonWriter.key("Watermarks");
                        jsonWriter.array();
                        for (JobWatermark watermarksListValue : watermarksList) {
                            Encryption encryption7;
                            if (watermarksListValue == null) continue;
                            jsonWriter.object();
                            if (watermarksListValue.getPresetWatermarkId() != null) {
                                jsonWriter.key("PresetWatermarkId").value((Object)watermarksListValue.getPresetWatermarkId());
                            }
                            if (watermarksListValue.getInputKey() != null) {
                                jsonWriter.key("InputKey").value((Object)watermarksListValue.getInputKey());
                            }
                            if ((encryption7 = watermarksListValue.getEncryption()) != null) {
                                jsonWriter.key("Encryption");
                                jsonWriter.object();
                                if (encryption7.getMode() != null) {
                                    jsonWriter.key("Mode").value((Object)encryption7.getMode());
                                }
                                if (encryption7.getKey() != null) {
                                    jsonWriter.key("Key").value((Object)encryption7.getKey());
                                }
                                if (encryption7.getKeyMd5() != null) {
                                    jsonWriter.key("KeyMd5").value((Object)encryption7.getKeyMd5());
                                }
                                if (encryption7.getInitializationVector() != null) {
                                    jsonWriter.key("InitializationVector").value((Object)encryption7.getInitializationVector());
                                }
                                jsonWriter.endObject();
                            }
                            jsonWriter.endObject();
                        }
                        jsonWriter.endArray();
                    }
                    if ((albumArt = outputsListValue.getAlbumArt()) != null) {
                        ListWithAutoConstructFlag artworkList;
                        jsonWriter.key("AlbumArt");
                        jsonWriter.object();
                        if (albumArt.getMergePolicy() != null) {
                            jsonWriter.key("MergePolicy").value((Object)albumArt.getMergePolicy());
                        }
                        if (!((artworkList = (ListWithAutoConstructFlag)albumArt.getArtwork()) == null || artworkList.isAutoConstruct() && artworkList.isEmpty())) {
                            jsonWriter.key("Artwork");
                            jsonWriter.array();
                            for (Artwork artworkListValue : artworkList) {
                                if (artworkListValue == null) continue;
                                jsonWriter.object();
                                if (artworkListValue.getInputKey() != null) {
                                    jsonWriter.key("InputKey").value((Object)artworkListValue.getInputKey());
                                }
                                if (artworkListValue.getMaxWidth() != null) {
                                    jsonWriter.key("MaxWidth").value((Object)artworkListValue.getMaxWidth());
                                }
                                if (artworkListValue.getMaxHeight() != null) {
                                    jsonWriter.key("MaxHeight").value((Object)artworkListValue.getMaxHeight());
                                }
                                if (artworkListValue.getSizingPolicy() != null) {
                                    jsonWriter.key("SizingPolicy").value((Object)artworkListValue.getSizingPolicy());
                                }
                                if (artworkListValue.getPaddingPolicy() != null) {
                                    jsonWriter.key("PaddingPolicy").value((Object)artworkListValue.getPaddingPolicy());
                                }
                                if (artworkListValue.getAlbumArtFormat() != null) {
                                    jsonWriter.key("AlbumArtFormat").value((Object)artworkListValue.getAlbumArtFormat());
                                }
                                if ((encryption = artworkListValue.getEncryption()) != null) {
                                    jsonWriter.key("Encryption");
                                    jsonWriter.object();
                                    if (encryption.getMode() != null) {
                                        jsonWriter.key("Mode").value((Object)encryption.getMode());
                                    }
                                    if (encryption.getKey() != null) {
                                        jsonWriter.key("Key").value((Object)encryption.getKey());
                                    }
                                    if (encryption.getKeyMd5() != null) {
                                        jsonWriter.key("KeyMd5").value((Object)encryption.getKeyMd5());
                                    }
                                    if (encryption.getInitializationVector() != null) {
                                        jsonWriter.key("InitializationVector").value((Object)encryption.getInitializationVector());
                                    }
                                    jsonWriter.endObject();
                                }
                                jsonWriter.endObject();
                            }
                            jsonWriter.endArray();
                        }
                        jsonWriter.endObject();
                    }
                    if (!((compositionList = (ListWithAutoConstructFlag)outputsListValue.getComposition()) == null || compositionList.isAutoConstruct() && compositionList.isEmpty())) {
                        jsonWriter.key("Composition");
                        jsonWriter.array();
                        for (Clip compositionListValue : compositionList) {
                            if (compositionListValue == null) continue;
                            jsonWriter.object();
                            TimeSpan timeSpan = compositionListValue.getTimeSpan();
                            if (timeSpan != null) {
                                jsonWriter.key("TimeSpan");
                                jsonWriter.object();
                                if (timeSpan.getStartTime() != null) {
                                    jsonWriter.key("StartTime").value((Object)timeSpan.getStartTime());
                                }
                                if (timeSpan.getDuration() != null) {
                                    jsonWriter.key("Duration").value((Object)timeSpan.getDuration());
                                }
                                jsonWriter.endObject();
                            }
                            jsonWriter.endObject();
                        }
                        jsonWriter.endArray();
                    }
                    if ((captions = outputsListValue.getCaptions()) != null) {
                        ListWithAutoConstructFlag captionFormatsList;
                        ListWithAutoConstructFlag captionSourcesList;
                        jsonWriter.key("Captions");
                        jsonWriter.object();
                        if (captions.getMergePolicy() != null) {
                            jsonWriter.key("MergePolicy").value((Object)captions.getMergePolicy());
                        }
                        if (!((captionSourcesList = (ListWithAutoConstructFlag)captions.getCaptionSources()) == null || captionSourcesList.isAutoConstruct() && captionSourcesList.isEmpty())) {
                            jsonWriter.key("CaptionSources");
                            jsonWriter.array();
                            for (CaptionSource captionSourcesListValue : captionSourcesList) {
                                Encryption encryption8;
                                if (captionSourcesListValue == null) continue;
                                jsonWriter.object();
                                if (captionSourcesListValue.getKey() != null) {
                                    jsonWriter.key("Key").value((Object)captionSourcesListValue.getKey());
                                }
                                if (captionSourcesListValue.getLanguage() != null) {
                                    jsonWriter.key("Language").value((Object)captionSourcesListValue.getLanguage());
                                }
                                if (captionSourcesListValue.getTimeOffset() != null) {
                                    jsonWriter.key("TimeOffset").value((Object)captionSourcesListValue.getTimeOffset());
                                }
                                if (captionSourcesListValue.getLabel() != null) {
                                    jsonWriter.key("Label").value((Object)captionSourcesListValue.getLabel());
                                }
                                if ((encryption8 = captionSourcesListValue.getEncryption()) != null) {
                                    jsonWriter.key("Encryption");
                                    jsonWriter.object();
                                    if (encryption8.getMode() != null) {
                                        jsonWriter.key("Mode").value((Object)encryption8.getMode());
                                    }
                                    if (encryption8.getKey() != null) {
                                        jsonWriter.key("Key").value((Object)encryption8.getKey());
                                    }
                                    if (encryption8.getKeyMd5() != null) {
                                        jsonWriter.key("KeyMd5").value((Object)encryption8.getKeyMd5());
                                    }
                                    if (encryption8.getInitializationVector() != null) {
                                        jsonWriter.key("InitializationVector").value((Object)encryption8.getInitializationVector());
                                    }
                                    jsonWriter.endObject();
                                }
                                jsonWriter.endObject();
                            }
                            jsonWriter.endArray();
                        }
                        if (!((captionFormatsList = (ListWithAutoConstructFlag)captions.getCaptionFormats()) == null || captionFormatsList.isAutoConstruct() && captionFormatsList.isEmpty())) {
                            jsonWriter.key("CaptionFormats");
                            jsonWriter.array();
                            for (CaptionFormat captionFormatsListValue : captionFormatsList) {
                                Encryption encryption9;
                                if (captionFormatsListValue == null) continue;
                                jsonWriter.object();
                                if (captionFormatsListValue.getFormat() != null) {
                                    jsonWriter.key("Format").value((Object)captionFormatsListValue.getFormat());
                                }
                                if (captionFormatsListValue.getPattern() != null) {
                                    jsonWriter.key("Pattern").value((Object)captionFormatsListValue.getPattern());
                                }
                                if ((encryption9 = captionFormatsListValue.getEncryption()) != null) {
                                    jsonWriter.key("Encryption");
                                    jsonWriter.object();
                                    if (encryption9.getMode() != null) {
                                        jsonWriter.key("Mode").value((Object)encryption9.getMode());
                                    }
                                    if (encryption9.getKey() != null) {
                                        jsonWriter.key("Key").value((Object)encryption9.getKey());
                                    }
                                    if (encryption9.getKeyMd5() != null) {
                                        jsonWriter.key("KeyMd5").value((Object)encryption9.getKeyMd5());
                                    }
                                    if (encryption9.getInitializationVector() != null) {
                                        jsonWriter.key("InitializationVector").value((Object)encryption9.getInitializationVector());
                                    }
                                    jsonWriter.endObject();
                                }
                                jsonWriter.endObject();
                            }
                            jsonWriter.endArray();
                        }
                        jsonWriter.endObject();
                    }
                    if ((encryption2 = outputsListValue.getEncryption()) != null) {
                        jsonWriter.key("Encryption");
                        jsonWriter.object();
                        if (encryption2.getMode() != null) {
                            jsonWriter.key("Mode").value((Object)encryption2.getMode());
                        }
                        if (encryption2.getKey() != null) {
                            jsonWriter.key("Key").value((Object)encryption2.getKey());
                        }
                        if (encryption2.getKeyMd5() != null) {
                            jsonWriter.key("KeyMd5").value((Object)encryption2.getKeyMd5());
                        }
                        if (encryption2.getInitializationVector() != null) {
                            jsonWriter.key("InitializationVector").value((Object)encryption2.getInitializationVector());
                        }
                        jsonWriter.endObject();
                    }
                    jsonWriter.endObject();
                }
                jsonWriter.endArray();
            }
            if (createJobRequest.getOutputKeyPrefix() != null) {
                jsonWriter.key("OutputKeyPrefix").value((Object)createJobRequest.getOutputKeyPrefix());
            }
            if (!((playlistsList = (ListWithAutoConstructFlag)createJobRequest.getPlaylists()) == null || playlistsList.isAutoConstruct() && playlistsList.isEmpty())) {
                jsonWriter.key("Playlists");
                jsonWriter.array();
                for (CreateJobPlaylist playlistsListValue : playlistsList) {
                    ListWithAutoConstructFlag outputKeysList;
                    if (playlistsListValue == null) continue;
                    jsonWriter.object();
                    if (playlistsListValue.getName() != null) {
                        jsonWriter.key("Name").value((Object)playlistsListValue.getName());
                    }
                    if (playlistsListValue.getFormat() != null) {
                        jsonWriter.key("Format").value((Object)playlistsListValue.getFormat());
                    }
                    if (!((outputKeysList = (ListWithAutoConstructFlag)playlistsListValue.getOutputKeys()) == null || outputKeysList.isAutoConstruct() && outputKeysList.isEmpty())) {
                        jsonWriter.key("OutputKeys");
                        jsonWriter.array();
                        for (String outputKeysListValue : outputKeysList) {
                            if (outputKeysListValue == null) continue;
                            jsonWriter.value((Object)outputKeysListValue);
                        }
                        jsonWriter.endArray();
                    }
                    jsonWriter.endObject();
                }
                jsonWriter.endArray();
            }
            if (createJobRequest.getUserMetadata() != null) {
                jsonWriter.key("UserMetadata");
                jsonWriter.object();
                for (Map.Entry<String, String> userMetadataListValue : createJobRequest.getUserMetadata().entrySet()) {
                    if (userMetadataListValue.getValue() == null) continue;
                    jsonWriter.key(userMetadataListValue.getKey());
                    jsonWriter.value((Object)userMetadataListValue.getValue());
                }
                jsonWriter.endObject();
            }
            jsonWriter.endObject();
            String snippet = stringWriter.toString();
            byte[] content = snippet.getBytes(StringUtils.UTF8);
            request.setContent((InputStream)new StringInputStream(snippet));
            request.addHeader("Content-Length", Integer.toString(content.length));
            request.addHeader("Content-Type", "application/x-amz-json-1.0");
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }

    static {
        String path = "2012-09-25/jobs";
        HashMap<String, String> staticMap = new HashMap<String, String>();
        HashMap<String, String> dynamicMap = new HashMap<String, String>();
        int index = path.indexOf("?");
        if (index != -1) {
            String queryString = path.substring(index + 1);
            path = path.substring(0, index);
            for (String s : queryString.split("[;&]")) {
                index = s.indexOf("=");
                if (index == -1) continue;
                String name = s.substring(0, index);
                String value = s.substring(index + 1);
                if (value.startsWith("{") && value.endsWith("}")) {
                    dynamicMap.put(value.substring(1, value.length() - 1), name);
                    continue;
                }
                staticMap.put(name, value);
            }
        }
        RESOURCE_PATH_TEMPLATE = path;
        STATIC_QUERY_PARAMS = Collections.unmodifiableMap(staticMap);
        DYNAMIC_QUERY_PARAMS = Collections.unmodifiableMap(dynamicMap);
    }
}

