/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.samples;

import com.amazonaws.codegen.model.intermediate.IntermediateModel;
import com.amazonaws.samples.GeneratedSamplesClassWriter;
import com.amazonaws.samples.SamplesGenerator;
import com.amazonaws.samples.util.IntermediateModelRetriever;
import java.io.IOException;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.model.Plugin;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.BuildPluginManager;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.util.xml.Xpp3Dom;
import org.twdata.maven.mojoexecutor.MojoExecutor;

@Mojo(name="GenerateSamples")
public class SampleGenerationRunner
extends AbstractMojo {
    @Component
    private MavenProject mavenProject;
    @Component
    private MavenSession mavenSession;
    @Component
    private BuildPluginManager pluginManager;
    @Parameter(defaultValue="${project.build.sourceDirectory}")
    private String projectSourceDir;

    public void execute() throws MojoExecutionException, MojoFailureException {
        try {
            for (IntermediateModel model : IntermediateModelRetriever.getDependencyIntermediateModels()) {
                if (model.getExamples().getOperationExamples().isEmpty()) continue;
                SamplesGenerator writer = new SamplesGenerator(model);
                GeneratedSamplesClassWriter.writeSamples(this.projectSourceDir + "/samples", model.getMetadata().getSyncInterface(), writer.getGeneratedSamples());
            }
            MojoExecutor.executeMojo((Plugin)MojoExecutor.plugin((String)MojoExecutor.groupId((String)"com.amazonaws"), (String)MojoExecutor.artifactId((String)"aws-java-sdk-sample-extractor"), (String)MojoExecutor.version((String)"LATEST")), (String)MojoExecutor.goal((String)"ExtractSamples"), (Xpp3Dom)MojoExecutor.configuration((MojoExecutor.Element[])new MojoExecutor.Element[]{MojoExecutor.element((String)"sourceExtension", (String)"java"), MojoExecutor.element((String)"sampleSubDir", (String)"/samples")}), (MojoExecutor.ExecutionEnvironment)MojoExecutor.executionEnvironment((MavenProject)this.mavenProject, (MavenSession)this.mavenSession, (BuildPluginManager)this.pluginManager));
        }
        catch (IOException e) {
            throw new MojoFailureException("Failed to generate samples", (Throwable)e);
        }
    }
}

