/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.lambda.model.transform;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.protocol.json.SdkJsonProtocolFactory;
import com.amazonaws.protocol.json.StructuredJsonGenerator;
import com.amazonaws.services.lambda.model.UpdateFunctionConfigurationRequest;
import com.amazonaws.services.lambda.model.transform.VpcConfigJsonMarshaller;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.SdkHttpUtils;
import com.amazonaws.util.StringUtils;
import java.io.ByteArrayInputStream;
import java.io.InputStream;

public class UpdateFunctionConfigurationRequestMarshaller
implements Marshaller<Request<UpdateFunctionConfigurationRequest>, UpdateFunctionConfigurationRequest> {
    private final SdkJsonProtocolFactory protocolFactory;

    public UpdateFunctionConfigurationRequestMarshaller(SdkJsonProtocolFactory protocolFactory) {
        this.protocolFactory = protocolFactory;
    }

    public Request<UpdateFunctionConfigurationRequest> marshall(UpdateFunctionConfigurationRequest updateFunctionConfigurationRequest) {
        if (updateFunctionConfigurationRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)updateFunctionConfigurationRequest, "AWSLambda");
        request.setHttpMethod(HttpMethodName.PUT);
        String uriResourcePath = "/2015-03-31/functions/{FunctionName}/configuration";
        uriResourcePath = uriResourcePath.replace("{FunctionName}", updateFunctionConfigurationRequest.getFunctionName() != null ? SdkHttpUtils.urlEncode((String)StringUtils.fromString((String)updateFunctionConfigurationRequest.getFunctionName()), (boolean)false) : "");
        request.setResourcePath(uriResourcePath);
        try {
            StructuredJsonGenerator jsonGenerator = this.protocolFactory.createGenerator();
            jsonGenerator.writeStartObject();
            if (updateFunctionConfigurationRequest.getRole() != null) {
                jsonGenerator.writeFieldName("Role").writeValue(updateFunctionConfigurationRequest.getRole());
            }
            if (updateFunctionConfigurationRequest.getHandler() != null) {
                jsonGenerator.writeFieldName("Handler").writeValue(updateFunctionConfigurationRequest.getHandler());
            }
            if (updateFunctionConfigurationRequest.getDescription() != null) {
                jsonGenerator.writeFieldName("Description").writeValue(updateFunctionConfigurationRequest.getDescription());
            }
            if (updateFunctionConfigurationRequest.getTimeout() != null) {
                jsonGenerator.writeFieldName("Timeout").writeValue(updateFunctionConfigurationRequest.getTimeout().intValue());
            }
            if (updateFunctionConfigurationRequest.getMemorySize() != null) {
                jsonGenerator.writeFieldName("MemorySize").writeValue(updateFunctionConfigurationRequest.getMemorySize().intValue());
            }
            if (updateFunctionConfigurationRequest.getVpcConfig() != null) {
                jsonGenerator.writeFieldName("VpcConfig");
                VpcConfigJsonMarshaller.getInstance().marshall(updateFunctionConfigurationRequest.getVpcConfig(), jsonGenerator);
            }
            if (updateFunctionConfigurationRequest.getRuntime() != null) {
                jsonGenerator.writeFieldName("Runtime").writeValue(updateFunctionConfigurationRequest.getRuntime());
            }
            jsonGenerator.writeEndObject();
            byte[] content = jsonGenerator.getBytes();
            request.setContent((InputStream)new ByteArrayInputStream(content));
            request.addHeader("Content-Length", Integer.toString(content.length));
            if (!request.getHeaders().containsKey("Content-Type")) {
                request.addHeader("Content-Type", this.protocolFactory.getContentType());
            }
        }
        catch (Throwable t) {
            throw new SdkClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

