/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.lambda;

import com.amazonaws.AmazonWebServiceClient;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.AmazonWebServiceResponse;
import com.amazonaws.ClientConfiguration;
import com.amazonaws.ClientConfigurationFactory;
import com.amazonaws.Request;
import com.amazonaws.Response;
import com.amazonaws.ResponseMetadata;
import com.amazonaws.annotation.ThreadSafe;
import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.auth.DefaultAWSCredentialsProviderChain;
import com.amazonaws.client.AwsSyncClientParams;
import com.amazonaws.handlers.HandlerChainFactory;
import com.amazonaws.http.ExecutionContext;
import com.amazonaws.http.HttpResponseHandler;
import com.amazonaws.internal.StaticCredentialsProvider;
import com.amazonaws.metrics.MetricType;
import com.amazonaws.metrics.RequestMetricCollector;
import com.amazonaws.protocol.json.JsonClientMetadata;
import com.amazonaws.protocol.json.JsonErrorResponseMetadata;
import com.amazonaws.protocol.json.JsonErrorShapeMetadata;
import com.amazonaws.protocol.json.JsonOperationMetadata;
import com.amazonaws.protocol.json.SdkJsonProtocolFactory;
import com.amazonaws.services.lambda.AWSLambda;
import com.amazonaws.services.lambda.model.AWSLambdaException;
import com.amazonaws.services.lambda.model.AddPermissionRequest;
import com.amazonaws.services.lambda.model.AddPermissionResult;
import com.amazonaws.services.lambda.model.CodeStorageExceededException;
import com.amazonaws.services.lambda.model.CreateAliasRequest;
import com.amazonaws.services.lambda.model.CreateAliasResult;
import com.amazonaws.services.lambda.model.CreateEventSourceMappingRequest;
import com.amazonaws.services.lambda.model.CreateEventSourceMappingResult;
import com.amazonaws.services.lambda.model.CreateFunctionRequest;
import com.amazonaws.services.lambda.model.CreateFunctionResult;
import com.amazonaws.services.lambda.model.DeleteAliasRequest;
import com.amazonaws.services.lambda.model.DeleteAliasResult;
import com.amazonaws.services.lambda.model.DeleteEventSourceMappingRequest;
import com.amazonaws.services.lambda.model.DeleteEventSourceMappingResult;
import com.amazonaws.services.lambda.model.DeleteFunctionRequest;
import com.amazonaws.services.lambda.model.DeleteFunctionResult;
import com.amazonaws.services.lambda.model.EC2AccessDeniedException;
import com.amazonaws.services.lambda.model.EC2ThrottledException;
import com.amazonaws.services.lambda.model.EC2UnexpectedException;
import com.amazonaws.services.lambda.model.ENILimitReachedException;
import com.amazonaws.services.lambda.model.GetAliasRequest;
import com.amazonaws.services.lambda.model.GetAliasResult;
import com.amazonaws.services.lambda.model.GetEventSourceMappingRequest;
import com.amazonaws.services.lambda.model.GetEventSourceMappingResult;
import com.amazonaws.services.lambda.model.GetFunctionConfigurationRequest;
import com.amazonaws.services.lambda.model.GetFunctionConfigurationResult;
import com.amazonaws.services.lambda.model.GetFunctionRequest;
import com.amazonaws.services.lambda.model.GetFunctionResult;
import com.amazonaws.services.lambda.model.GetPolicyRequest;
import com.amazonaws.services.lambda.model.GetPolicyResult;
import com.amazonaws.services.lambda.model.InvalidParameterValueException;
import com.amazonaws.services.lambda.model.InvalidRequestContentException;
import com.amazonaws.services.lambda.model.InvalidSecurityGroupIDException;
import com.amazonaws.services.lambda.model.InvalidSubnetIDException;
import com.amazonaws.services.lambda.model.InvalidZipFileException;
import com.amazonaws.services.lambda.model.InvokeAsyncRequest;
import com.amazonaws.services.lambda.model.InvokeAsyncResult;
import com.amazonaws.services.lambda.model.InvokeRequest;
import com.amazonaws.services.lambda.model.InvokeResult;
import com.amazonaws.services.lambda.model.KMSAccessDeniedException;
import com.amazonaws.services.lambda.model.KMSDisabledException;
import com.amazonaws.services.lambda.model.KMSInvalidStateException;
import com.amazonaws.services.lambda.model.KMSNotFoundException;
import com.amazonaws.services.lambda.model.ListAliasesRequest;
import com.amazonaws.services.lambda.model.ListAliasesResult;
import com.amazonaws.services.lambda.model.ListEventSourceMappingsRequest;
import com.amazonaws.services.lambda.model.ListEventSourceMappingsResult;
import com.amazonaws.services.lambda.model.ListFunctionsRequest;
import com.amazonaws.services.lambda.model.ListFunctionsResult;
import com.amazonaws.services.lambda.model.ListVersionsByFunctionRequest;
import com.amazonaws.services.lambda.model.ListVersionsByFunctionResult;
import com.amazonaws.services.lambda.model.PolicyLengthExceededException;
import com.amazonaws.services.lambda.model.PublishVersionRequest;
import com.amazonaws.services.lambda.model.PublishVersionResult;
import com.amazonaws.services.lambda.model.RemovePermissionRequest;
import com.amazonaws.services.lambda.model.RemovePermissionResult;
import com.amazonaws.services.lambda.model.RequestTooLargeException;
import com.amazonaws.services.lambda.model.ResourceConflictException;
import com.amazonaws.services.lambda.model.ResourceNotFoundException;
import com.amazonaws.services.lambda.model.ServiceException;
import com.amazonaws.services.lambda.model.SubnetIPAddressLimitReachedException;
import com.amazonaws.services.lambda.model.TooManyRequestsException;
import com.amazonaws.services.lambda.model.UnsupportedMediaTypeException;
import com.amazonaws.services.lambda.model.UpdateAliasRequest;
import com.amazonaws.services.lambda.model.UpdateAliasResult;
import com.amazonaws.services.lambda.model.UpdateEventSourceMappingRequest;
import com.amazonaws.services.lambda.model.UpdateEventSourceMappingResult;
import com.amazonaws.services.lambda.model.UpdateFunctionCodeRequest;
import com.amazonaws.services.lambda.model.UpdateFunctionCodeResult;
import com.amazonaws.services.lambda.model.UpdateFunctionConfigurationRequest;
import com.amazonaws.services.lambda.model.UpdateFunctionConfigurationResult;
import com.amazonaws.services.lambda.model.transform.AddPermissionRequestMarshaller;
import com.amazonaws.services.lambda.model.transform.AddPermissionResultJsonUnmarshaller;
import com.amazonaws.services.lambda.model.transform.CreateAliasRequestMarshaller;
import com.amazonaws.services.lambda.model.transform.CreateAliasResultJsonUnmarshaller;
import com.amazonaws.services.lambda.model.transform.CreateEventSourceMappingRequestMarshaller;
import com.amazonaws.services.lambda.model.transform.CreateEventSourceMappingResultJsonUnmarshaller;
import com.amazonaws.services.lambda.model.transform.CreateFunctionRequestMarshaller;
import com.amazonaws.services.lambda.model.transform.CreateFunctionResultJsonUnmarshaller;
import com.amazonaws.services.lambda.model.transform.DeleteAliasRequestMarshaller;
import com.amazonaws.services.lambda.model.transform.DeleteAliasResultJsonUnmarshaller;
import com.amazonaws.services.lambda.model.transform.DeleteEventSourceMappingRequestMarshaller;
import com.amazonaws.services.lambda.model.transform.DeleteEventSourceMappingResultJsonUnmarshaller;
import com.amazonaws.services.lambda.model.transform.DeleteFunctionRequestMarshaller;
import com.amazonaws.services.lambda.model.transform.DeleteFunctionResultJsonUnmarshaller;
import com.amazonaws.services.lambda.model.transform.GetAliasRequestMarshaller;
import com.amazonaws.services.lambda.model.transform.GetAliasResultJsonUnmarshaller;
import com.amazonaws.services.lambda.model.transform.GetEventSourceMappingRequestMarshaller;
import com.amazonaws.services.lambda.model.transform.GetEventSourceMappingResultJsonUnmarshaller;
import com.amazonaws.services.lambda.model.transform.GetFunctionConfigurationRequestMarshaller;
import com.amazonaws.services.lambda.model.transform.GetFunctionConfigurationResultJsonUnmarshaller;
import com.amazonaws.services.lambda.model.transform.GetFunctionRequestMarshaller;
import com.amazonaws.services.lambda.model.transform.GetFunctionResultJsonUnmarshaller;
import com.amazonaws.services.lambda.model.transform.GetPolicyRequestMarshaller;
import com.amazonaws.services.lambda.model.transform.GetPolicyResultJsonUnmarshaller;
import com.amazonaws.services.lambda.model.transform.InvokeAsyncRequestMarshaller;
import com.amazonaws.services.lambda.model.transform.InvokeAsyncResultJsonUnmarshaller;
import com.amazonaws.services.lambda.model.transform.InvokeRequestMarshaller;
import com.amazonaws.services.lambda.model.transform.InvokeResultJsonUnmarshaller;
import com.amazonaws.services.lambda.model.transform.ListAliasesRequestMarshaller;
import com.amazonaws.services.lambda.model.transform.ListAliasesResultJsonUnmarshaller;
import com.amazonaws.services.lambda.model.transform.ListEventSourceMappingsRequestMarshaller;
import com.amazonaws.services.lambda.model.transform.ListEventSourceMappingsResultJsonUnmarshaller;
import com.amazonaws.services.lambda.model.transform.ListFunctionsRequestMarshaller;
import com.amazonaws.services.lambda.model.transform.ListFunctionsResultJsonUnmarshaller;
import com.amazonaws.services.lambda.model.transform.ListVersionsByFunctionRequestMarshaller;
import com.amazonaws.services.lambda.model.transform.ListVersionsByFunctionResultJsonUnmarshaller;
import com.amazonaws.services.lambda.model.transform.PublishVersionRequestMarshaller;
import com.amazonaws.services.lambda.model.transform.PublishVersionResultJsonUnmarshaller;
import com.amazonaws.services.lambda.model.transform.RemovePermissionRequestMarshaller;
import com.amazonaws.services.lambda.model.transform.RemovePermissionResultJsonUnmarshaller;
import com.amazonaws.services.lambda.model.transform.UpdateAliasRequestMarshaller;
import com.amazonaws.services.lambda.model.transform.UpdateAliasResultJsonUnmarshaller;
import com.amazonaws.services.lambda.model.transform.UpdateEventSourceMappingRequestMarshaller;
import com.amazonaws.services.lambda.model.transform.UpdateEventSourceMappingResultJsonUnmarshaller;
import com.amazonaws.services.lambda.model.transform.UpdateFunctionCodeRequestMarshaller;
import com.amazonaws.services.lambda.model.transform.UpdateFunctionCodeResultJsonUnmarshaller;
import com.amazonaws.services.lambda.model.transform.UpdateFunctionConfigurationRequestMarshaller;
import com.amazonaws.services.lambda.model.transform.UpdateFunctionConfigurationResultJsonUnmarshaller;
import com.amazonaws.transform.Unmarshaller;
import com.amazonaws.util.AWSRequestMetrics;
import com.amazonaws.util.CredentialUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

@ThreadSafe
public class AWSLambdaClient
extends AmazonWebServiceClient
implements AWSLambda {
    private final AWSCredentialsProvider awsCredentialsProvider;
    private static final Log log = LogFactory.getLog(AWSLambda.class);
    private static final String DEFAULT_SIGNING_NAME = "lambda";
    protected static final ClientConfigurationFactory configFactory = new ClientConfigurationFactory();
    private final SdkJsonProtocolFactory protocolFactory = new SdkJsonProtocolFactory(new JsonClientMetadata().withProtocolVersion("1.1").withSupportsCbor(false).withSupportsIon(false).withContentTypeOverride("").addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("InvalidParameterValueException").withModeledClass(InvalidParameterValueException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("ResourceNotFoundException").withModeledClass(ResourceNotFoundException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("EC2UnexpectedException").withModeledClass(EC2UnexpectedException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("EC2AccessDeniedException").withModeledClass(EC2AccessDeniedException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("InvalidSecurityGroupIDException").withModeledClass(InvalidSecurityGroupIDException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("PolicyLengthExceededException").withModeledClass(PolicyLengthExceededException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("KMSAccessDeniedException").withModeledClass(KMSAccessDeniedException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("ResourceConflictException").withModeledClass(ResourceConflictException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("ServiceException").withModeledClass(ServiceException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("CodeStorageExceededException").withModeledClass(CodeStorageExceededException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("EC2ThrottledException").withModeledClass(EC2ThrottledException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("ENILimitReachedException").withModeledClass(ENILimitReachedException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("KMSInvalidStateException").withModeledClass(KMSInvalidStateException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("InvalidZipFileException").withModeledClass(InvalidZipFileException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("KMSDisabledException").withModeledClass(KMSDisabledException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("SubnetIPAddressLimitReachedException").withModeledClass(SubnetIPAddressLimitReachedException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("KMSNotFoundException").withModeledClass(KMSNotFoundException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("InvalidSubnetIDException").withModeledClass(InvalidSubnetIDException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("InvalidRequestContentException").withModeledClass(InvalidRequestContentException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("RequestTooLargeException").withModeledClass(RequestTooLargeException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("TooManyRequestsException").withModeledClass(TooManyRequestsException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("UnsupportedMediaTypeException").withModeledClass(UnsupportedMediaTypeException.class)).withBaseServiceExceptionClass(AWSLambdaException.class));

    public AWSLambdaClient() {
        this((AWSCredentialsProvider)DefaultAWSCredentialsProviderChain.getInstance(), configFactory.getConfig());
    }

    public AWSLambdaClient(ClientConfiguration clientConfiguration) {
        this((AWSCredentialsProvider)DefaultAWSCredentialsProviderChain.getInstance(), clientConfiguration);
    }

    public AWSLambdaClient(AWSCredentials awsCredentials) {
        this(awsCredentials, configFactory.getConfig());
    }

    public AWSLambdaClient(AWSCredentials awsCredentials, ClientConfiguration clientConfiguration) {
        super(clientConfiguration);
        this.awsCredentialsProvider = new StaticCredentialsProvider(awsCredentials);
        this.init();
    }

    public AWSLambdaClient(AWSCredentialsProvider awsCredentialsProvider) {
        this(awsCredentialsProvider, configFactory.getConfig());
    }

    public AWSLambdaClient(AWSCredentialsProvider awsCredentialsProvider, ClientConfiguration clientConfiguration) {
        this(awsCredentialsProvider, clientConfiguration, null);
    }

    public AWSLambdaClient(AWSCredentialsProvider awsCredentialsProvider, ClientConfiguration clientConfiguration, RequestMetricCollector requestMetricCollector) {
        super(clientConfiguration, requestMetricCollector);
        this.awsCredentialsProvider = awsCredentialsProvider;
        this.init();
    }

    AWSLambdaClient(AwsSyncClientParams clientParams) {
        super(clientParams);
        this.awsCredentialsProvider = clientParams.getCredentialsProvider();
        this.init();
    }

    private void init() {
        this.setServiceNameIntern(DEFAULT_SIGNING_NAME);
        this.setEndpointPrefix(DEFAULT_SIGNING_NAME);
        this.setEndpoint("lambda.us-east-1.amazonaws.com");
        HandlerChainFactory chainFactory = new HandlerChainFactory();
        this.requestHandler2s.addAll(chainFactory.newRequestHandlerChain("/com/amazonaws/services/lambda/request.handlers"));
        this.requestHandler2s.addAll(chainFactory.newRequestHandler2Chain("/com/amazonaws/services/lambda/request.handler2s"));
        this.requestHandler2s.addAll(chainFactory.getGlobalHandlers());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public AddPermissionResult addPermission(AddPermissionRequest addPermissionRequest) {
        ExecutionContext executionContext = this.createExecutionContext(addPermissionRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<AddPermissionRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new AddPermissionRequestMarshaller(this.protocolFactory).marshall((AddPermissionRequest)super.beforeMarshalling((AmazonWebServiceRequest)addPermissionRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new AddPermissionResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            AddPermissionResult addPermissionResult = (AddPermissionResult)response.getAwsResponse();
            return addPermissionResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CreateAliasResult createAlias(CreateAliasRequest createAliasRequest) {
        ExecutionContext executionContext = this.createExecutionContext(createAliasRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<CreateAliasRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new CreateAliasRequestMarshaller(this.protocolFactory).marshall((CreateAliasRequest)super.beforeMarshalling((AmazonWebServiceRequest)createAliasRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new CreateAliasResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            CreateAliasResult createAliasResult = (CreateAliasResult)response.getAwsResponse();
            return createAliasResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CreateEventSourceMappingResult createEventSourceMapping(CreateEventSourceMappingRequest createEventSourceMappingRequest) {
        ExecutionContext executionContext = this.createExecutionContext(createEventSourceMappingRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<CreateEventSourceMappingRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new CreateEventSourceMappingRequestMarshaller(this.protocolFactory).marshall((CreateEventSourceMappingRequest)super.beforeMarshalling((AmazonWebServiceRequest)createEventSourceMappingRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new CreateEventSourceMappingResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            CreateEventSourceMappingResult createEventSourceMappingResult = (CreateEventSourceMappingResult)response.getAwsResponse();
            return createEventSourceMappingResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CreateFunctionResult createFunction(CreateFunctionRequest createFunctionRequest) {
        ExecutionContext executionContext = this.createExecutionContext(createFunctionRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<CreateFunctionRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new CreateFunctionRequestMarshaller(this.protocolFactory).marshall((CreateFunctionRequest)super.beforeMarshalling((AmazonWebServiceRequest)createFunctionRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new CreateFunctionResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            CreateFunctionResult createFunctionResult = (CreateFunctionResult)response.getAwsResponse();
            return createFunctionResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeleteAliasResult deleteAlias(DeleteAliasRequest deleteAliasRequest) {
        ExecutionContext executionContext = this.createExecutionContext(deleteAliasRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DeleteAliasRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DeleteAliasRequestMarshaller(this.protocolFactory).marshall((DeleteAliasRequest)super.beforeMarshalling((AmazonWebServiceRequest)deleteAliasRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new DeleteAliasResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            DeleteAliasResult deleteAliasResult = (DeleteAliasResult)response.getAwsResponse();
            return deleteAliasResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeleteEventSourceMappingResult deleteEventSourceMapping(DeleteEventSourceMappingRequest deleteEventSourceMappingRequest) {
        ExecutionContext executionContext = this.createExecutionContext(deleteEventSourceMappingRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DeleteEventSourceMappingRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DeleteEventSourceMappingRequestMarshaller(this.protocolFactory).marshall((DeleteEventSourceMappingRequest)super.beforeMarshalling((AmazonWebServiceRequest)deleteEventSourceMappingRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new DeleteEventSourceMappingResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            DeleteEventSourceMappingResult deleteEventSourceMappingResult = (DeleteEventSourceMappingResult)response.getAwsResponse();
            return deleteEventSourceMappingResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeleteFunctionResult deleteFunction(DeleteFunctionRequest deleteFunctionRequest) {
        ExecutionContext executionContext = this.createExecutionContext(deleteFunctionRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DeleteFunctionRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DeleteFunctionRequestMarshaller(this.protocolFactory).marshall((DeleteFunctionRequest)super.beforeMarshalling((AmazonWebServiceRequest)deleteFunctionRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new DeleteFunctionResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            DeleteFunctionResult deleteFunctionResult = (DeleteFunctionResult)response.getAwsResponse();
            return deleteFunctionResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetAliasResult getAlias(GetAliasRequest getAliasRequest) {
        ExecutionContext executionContext = this.createExecutionContext(getAliasRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<GetAliasRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new GetAliasRequestMarshaller(this.protocolFactory).marshall((GetAliasRequest)super.beforeMarshalling((AmazonWebServiceRequest)getAliasRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new GetAliasResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            GetAliasResult getAliasResult = (GetAliasResult)response.getAwsResponse();
            return getAliasResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetEventSourceMappingResult getEventSourceMapping(GetEventSourceMappingRequest getEventSourceMappingRequest) {
        ExecutionContext executionContext = this.createExecutionContext(getEventSourceMappingRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<GetEventSourceMappingRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new GetEventSourceMappingRequestMarshaller(this.protocolFactory).marshall((GetEventSourceMappingRequest)super.beforeMarshalling((AmazonWebServiceRequest)getEventSourceMappingRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new GetEventSourceMappingResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            GetEventSourceMappingResult getEventSourceMappingResult = (GetEventSourceMappingResult)response.getAwsResponse();
            return getEventSourceMappingResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetFunctionResult getFunction(GetFunctionRequest getFunctionRequest) {
        ExecutionContext executionContext = this.createExecutionContext(getFunctionRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<GetFunctionRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new GetFunctionRequestMarshaller(this.protocolFactory).marshall((GetFunctionRequest)super.beforeMarshalling((AmazonWebServiceRequest)getFunctionRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new GetFunctionResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            GetFunctionResult getFunctionResult = (GetFunctionResult)response.getAwsResponse();
            return getFunctionResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetFunctionConfigurationResult getFunctionConfiguration(GetFunctionConfigurationRequest getFunctionConfigurationRequest) {
        ExecutionContext executionContext = this.createExecutionContext(getFunctionConfigurationRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<GetFunctionConfigurationRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new GetFunctionConfigurationRequestMarshaller(this.protocolFactory).marshall((GetFunctionConfigurationRequest)super.beforeMarshalling((AmazonWebServiceRequest)getFunctionConfigurationRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new GetFunctionConfigurationResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            GetFunctionConfigurationResult getFunctionConfigurationResult = (GetFunctionConfigurationResult)response.getAwsResponse();
            return getFunctionConfigurationResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetPolicyResult getPolicy(GetPolicyRequest getPolicyRequest) {
        ExecutionContext executionContext = this.createExecutionContext(getPolicyRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<GetPolicyRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new GetPolicyRequestMarshaller(this.protocolFactory).marshall((GetPolicyRequest)super.beforeMarshalling((AmazonWebServiceRequest)getPolicyRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new GetPolicyResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            GetPolicyResult getPolicyResult = (GetPolicyResult)response.getAwsResponse();
            return getPolicyResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public InvokeResult invoke(InvokeRequest invokeRequest) {
        ExecutionContext executionContext = this.createExecutionContext(invokeRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<InvokeRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new InvokeRequestMarshaller(this.protocolFactory).marshall((InvokeRequest)super.beforeMarshalling((AmazonWebServiceRequest)invokeRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(false).withHasStreamingSuccessResponse(false), (Unmarshaller)new InvokeResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            InvokeResult invokeResult = (InvokeResult)response.getAwsResponse();
            return invokeResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Deprecated
    public InvokeAsyncResult invokeAsync(InvokeAsyncRequest invokeAsyncRequest) {
        ExecutionContext executionContext = this.createExecutionContext(invokeAsyncRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<InvokeAsyncRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new InvokeAsyncRequestMarshaller(this.protocolFactory).marshall((InvokeAsyncRequest)super.beforeMarshalling((AmazonWebServiceRequest)invokeAsyncRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new InvokeAsyncResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            InvokeAsyncResult invokeAsyncResult = (InvokeAsyncResult)response.getAwsResponse();
            return invokeAsyncResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListAliasesResult listAliases(ListAliasesRequest listAliasesRequest) {
        ExecutionContext executionContext = this.createExecutionContext(listAliasesRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<ListAliasesRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new ListAliasesRequestMarshaller(this.protocolFactory).marshall((ListAliasesRequest)super.beforeMarshalling((AmazonWebServiceRequest)listAliasesRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new ListAliasesResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            ListAliasesResult listAliasesResult = (ListAliasesResult)response.getAwsResponse();
            return listAliasesResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListEventSourceMappingsResult listEventSourceMappings(ListEventSourceMappingsRequest listEventSourceMappingsRequest) {
        ExecutionContext executionContext = this.createExecutionContext(listEventSourceMappingsRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<ListEventSourceMappingsRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new ListEventSourceMappingsRequestMarshaller(this.protocolFactory).marshall((ListEventSourceMappingsRequest)super.beforeMarshalling((AmazonWebServiceRequest)listEventSourceMappingsRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new ListEventSourceMappingsResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            ListEventSourceMappingsResult listEventSourceMappingsResult = (ListEventSourceMappingsResult)response.getAwsResponse();
            return listEventSourceMappingsResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public ListEventSourceMappingsResult listEventSourceMappings() {
        return this.listEventSourceMappings(new ListEventSourceMappingsRequest());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListFunctionsResult listFunctions(ListFunctionsRequest listFunctionsRequest) {
        ExecutionContext executionContext = this.createExecutionContext(listFunctionsRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<ListFunctionsRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new ListFunctionsRequestMarshaller(this.protocolFactory).marshall((ListFunctionsRequest)super.beforeMarshalling((AmazonWebServiceRequest)listFunctionsRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new ListFunctionsResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            ListFunctionsResult listFunctionsResult = (ListFunctionsResult)response.getAwsResponse();
            return listFunctionsResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public ListFunctionsResult listFunctions() {
        return this.listFunctions(new ListFunctionsRequest());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListVersionsByFunctionResult listVersionsByFunction(ListVersionsByFunctionRequest listVersionsByFunctionRequest) {
        ExecutionContext executionContext = this.createExecutionContext(listVersionsByFunctionRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<ListVersionsByFunctionRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new ListVersionsByFunctionRequestMarshaller(this.protocolFactory).marshall((ListVersionsByFunctionRequest)super.beforeMarshalling((AmazonWebServiceRequest)listVersionsByFunctionRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new ListVersionsByFunctionResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            ListVersionsByFunctionResult listVersionsByFunctionResult = (ListVersionsByFunctionResult)response.getAwsResponse();
            return listVersionsByFunctionResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PublishVersionResult publishVersion(PublishVersionRequest publishVersionRequest) {
        ExecutionContext executionContext = this.createExecutionContext(publishVersionRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<PublishVersionRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new PublishVersionRequestMarshaller(this.protocolFactory).marshall((PublishVersionRequest)super.beforeMarshalling((AmazonWebServiceRequest)publishVersionRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new PublishVersionResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            PublishVersionResult publishVersionResult = (PublishVersionResult)response.getAwsResponse();
            return publishVersionResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public RemovePermissionResult removePermission(RemovePermissionRequest removePermissionRequest) {
        ExecutionContext executionContext = this.createExecutionContext(removePermissionRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<RemovePermissionRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new RemovePermissionRequestMarshaller(this.protocolFactory).marshall((RemovePermissionRequest)super.beforeMarshalling((AmazonWebServiceRequest)removePermissionRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new RemovePermissionResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            RemovePermissionResult removePermissionResult = (RemovePermissionResult)response.getAwsResponse();
            return removePermissionResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UpdateAliasResult updateAlias(UpdateAliasRequest updateAliasRequest) {
        ExecutionContext executionContext = this.createExecutionContext(updateAliasRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<UpdateAliasRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new UpdateAliasRequestMarshaller(this.protocolFactory).marshall((UpdateAliasRequest)super.beforeMarshalling((AmazonWebServiceRequest)updateAliasRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new UpdateAliasResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            UpdateAliasResult updateAliasResult = (UpdateAliasResult)response.getAwsResponse();
            return updateAliasResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UpdateEventSourceMappingResult updateEventSourceMapping(UpdateEventSourceMappingRequest updateEventSourceMappingRequest) {
        ExecutionContext executionContext = this.createExecutionContext(updateEventSourceMappingRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<UpdateEventSourceMappingRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new UpdateEventSourceMappingRequestMarshaller(this.protocolFactory).marshall((UpdateEventSourceMappingRequest)super.beforeMarshalling((AmazonWebServiceRequest)updateEventSourceMappingRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new UpdateEventSourceMappingResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            UpdateEventSourceMappingResult updateEventSourceMappingResult = (UpdateEventSourceMappingResult)response.getAwsResponse();
            return updateEventSourceMappingResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UpdateFunctionCodeResult updateFunctionCode(UpdateFunctionCodeRequest updateFunctionCodeRequest) {
        ExecutionContext executionContext = this.createExecutionContext(updateFunctionCodeRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<UpdateFunctionCodeRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new UpdateFunctionCodeRequestMarshaller(this.protocolFactory).marshall((UpdateFunctionCodeRequest)super.beforeMarshalling((AmazonWebServiceRequest)updateFunctionCodeRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new UpdateFunctionCodeResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            UpdateFunctionCodeResult updateFunctionCodeResult = (UpdateFunctionCodeResult)response.getAwsResponse();
            return updateFunctionCodeResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UpdateFunctionConfigurationResult updateFunctionConfiguration(UpdateFunctionConfigurationRequest updateFunctionConfigurationRequest) {
        ExecutionContext executionContext = this.createExecutionContext(updateFunctionConfigurationRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<UpdateFunctionConfigurationRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new UpdateFunctionConfigurationRequestMarshaller(this.protocolFactory).marshall((UpdateFunctionConfigurationRequest)super.beforeMarshalling((AmazonWebServiceRequest)updateFunctionConfigurationRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new UpdateFunctionConfigurationResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            UpdateFunctionConfigurationResult updateFunctionConfigurationResult = (UpdateFunctionConfigurationResult)response.getAwsResponse();
            return updateFunctionConfigurationResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public ResponseMetadata getCachedResponseMetadata(AmazonWebServiceRequest request) {
        return this.client.getResponseMetadataForRequest(request);
    }

    private <X, Y extends AmazonWebServiceRequest> Response<X> invoke(Request<Y> request, HttpResponseHandler<AmazonWebServiceResponse<X>> responseHandler, ExecutionContext executionContext) {
        executionContext.setCredentialsProvider(CredentialUtils.getCredentialsProvider((AmazonWebServiceRequest)request.getOriginalRequest(), (AWSCredentialsProvider)this.awsCredentialsProvider));
        return this.doInvoke(request, responseHandler, executionContext);
    }

    private <X, Y extends AmazonWebServiceRequest> Response<X> anonymousInvoke(Request<Y> request, HttpResponseHandler<AmazonWebServiceResponse<X>> responseHandler, ExecutionContext executionContext) {
        return this.doInvoke(request, responseHandler, executionContext);
    }

    private <X, Y extends AmazonWebServiceRequest> Response<X> doInvoke(Request<Y> request, HttpResponseHandler<AmazonWebServiceResponse<X>> responseHandler, ExecutionContext executionContext) {
        request.setEndpoint(this.endpoint);
        request.setTimeOffset(this.timeOffset);
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler(new JsonErrorResponseMetadata());
        return this.client.execute(request, responseHandler, errorResponseHandler, executionContext);
    }
}

