/*
 * Copyright 2018-2023 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */
package com.amazonaws.services.securityhub.model.transform;

import javax.annotation.Generated;

import com.amazonaws.SdkClientException;
import com.amazonaws.services.securityhub.model.*;

import com.amazonaws.protocol.*;
import com.amazonaws.annotation.SdkInternalApi;

/**
 * AwsOpenSearchServiceDomainAdvancedSecurityOptionsDetailsMarshaller
 */
@Generated("com.amazonaws:aws-java-sdk-code-generator")
@SdkInternalApi
public class AwsOpenSearchServiceDomainAdvancedSecurityOptionsDetailsMarshaller {

    private static final MarshallingInfo<Boolean> ENABLED_BINDING = MarshallingInfo.builder(MarshallingType.BOOLEAN).marshallLocation(MarshallLocation.PAYLOAD)
            .marshallLocationName("Enabled").build();
    private static final MarshallingInfo<Boolean> INTERNALUSERDATABASEENABLED_BINDING = MarshallingInfo.builder(MarshallingType.BOOLEAN)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("InternalUserDatabaseEnabled").build();
    private static final MarshallingInfo<StructuredPojo> MASTERUSEROPTIONS_BINDING = MarshallingInfo.builder(MarshallingType.STRUCTURED)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("MasterUserOptions").build();

    private static final AwsOpenSearchServiceDomainAdvancedSecurityOptionsDetailsMarshaller instance = new AwsOpenSearchServiceDomainAdvancedSecurityOptionsDetailsMarshaller();

    public static AwsOpenSearchServiceDomainAdvancedSecurityOptionsDetailsMarshaller getInstance() {
        return instance;
    }

    /**
     * Marshall the given parameter object.
     */
    public void marshall(AwsOpenSearchServiceDomainAdvancedSecurityOptionsDetails awsOpenSearchServiceDomainAdvancedSecurityOptionsDetails,
            ProtocolMarshaller protocolMarshaller) {

        if (awsOpenSearchServiceDomainAdvancedSecurityOptionsDetails == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }

        try {
            protocolMarshaller.marshall(awsOpenSearchServiceDomainAdvancedSecurityOptionsDetails.getEnabled(), ENABLED_BINDING);
            protocolMarshaller.marshall(awsOpenSearchServiceDomainAdvancedSecurityOptionsDetails.getInternalUserDatabaseEnabled(),
                    INTERNALUSERDATABASEENABLED_BINDING);
            protocolMarshaller.marshall(awsOpenSearchServiceDomainAdvancedSecurityOptionsDetails.getMasterUserOptions(), MASTERUSEROPTIONS_BINDING);
        } catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), e);
        }
    }

}
