/*
 * Copyright 2018-2023 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */
package com.amazonaws.services.securityhub.model;

import java.io.Serializable;
import javax.annotation.Generated;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.protocol.ProtocolMarshaller;

/**
 * <p>
 * Provides a consistent format for Security Hub findings. <code>AwsSecurityFinding</code> format allows you to share
 * findings between Amazon Web Services security services and third-party solutions.
 * </p>
 * <note>
 * <p>
 * A finding is a potential security issue generated either by Amazon Web Services services or by the integrated
 * third-party solutions and standards checks.
 * </p>
 * </note>
 * 
 * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/AwsSecurityFinding" target="_top">AWS API
 *      Documentation</a>
 */
@Generated("com.amazonaws:aws-java-sdk-code-generator")
public class AwsSecurityFinding implements Serializable, Cloneable, StructuredPojo {

    /**
     * <p>
     * The schema version that a finding is formatted for.
     * </p>
     */
    private String schemaVersion;
    /**
     * <p>
     * The security findings provider-specific identifier for a finding.
     * </p>
     */
    private String id;
    /**
     * <p>
     * The ARN generated by Security Hub that uniquely identifies a product that generates findings. This can be the ARN
     * for a third-party product that is integrated with Security Hub, or the ARN for a custom integration.
     * </p>
     */
    private String productArn;
    /**
     * <p>
     * The name of the product that generated the finding.
     * </p>
     * <p>
     * Security Hub populates this attribute automatically for each finding. You cannot update this attribute with
     * <code>BatchImportFindings</code> or <code>BatchUpdateFindings</code>. The exception to this is a custom
     * integration.
     * </p>
     * <p>
     * When you use the Security Hub console or API to filter findings by product name, you use this attribute.
     * </p>
     */
    private String productName;
    /**
     * <p>
     * The name of the company for the product that generated the finding.
     * </p>
     * <p>
     * Security Hub populates this attribute automatically for each finding. You cannot update this attribute with
     * <code>BatchImportFindings</code> or <code>BatchUpdateFindings</code>. The exception to this is a custom
     * integration.
     * </p>
     * <p>
     * When you use the Security Hub console or API to filter findings by company name, you use this attribute.
     * </p>
     */
    private String companyName;
    /**
     * <p>
     * The Region from which the finding was generated.
     * </p>
     * <p>
     * Security Hub populates this attribute automatically for each finding. You cannot update it using
     * <code>BatchImportFindings</code> or <code>BatchUpdateFindings</code>.
     * </p>
     */
    private String region;
    /**
     * <p>
     * The identifier for the solution-specific component (a discrete unit of logic) that generated a finding. In
     * various security findings providers' solutions, this generator can be called a rule, a check, a detector, a
     * plugin, etc.
     * </p>
     */
    private String generatorId;
    /**
     * <p>
     * The Amazon Web Services account ID that a finding is generated in.
     * </p>
     */
    private String awsAccountId;
    /**
     * <p>
     * One or more finding types in the format of <code>namespace/category/classifier</code> that classify a finding.
     * </p>
     * <p>
     * Valid namespace values are: Software and Configuration Checks | TTPs | Effects | Unusual Behaviors | Sensitive
     * Data Identifications
     * </p>
     */
    private java.util.List<String> types;
    /**
     * <p>
     * Indicates when the security findings provider first observed the potential security issue that a finding
     * captured.
     * </p>
     * <p>
     * Uses the <code>date-time</code> format specified in <a href="https://tools.ietf.org/html/rfc3339#section-5.6">RFC
     * 3339 section 5.6, Internet Date/Time Format</a>. The value cannot contain spaces, and date and time should be
     * separated by <code>T</code>. For example, <code>2020-03-22T13:22:13.933Z</code>.
     * </p>
     */
    private String firstObservedAt;
    /**
     * <p>
     * Indicates when the security findings provider most recently observed the potential security issue that a finding
     * captured.
     * </p>
     * <p>
     * Uses the <code>date-time</code> format specified in <a href="https://tools.ietf.org/html/rfc3339#section-5.6">RFC
     * 3339 section 5.6, Internet Date/Time Format</a>. The value cannot contain spaces, and date and time should be
     * separated by <code>T</code>. For example, <code>2020-03-22T13:22:13.933Z</code>.
     * </p>
     */
    private String lastObservedAt;
    /**
     * <p>
     * Indicates when the security findings provider created the potential security issue that a finding captured.
     * </p>
     * <p>
     * Uses the <code>date-time</code> format specified in <a href="https://tools.ietf.org/html/rfc3339#section-5.6">RFC
     * 3339 section 5.6, Internet Date/Time Format</a>. The value cannot contain spaces, and date and time should be
     * separated by <code>T</code>. For example, <code>2020-03-22T13:22:13.933Z</code>.
     * </p>
     */
    private String createdAt;
    /**
     * <p>
     * Indicates when the security findings provider last updated the finding record.
     * </p>
     * <p>
     * Uses the <code>date-time</code> format specified in <a href="https://tools.ietf.org/html/rfc3339#section-5.6">RFC
     * 3339 section 5.6, Internet Date/Time Format</a>. The value cannot contain spaces, and date and time should be
     * separated by <code>T</code>. For example, <code>2020-03-22T13:22:13.933Z</code>.
     * </p>
     */
    private String updatedAt;
    /**
     * <p>
     * A finding's severity.
     * </p>
     */
    private Severity severity;
    /**
     * <p>
     * A finding's confidence. Confidence is defined as the likelihood that a finding accurately identifies the behavior
     * or issue that it was intended to identify.
     * </p>
     * <p>
     * Confidence is scored on a 0-100 basis using a ratio scale, where 0 means zero percent confidence and 100 means
     * 100 percent confidence.
     * </p>
     */
    private Integer confidence;
    /**
     * <p>
     * The level of importance assigned to the resources associated with the finding.
     * </p>
     * <p>
     * A score of 0 means that the underlying resources have no criticality, and a score of 100 is reserved for the most
     * critical resources.
     * </p>
     */
    private Integer criticality;
    /**
     * <p>
     * A finding's title.
     * </p>
     * <note>
     * <p>
     * In this release, <code>Title</code> is a required property.
     * </p>
     * </note>
     */
    private String title;
    /**
     * <p>
     * A finding's description.
     * </p>
     * <note>
     * <p>
     * In this release, <code>Description</code> is a required property.
     * </p>
     * </note>
     */
    private String description;
    /**
     * <p>
     * A data type that describes the remediation options for a finding.
     * </p>
     */
    private Remediation remediation;
    /**
     * <p>
     * A URL that links to a page about the current finding in the security findings provider's solution.
     * </p>
     */
    private String sourceUrl;
    /**
     * <p>
     * A data type where security findings providers can include additional solution-specific details that aren't part
     * of the defined <code>AwsSecurityFinding</code> format.
     * </p>
     * <p>
     * Can contain up to 50 key-value pairs. For each key-value pair, the key can contain up to 128 characters, and the
     * value can contain up to 2048 characters.
     * </p>
     */
    private java.util.Map<String, String> productFields;
    /**
     * <p>
     * A list of name/value string pairs associated with the finding. These are custom, user-defined fields added to a
     * finding.
     * </p>
     */
    private java.util.Map<String, String> userDefinedFields;
    /**
     * <p>
     * A list of malware related to a finding.
     * </p>
     */
    private java.util.List<Malware> malware;
    /**
     * <p>
     * The details of network-related information about a finding.
     * </p>
     */
    private Network network;
    /**
     * <p>
     * Provides information about a network path that is relevant to a finding. Each entry under
     * <code>NetworkPath</code> represents a component of that path.
     * </p>
     */
    private java.util.List<NetworkPathComponent> networkPath;
    /**
     * <p>
     * The details of process-related information about a finding.
     * </p>
     */
    private ProcessDetails process;
    /**
     * <p>
     * Details about the threat detected in a security finding and the file paths that were affected by the threat.
     * </p>
     */
    private java.util.List<Threat> threats;
    /**
     * <p>
     * Threat intelligence details related to a finding.
     * </p>
     */
    private java.util.List<ThreatIntelIndicator> threatIntelIndicators;
    /**
     * <p>
     * A set of resource data types that describe the resources that the finding refers to.
     * </p>
     */
    private java.util.List<Resource> resources;
    /**
     * <p>
     * This data type is exclusive to findings that are generated as the result of a check run against a specific rule
     * in a supported security standard, such as CIS Amazon Web Services Foundations. Contains security standard-related
     * finding details.
     * </p>
     */
    private Compliance compliance;
    /**
     * <p>
     * Indicates the veracity of a finding.
     * </p>
     */
    private String verificationState;
    /**
     * <p>
     * The workflow state of a finding.
     * </p>
     */
    private String workflowState;
    /**
     * <p>
     * Provides information about the status of the investigation into a finding.
     * </p>
     */
    private Workflow workflow;
    /**
     * <p>
     * The record state of a finding.
     * </p>
     */
    private String recordState;
    /**
     * <p>
     * A list of related findings.
     * </p>
     */
    private java.util.List<RelatedFinding> relatedFindings;
    /**
     * <p>
     * A user-defined note added to a finding.
     * </p>
     */
    private Note note;
    /**
     * <p>
     * Provides a list of vulnerabilities associated with the findings.
     * </p>
     */
    private java.util.List<Vulnerability> vulnerabilities;
    /**
     * <p>
     * Provides an overview of the patch compliance status for an instance against a selected compliance standard.
     * </p>
     */
    private PatchSummary patchSummary;
    /**
     * <p>
     * Provides details about an action that affects or that was taken on a resource.
     * </p>
     */
    private Action action;
    /**
     * <p>
     * In a <code>BatchImportFindings</code> request, finding providers use <code>FindingProviderFields</code> to
     * provide and update their own values for confidence, criticality, related findings, severity, and types.
     * </p>
     */
    private FindingProviderFields findingProviderFields;
    /**
     * <p>
     * Indicates whether the finding is a sample finding.
     * </p>
     */
    private Boolean sample;

    /**
     * <p>
     * The schema version that a finding is formatted for.
     * </p>
     * 
     * @param schemaVersion
     *        The schema version that a finding is formatted for.
     */

    public void setSchemaVersion(String schemaVersion) {
        this.schemaVersion = schemaVersion;
    }

    /**
     * <p>
     * The schema version that a finding is formatted for.
     * </p>
     * 
     * @return The schema version that a finding is formatted for.
     */

    public String getSchemaVersion() {
        return this.schemaVersion;
    }

    /**
     * <p>
     * The schema version that a finding is formatted for.
     * </p>
     * 
     * @param schemaVersion
     *        The schema version that a finding is formatted for.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public AwsSecurityFinding withSchemaVersion(String schemaVersion) {
        setSchemaVersion(schemaVersion);
        return this;
    }

    /**
     * <p>
     * The security findings provider-specific identifier for a finding.
     * </p>
     * 
     * @param id
     *        The security findings provider-specific identifier for a finding.
     */

    public void setId(String id) {
        this.id = id;
    }

    /**
     * <p>
     * The security findings provider-specific identifier for a finding.
     * </p>
     * 
     * @return The security findings provider-specific identifier for a finding.
     */

    public String getId() {
        return this.id;
    }

    /**
     * <p>
     * The security findings provider-specific identifier for a finding.
     * </p>
     * 
     * @param id
     *        The security findings provider-specific identifier for a finding.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public AwsSecurityFinding withId(String id) {
        setId(id);
        return this;
    }

    /**
     * <p>
     * The ARN generated by Security Hub that uniquely identifies a product that generates findings. This can be the ARN
     * for a third-party product that is integrated with Security Hub, or the ARN for a custom integration.
     * </p>
     * 
     * @param productArn
     *        The ARN generated by Security Hub that uniquely identifies a product that generates findings. This can be
     *        the ARN for a third-party product that is integrated with Security Hub, or the ARN for a custom
     *        integration.
     */

    public void setProductArn(String productArn) {
        this.productArn = productArn;
    }

    /**
     * <p>
     * The ARN generated by Security Hub that uniquely identifies a product that generates findings. This can be the ARN
     * for a third-party product that is integrated with Security Hub, or the ARN for a custom integration.
     * </p>
     * 
     * @return The ARN generated by Security Hub that uniquely identifies a product that generates findings. This can be
     *         the ARN for a third-party product that is integrated with Security Hub, or the ARN for a custom
     *         integration.
     */

    public String getProductArn() {
        return this.productArn;
    }

    /**
     * <p>
     * The ARN generated by Security Hub that uniquely identifies a product that generates findings. This can be the ARN
     * for a third-party product that is integrated with Security Hub, or the ARN for a custom integration.
     * </p>
     * 
     * @param productArn
     *        The ARN generated by Security Hub that uniquely identifies a product that generates findings. This can be
     *        the ARN for a third-party product that is integrated with Security Hub, or the ARN for a custom
     *        integration.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public AwsSecurityFinding withProductArn(String productArn) {
        setProductArn(productArn);
        return this;
    }

    /**
     * <p>
     * The name of the product that generated the finding.
     * </p>
     * <p>
     * Security Hub populates this attribute automatically for each finding. You cannot update this attribute with
     * <code>BatchImportFindings</code> or <code>BatchUpdateFindings</code>. The exception to this is a custom
     * integration.
     * </p>
     * <p>
     * When you use the Security Hub console or API to filter findings by product name, you use this attribute.
     * </p>
     * 
     * @param productName
     *        The name of the product that generated the finding.</p>
     *        <p>
     *        Security Hub populates this attribute automatically for each finding. You cannot update this attribute
     *        with <code>BatchImportFindings</code> or <code>BatchUpdateFindings</code>. The exception to this is a
     *        custom integration.
     *        </p>
     *        <p>
     *        When you use the Security Hub console or API to filter findings by product name, you use this attribute.
     */

    public void setProductName(String productName) {
        this.productName = productName;
    }

    /**
     * <p>
     * The name of the product that generated the finding.
     * </p>
     * <p>
     * Security Hub populates this attribute automatically for each finding. You cannot update this attribute with
     * <code>BatchImportFindings</code> or <code>BatchUpdateFindings</code>. The exception to this is a custom
     * integration.
     * </p>
     * <p>
     * When you use the Security Hub console or API to filter findings by product name, you use this attribute.
     * </p>
     * 
     * @return The name of the product that generated the finding.</p>
     *         <p>
     *         Security Hub populates this attribute automatically for each finding. You cannot update this attribute
     *         with <code>BatchImportFindings</code> or <code>BatchUpdateFindings</code>. The exception to this is a
     *         custom integration.
     *         </p>
     *         <p>
     *         When you use the Security Hub console or API to filter findings by product name, you use this attribute.
     */

    public String getProductName() {
        return this.productName;
    }

    /**
     * <p>
     * The name of the product that generated the finding.
     * </p>
     * <p>
     * Security Hub populates this attribute automatically for each finding. You cannot update this attribute with
     * <code>BatchImportFindings</code> or <code>BatchUpdateFindings</code>. The exception to this is a custom
     * integration.
     * </p>
     * <p>
     * When you use the Security Hub console or API to filter findings by product name, you use this attribute.
     * </p>
     * 
     * @param productName
     *        The name of the product that generated the finding.</p>
     *        <p>
     *        Security Hub populates this attribute automatically for each finding. You cannot update this attribute
     *        with <code>BatchImportFindings</code> or <code>BatchUpdateFindings</code>. The exception to this is a
     *        custom integration.
     *        </p>
     *        <p>
     *        When you use the Security Hub console or API to filter findings by product name, you use this attribute.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public AwsSecurityFinding withProductName(String productName) {
        setProductName(productName);
        return this;
    }

    /**
     * <p>
     * The name of the company for the product that generated the finding.
     * </p>
     * <p>
     * Security Hub populates this attribute automatically for each finding. You cannot update this attribute with
     * <code>BatchImportFindings</code> or <code>BatchUpdateFindings</code>. The exception to this is a custom
     * integration.
     * </p>
     * <p>
     * When you use the Security Hub console or API to filter findings by company name, you use this attribute.
     * </p>
     * 
     * @param companyName
     *        The name of the company for the product that generated the finding.</p>
     *        <p>
     *        Security Hub populates this attribute automatically for each finding. You cannot update this attribute
     *        with <code>BatchImportFindings</code> or <code>BatchUpdateFindings</code>. The exception to this is a
     *        custom integration.
     *        </p>
     *        <p>
     *        When you use the Security Hub console or API to filter findings by company name, you use this attribute.
     */

    public void setCompanyName(String companyName) {
        this.companyName = companyName;
    }

    /**
     * <p>
     * The name of the company for the product that generated the finding.
     * </p>
     * <p>
     * Security Hub populates this attribute automatically for each finding. You cannot update this attribute with
     * <code>BatchImportFindings</code> or <code>BatchUpdateFindings</code>. The exception to this is a custom
     * integration.
     * </p>
     * <p>
     * When you use the Security Hub console or API to filter findings by company name, you use this attribute.
     * </p>
     * 
     * @return The name of the company for the product that generated the finding.</p>
     *         <p>
     *         Security Hub populates this attribute automatically for each finding. You cannot update this attribute
     *         with <code>BatchImportFindings</code> or <code>BatchUpdateFindings</code>. The exception to this is a
     *         custom integration.
     *         </p>
     *         <p>
     *         When you use the Security Hub console or API to filter findings by company name, you use this attribute.
     */

    public String getCompanyName() {
        return this.companyName;
    }

    /**
     * <p>
     * The name of the company for the product that generated the finding.
     * </p>
     * <p>
     * Security Hub populates this attribute automatically for each finding. You cannot update this attribute with
     * <code>BatchImportFindings</code> or <code>BatchUpdateFindings</code>. The exception to this is a custom
     * integration.
     * </p>
     * <p>
     * When you use the Security Hub console or API to filter findings by company name, you use this attribute.
     * </p>
     * 
     * @param companyName
     *        The name of the company for the product that generated the finding.</p>
     *        <p>
     *        Security Hub populates this attribute automatically for each finding. You cannot update this attribute
     *        with <code>BatchImportFindings</code> or <code>BatchUpdateFindings</code>. The exception to this is a
     *        custom integration.
     *        </p>
     *        <p>
     *        When you use the Security Hub console or API to filter findings by company name, you use this attribute.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public AwsSecurityFinding withCompanyName(String companyName) {
        setCompanyName(companyName);
        return this;
    }

    /**
     * <p>
     * The Region from which the finding was generated.
     * </p>
     * <p>
     * Security Hub populates this attribute automatically for each finding. You cannot update it using
     * <code>BatchImportFindings</code> or <code>BatchUpdateFindings</code>.
     * </p>
     * 
     * @param region
     *        The Region from which the finding was generated.</p>
     *        <p>
     *        Security Hub populates this attribute automatically for each finding. You cannot update it using
     *        <code>BatchImportFindings</code> or <code>BatchUpdateFindings</code>.
     */

    public void setRegion(String region) {
        this.region = region;
    }

    /**
     * <p>
     * The Region from which the finding was generated.
     * </p>
     * <p>
     * Security Hub populates this attribute automatically for each finding. You cannot update it using
     * <code>BatchImportFindings</code> or <code>BatchUpdateFindings</code>.
     * </p>
     * 
     * @return The Region from which the finding was generated.</p>
     *         <p>
     *         Security Hub populates this attribute automatically for each finding. You cannot update it using
     *         <code>BatchImportFindings</code> or <code>BatchUpdateFindings</code>.
     */

    public String getRegion() {
        return this.region;
    }

    /**
     * <p>
     * The Region from which the finding was generated.
     * </p>
     * <p>
     * Security Hub populates this attribute automatically for each finding. You cannot update it using
     * <code>BatchImportFindings</code> or <code>BatchUpdateFindings</code>.
     * </p>
     * 
     * @param region
     *        The Region from which the finding was generated.</p>
     *        <p>
     *        Security Hub populates this attribute automatically for each finding. You cannot update it using
     *        <code>BatchImportFindings</code> or <code>BatchUpdateFindings</code>.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public AwsSecurityFinding withRegion(String region) {
        setRegion(region);
        return this;
    }

    /**
     * <p>
     * The identifier for the solution-specific component (a discrete unit of logic) that generated a finding. In
     * various security findings providers' solutions, this generator can be called a rule, a check, a detector, a
     * plugin, etc.
     * </p>
     * 
     * @param generatorId
     *        The identifier for the solution-specific component (a discrete unit of logic) that generated a finding. In
     *        various security findings providers' solutions, this generator can be called a rule, a check, a detector,
     *        a plugin, etc.
     */

    public void setGeneratorId(String generatorId) {
        this.generatorId = generatorId;
    }

    /**
     * <p>
     * The identifier for the solution-specific component (a discrete unit of logic) that generated a finding. In
     * various security findings providers' solutions, this generator can be called a rule, a check, a detector, a
     * plugin, etc.
     * </p>
     * 
     * @return The identifier for the solution-specific component (a discrete unit of logic) that generated a finding.
     *         In various security findings providers' solutions, this generator can be called a rule, a check, a
     *         detector, a plugin, etc.
     */

    public String getGeneratorId() {
        return this.generatorId;
    }

    /**
     * <p>
     * The identifier for the solution-specific component (a discrete unit of logic) that generated a finding. In
     * various security findings providers' solutions, this generator can be called a rule, a check, a detector, a
     * plugin, etc.
     * </p>
     * 
     * @param generatorId
     *        The identifier for the solution-specific component (a discrete unit of logic) that generated a finding. In
     *        various security findings providers' solutions, this generator can be called a rule, a check, a detector,
     *        a plugin, etc.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public AwsSecurityFinding withGeneratorId(String generatorId) {
        setGeneratorId(generatorId);
        return this;
    }

    /**
     * <p>
     * The Amazon Web Services account ID that a finding is generated in.
     * </p>
     * 
     * @param awsAccountId
     *        The Amazon Web Services account ID that a finding is generated in.
     */

    public void setAwsAccountId(String awsAccountId) {
        this.awsAccountId = awsAccountId;
    }

    /**
     * <p>
     * The Amazon Web Services account ID that a finding is generated in.
     * </p>
     * 
     * @return The Amazon Web Services account ID that a finding is generated in.
     */

    public String getAwsAccountId() {
        return this.awsAccountId;
    }

    /**
     * <p>
     * The Amazon Web Services account ID that a finding is generated in.
     * </p>
     * 
     * @param awsAccountId
     *        The Amazon Web Services account ID that a finding is generated in.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public AwsSecurityFinding withAwsAccountId(String awsAccountId) {
        setAwsAccountId(awsAccountId);
        return this;
    }

    /**
     * <p>
     * One or more finding types in the format of <code>namespace/category/classifier</code> that classify a finding.
     * </p>
     * <p>
     * Valid namespace values are: Software and Configuration Checks | TTPs | Effects | Unusual Behaviors | Sensitive
     * Data Identifications
     * </p>
     * 
     * @return One or more finding types in the format of <code>namespace/category/classifier</code> that classify a
     *         finding.</p>
     *         <p>
     *         Valid namespace values are: Software and Configuration Checks | TTPs | Effects | Unusual Behaviors |
     *         Sensitive Data Identifications
     */

    public java.util.List<String> getTypes() {
        return types;
    }

    /**
     * <p>
     * One or more finding types in the format of <code>namespace/category/classifier</code> that classify a finding.
     * </p>
     * <p>
     * Valid namespace values are: Software and Configuration Checks | TTPs | Effects | Unusual Behaviors | Sensitive
     * Data Identifications
     * </p>
     * 
     * @param types
     *        One or more finding types in the format of <code>namespace/category/classifier</code> that classify a
     *        finding.</p>
     *        <p>
     *        Valid namespace values are: Software and Configuration Checks | TTPs | Effects | Unusual Behaviors |
     *        Sensitive Data Identifications
     */

    public void setTypes(java.util.Collection<String> types) {
        if (types == null) {
            this.types = null;
            return;
        }

        this.types = new java.util.ArrayList<String>(types);
    }

    /**
     * <p>
     * One or more finding types in the format of <code>namespace/category/classifier</code> that classify a finding.
     * </p>
     * <p>
     * Valid namespace values are: Software and Configuration Checks | TTPs | Effects | Unusual Behaviors | Sensitive
     * Data Identifications
     * </p>
     * <p>
     * <b>NOTE:</b> This method appends the values to the existing list (if any). Use
     * {@link #setTypes(java.util.Collection)} or {@link #withTypes(java.util.Collection)} if you want to override the
     * existing values.
     * </p>
     * 
     * @param types
     *        One or more finding types in the format of <code>namespace/category/classifier</code> that classify a
     *        finding.</p>
     *        <p>
     *        Valid namespace values are: Software and Configuration Checks | TTPs | Effects | Unusual Behaviors |
     *        Sensitive Data Identifications
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public AwsSecurityFinding withTypes(String... types) {
        if (this.types == null) {
            setTypes(new java.util.ArrayList<String>(types.length));
        }
        for (String ele : types) {
            this.types.add(ele);
        }
        return this;
    }

    /**
     * <p>
     * One or more finding types in the format of <code>namespace/category/classifier</code> that classify a finding.
     * </p>
     * <p>
     * Valid namespace values are: Software and Configuration Checks | TTPs | Effects | Unusual Behaviors | Sensitive
     * Data Identifications
     * </p>
     * 
     * @param types
     *        One or more finding types in the format of <code>namespace/category/classifier</code> that classify a
     *        finding.</p>
     *        <p>
     *        Valid namespace values are: Software and Configuration Checks | TTPs | Effects | Unusual Behaviors |
     *        Sensitive Data Identifications
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public AwsSecurityFinding withTypes(java.util.Collection<String> types) {
        setTypes(types);
        return this;
    }

    /**
     * <p>
     * Indicates when the security findings provider first observed the potential security issue that a finding
     * captured.
     * </p>
     * <p>
     * Uses the <code>date-time</code> format specified in <a href="https://tools.ietf.org/html/rfc3339#section-5.6">RFC
     * 3339 section 5.6, Internet Date/Time Format</a>. The value cannot contain spaces, and date and time should be
     * separated by <code>T</code>. For example, <code>2020-03-22T13:22:13.933Z</code>.
     * </p>
     * 
     * @param firstObservedAt
     *        Indicates when the security findings provider first observed the potential security issue that a finding
     *        captured.</p>
     *        <p>
     *        Uses the <code>date-time</code> format specified in <a
     *        href="https://tools.ietf.org/html/rfc3339#section-5.6">RFC 3339 section 5.6, Internet Date/Time
     *        Format</a>. The value cannot contain spaces, and date and time should be separated by <code>T</code>. For
     *        example, <code>2020-03-22T13:22:13.933Z</code>.
     */

    public void setFirstObservedAt(String firstObservedAt) {
        this.firstObservedAt = firstObservedAt;
    }

    /**
     * <p>
     * Indicates when the security findings provider first observed the potential security issue that a finding
     * captured.
     * </p>
     * <p>
     * Uses the <code>date-time</code> format specified in <a href="https://tools.ietf.org/html/rfc3339#section-5.6">RFC
     * 3339 section 5.6, Internet Date/Time Format</a>. The value cannot contain spaces, and date and time should be
     * separated by <code>T</code>. For example, <code>2020-03-22T13:22:13.933Z</code>.
     * </p>
     * 
     * @return Indicates when the security findings provider first observed the potential security issue that a finding
     *         captured.</p>
     *         <p>
     *         Uses the <code>date-time</code> format specified in <a
     *         href="https://tools.ietf.org/html/rfc3339#section-5.6">RFC 3339 section 5.6, Internet Date/Time
     *         Format</a>. The value cannot contain spaces, and date and time should be separated by <code>T</code>. For
     *         example, <code>2020-03-22T13:22:13.933Z</code>.
     */

    public String getFirstObservedAt() {
        return this.firstObservedAt;
    }

    /**
     * <p>
     * Indicates when the security findings provider first observed the potential security issue that a finding
     * captured.
     * </p>
     * <p>
     * Uses the <code>date-time</code> format specified in <a href="https://tools.ietf.org/html/rfc3339#section-5.6">RFC
     * 3339 section 5.6, Internet Date/Time Format</a>. The value cannot contain spaces, and date and time should be
     * separated by <code>T</code>. For example, <code>2020-03-22T13:22:13.933Z</code>.
     * </p>
     * 
     * @param firstObservedAt
     *        Indicates when the security findings provider first observed the potential security issue that a finding
     *        captured.</p>
     *        <p>
     *        Uses the <code>date-time</code> format specified in <a
     *        href="https://tools.ietf.org/html/rfc3339#section-5.6">RFC 3339 section 5.6, Internet Date/Time
     *        Format</a>. The value cannot contain spaces, and date and time should be separated by <code>T</code>. For
     *        example, <code>2020-03-22T13:22:13.933Z</code>.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public AwsSecurityFinding withFirstObservedAt(String firstObservedAt) {
        setFirstObservedAt(firstObservedAt);
        return this;
    }

    /**
     * <p>
     * Indicates when the security findings provider most recently observed the potential security issue that a finding
     * captured.
     * </p>
     * <p>
     * Uses the <code>date-time</code> format specified in <a href="https://tools.ietf.org/html/rfc3339#section-5.6">RFC
     * 3339 section 5.6, Internet Date/Time Format</a>. The value cannot contain spaces, and date and time should be
     * separated by <code>T</code>. For example, <code>2020-03-22T13:22:13.933Z</code>.
     * </p>
     * 
     * @param lastObservedAt
     *        Indicates when the security findings provider most recently observed the potential security issue that a
     *        finding captured.</p>
     *        <p>
     *        Uses the <code>date-time</code> format specified in <a
     *        href="https://tools.ietf.org/html/rfc3339#section-5.6">RFC 3339 section 5.6, Internet Date/Time
     *        Format</a>. The value cannot contain spaces, and date and time should be separated by <code>T</code>. For
     *        example, <code>2020-03-22T13:22:13.933Z</code>.
     */

    public void setLastObservedAt(String lastObservedAt) {
        this.lastObservedAt = lastObservedAt;
    }

    /**
     * <p>
     * Indicates when the security findings provider most recently observed the potential security issue that a finding
     * captured.
     * </p>
     * <p>
     * Uses the <code>date-time</code> format specified in <a href="https://tools.ietf.org/html/rfc3339#section-5.6">RFC
     * 3339 section 5.6, Internet Date/Time Format</a>. The value cannot contain spaces, and date and time should be
     * separated by <code>T</code>. For example, <code>2020-03-22T13:22:13.933Z</code>.
     * </p>
     * 
     * @return Indicates when the security findings provider most recently observed the potential security issue that a
     *         finding captured.</p>
     *         <p>
     *         Uses the <code>date-time</code> format specified in <a
     *         href="https://tools.ietf.org/html/rfc3339#section-5.6">RFC 3339 section 5.6, Internet Date/Time
     *         Format</a>. The value cannot contain spaces, and date and time should be separated by <code>T</code>. For
     *         example, <code>2020-03-22T13:22:13.933Z</code>.
     */

    public String getLastObservedAt() {
        return this.lastObservedAt;
    }

    /**
     * <p>
     * Indicates when the security findings provider most recently observed the potential security issue that a finding
     * captured.
     * </p>
     * <p>
     * Uses the <code>date-time</code> format specified in <a href="https://tools.ietf.org/html/rfc3339#section-5.6">RFC
     * 3339 section 5.6, Internet Date/Time Format</a>. The value cannot contain spaces, and date and time should be
     * separated by <code>T</code>. For example, <code>2020-03-22T13:22:13.933Z</code>.
     * </p>
     * 
     * @param lastObservedAt
     *        Indicates when the security findings provider most recently observed the potential security issue that a
     *        finding captured.</p>
     *        <p>
     *        Uses the <code>date-time</code> format specified in <a
     *        href="https://tools.ietf.org/html/rfc3339#section-5.6">RFC 3339 section 5.6, Internet Date/Time
     *        Format</a>. The value cannot contain spaces, and date and time should be separated by <code>T</code>. For
     *        example, <code>2020-03-22T13:22:13.933Z</code>.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public AwsSecurityFinding withLastObservedAt(String lastObservedAt) {
        setLastObservedAt(lastObservedAt);
        return this;
    }

    /**
     * <p>
     * Indicates when the security findings provider created the potential security issue that a finding captured.
     * </p>
     * <p>
     * Uses the <code>date-time</code> format specified in <a href="https://tools.ietf.org/html/rfc3339#section-5.6">RFC
     * 3339 section 5.6, Internet Date/Time Format</a>. The value cannot contain spaces, and date and time should be
     * separated by <code>T</code>. For example, <code>2020-03-22T13:22:13.933Z</code>.
     * </p>
     * 
     * @param createdAt
     *        Indicates when the security findings provider created the potential security issue that a finding
     *        captured.</p>
     *        <p>
     *        Uses the <code>date-time</code> format specified in <a
     *        href="https://tools.ietf.org/html/rfc3339#section-5.6">RFC 3339 section 5.6, Internet Date/Time
     *        Format</a>. The value cannot contain spaces, and date and time should be separated by <code>T</code>. For
     *        example, <code>2020-03-22T13:22:13.933Z</code>.
     */

    public void setCreatedAt(String createdAt) {
        this.createdAt = createdAt;
    }

    /**
     * <p>
     * Indicates when the security findings provider created the potential security issue that a finding captured.
     * </p>
     * <p>
     * Uses the <code>date-time</code> format specified in <a href="https://tools.ietf.org/html/rfc3339#section-5.6">RFC
     * 3339 section 5.6, Internet Date/Time Format</a>. The value cannot contain spaces, and date and time should be
     * separated by <code>T</code>. For example, <code>2020-03-22T13:22:13.933Z</code>.
     * </p>
     * 
     * @return Indicates when the security findings provider created the potential security issue that a finding
     *         captured.</p>
     *         <p>
     *         Uses the <code>date-time</code> format specified in <a
     *         href="https://tools.ietf.org/html/rfc3339#section-5.6">RFC 3339 section 5.6, Internet Date/Time
     *         Format</a>. The value cannot contain spaces, and date and time should be separated by <code>T</code>. For
     *         example, <code>2020-03-22T13:22:13.933Z</code>.
     */

    public String getCreatedAt() {
        return this.createdAt;
    }

    /**
     * <p>
     * Indicates when the security findings provider created the potential security issue that a finding captured.
     * </p>
     * <p>
     * Uses the <code>date-time</code> format specified in <a href="https://tools.ietf.org/html/rfc3339#section-5.6">RFC
     * 3339 section 5.6, Internet Date/Time Format</a>. The value cannot contain spaces, and date and time should be
     * separated by <code>T</code>. For example, <code>2020-03-22T13:22:13.933Z</code>.
     * </p>
     * 
     * @param createdAt
     *        Indicates when the security findings provider created the potential security issue that a finding
     *        captured.</p>
     *        <p>
     *        Uses the <code>date-time</code> format specified in <a
     *        href="https://tools.ietf.org/html/rfc3339#section-5.6">RFC 3339 section 5.6, Internet Date/Time
     *        Format</a>. The value cannot contain spaces, and date and time should be separated by <code>T</code>. For
     *        example, <code>2020-03-22T13:22:13.933Z</code>.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public AwsSecurityFinding withCreatedAt(String createdAt) {
        setCreatedAt(createdAt);
        return this;
    }

    /**
     * <p>
     * Indicates when the security findings provider last updated the finding record.
     * </p>
     * <p>
     * Uses the <code>date-time</code> format specified in <a href="https://tools.ietf.org/html/rfc3339#section-5.6">RFC
     * 3339 section 5.6, Internet Date/Time Format</a>. The value cannot contain spaces, and date and time should be
     * separated by <code>T</code>. For example, <code>2020-03-22T13:22:13.933Z</code>.
     * </p>
     * 
     * @param updatedAt
     *        Indicates when the security findings provider last updated the finding record.</p>
     *        <p>
     *        Uses the <code>date-time</code> format specified in <a
     *        href="https://tools.ietf.org/html/rfc3339#section-5.6">RFC 3339 section 5.6, Internet Date/Time
     *        Format</a>. The value cannot contain spaces, and date and time should be separated by <code>T</code>. For
     *        example, <code>2020-03-22T13:22:13.933Z</code>.
     */

    public void setUpdatedAt(String updatedAt) {
        this.updatedAt = updatedAt;
    }

    /**
     * <p>
     * Indicates when the security findings provider last updated the finding record.
     * </p>
     * <p>
     * Uses the <code>date-time</code> format specified in <a href="https://tools.ietf.org/html/rfc3339#section-5.6">RFC
     * 3339 section 5.6, Internet Date/Time Format</a>. The value cannot contain spaces, and date and time should be
     * separated by <code>T</code>. For example, <code>2020-03-22T13:22:13.933Z</code>.
     * </p>
     * 
     * @return Indicates when the security findings provider last updated the finding record.</p>
     *         <p>
     *         Uses the <code>date-time</code> format specified in <a
     *         href="https://tools.ietf.org/html/rfc3339#section-5.6">RFC 3339 section 5.6, Internet Date/Time
     *         Format</a>. The value cannot contain spaces, and date and time should be separated by <code>T</code>. For
     *         example, <code>2020-03-22T13:22:13.933Z</code>.
     */

    public String getUpdatedAt() {
        return this.updatedAt;
    }

    /**
     * <p>
     * Indicates when the security findings provider last updated the finding record.
     * </p>
     * <p>
     * Uses the <code>date-time</code> format specified in <a href="https://tools.ietf.org/html/rfc3339#section-5.6">RFC
     * 3339 section 5.6, Internet Date/Time Format</a>. The value cannot contain spaces, and date and time should be
     * separated by <code>T</code>. For example, <code>2020-03-22T13:22:13.933Z</code>.
     * </p>
     * 
     * @param updatedAt
     *        Indicates when the security findings provider last updated the finding record.</p>
     *        <p>
     *        Uses the <code>date-time</code> format specified in <a
     *        href="https://tools.ietf.org/html/rfc3339#section-5.6">RFC 3339 section 5.6, Internet Date/Time
     *        Format</a>. The value cannot contain spaces, and date and time should be separated by <code>T</code>. For
     *        example, <code>2020-03-22T13:22:13.933Z</code>.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public AwsSecurityFinding withUpdatedAt(String updatedAt) {
        setUpdatedAt(updatedAt);
        return this;
    }

    /**
     * <p>
     * A finding's severity.
     * </p>
     * 
     * @param severity
     *        A finding's severity.
     */

    public void setSeverity(Severity severity) {
        this.severity = severity;
    }

    /**
     * <p>
     * A finding's severity.
     * </p>
     * 
     * @return A finding's severity.
     */

    public Severity getSeverity() {
        return this.severity;
    }

    /**
     * <p>
     * A finding's severity.
     * </p>
     * 
     * @param severity
     *        A finding's severity.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public AwsSecurityFinding withSeverity(Severity severity) {
        setSeverity(severity);
        return this;
    }

    /**
     * <p>
     * A finding's confidence. Confidence is defined as the likelihood that a finding accurately identifies the behavior
     * or issue that it was intended to identify.
     * </p>
     * <p>
     * Confidence is scored on a 0-100 basis using a ratio scale, where 0 means zero percent confidence and 100 means
     * 100 percent confidence.
     * </p>
     * 
     * @param confidence
     *        A finding's confidence. Confidence is defined as the likelihood that a finding accurately identifies the
     *        behavior or issue that it was intended to identify.</p>
     *        <p>
     *        Confidence is scored on a 0-100 basis using a ratio scale, where 0 means zero percent confidence and 100
     *        means 100 percent confidence.
     */

    public void setConfidence(Integer confidence) {
        this.confidence = confidence;
    }

    /**
     * <p>
     * A finding's confidence. Confidence is defined as the likelihood that a finding accurately identifies the behavior
     * or issue that it was intended to identify.
     * </p>
     * <p>
     * Confidence is scored on a 0-100 basis using a ratio scale, where 0 means zero percent confidence and 100 means
     * 100 percent confidence.
     * </p>
     * 
     * @return A finding's confidence. Confidence is defined as the likelihood that a finding accurately identifies the
     *         behavior or issue that it was intended to identify.</p>
     *         <p>
     *         Confidence is scored on a 0-100 basis using a ratio scale, where 0 means zero percent confidence and 100
     *         means 100 percent confidence.
     */

    public Integer getConfidence() {
        return this.confidence;
    }

    /**
     * <p>
     * A finding's confidence. Confidence is defined as the likelihood that a finding accurately identifies the behavior
     * or issue that it was intended to identify.
     * </p>
     * <p>
     * Confidence is scored on a 0-100 basis using a ratio scale, where 0 means zero percent confidence and 100 means
     * 100 percent confidence.
     * </p>
     * 
     * @param confidence
     *        A finding's confidence. Confidence is defined as the likelihood that a finding accurately identifies the
     *        behavior or issue that it was intended to identify.</p>
     *        <p>
     *        Confidence is scored on a 0-100 basis using a ratio scale, where 0 means zero percent confidence and 100
     *        means 100 percent confidence.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public AwsSecurityFinding withConfidence(Integer confidence) {
        setConfidence(confidence);
        return this;
    }

    /**
     * <p>
     * The level of importance assigned to the resources associated with the finding.
     * </p>
     * <p>
     * A score of 0 means that the underlying resources have no criticality, and a score of 100 is reserved for the most
     * critical resources.
     * </p>
     * 
     * @param criticality
     *        The level of importance assigned to the resources associated with the finding.</p>
     *        <p>
     *        A score of 0 means that the underlying resources have no criticality, and a score of 100 is reserved for
     *        the most critical resources.
     */

    public void setCriticality(Integer criticality) {
        this.criticality = criticality;
    }

    /**
     * <p>
     * The level of importance assigned to the resources associated with the finding.
     * </p>
     * <p>
     * A score of 0 means that the underlying resources have no criticality, and a score of 100 is reserved for the most
     * critical resources.
     * </p>
     * 
     * @return The level of importance assigned to the resources associated with the finding.</p>
     *         <p>
     *         A score of 0 means that the underlying resources have no criticality, and a score of 100 is reserved for
     *         the most critical resources.
     */

    public Integer getCriticality() {
        return this.criticality;
    }

    /**
     * <p>
     * The level of importance assigned to the resources associated with the finding.
     * </p>
     * <p>
     * A score of 0 means that the underlying resources have no criticality, and a score of 100 is reserved for the most
     * critical resources.
     * </p>
     * 
     * @param criticality
     *        The level of importance assigned to the resources associated with the finding.</p>
     *        <p>
     *        A score of 0 means that the underlying resources have no criticality, and a score of 100 is reserved for
     *        the most critical resources.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public AwsSecurityFinding withCriticality(Integer criticality) {
        setCriticality(criticality);
        return this;
    }

    /**
     * <p>
     * A finding's title.
     * </p>
     * <note>
     * <p>
     * In this release, <code>Title</code> is a required property.
     * </p>
     * </note>
     * 
     * @param title
     *        A finding's title.</p> <note>
     *        <p>
     *        In this release, <code>Title</code> is a required property.
     *        </p>
     */

    public void setTitle(String title) {
        this.title = title;
    }

    /**
     * <p>
     * A finding's title.
     * </p>
     * <note>
     * <p>
     * In this release, <code>Title</code> is a required property.
     * </p>
     * </note>
     * 
     * @return A finding's title.</p> <note>
     *         <p>
     *         In this release, <code>Title</code> is a required property.
     *         </p>
     */

    public String getTitle() {
        return this.title;
    }

    /**
     * <p>
     * A finding's title.
     * </p>
     * <note>
     * <p>
     * In this release, <code>Title</code> is a required property.
     * </p>
     * </note>
     * 
     * @param title
     *        A finding's title.</p> <note>
     *        <p>
     *        In this release, <code>Title</code> is a required property.
     *        </p>
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public AwsSecurityFinding withTitle(String title) {
        setTitle(title);
        return this;
    }

    /**
     * <p>
     * A finding's description.
     * </p>
     * <note>
     * <p>
     * In this release, <code>Description</code> is a required property.
     * </p>
     * </note>
     * 
     * @param description
     *        A finding's description.</p> <note>
     *        <p>
     *        In this release, <code>Description</code> is a required property.
     *        </p>
     */

    public void setDescription(String description) {
        this.description = description;
    }

    /**
     * <p>
     * A finding's description.
     * </p>
     * <note>
     * <p>
     * In this release, <code>Description</code> is a required property.
     * </p>
     * </note>
     * 
     * @return A finding's description.</p> <note>
     *         <p>
     *         In this release, <code>Description</code> is a required property.
     *         </p>
     */

    public String getDescription() {
        return this.description;
    }

    /**
     * <p>
     * A finding's description.
     * </p>
     * <note>
     * <p>
     * In this release, <code>Description</code> is a required property.
     * </p>
     * </note>
     * 
     * @param description
     *        A finding's description.</p> <note>
     *        <p>
     *        In this release, <code>Description</code> is a required property.
     *        </p>
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public AwsSecurityFinding withDescription(String description) {
        setDescription(description);
        return this;
    }

    /**
     * <p>
     * A data type that describes the remediation options for a finding.
     * </p>
     * 
     * @param remediation
     *        A data type that describes the remediation options for a finding.
     */

    public void setRemediation(Remediation remediation) {
        this.remediation = remediation;
    }

    /**
     * <p>
     * A data type that describes the remediation options for a finding.
     * </p>
     * 
     * @return A data type that describes the remediation options for a finding.
     */

    public Remediation getRemediation() {
        return this.remediation;
    }

    /**
     * <p>
     * A data type that describes the remediation options for a finding.
     * </p>
     * 
     * @param remediation
     *        A data type that describes the remediation options for a finding.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public AwsSecurityFinding withRemediation(Remediation remediation) {
        setRemediation(remediation);
        return this;
    }

    /**
     * <p>
     * A URL that links to a page about the current finding in the security findings provider's solution.
     * </p>
     * 
     * @param sourceUrl
     *        A URL that links to a page about the current finding in the security findings provider's solution.
     */

    public void setSourceUrl(String sourceUrl) {
        this.sourceUrl = sourceUrl;
    }

    /**
     * <p>
     * A URL that links to a page about the current finding in the security findings provider's solution.
     * </p>
     * 
     * @return A URL that links to a page about the current finding in the security findings provider's solution.
     */

    public String getSourceUrl() {
        return this.sourceUrl;
    }

    /**
     * <p>
     * A URL that links to a page about the current finding in the security findings provider's solution.
     * </p>
     * 
     * @param sourceUrl
     *        A URL that links to a page about the current finding in the security findings provider's solution.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public AwsSecurityFinding withSourceUrl(String sourceUrl) {
        setSourceUrl(sourceUrl);
        return this;
    }

    /**
     * <p>
     * A data type where security findings providers can include additional solution-specific details that aren't part
     * of the defined <code>AwsSecurityFinding</code> format.
     * </p>
     * <p>
     * Can contain up to 50 key-value pairs. For each key-value pair, the key can contain up to 128 characters, and the
     * value can contain up to 2048 characters.
     * </p>
     * 
     * @return A data type where security findings providers can include additional solution-specific details that
     *         aren't part of the defined <code>AwsSecurityFinding</code> format.</p>
     *         <p>
     *         Can contain up to 50 key-value pairs. For each key-value pair, the key can contain up to 128 characters,
     *         and the value can contain up to 2048 characters.
     */

    public java.util.Map<String, String> getProductFields() {
        return productFields;
    }

    /**
     * <p>
     * A data type where security findings providers can include additional solution-specific details that aren't part
     * of the defined <code>AwsSecurityFinding</code> format.
     * </p>
     * <p>
     * Can contain up to 50 key-value pairs. For each key-value pair, the key can contain up to 128 characters, and the
     * value can contain up to 2048 characters.
     * </p>
     * 
     * @param productFields
     *        A data type where security findings providers can include additional solution-specific details that aren't
     *        part of the defined <code>AwsSecurityFinding</code> format.</p>
     *        <p>
     *        Can contain up to 50 key-value pairs. For each key-value pair, the key can contain up to 128 characters,
     *        and the value can contain up to 2048 characters.
     */

    public void setProductFields(java.util.Map<String, String> productFields) {
        this.productFields = productFields;
    }

    /**
     * <p>
     * A data type where security findings providers can include additional solution-specific details that aren't part
     * of the defined <code>AwsSecurityFinding</code> format.
     * </p>
     * <p>
     * Can contain up to 50 key-value pairs. For each key-value pair, the key can contain up to 128 characters, and the
     * value can contain up to 2048 characters.
     * </p>
     * 
     * @param productFields
     *        A data type where security findings providers can include additional solution-specific details that aren't
     *        part of the defined <code>AwsSecurityFinding</code> format.</p>
     *        <p>
     *        Can contain up to 50 key-value pairs. For each key-value pair, the key can contain up to 128 characters,
     *        and the value can contain up to 2048 characters.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public AwsSecurityFinding withProductFields(java.util.Map<String, String> productFields) {
        setProductFields(productFields);
        return this;
    }

    /**
     * Add a single ProductFields entry
     *
     * @see AwsSecurityFinding#withProductFields
     * @returns a reference to this object so that method calls can be chained together.
     */

    public AwsSecurityFinding addProductFieldsEntry(String key, String value) {
        if (null == this.productFields) {
            this.productFields = new java.util.HashMap<String, String>();
        }
        if (this.productFields.containsKey(key))
            throw new IllegalArgumentException("Duplicated keys (" + key.toString() + ") are provided.");
        this.productFields.put(key, value);
        return this;
    }

    /**
     * Removes all the entries added into ProductFields.
     *
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public AwsSecurityFinding clearProductFieldsEntries() {
        this.productFields = null;
        return this;
    }

    /**
     * <p>
     * A list of name/value string pairs associated with the finding. These are custom, user-defined fields added to a
     * finding.
     * </p>
     * 
     * @return A list of name/value string pairs associated with the finding. These are custom, user-defined fields
     *         added to a finding.
     */

    public java.util.Map<String, String> getUserDefinedFields() {
        return userDefinedFields;
    }

    /**
     * <p>
     * A list of name/value string pairs associated with the finding. These are custom, user-defined fields added to a
     * finding.
     * </p>
     * 
     * @param userDefinedFields
     *        A list of name/value string pairs associated with the finding. These are custom, user-defined fields added
     *        to a finding.
     */

    public void setUserDefinedFields(java.util.Map<String, String> userDefinedFields) {
        this.userDefinedFields = userDefinedFields;
    }

    /**
     * <p>
     * A list of name/value string pairs associated with the finding. These are custom, user-defined fields added to a
     * finding.
     * </p>
     * 
     * @param userDefinedFields
     *        A list of name/value string pairs associated with the finding. These are custom, user-defined fields added
     *        to a finding.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public AwsSecurityFinding withUserDefinedFields(java.util.Map<String, String> userDefinedFields) {
        setUserDefinedFields(userDefinedFields);
        return this;
    }

    /**
     * Add a single UserDefinedFields entry
     *
     * @see AwsSecurityFinding#withUserDefinedFields
     * @returns a reference to this object so that method calls can be chained together.
     */

    public AwsSecurityFinding addUserDefinedFieldsEntry(String key, String value) {
        if (null == this.userDefinedFields) {
            this.userDefinedFields = new java.util.HashMap<String, String>();
        }
        if (this.userDefinedFields.containsKey(key))
            throw new IllegalArgumentException("Duplicated keys (" + key.toString() + ") are provided.");
        this.userDefinedFields.put(key, value);
        return this;
    }

    /**
     * Removes all the entries added into UserDefinedFields.
     *
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public AwsSecurityFinding clearUserDefinedFieldsEntries() {
        this.userDefinedFields = null;
        return this;
    }

    /**
     * <p>
     * A list of malware related to a finding.
     * </p>
     * 
     * @return A list of malware related to a finding.
     */

    public java.util.List<Malware> getMalware() {
        return malware;
    }

    /**
     * <p>
     * A list of malware related to a finding.
     * </p>
     * 
     * @param malware
     *        A list of malware related to a finding.
     */

    public void setMalware(java.util.Collection<Malware> malware) {
        if (malware == null) {
            this.malware = null;
            return;
        }

        this.malware = new java.util.ArrayList<Malware>(malware);
    }

    /**
     * <p>
     * A list of malware related to a finding.
     * </p>
     * <p>
     * <b>NOTE:</b> This method appends the values to the existing list (if any). Use
     * {@link #setMalware(java.util.Collection)} or {@link #withMalware(java.util.Collection)} if you want to override
     * the existing values.
     * </p>
     * 
     * @param malware
     *        A list of malware related to a finding.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public AwsSecurityFinding withMalware(Malware... malware) {
        if (this.malware == null) {
            setMalware(new java.util.ArrayList<Malware>(malware.length));
        }
        for (Malware ele : malware) {
            this.malware.add(ele);
        }
        return this;
    }

    /**
     * <p>
     * A list of malware related to a finding.
     * </p>
     * 
     * @param malware
     *        A list of malware related to a finding.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public AwsSecurityFinding withMalware(java.util.Collection<Malware> malware) {
        setMalware(malware);
        return this;
    }

    /**
     * <p>
     * The details of network-related information about a finding.
     * </p>
     * 
     * @param network
     *        The details of network-related information about a finding.
     */

    public void setNetwork(Network network) {
        this.network = network;
    }

    /**
     * <p>
     * The details of network-related information about a finding.
     * </p>
     * 
     * @return The details of network-related information about a finding.
     */

    public Network getNetwork() {
        return this.network;
    }

    /**
     * <p>
     * The details of network-related information about a finding.
     * </p>
     * 
     * @param network
     *        The details of network-related information about a finding.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public AwsSecurityFinding withNetwork(Network network) {
        setNetwork(network);
        return this;
    }

    /**
     * <p>
     * Provides information about a network path that is relevant to a finding. Each entry under
     * <code>NetworkPath</code> represents a component of that path.
     * </p>
     * 
     * @return Provides information about a network path that is relevant to a finding. Each entry under
     *         <code>NetworkPath</code> represents a component of that path.
     */

    public java.util.List<NetworkPathComponent> getNetworkPath() {
        return networkPath;
    }

    /**
     * <p>
     * Provides information about a network path that is relevant to a finding. Each entry under
     * <code>NetworkPath</code> represents a component of that path.
     * </p>
     * 
     * @param networkPath
     *        Provides information about a network path that is relevant to a finding. Each entry under
     *        <code>NetworkPath</code> represents a component of that path.
     */

    public void setNetworkPath(java.util.Collection<NetworkPathComponent> networkPath) {
        if (networkPath == null) {
            this.networkPath = null;
            return;
        }

        this.networkPath = new java.util.ArrayList<NetworkPathComponent>(networkPath);
    }

    /**
     * <p>
     * Provides information about a network path that is relevant to a finding. Each entry under
     * <code>NetworkPath</code> represents a component of that path.
     * </p>
     * <p>
     * <b>NOTE:</b> This method appends the values to the existing list (if any). Use
     * {@link #setNetworkPath(java.util.Collection)} or {@link #withNetworkPath(java.util.Collection)} if you want to
     * override the existing values.
     * </p>
     * 
     * @param networkPath
     *        Provides information about a network path that is relevant to a finding. Each entry under
     *        <code>NetworkPath</code> represents a component of that path.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public AwsSecurityFinding withNetworkPath(NetworkPathComponent... networkPath) {
        if (this.networkPath == null) {
            setNetworkPath(new java.util.ArrayList<NetworkPathComponent>(networkPath.length));
        }
        for (NetworkPathComponent ele : networkPath) {
            this.networkPath.add(ele);
        }
        return this;
    }

    /**
     * <p>
     * Provides information about a network path that is relevant to a finding. Each entry under
     * <code>NetworkPath</code> represents a component of that path.
     * </p>
     * 
     * @param networkPath
     *        Provides information about a network path that is relevant to a finding. Each entry under
     *        <code>NetworkPath</code> represents a component of that path.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public AwsSecurityFinding withNetworkPath(java.util.Collection<NetworkPathComponent> networkPath) {
        setNetworkPath(networkPath);
        return this;
    }

    /**
     * <p>
     * The details of process-related information about a finding.
     * </p>
     * 
     * @param process
     *        The details of process-related information about a finding.
     */

    public void setProcess(ProcessDetails process) {
        this.process = process;
    }

    /**
     * <p>
     * The details of process-related information about a finding.
     * </p>
     * 
     * @return The details of process-related information about a finding.
     */

    public ProcessDetails getProcess() {
        return this.process;
    }

    /**
     * <p>
     * The details of process-related information about a finding.
     * </p>
     * 
     * @param process
     *        The details of process-related information about a finding.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public AwsSecurityFinding withProcess(ProcessDetails process) {
        setProcess(process);
        return this;
    }

    /**
     * <p>
     * Details about the threat detected in a security finding and the file paths that were affected by the threat.
     * </p>
     * 
     * @return Details about the threat detected in a security finding and the file paths that were affected by the
     *         threat.
     */

    public java.util.List<Threat> getThreats() {
        return threats;
    }

    /**
     * <p>
     * Details about the threat detected in a security finding and the file paths that were affected by the threat.
     * </p>
     * 
     * @param threats
     *        Details about the threat detected in a security finding and the file paths that were affected by the
     *        threat.
     */

    public void setThreats(java.util.Collection<Threat> threats) {
        if (threats == null) {
            this.threats = null;
            return;
        }

        this.threats = new java.util.ArrayList<Threat>(threats);
    }

    /**
     * <p>
     * Details about the threat detected in a security finding and the file paths that were affected by the threat.
     * </p>
     * <p>
     * <b>NOTE:</b> This method appends the values to the existing list (if any). Use
     * {@link #setThreats(java.util.Collection)} or {@link #withThreats(java.util.Collection)} if you want to override
     * the existing values.
     * </p>
     * 
     * @param threats
     *        Details about the threat detected in a security finding and the file paths that were affected by the
     *        threat.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public AwsSecurityFinding withThreats(Threat... threats) {
        if (this.threats == null) {
            setThreats(new java.util.ArrayList<Threat>(threats.length));
        }
        for (Threat ele : threats) {
            this.threats.add(ele);
        }
        return this;
    }

    /**
     * <p>
     * Details about the threat detected in a security finding and the file paths that were affected by the threat.
     * </p>
     * 
     * @param threats
     *        Details about the threat detected in a security finding and the file paths that were affected by the
     *        threat.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public AwsSecurityFinding withThreats(java.util.Collection<Threat> threats) {
        setThreats(threats);
        return this;
    }

    /**
     * <p>
     * Threat intelligence details related to a finding.
     * </p>
     * 
     * @return Threat intelligence details related to a finding.
     */

    public java.util.List<ThreatIntelIndicator> getThreatIntelIndicators() {
        return threatIntelIndicators;
    }

    /**
     * <p>
     * Threat intelligence details related to a finding.
     * </p>
     * 
     * @param threatIntelIndicators
     *        Threat intelligence details related to a finding.
     */

    public void setThreatIntelIndicators(java.util.Collection<ThreatIntelIndicator> threatIntelIndicators) {
        if (threatIntelIndicators == null) {
            this.threatIntelIndicators = null;
            return;
        }

        this.threatIntelIndicators = new java.util.ArrayList<ThreatIntelIndicator>(threatIntelIndicators);
    }

    /**
     * <p>
     * Threat intelligence details related to a finding.
     * </p>
     * <p>
     * <b>NOTE:</b> This method appends the values to the existing list (if any). Use
     * {@link #setThreatIntelIndicators(java.util.Collection)} or
     * {@link #withThreatIntelIndicators(java.util.Collection)} if you want to override the existing values.
     * </p>
     * 
     * @param threatIntelIndicators
     *        Threat intelligence details related to a finding.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public AwsSecurityFinding withThreatIntelIndicators(ThreatIntelIndicator... threatIntelIndicators) {
        if (this.threatIntelIndicators == null) {
            setThreatIntelIndicators(new java.util.ArrayList<ThreatIntelIndicator>(threatIntelIndicators.length));
        }
        for (ThreatIntelIndicator ele : threatIntelIndicators) {
            this.threatIntelIndicators.add(ele);
        }
        return this;
    }

    /**
     * <p>
     * Threat intelligence details related to a finding.
     * </p>
     * 
     * @param threatIntelIndicators
     *        Threat intelligence details related to a finding.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public AwsSecurityFinding withThreatIntelIndicators(java.util.Collection<ThreatIntelIndicator> threatIntelIndicators) {
        setThreatIntelIndicators(threatIntelIndicators);
        return this;
    }

    /**
     * <p>
     * A set of resource data types that describe the resources that the finding refers to.
     * </p>
     * 
     * @return A set of resource data types that describe the resources that the finding refers to.
     */

    public java.util.List<Resource> getResources() {
        return resources;
    }

    /**
     * <p>
     * A set of resource data types that describe the resources that the finding refers to.
     * </p>
     * 
     * @param resources
     *        A set of resource data types that describe the resources that the finding refers to.
     */

    public void setResources(java.util.Collection<Resource> resources) {
        if (resources == null) {
            this.resources = null;
            return;
        }

        this.resources = new java.util.ArrayList<Resource>(resources);
    }

    /**
     * <p>
     * A set of resource data types that describe the resources that the finding refers to.
     * </p>
     * <p>
     * <b>NOTE:</b> This method appends the values to the existing list (if any). Use
     * {@link #setResources(java.util.Collection)} or {@link #withResources(java.util.Collection)} if you want to
     * override the existing values.
     * </p>
     * 
     * @param resources
     *        A set of resource data types that describe the resources that the finding refers to.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public AwsSecurityFinding withResources(Resource... resources) {
        if (this.resources == null) {
            setResources(new java.util.ArrayList<Resource>(resources.length));
        }
        for (Resource ele : resources) {
            this.resources.add(ele);
        }
        return this;
    }

    /**
     * <p>
     * A set of resource data types that describe the resources that the finding refers to.
     * </p>
     * 
     * @param resources
     *        A set of resource data types that describe the resources that the finding refers to.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public AwsSecurityFinding withResources(java.util.Collection<Resource> resources) {
        setResources(resources);
        return this;
    }

    /**
     * <p>
     * This data type is exclusive to findings that are generated as the result of a check run against a specific rule
     * in a supported security standard, such as CIS Amazon Web Services Foundations. Contains security standard-related
     * finding details.
     * </p>
     * 
     * @param compliance
     *        This data type is exclusive to findings that are generated as the result of a check run against a specific
     *        rule in a supported security standard, such as CIS Amazon Web Services Foundations. Contains security
     *        standard-related finding details.
     */

    public void setCompliance(Compliance compliance) {
        this.compliance = compliance;
    }

    /**
     * <p>
     * This data type is exclusive to findings that are generated as the result of a check run against a specific rule
     * in a supported security standard, such as CIS Amazon Web Services Foundations. Contains security standard-related
     * finding details.
     * </p>
     * 
     * @return This data type is exclusive to findings that are generated as the result of a check run against a
     *         specific rule in a supported security standard, such as CIS Amazon Web Services Foundations. Contains
     *         security standard-related finding details.
     */

    public Compliance getCompliance() {
        return this.compliance;
    }

    /**
     * <p>
     * This data type is exclusive to findings that are generated as the result of a check run against a specific rule
     * in a supported security standard, such as CIS Amazon Web Services Foundations. Contains security standard-related
     * finding details.
     * </p>
     * 
     * @param compliance
     *        This data type is exclusive to findings that are generated as the result of a check run against a specific
     *        rule in a supported security standard, such as CIS Amazon Web Services Foundations. Contains security
     *        standard-related finding details.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public AwsSecurityFinding withCompliance(Compliance compliance) {
        setCompliance(compliance);
        return this;
    }

    /**
     * <p>
     * Indicates the veracity of a finding.
     * </p>
     * 
     * @param verificationState
     *        Indicates the veracity of a finding.
     * @see VerificationState
     */

    public void setVerificationState(String verificationState) {
        this.verificationState = verificationState;
    }

    /**
     * <p>
     * Indicates the veracity of a finding.
     * </p>
     * 
     * @return Indicates the veracity of a finding.
     * @see VerificationState
     */

    public String getVerificationState() {
        return this.verificationState;
    }

    /**
     * <p>
     * Indicates the veracity of a finding.
     * </p>
     * 
     * @param verificationState
     *        Indicates the veracity of a finding.
     * @return Returns a reference to this object so that method calls can be chained together.
     * @see VerificationState
     */

    public AwsSecurityFinding withVerificationState(String verificationState) {
        setVerificationState(verificationState);
        return this;
    }

    /**
     * <p>
     * Indicates the veracity of a finding.
     * </p>
     * 
     * @param verificationState
     *        Indicates the veracity of a finding.
     * @return Returns a reference to this object so that method calls can be chained together.
     * @see VerificationState
     */

    public AwsSecurityFinding withVerificationState(VerificationState verificationState) {
        this.verificationState = verificationState.toString();
        return this;
    }

    /**
     * <p>
     * The workflow state of a finding.
     * </p>
     * 
     * @param workflowState
     *        The workflow state of a finding.
     * @see WorkflowState
     */
    @Deprecated
    public void setWorkflowState(String workflowState) {
        this.workflowState = workflowState;
    }

    /**
     * <p>
     * The workflow state of a finding.
     * </p>
     * 
     * @return The workflow state of a finding.
     * @see WorkflowState
     */
    @Deprecated
    public String getWorkflowState() {
        return this.workflowState;
    }

    /**
     * <p>
     * The workflow state of a finding.
     * </p>
     * 
     * @param workflowState
     *        The workflow state of a finding.
     * @return Returns a reference to this object so that method calls can be chained together.
     * @see WorkflowState
     */
    @Deprecated
    public AwsSecurityFinding withWorkflowState(String workflowState) {
        setWorkflowState(workflowState);
        return this;
    }

    /**
     * <p>
     * The workflow state of a finding.
     * </p>
     * 
     * @param workflowState
     *        The workflow state of a finding.
     * @return Returns a reference to this object so that method calls can be chained together.
     * @see WorkflowState
     */
    @Deprecated
    public AwsSecurityFinding withWorkflowState(WorkflowState workflowState) {
        this.workflowState = workflowState.toString();
        return this;
    }

    /**
     * <p>
     * Provides information about the status of the investigation into a finding.
     * </p>
     * 
     * @param workflow
     *        Provides information about the status of the investigation into a finding.
     */

    public void setWorkflow(Workflow workflow) {
        this.workflow = workflow;
    }

    /**
     * <p>
     * Provides information about the status of the investigation into a finding.
     * </p>
     * 
     * @return Provides information about the status of the investigation into a finding.
     */

    public Workflow getWorkflow() {
        return this.workflow;
    }

    /**
     * <p>
     * Provides information about the status of the investigation into a finding.
     * </p>
     * 
     * @param workflow
     *        Provides information about the status of the investigation into a finding.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public AwsSecurityFinding withWorkflow(Workflow workflow) {
        setWorkflow(workflow);
        return this;
    }

    /**
     * <p>
     * The record state of a finding.
     * </p>
     * 
     * @param recordState
     *        The record state of a finding.
     * @see RecordState
     */

    public void setRecordState(String recordState) {
        this.recordState = recordState;
    }

    /**
     * <p>
     * The record state of a finding.
     * </p>
     * 
     * @return The record state of a finding.
     * @see RecordState
     */

    public String getRecordState() {
        return this.recordState;
    }

    /**
     * <p>
     * The record state of a finding.
     * </p>
     * 
     * @param recordState
     *        The record state of a finding.
     * @return Returns a reference to this object so that method calls can be chained together.
     * @see RecordState
     */

    public AwsSecurityFinding withRecordState(String recordState) {
        setRecordState(recordState);
        return this;
    }

    /**
     * <p>
     * The record state of a finding.
     * </p>
     * 
     * @param recordState
     *        The record state of a finding.
     * @return Returns a reference to this object so that method calls can be chained together.
     * @see RecordState
     */

    public AwsSecurityFinding withRecordState(RecordState recordState) {
        this.recordState = recordState.toString();
        return this;
    }

    /**
     * <p>
     * A list of related findings.
     * </p>
     * 
     * @return A list of related findings.
     */

    public java.util.List<RelatedFinding> getRelatedFindings() {
        return relatedFindings;
    }

    /**
     * <p>
     * A list of related findings.
     * </p>
     * 
     * @param relatedFindings
     *        A list of related findings.
     */

    public void setRelatedFindings(java.util.Collection<RelatedFinding> relatedFindings) {
        if (relatedFindings == null) {
            this.relatedFindings = null;
            return;
        }

        this.relatedFindings = new java.util.ArrayList<RelatedFinding>(relatedFindings);
    }

    /**
     * <p>
     * A list of related findings.
     * </p>
     * <p>
     * <b>NOTE:</b> This method appends the values to the existing list (if any). Use
     * {@link #setRelatedFindings(java.util.Collection)} or {@link #withRelatedFindings(java.util.Collection)} if you
     * want to override the existing values.
     * </p>
     * 
     * @param relatedFindings
     *        A list of related findings.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public AwsSecurityFinding withRelatedFindings(RelatedFinding... relatedFindings) {
        if (this.relatedFindings == null) {
            setRelatedFindings(new java.util.ArrayList<RelatedFinding>(relatedFindings.length));
        }
        for (RelatedFinding ele : relatedFindings) {
            this.relatedFindings.add(ele);
        }
        return this;
    }

    /**
     * <p>
     * A list of related findings.
     * </p>
     * 
     * @param relatedFindings
     *        A list of related findings.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public AwsSecurityFinding withRelatedFindings(java.util.Collection<RelatedFinding> relatedFindings) {
        setRelatedFindings(relatedFindings);
        return this;
    }

    /**
     * <p>
     * A user-defined note added to a finding.
     * </p>
     * 
     * @param note
     *        A user-defined note added to a finding.
     */

    public void setNote(Note note) {
        this.note = note;
    }

    /**
     * <p>
     * A user-defined note added to a finding.
     * </p>
     * 
     * @return A user-defined note added to a finding.
     */

    public Note getNote() {
        return this.note;
    }

    /**
     * <p>
     * A user-defined note added to a finding.
     * </p>
     * 
     * @param note
     *        A user-defined note added to a finding.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public AwsSecurityFinding withNote(Note note) {
        setNote(note);
        return this;
    }

    /**
     * <p>
     * Provides a list of vulnerabilities associated with the findings.
     * </p>
     * 
     * @return Provides a list of vulnerabilities associated with the findings.
     */

    public java.util.List<Vulnerability> getVulnerabilities() {
        return vulnerabilities;
    }

    /**
     * <p>
     * Provides a list of vulnerabilities associated with the findings.
     * </p>
     * 
     * @param vulnerabilities
     *        Provides a list of vulnerabilities associated with the findings.
     */

    public void setVulnerabilities(java.util.Collection<Vulnerability> vulnerabilities) {
        if (vulnerabilities == null) {
            this.vulnerabilities = null;
            return;
        }

        this.vulnerabilities = new java.util.ArrayList<Vulnerability>(vulnerabilities);
    }

    /**
     * <p>
     * Provides a list of vulnerabilities associated with the findings.
     * </p>
     * <p>
     * <b>NOTE:</b> This method appends the values to the existing list (if any). Use
     * {@link #setVulnerabilities(java.util.Collection)} or {@link #withVulnerabilities(java.util.Collection)} if you
     * want to override the existing values.
     * </p>
     * 
     * @param vulnerabilities
     *        Provides a list of vulnerabilities associated with the findings.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public AwsSecurityFinding withVulnerabilities(Vulnerability... vulnerabilities) {
        if (this.vulnerabilities == null) {
            setVulnerabilities(new java.util.ArrayList<Vulnerability>(vulnerabilities.length));
        }
        for (Vulnerability ele : vulnerabilities) {
            this.vulnerabilities.add(ele);
        }
        return this;
    }

    /**
     * <p>
     * Provides a list of vulnerabilities associated with the findings.
     * </p>
     * 
     * @param vulnerabilities
     *        Provides a list of vulnerabilities associated with the findings.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public AwsSecurityFinding withVulnerabilities(java.util.Collection<Vulnerability> vulnerabilities) {
        setVulnerabilities(vulnerabilities);
        return this;
    }

    /**
     * <p>
     * Provides an overview of the patch compliance status for an instance against a selected compliance standard.
     * </p>
     * 
     * @param patchSummary
     *        Provides an overview of the patch compliance status for an instance against a selected compliance
     *        standard.
     */

    public void setPatchSummary(PatchSummary patchSummary) {
        this.patchSummary = patchSummary;
    }

    /**
     * <p>
     * Provides an overview of the patch compliance status for an instance against a selected compliance standard.
     * </p>
     * 
     * @return Provides an overview of the patch compliance status for an instance against a selected compliance
     *         standard.
     */

    public PatchSummary getPatchSummary() {
        return this.patchSummary;
    }

    /**
     * <p>
     * Provides an overview of the patch compliance status for an instance against a selected compliance standard.
     * </p>
     * 
     * @param patchSummary
     *        Provides an overview of the patch compliance status for an instance against a selected compliance
     *        standard.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public AwsSecurityFinding withPatchSummary(PatchSummary patchSummary) {
        setPatchSummary(patchSummary);
        return this;
    }

    /**
     * <p>
     * Provides details about an action that affects or that was taken on a resource.
     * </p>
     * 
     * @param action
     *        Provides details about an action that affects or that was taken on a resource.
     */

    public void setAction(Action action) {
        this.action = action;
    }

    /**
     * <p>
     * Provides details about an action that affects or that was taken on a resource.
     * </p>
     * 
     * @return Provides details about an action that affects or that was taken on a resource.
     */

    public Action getAction() {
        return this.action;
    }

    /**
     * <p>
     * Provides details about an action that affects or that was taken on a resource.
     * </p>
     * 
     * @param action
     *        Provides details about an action that affects or that was taken on a resource.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public AwsSecurityFinding withAction(Action action) {
        setAction(action);
        return this;
    }

    /**
     * <p>
     * In a <code>BatchImportFindings</code> request, finding providers use <code>FindingProviderFields</code> to
     * provide and update their own values for confidence, criticality, related findings, severity, and types.
     * </p>
     * 
     * @param findingProviderFields
     *        In a <code>BatchImportFindings</code> request, finding providers use <code>FindingProviderFields</code> to
     *        provide and update their own values for confidence, criticality, related findings, severity, and types.
     */

    public void setFindingProviderFields(FindingProviderFields findingProviderFields) {
        this.findingProviderFields = findingProviderFields;
    }

    /**
     * <p>
     * In a <code>BatchImportFindings</code> request, finding providers use <code>FindingProviderFields</code> to
     * provide and update their own values for confidence, criticality, related findings, severity, and types.
     * </p>
     * 
     * @return In a <code>BatchImportFindings</code> request, finding providers use <code>FindingProviderFields</code>
     *         to provide and update their own values for confidence, criticality, related findings, severity, and
     *         types.
     */

    public FindingProviderFields getFindingProviderFields() {
        return this.findingProviderFields;
    }

    /**
     * <p>
     * In a <code>BatchImportFindings</code> request, finding providers use <code>FindingProviderFields</code> to
     * provide and update their own values for confidence, criticality, related findings, severity, and types.
     * </p>
     * 
     * @param findingProviderFields
     *        In a <code>BatchImportFindings</code> request, finding providers use <code>FindingProviderFields</code> to
     *        provide and update their own values for confidence, criticality, related findings, severity, and types.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public AwsSecurityFinding withFindingProviderFields(FindingProviderFields findingProviderFields) {
        setFindingProviderFields(findingProviderFields);
        return this;
    }

    /**
     * <p>
     * Indicates whether the finding is a sample finding.
     * </p>
     * 
     * @param sample
     *        Indicates whether the finding is a sample finding.
     */

    public void setSample(Boolean sample) {
        this.sample = sample;
    }

    /**
     * <p>
     * Indicates whether the finding is a sample finding.
     * </p>
     * 
     * @return Indicates whether the finding is a sample finding.
     */

    public Boolean getSample() {
        return this.sample;
    }

    /**
     * <p>
     * Indicates whether the finding is a sample finding.
     * </p>
     * 
     * @param sample
     *        Indicates whether the finding is a sample finding.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public AwsSecurityFinding withSample(Boolean sample) {
        setSample(sample);
        return this;
    }

    /**
     * <p>
     * Indicates whether the finding is a sample finding.
     * </p>
     * 
     * @return Indicates whether the finding is a sample finding.
     */

    public Boolean isSample() {
        return this.sample;
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     *
     * @return A string representation of this object.
     *
     * @see java.lang.Object#toString()
     */
    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (getSchemaVersion() != null)
            sb.append("SchemaVersion: ").append(getSchemaVersion()).append(",");
        if (getId() != null)
            sb.append("Id: ").append(getId()).append(",");
        if (getProductArn() != null)
            sb.append("ProductArn: ").append(getProductArn()).append(",");
        if (getProductName() != null)
            sb.append("ProductName: ").append(getProductName()).append(",");
        if (getCompanyName() != null)
            sb.append("CompanyName: ").append(getCompanyName()).append(",");
        if (getRegion() != null)
            sb.append("Region: ").append(getRegion()).append(",");
        if (getGeneratorId() != null)
            sb.append("GeneratorId: ").append(getGeneratorId()).append(",");
        if (getAwsAccountId() != null)
            sb.append("AwsAccountId: ").append(getAwsAccountId()).append(",");
        if (getTypes() != null)
            sb.append("Types: ").append(getTypes()).append(",");
        if (getFirstObservedAt() != null)
            sb.append("FirstObservedAt: ").append(getFirstObservedAt()).append(",");
        if (getLastObservedAt() != null)
            sb.append("LastObservedAt: ").append(getLastObservedAt()).append(",");
        if (getCreatedAt() != null)
            sb.append("CreatedAt: ").append(getCreatedAt()).append(",");
        if (getUpdatedAt() != null)
            sb.append("UpdatedAt: ").append(getUpdatedAt()).append(",");
        if (getSeverity() != null)
            sb.append("Severity: ").append(getSeverity()).append(",");
        if (getConfidence() != null)
            sb.append("Confidence: ").append(getConfidence()).append(",");
        if (getCriticality() != null)
            sb.append("Criticality: ").append(getCriticality()).append(",");
        if (getTitle() != null)
            sb.append("Title: ").append(getTitle()).append(",");
        if (getDescription() != null)
            sb.append("Description: ").append(getDescription()).append(",");
        if (getRemediation() != null)
            sb.append("Remediation: ").append(getRemediation()).append(",");
        if (getSourceUrl() != null)
            sb.append("SourceUrl: ").append(getSourceUrl()).append(",");
        if (getProductFields() != null)
            sb.append("ProductFields: ").append(getProductFields()).append(",");
        if (getUserDefinedFields() != null)
            sb.append("UserDefinedFields: ").append(getUserDefinedFields()).append(",");
        if (getMalware() != null)
            sb.append("Malware: ").append(getMalware()).append(",");
        if (getNetwork() != null)
            sb.append("Network: ").append(getNetwork()).append(",");
        if (getNetworkPath() != null)
            sb.append("NetworkPath: ").append(getNetworkPath()).append(",");
        if (getProcess() != null)
            sb.append("Process: ").append(getProcess()).append(",");
        if (getThreats() != null)
            sb.append("Threats: ").append(getThreats()).append(",");
        if (getThreatIntelIndicators() != null)
            sb.append("ThreatIntelIndicators: ").append(getThreatIntelIndicators()).append(",");
        if (getResources() != null)
            sb.append("Resources: ").append(getResources()).append(",");
        if (getCompliance() != null)
            sb.append("Compliance: ").append(getCompliance()).append(",");
        if (getVerificationState() != null)
            sb.append("VerificationState: ").append(getVerificationState()).append(",");
        if (getWorkflowState() != null)
            sb.append("WorkflowState: ").append(getWorkflowState()).append(",");
        if (getWorkflow() != null)
            sb.append("Workflow: ").append(getWorkflow()).append(",");
        if (getRecordState() != null)
            sb.append("RecordState: ").append(getRecordState()).append(",");
        if (getRelatedFindings() != null)
            sb.append("RelatedFindings: ").append(getRelatedFindings()).append(",");
        if (getNote() != null)
            sb.append("Note: ").append(getNote()).append(",");
        if (getVulnerabilities() != null)
            sb.append("Vulnerabilities: ").append(getVulnerabilities()).append(",");
        if (getPatchSummary() != null)
            sb.append("PatchSummary: ").append(getPatchSummary()).append(",");
        if (getAction() != null)
            sb.append("Action: ").append(getAction()).append(",");
        if (getFindingProviderFields() != null)
            sb.append("FindingProviderFields: ").append(getFindingProviderFields()).append(",");
        if (getSample() != null)
            sb.append("Sample: ").append(getSample());
        sb.append("}");
        return sb.toString();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj)
            return true;
        if (obj == null)
            return false;

        if (obj instanceof AwsSecurityFinding == false)
            return false;
        AwsSecurityFinding other = (AwsSecurityFinding) obj;
        if (other.getSchemaVersion() == null ^ this.getSchemaVersion() == null)
            return false;
        if (other.getSchemaVersion() != null && other.getSchemaVersion().equals(this.getSchemaVersion()) == false)
            return false;
        if (other.getId() == null ^ this.getId() == null)
            return false;
        if (other.getId() != null && other.getId().equals(this.getId()) == false)
            return false;
        if (other.getProductArn() == null ^ this.getProductArn() == null)
            return false;
        if (other.getProductArn() != null && other.getProductArn().equals(this.getProductArn()) == false)
            return false;
        if (other.getProductName() == null ^ this.getProductName() == null)
            return false;
        if (other.getProductName() != null && other.getProductName().equals(this.getProductName()) == false)
            return false;
        if (other.getCompanyName() == null ^ this.getCompanyName() == null)
            return false;
        if (other.getCompanyName() != null && other.getCompanyName().equals(this.getCompanyName()) == false)
            return false;
        if (other.getRegion() == null ^ this.getRegion() == null)
            return false;
        if (other.getRegion() != null && other.getRegion().equals(this.getRegion()) == false)
            return false;
        if (other.getGeneratorId() == null ^ this.getGeneratorId() == null)
            return false;
        if (other.getGeneratorId() != null && other.getGeneratorId().equals(this.getGeneratorId()) == false)
            return false;
        if (other.getAwsAccountId() == null ^ this.getAwsAccountId() == null)
            return false;
        if (other.getAwsAccountId() != null && other.getAwsAccountId().equals(this.getAwsAccountId()) == false)
            return false;
        if (other.getTypes() == null ^ this.getTypes() == null)
            return false;
        if (other.getTypes() != null && other.getTypes().equals(this.getTypes()) == false)
            return false;
        if (other.getFirstObservedAt() == null ^ this.getFirstObservedAt() == null)
            return false;
        if (other.getFirstObservedAt() != null && other.getFirstObservedAt().equals(this.getFirstObservedAt()) == false)
            return false;
        if (other.getLastObservedAt() == null ^ this.getLastObservedAt() == null)
            return false;
        if (other.getLastObservedAt() != null && other.getLastObservedAt().equals(this.getLastObservedAt()) == false)
            return false;
        if (other.getCreatedAt() == null ^ this.getCreatedAt() == null)
            return false;
        if (other.getCreatedAt() != null && other.getCreatedAt().equals(this.getCreatedAt()) == false)
            return false;
        if (other.getUpdatedAt() == null ^ this.getUpdatedAt() == null)
            return false;
        if (other.getUpdatedAt() != null && other.getUpdatedAt().equals(this.getUpdatedAt()) == false)
            return false;
        if (other.getSeverity() == null ^ this.getSeverity() == null)
            return false;
        if (other.getSeverity() != null && other.getSeverity().equals(this.getSeverity()) == false)
            return false;
        if (other.getConfidence() == null ^ this.getConfidence() == null)
            return false;
        if (other.getConfidence() != null && other.getConfidence().equals(this.getConfidence()) == false)
            return false;
        if (other.getCriticality() == null ^ this.getCriticality() == null)
            return false;
        if (other.getCriticality() != null && other.getCriticality().equals(this.getCriticality()) == false)
            return false;
        if (other.getTitle() == null ^ this.getTitle() == null)
            return false;
        if (other.getTitle() != null && other.getTitle().equals(this.getTitle()) == false)
            return false;
        if (other.getDescription() == null ^ this.getDescription() == null)
            return false;
        if (other.getDescription() != null && other.getDescription().equals(this.getDescription()) == false)
            return false;
        if (other.getRemediation() == null ^ this.getRemediation() == null)
            return false;
        if (other.getRemediation() != null && other.getRemediation().equals(this.getRemediation()) == false)
            return false;
        if (other.getSourceUrl() == null ^ this.getSourceUrl() == null)
            return false;
        if (other.getSourceUrl() != null && other.getSourceUrl().equals(this.getSourceUrl()) == false)
            return false;
        if (other.getProductFields() == null ^ this.getProductFields() == null)
            return false;
        if (other.getProductFields() != null && other.getProductFields().equals(this.getProductFields()) == false)
            return false;
        if (other.getUserDefinedFields() == null ^ this.getUserDefinedFields() == null)
            return false;
        if (other.getUserDefinedFields() != null && other.getUserDefinedFields().equals(this.getUserDefinedFields()) == false)
            return false;
        if (other.getMalware() == null ^ this.getMalware() == null)
            return false;
        if (other.getMalware() != null && other.getMalware().equals(this.getMalware()) == false)
            return false;
        if (other.getNetwork() == null ^ this.getNetwork() == null)
            return false;
        if (other.getNetwork() != null && other.getNetwork().equals(this.getNetwork()) == false)
            return false;
        if (other.getNetworkPath() == null ^ this.getNetworkPath() == null)
            return false;
        if (other.getNetworkPath() != null && other.getNetworkPath().equals(this.getNetworkPath()) == false)
            return false;
        if (other.getProcess() == null ^ this.getProcess() == null)
            return false;
        if (other.getProcess() != null && other.getProcess().equals(this.getProcess()) == false)
            return false;
        if (other.getThreats() == null ^ this.getThreats() == null)
            return false;
        if (other.getThreats() != null && other.getThreats().equals(this.getThreats()) == false)
            return false;
        if (other.getThreatIntelIndicators() == null ^ this.getThreatIntelIndicators() == null)
            return false;
        if (other.getThreatIntelIndicators() != null && other.getThreatIntelIndicators().equals(this.getThreatIntelIndicators()) == false)
            return false;
        if (other.getResources() == null ^ this.getResources() == null)
            return false;
        if (other.getResources() != null && other.getResources().equals(this.getResources()) == false)
            return false;
        if (other.getCompliance() == null ^ this.getCompliance() == null)
            return false;
        if (other.getCompliance() != null && other.getCompliance().equals(this.getCompliance()) == false)
            return false;
        if (other.getVerificationState() == null ^ this.getVerificationState() == null)
            return false;
        if (other.getVerificationState() != null && other.getVerificationState().equals(this.getVerificationState()) == false)
            return false;
        if (other.getWorkflowState() == null ^ this.getWorkflowState() == null)
            return false;
        if (other.getWorkflowState() != null && other.getWorkflowState().equals(this.getWorkflowState()) == false)
            return false;
        if (other.getWorkflow() == null ^ this.getWorkflow() == null)
            return false;
        if (other.getWorkflow() != null && other.getWorkflow().equals(this.getWorkflow()) == false)
            return false;
        if (other.getRecordState() == null ^ this.getRecordState() == null)
            return false;
        if (other.getRecordState() != null && other.getRecordState().equals(this.getRecordState()) == false)
            return false;
        if (other.getRelatedFindings() == null ^ this.getRelatedFindings() == null)
            return false;
        if (other.getRelatedFindings() != null && other.getRelatedFindings().equals(this.getRelatedFindings()) == false)
            return false;
        if (other.getNote() == null ^ this.getNote() == null)
            return false;
        if (other.getNote() != null && other.getNote().equals(this.getNote()) == false)
            return false;
        if (other.getVulnerabilities() == null ^ this.getVulnerabilities() == null)
            return false;
        if (other.getVulnerabilities() != null && other.getVulnerabilities().equals(this.getVulnerabilities()) == false)
            return false;
        if (other.getPatchSummary() == null ^ this.getPatchSummary() == null)
            return false;
        if (other.getPatchSummary() != null && other.getPatchSummary().equals(this.getPatchSummary()) == false)
            return false;
        if (other.getAction() == null ^ this.getAction() == null)
            return false;
        if (other.getAction() != null && other.getAction().equals(this.getAction()) == false)
            return false;
        if (other.getFindingProviderFields() == null ^ this.getFindingProviderFields() == null)
            return false;
        if (other.getFindingProviderFields() != null && other.getFindingProviderFields().equals(this.getFindingProviderFields()) == false)
            return false;
        if (other.getSample() == null ^ this.getSample() == null)
            return false;
        if (other.getSample() != null && other.getSample().equals(this.getSample()) == false)
            return false;
        return true;
    }

    @Override
    public int hashCode() {
        final int prime = 31;
        int hashCode = 1;

        hashCode = prime * hashCode + ((getSchemaVersion() == null) ? 0 : getSchemaVersion().hashCode());
        hashCode = prime * hashCode + ((getId() == null) ? 0 : getId().hashCode());
        hashCode = prime * hashCode + ((getProductArn() == null) ? 0 : getProductArn().hashCode());
        hashCode = prime * hashCode + ((getProductName() == null) ? 0 : getProductName().hashCode());
        hashCode = prime * hashCode + ((getCompanyName() == null) ? 0 : getCompanyName().hashCode());
        hashCode = prime * hashCode + ((getRegion() == null) ? 0 : getRegion().hashCode());
        hashCode = prime * hashCode + ((getGeneratorId() == null) ? 0 : getGeneratorId().hashCode());
        hashCode = prime * hashCode + ((getAwsAccountId() == null) ? 0 : getAwsAccountId().hashCode());
        hashCode = prime * hashCode + ((getTypes() == null) ? 0 : getTypes().hashCode());
        hashCode = prime * hashCode + ((getFirstObservedAt() == null) ? 0 : getFirstObservedAt().hashCode());
        hashCode = prime * hashCode + ((getLastObservedAt() == null) ? 0 : getLastObservedAt().hashCode());
        hashCode = prime * hashCode + ((getCreatedAt() == null) ? 0 : getCreatedAt().hashCode());
        hashCode = prime * hashCode + ((getUpdatedAt() == null) ? 0 : getUpdatedAt().hashCode());
        hashCode = prime * hashCode + ((getSeverity() == null) ? 0 : getSeverity().hashCode());
        hashCode = prime * hashCode + ((getConfidence() == null) ? 0 : getConfidence().hashCode());
        hashCode = prime * hashCode + ((getCriticality() == null) ? 0 : getCriticality().hashCode());
        hashCode = prime * hashCode + ((getTitle() == null) ? 0 : getTitle().hashCode());
        hashCode = prime * hashCode + ((getDescription() == null) ? 0 : getDescription().hashCode());
        hashCode = prime * hashCode + ((getRemediation() == null) ? 0 : getRemediation().hashCode());
        hashCode = prime * hashCode + ((getSourceUrl() == null) ? 0 : getSourceUrl().hashCode());
        hashCode = prime * hashCode + ((getProductFields() == null) ? 0 : getProductFields().hashCode());
        hashCode = prime * hashCode + ((getUserDefinedFields() == null) ? 0 : getUserDefinedFields().hashCode());
        hashCode = prime * hashCode + ((getMalware() == null) ? 0 : getMalware().hashCode());
        hashCode = prime * hashCode + ((getNetwork() == null) ? 0 : getNetwork().hashCode());
        hashCode = prime * hashCode + ((getNetworkPath() == null) ? 0 : getNetworkPath().hashCode());
        hashCode = prime * hashCode + ((getProcess() == null) ? 0 : getProcess().hashCode());
        hashCode = prime * hashCode + ((getThreats() == null) ? 0 : getThreats().hashCode());
        hashCode = prime * hashCode + ((getThreatIntelIndicators() == null) ? 0 : getThreatIntelIndicators().hashCode());
        hashCode = prime * hashCode + ((getResources() == null) ? 0 : getResources().hashCode());
        hashCode = prime * hashCode + ((getCompliance() == null) ? 0 : getCompliance().hashCode());
        hashCode = prime * hashCode + ((getVerificationState() == null) ? 0 : getVerificationState().hashCode());
        hashCode = prime * hashCode + ((getWorkflowState() == null) ? 0 : getWorkflowState().hashCode());
        hashCode = prime * hashCode + ((getWorkflow() == null) ? 0 : getWorkflow().hashCode());
        hashCode = prime * hashCode + ((getRecordState() == null) ? 0 : getRecordState().hashCode());
        hashCode = prime * hashCode + ((getRelatedFindings() == null) ? 0 : getRelatedFindings().hashCode());
        hashCode = prime * hashCode + ((getNote() == null) ? 0 : getNote().hashCode());
        hashCode = prime * hashCode + ((getVulnerabilities() == null) ? 0 : getVulnerabilities().hashCode());
        hashCode = prime * hashCode + ((getPatchSummary() == null) ? 0 : getPatchSummary().hashCode());
        hashCode = prime * hashCode + ((getAction() == null) ? 0 : getAction().hashCode());
        hashCode = prime * hashCode + ((getFindingProviderFields() == null) ? 0 : getFindingProviderFields().hashCode());
        hashCode = prime * hashCode + ((getSample() == null) ? 0 : getSample().hashCode());
        return hashCode;
    }

    @Override
    public AwsSecurityFinding clone() {
        try {
            return (AwsSecurityFinding) super.clone();
        } catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() " + "even though we're Cloneable!", e);
        }
    }

    @com.amazonaws.annotation.SdkInternalApi
    @Override
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        com.amazonaws.services.securityhub.model.transform.AwsSecurityFindingMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}
