/*
 * Copyright 2019-2024 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */
package com.amazonaws.services.securityhub.model;

import java.io.Serializable;
import javax.annotation.Generated;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.protocol.ProtocolMarshaller;

/**
 * <p>
 * The monitoring for an Amazon EC2 instance.
 * </p>
 * 
 * @see <a
 *      href="http://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/AwsEc2LaunchTemplateDataMonitoringDetails"
 *      target="_top">AWS API Documentation</a>
 */
@Generated("com.amazonaws:aws-java-sdk-code-generator")
public class AwsEc2LaunchTemplateDataMonitoringDetails implements Serializable, Cloneable, StructuredPojo {

    /**
     * <p>
     * Enables detailed monitoring when <code>true</code> is specified. Otherwise, basic monitoring is enabled. For more
     * information about detailed monitoring, see <a
     * href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/using-cloudwatch-new.html">Enable or turn off detailed
     * monitoring for your instances</a> in the <i>Amazon EC2 User Guide</i>.
     * </p>
     */
    private Boolean enabled;

    /**
     * <p>
     * Enables detailed monitoring when <code>true</code> is specified. Otherwise, basic monitoring is enabled. For more
     * information about detailed monitoring, see <a
     * href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/using-cloudwatch-new.html">Enable or turn off detailed
     * monitoring for your instances</a> in the <i>Amazon EC2 User Guide</i>.
     * </p>
     * 
     * @param enabled
     *        Enables detailed monitoring when <code>true</code> is specified. Otherwise, basic monitoring is enabled.
     *        For more information about detailed monitoring, see <a
     *        href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/using-cloudwatch-new.html">Enable or turn off
     *        detailed monitoring for your instances</a> in the <i>Amazon EC2 User Guide</i>.
     */

    public void setEnabled(Boolean enabled) {
        this.enabled = enabled;
    }

    /**
     * <p>
     * Enables detailed monitoring when <code>true</code> is specified. Otherwise, basic monitoring is enabled. For more
     * information about detailed monitoring, see <a
     * href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/using-cloudwatch-new.html">Enable or turn off detailed
     * monitoring for your instances</a> in the <i>Amazon EC2 User Guide</i>.
     * </p>
     * 
     * @return Enables detailed monitoring when <code>true</code> is specified. Otherwise, basic monitoring is enabled.
     *         For more information about detailed monitoring, see <a
     *         href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/using-cloudwatch-new.html">Enable or turn off
     *         detailed monitoring for your instances</a> in the <i>Amazon EC2 User Guide</i>.
     */

    public Boolean getEnabled() {
        return this.enabled;
    }

    /**
     * <p>
     * Enables detailed monitoring when <code>true</code> is specified. Otherwise, basic monitoring is enabled. For more
     * information about detailed monitoring, see <a
     * href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/using-cloudwatch-new.html">Enable or turn off detailed
     * monitoring for your instances</a> in the <i>Amazon EC2 User Guide</i>.
     * </p>
     * 
     * @param enabled
     *        Enables detailed monitoring when <code>true</code> is specified. Otherwise, basic monitoring is enabled.
     *        For more information about detailed monitoring, see <a
     *        href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/using-cloudwatch-new.html">Enable or turn off
     *        detailed monitoring for your instances</a> in the <i>Amazon EC2 User Guide</i>.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public AwsEc2LaunchTemplateDataMonitoringDetails withEnabled(Boolean enabled) {
        setEnabled(enabled);
        return this;
    }

    /**
     * <p>
     * Enables detailed monitoring when <code>true</code> is specified. Otherwise, basic monitoring is enabled. For more
     * information about detailed monitoring, see <a
     * href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/using-cloudwatch-new.html">Enable or turn off detailed
     * monitoring for your instances</a> in the <i>Amazon EC2 User Guide</i>.
     * </p>
     * 
     * @return Enables detailed monitoring when <code>true</code> is specified. Otherwise, basic monitoring is enabled.
     *         For more information about detailed monitoring, see <a
     *         href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/using-cloudwatch-new.html">Enable or turn off
     *         detailed monitoring for your instances</a> in the <i>Amazon EC2 User Guide</i>.
     */

    public Boolean isEnabled() {
        return this.enabled;
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     *
     * @return A string representation of this object.
     *
     * @see java.lang.Object#toString()
     */
    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (getEnabled() != null)
            sb.append("Enabled: ").append(getEnabled());
        sb.append("}");
        return sb.toString();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj)
            return true;
        if (obj == null)
            return false;

        if (obj instanceof AwsEc2LaunchTemplateDataMonitoringDetails == false)
            return false;
        AwsEc2LaunchTemplateDataMonitoringDetails other = (AwsEc2LaunchTemplateDataMonitoringDetails) obj;
        if (other.getEnabled() == null ^ this.getEnabled() == null)
            return false;
        if (other.getEnabled() != null && other.getEnabled().equals(this.getEnabled()) == false)
            return false;
        return true;
    }

    @Override
    public int hashCode() {
        final int prime = 31;
        int hashCode = 1;

        hashCode = prime * hashCode + ((getEnabled() == null) ? 0 : getEnabled().hashCode());
        return hashCode;
    }

    @Override
    public AwsEc2LaunchTemplateDataMonitoringDetails clone() {
        try {
            return (AwsEc2LaunchTemplateDataMonitoringDetails) super.clone();
        } catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() " + "even though we're Cloneable!", e);
        }
    }

    @com.amazonaws.annotation.SdkInternalApi
    @Override
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        com.amazonaws.services.securityhub.model.transform.AwsEc2LaunchTemplateDataMonitoringDetailsMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}
