/*
 * Copyright 2019-2024 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */
package com.amazonaws.services.securityhub.model;

import java.io.Serializable;
import javax.annotation.Generated;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.protocol.ProtocolMarshaller;

/**
 * <p>
 * Provides details about the vulnerabilities found in your Lambda function code. This field pertains to findings that
 * Security Hub receives from Amazon Inspector.
 * </p>
 * 
 * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/VulnerabilityCodeVulnerabilities"
 *      target="_top">AWS API Documentation</a>
 */
@Generated("com.amazonaws:aws-java-sdk-code-generator")
public class VulnerabilityCodeVulnerabilities implements Serializable, Cloneable, StructuredPojo {

    /**
     * <p>
     * The Common Weakness Enumeration (CWE) item associated with the detected code vulnerability.
     * </p>
     */
    private java.util.List<String> cwes;
    /**
     * <p>
     * Provides details about where a code vulnerability is located in your Lambda function.
     * </p>
     */
    private CodeVulnerabilitiesFilePath filePath;
    /**
     * <p>
     * The Amazon Resource Name (ARN) of the Lambda layer in which the code vulnerability is located.
     * </p>
     */
    private String sourceArn;

    /**
     * <p>
     * The Common Weakness Enumeration (CWE) item associated with the detected code vulnerability.
     * </p>
     * 
     * @return The Common Weakness Enumeration (CWE) item associated with the detected code vulnerability.
     */

    public java.util.List<String> getCwes() {
        return cwes;
    }

    /**
     * <p>
     * The Common Weakness Enumeration (CWE) item associated with the detected code vulnerability.
     * </p>
     * 
     * @param cwes
     *        The Common Weakness Enumeration (CWE) item associated with the detected code vulnerability.
     */

    public void setCwes(java.util.Collection<String> cwes) {
        if (cwes == null) {
            this.cwes = null;
            return;
        }

        this.cwes = new java.util.ArrayList<String>(cwes);
    }

    /**
     * <p>
     * The Common Weakness Enumeration (CWE) item associated with the detected code vulnerability.
     * </p>
     * <p>
     * <b>NOTE:</b> This method appends the values to the existing list (if any). Use
     * {@link #setCwes(java.util.Collection)} or {@link #withCwes(java.util.Collection)} if you want to override the
     * existing values.
     * </p>
     * 
     * @param cwes
     *        The Common Weakness Enumeration (CWE) item associated with the detected code vulnerability.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public VulnerabilityCodeVulnerabilities withCwes(String... cwes) {
        if (this.cwes == null) {
            setCwes(new java.util.ArrayList<String>(cwes.length));
        }
        for (String ele : cwes) {
            this.cwes.add(ele);
        }
        return this;
    }

    /**
     * <p>
     * The Common Weakness Enumeration (CWE) item associated with the detected code vulnerability.
     * </p>
     * 
     * @param cwes
     *        The Common Weakness Enumeration (CWE) item associated with the detected code vulnerability.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public VulnerabilityCodeVulnerabilities withCwes(java.util.Collection<String> cwes) {
        setCwes(cwes);
        return this;
    }

    /**
     * <p>
     * Provides details about where a code vulnerability is located in your Lambda function.
     * </p>
     * 
     * @param filePath
     *        Provides details about where a code vulnerability is located in your Lambda function.
     */

    public void setFilePath(CodeVulnerabilitiesFilePath filePath) {
        this.filePath = filePath;
    }

    /**
     * <p>
     * Provides details about where a code vulnerability is located in your Lambda function.
     * </p>
     * 
     * @return Provides details about where a code vulnerability is located in your Lambda function.
     */

    public CodeVulnerabilitiesFilePath getFilePath() {
        return this.filePath;
    }

    /**
     * <p>
     * Provides details about where a code vulnerability is located in your Lambda function.
     * </p>
     * 
     * @param filePath
     *        Provides details about where a code vulnerability is located in your Lambda function.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public VulnerabilityCodeVulnerabilities withFilePath(CodeVulnerabilitiesFilePath filePath) {
        setFilePath(filePath);
        return this;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the Lambda layer in which the code vulnerability is located.
     * </p>
     * 
     * @param sourceArn
     *        The Amazon Resource Name (ARN) of the Lambda layer in which the code vulnerability is located.
     */

    public void setSourceArn(String sourceArn) {
        this.sourceArn = sourceArn;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the Lambda layer in which the code vulnerability is located.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the Lambda layer in which the code vulnerability is located.
     */

    public String getSourceArn() {
        return this.sourceArn;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the Lambda layer in which the code vulnerability is located.
     * </p>
     * 
     * @param sourceArn
     *        The Amazon Resource Name (ARN) of the Lambda layer in which the code vulnerability is located.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public VulnerabilityCodeVulnerabilities withSourceArn(String sourceArn) {
        setSourceArn(sourceArn);
        return this;
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     *
     * @return A string representation of this object.
     *
     * @see java.lang.Object#toString()
     */
    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (getCwes() != null)
            sb.append("Cwes: ").append(getCwes()).append(",");
        if (getFilePath() != null)
            sb.append("FilePath: ").append(getFilePath()).append(",");
        if (getSourceArn() != null)
            sb.append("SourceArn: ").append(getSourceArn());
        sb.append("}");
        return sb.toString();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj)
            return true;
        if (obj == null)
            return false;

        if (obj instanceof VulnerabilityCodeVulnerabilities == false)
            return false;
        VulnerabilityCodeVulnerabilities other = (VulnerabilityCodeVulnerabilities) obj;
        if (other.getCwes() == null ^ this.getCwes() == null)
            return false;
        if (other.getCwes() != null && other.getCwes().equals(this.getCwes()) == false)
            return false;
        if (other.getFilePath() == null ^ this.getFilePath() == null)
            return false;
        if (other.getFilePath() != null && other.getFilePath().equals(this.getFilePath()) == false)
            return false;
        if (other.getSourceArn() == null ^ this.getSourceArn() == null)
            return false;
        if (other.getSourceArn() != null && other.getSourceArn().equals(this.getSourceArn()) == false)
            return false;
        return true;
    }

    @Override
    public int hashCode() {
        final int prime = 31;
        int hashCode = 1;

        hashCode = prime * hashCode + ((getCwes() == null) ? 0 : getCwes().hashCode());
        hashCode = prime * hashCode + ((getFilePath() == null) ? 0 : getFilePath().hashCode());
        hashCode = prime * hashCode + ((getSourceArn() == null) ? 0 : getSourceArn().hashCode());
        return hashCode;
    }

    @Override
    public VulnerabilityCodeVulnerabilities clone() {
        try {
            return (VulnerabilityCodeVulnerabilities) super.clone();
        } catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() " + "even though we're Cloneable!", e);
        }
    }

    @com.amazonaws.annotation.SdkInternalApi
    @Override
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        com.amazonaws.services.securityhub.model.transform.VulnerabilityCodeVulnerabilitiesMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}
