/*
 * Copyright 2020-2025 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */
package com.amazonaws.services.securityhub.model;

import java.io.Serializable;
import javax.annotation.Generated;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.protocol.ProtocolMarshaller;

/**
 * <p>
 * Identifies the source of the finding change event.
 * </p>
 * 
 * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/FindingHistoryUpdateSource"
 *      target="_top">AWS API Documentation</a>
 */
@Generated("com.amazonaws:aws-java-sdk-code-generator")
public class FindingHistoryUpdateSource implements Serializable, Cloneable, StructuredPojo {

    /**
     * <p>
     * Describes the type of finding change event, such as a call to <a
     * href="https://docs.aws.amazon.com/securityhub/1.0/APIReference/API_BatchImportFindings.html">
     * <code>BatchImportFindings</code> </a> (by an integrated Amazon Web Service or third party partner integration) or
     * <a href="https://docs.aws.amazon.com/securityhub/1.0/APIReference/API_BatchUpdateFindings.html">
     * <code>BatchUpdateFindings</code> </a> (by a Security Hub customer).
     * </p>
     */
    private String type;
    /**
     * <p>
     * The identity of the source that initiated the finding change event. For example, the Amazon Resource Name (ARN)
     * of a partner that calls BatchImportFindings or of a customer that calls BatchUpdateFindings.
     * </p>
     */
    private String identity;

    /**
     * <p>
     * Describes the type of finding change event, such as a call to <a
     * href="https://docs.aws.amazon.com/securityhub/1.0/APIReference/API_BatchImportFindings.html">
     * <code>BatchImportFindings</code> </a> (by an integrated Amazon Web Service or third party partner integration) or
     * <a href="https://docs.aws.amazon.com/securityhub/1.0/APIReference/API_BatchUpdateFindings.html">
     * <code>BatchUpdateFindings</code> </a> (by a Security Hub customer).
     * </p>
     * 
     * @param type
     *        Describes the type of finding change event, such as a call to <a
     *        href="https://docs.aws.amazon.com/securityhub/1.0/APIReference/API_BatchImportFindings.html">
     *        <code>BatchImportFindings</code> </a> (by an integrated Amazon Web Service or third party partner
     *        integration) or <a
     *        href="https://docs.aws.amazon.com/securityhub/1.0/APIReference/API_BatchUpdateFindings.html">
     *        <code>BatchUpdateFindings</code> </a> (by a Security Hub customer).
     * @see FindingHistoryUpdateSourceType
     */

    public void setType(String type) {
        this.type = type;
    }

    /**
     * <p>
     * Describes the type of finding change event, such as a call to <a
     * href="https://docs.aws.amazon.com/securityhub/1.0/APIReference/API_BatchImportFindings.html">
     * <code>BatchImportFindings</code> </a> (by an integrated Amazon Web Service or third party partner integration) or
     * <a href="https://docs.aws.amazon.com/securityhub/1.0/APIReference/API_BatchUpdateFindings.html">
     * <code>BatchUpdateFindings</code> </a> (by a Security Hub customer).
     * </p>
     * 
     * @return Describes the type of finding change event, such as a call to <a
     *         href="https://docs.aws.amazon.com/securityhub/1.0/APIReference/API_BatchImportFindings.html">
     *         <code>BatchImportFindings</code> </a> (by an integrated Amazon Web Service or third party partner
     *         integration) or <a
     *         href="https://docs.aws.amazon.com/securityhub/1.0/APIReference/API_BatchUpdateFindings.html">
     *         <code>BatchUpdateFindings</code> </a> (by a Security Hub customer).
     * @see FindingHistoryUpdateSourceType
     */

    public String getType() {
        return this.type;
    }

    /**
     * <p>
     * Describes the type of finding change event, such as a call to <a
     * href="https://docs.aws.amazon.com/securityhub/1.0/APIReference/API_BatchImportFindings.html">
     * <code>BatchImportFindings</code> </a> (by an integrated Amazon Web Service or third party partner integration) or
     * <a href="https://docs.aws.amazon.com/securityhub/1.0/APIReference/API_BatchUpdateFindings.html">
     * <code>BatchUpdateFindings</code> </a> (by a Security Hub customer).
     * </p>
     * 
     * @param type
     *        Describes the type of finding change event, such as a call to <a
     *        href="https://docs.aws.amazon.com/securityhub/1.0/APIReference/API_BatchImportFindings.html">
     *        <code>BatchImportFindings</code> </a> (by an integrated Amazon Web Service or third party partner
     *        integration) or <a
     *        href="https://docs.aws.amazon.com/securityhub/1.0/APIReference/API_BatchUpdateFindings.html">
     *        <code>BatchUpdateFindings</code> </a> (by a Security Hub customer).
     * @return Returns a reference to this object so that method calls can be chained together.
     * @see FindingHistoryUpdateSourceType
     */

    public FindingHistoryUpdateSource withType(String type) {
        setType(type);
        return this;
    }

    /**
     * <p>
     * Describes the type of finding change event, such as a call to <a
     * href="https://docs.aws.amazon.com/securityhub/1.0/APIReference/API_BatchImportFindings.html">
     * <code>BatchImportFindings</code> </a> (by an integrated Amazon Web Service or third party partner integration) or
     * <a href="https://docs.aws.amazon.com/securityhub/1.0/APIReference/API_BatchUpdateFindings.html">
     * <code>BatchUpdateFindings</code> </a> (by a Security Hub customer).
     * </p>
     * 
     * @param type
     *        Describes the type of finding change event, such as a call to <a
     *        href="https://docs.aws.amazon.com/securityhub/1.0/APIReference/API_BatchImportFindings.html">
     *        <code>BatchImportFindings</code> </a> (by an integrated Amazon Web Service or third party partner
     *        integration) or <a
     *        href="https://docs.aws.amazon.com/securityhub/1.0/APIReference/API_BatchUpdateFindings.html">
     *        <code>BatchUpdateFindings</code> </a> (by a Security Hub customer).
     * @return Returns a reference to this object so that method calls can be chained together.
     * @see FindingHistoryUpdateSourceType
     */

    public FindingHistoryUpdateSource withType(FindingHistoryUpdateSourceType type) {
        this.type = type.toString();
        return this;
    }

    /**
     * <p>
     * The identity of the source that initiated the finding change event. For example, the Amazon Resource Name (ARN)
     * of a partner that calls BatchImportFindings or of a customer that calls BatchUpdateFindings.
     * </p>
     * 
     * @param identity
     *        The identity of the source that initiated the finding change event. For example, the Amazon Resource Name
     *        (ARN) of a partner that calls BatchImportFindings or of a customer that calls BatchUpdateFindings.
     */

    public void setIdentity(String identity) {
        this.identity = identity;
    }

    /**
     * <p>
     * The identity of the source that initiated the finding change event. For example, the Amazon Resource Name (ARN)
     * of a partner that calls BatchImportFindings or of a customer that calls BatchUpdateFindings.
     * </p>
     * 
     * @return The identity of the source that initiated the finding change event. For example, the Amazon Resource Name
     *         (ARN) of a partner that calls BatchImportFindings or of a customer that calls BatchUpdateFindings.
     */

    public String getIdentity() {
        return this.identity;
    }

    /**
     * <p>
     * The identity of the source that initiated the finding change event. For example, the Amazon Resource Name (ARN)
     * of a partner that calls BatchImportFindings or of a customer that calls BatchUpdateFindings.
     * </p>
     * 
     * @param identity
     *        The identity of the source that initiated the finding change event. For example, the Amazon Resource Name
     *        (ARN) of a partner that calls BatchImportFindings or of a customer that calls BatchUpdateFindings.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public FindingHistoryUpdateSource withIdentity(String identity) {
        setIdentity(identity);
        return this;
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     *
     * @return A string representation of this object.
     *
     * @see java.lang.Object#toString()
     */
    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (getType() != null)
            sb.append("Type: ").append(getType()).append(",");
        if (getIdentity() != null)
            sb.append("Identity: ").append(getIdentity());
        sb.append("}");
        return sb.toString();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj)
            return true;
        if (obj == null)
            return false;

        if (obj instanceof FindingHistoryUpdateSource == false)
            return false;
        FindingHistoryUpdateSource other = (FindingHistoryUpdateSource) obj;
        if (other.getType() == null ^ this.getType() == null)
            return false;
        if (other.getType() != null && other.getType().equals(this.getType()) == false)
            return false;
        if (other.getIdentity() == null ^ this.getIdentity() == null)
            return false;
        if (other.getIdentity() != null && other.getIdentity().equals(this.getIdentity()) == false)
            return false;
        return true;
    }

    @Override
    public int hashCode() {
        final int prime = 31;
        int hashCode = 1;

        hashCode = prime * hashCode + ((getType() == null) ? 0 : getType().hashCode());
        hashCode = prime * hashCode + ((getIdentity() == null) ? 0 : getIdentity().hashCode());
        return hashCode;
    }

    @Override
    public FindingHistoryUpdateSource clone() {
        try {
            return (FindingHistoryUpdateSource) super.clone();
        } catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() " + "even though we're Cloneable!", e);
        }
    }

    @com.amazonaws.annotation.SdkInternalApi
    @Override
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        com.amazonaws.services.securityhub.model.transform.FindingHistoryUpdateSourceMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}
