/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.lambda.runtime.tests;

import com.amazonaws.services.lambda.runtime.events.APIGatewayCustomAuthorizerEvent;
import com.amazonaws.services.lambda.runtime.events.APIGatewayProxyRequestEvent;
import com.amazonaws.services.lambda.runtime.events.APIGatewayV2CustomAuthorizerEvent;
import com.amazonaws.services.lambda.runtime.events.APIGatewayV2HTTPEvent;
import com.amazonaws.services.lambda.runtime.events.ActiveMQEvent;
import com.amazonaws.services.lambda.runtime.events.ApplicationLoadBalancerRequestEvent;
import com.amazonaws.services.lambda.runtime.events.CloudFormationCustomResourceEvent;
import com.amazonaws.services.lambda.runtime.events.CloudFrontEvent;
import com.amazonaws.services.lambda.runtime.events.CloudWatchLogsEvent;
import com.amazonaws.services.lambda.runtime.events.CodeCommitEvent;
import com.amazonaws.services.lambda.runtime.events.ConfigEvent;
import com.amazonaws.services.lambda.runtime.events.ConnectEvent;
import com.amazonaws.services.lambda.runtime.events.DynamodbEvent;
import com.amazonaws.services.lambda.runtime.events.KafkaEvent;
import com.amazonaws.services.lambda.runtime.events.KinesisEvent;
import com.amazonaws.services.lambda.runtime.events.KinesisFirehoseEvent;
import com.amazonaws.services.lambda.runtime.events.LambdaDestinationEvent;
import com.amazonaws.services.lambda.runtime.events.LexEvent;
import com.amazonaws.services.lambda.runtime.events.RabbitMQEvent;
import com.amazonaws.services.lambda.runtime.events.S3Event;
import com.amazonaws.services.lambda.runtime.events.SNSEvent;
import com.amazonaws.services.lambda.runtime.events.SQSEvent;
import com.amazonaws.services.lambda.runtime.events.ScheduledEvent;
import com.amazonaws.services.lambda.runtime.events.SecretsManagerRotationEvent;
import com.amazonaws.services.lambda.runtime.serialization.PojoSerializer;
import com.amazonaws.services.lambda.runtime.serialization.events.LambdaEventSerializers;
import com.amazonaws.services.lambda.runtime.tests.EventLoadingException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;

public class EventLoader {
    public static ActiveMQEvent loadActiveMQEvent(String filename) {
        return EventLoader.loadEvent(filename, ActiveMQEvent.class);
    }

    public static APIGatewayV2HTTPEvent loadApiGatewayHttpEvent(String filename) {
        return EventLoader.loadEvent(filename, APIGatewayV2HTTPEvent.class);
    }

    public static APIGatewayProxyRequestEvent loadApiGatewayRestEvent(String filename) {
        return EventLoader.loadEvent(filename, APIGatewayProxyRequestEvent.class);
    }

    public static APIGatewayCustomAuthorizerEvent loadAPIGatewayCustomAuthorizerEvent(String filename) {
        return EventLoader.loadEvent(filename, APIGatewayCustomAuthorizerEvent.class);
    }

    public static APIGatewayV2CustomAuthorizerEvent loadAPIGatewayV2CustomAuthorizerEvent(String filename) {
        return EventLoader.loadEvent(filename, APIGatewayV2CustomAuthorizerEvent.class);
    }

    public static ApplicationLoadBalancerRequestEvent loadApplicationLoadBalancerRequestEvent(String filename) {
        return EventLoader.loadEvent(filename, ApplicationLoadBalancerRequestEvent.class);
    }

    public static CloudFormationCustomResourceEvent loadCloudFormationCustomResourceEvent(String filename) {
        return EventLoader.loadEvent(filename, CloudFormationCustomResourceEvent.class);
    }

    public static CloudFrontEvent loadCloudFrontEvent(String filename) {
        return EventLoader.loadEvent(filename, CloudFrontEvent.class);
    }

    public static CloudWatchLogsEvent loadCloudWatchLogsEvent(String filename) {
        return EventLoader.loadEvent(filename, CloudWatchLogsEvent.class);
    }

    public static CodeCommitEvent loadCodeCommitEvent(String filename) {
        return EventLoader.loadEvent(filename, CodeCommitEvent.class);
    }

    public static ConfigEvent loadConfigEvent(String filename) {
        return EventLoader.loadEvent(filename, ConfigEvent.class);
    }

    public static ConnectEvent loadConnectEvent(String filename) {
        return EventLoader.loadEvent(filename, ConnectEvent.class);
    }

    public static DynamodbEvent loadDynamoDbEvent(String filename) {
        return EventLoader.loadEvent(filename, DynamodbEvent.class);
    }

    public static KafkaEvent loadKafkaEvent(String filename) {
        return EventLoader.loadEvent(filename, KafkaEvent.class);
    }

    public static KinesisEvent loadKinesisEvent(String filename) {
        return EventLoader.loadEvent(filename, KinesisEvent.class);
    }

    public static KinesisFirehoseEvent loadKinesisFirehoseEvent(String filename) {
        return EventLoader.loadEvent(filename, KinesisFirehoseEvent.class);
    }

    public static LambdaDestinationEvent loadLambdaDestinationEvent(String filename) {
        return EventLoader.loadEvent(filename, LambdaDestinationEvent.class);
    }

    public static LexEvent loadLexEvent(String filename) {
        return EventLoader.loadEvent(filename, LexEvent.class);
    }

    public static S3Event loadS3Event(String filename) {
        return EventLoader.loadEvent(filename, S3Event.class);
    }

    public static SecretsManagerRotationEvent loadSecretsManagerRotationEvent(String filename) {
        return EventLoader.loadEvent(filename, SecretsManagerRotationEvent.class);
    }

    public static ScheduledEvent loadScheduledEvent(String filename) {
        return EventLoader.loadEvent(filename, ScheduledEvent.class);
    }

    public static SNSEvent loadSNSEvent(String filename) {
        return EventLoader.loadEvent(filename, SNSEvent.class);
    }

    public static SQSEvent loadSQSEvent(String filename) {
        return EventLoader.loadEvent(filename, SQSEvent.class);
    }

    public static RabbitMQEvent loadRabbitMQEvent(String filename) {
        return EventLoader.loadEvent(filename, RabbitMQEvent.class);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> T loadEvent(String filename, Class<T> targetClass) {
        if (!filename.endsWith("json")) {
            throw new IllegalArgumentException("File " + filename + " must have json extension");
        }
        PojoSerializer serializer = LambdaEventSerializers.serializerFor(targetClass, (ClassLoader)ClassLoader.getSystemClassLoader());
        InputStream stream = serializer.getClass().getResourceAsStream(filename);
        if (stream == null) {
            stream = serializer.getClass().getClassLoader().getResourceAsStream(filename);
        }
        if (stream == null) {
            try {
                stream = new FileInputStream(new File(filename));
            }
            catch (FileNotFoundException e) {
                throw new EventLoadingException("Cannot load " + filename, e);
            }
        }
        try {
            Object object = serializer.fromJson(stream);
            return (T)object;
        }
        finally {
            try {
                stream.close();
            }
            catch (IOException ioe) {
                ioe.printStackTrace();
            }
        }
    }
}

