/*
 * Decompiled with CFR 0.152.
 */
package com.bandwidth.library.model;

import com.bandwidth.library.BandwidthRestClient;
import com.bandwidth.library.model.BaseModelObject;
import com.bandwidth.library.model.MediaFile;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;

public class Media
extends BaseModelObject {
    public Media(BandwidthRestClient client, String parentUri) {
        super(client, parentUri, null);
    }

    public List<MediaFile> getMediaFiles() throws IOException {
        String uri = this.getUri();
        JSONArray array = this.client.getArray(uri, null);
        ArrayList<MediaFile> mediaFiles = new ArrayList<MediaFile>();
        for (Object obj : array) {
            mediaFiles.add(new MediaFile(this.client, uri, (JSONObject)obj));
        }
        return mediaFiles;
    }

    public MediaFile upload(String mediaName, File file, String contentType) throws IOException {
        String uri = StringUtils.join((Object[])new String[]{this.getUri(), mediaName}, (char)'/');
        this.client.uploadFile(uri, file, contentType);
        List<MediaFile> mediaFiles = this.getMediaFiles();
        for (MediaFile mediaFile : mediaFiles) {
            if (!StringUtils.equals((CharSequence)mediaFile.getMediaName(), (CharSequence)mediaName)) continue;
            return mediaFile;
        }
        return null;
    }

    public void download(String mediaName, File file) throws IOException {
        String uri = StringUtils.join((Object[])new String[]{this.getUri(), mediaName}, (char)'/');
        this.client.downloadFileTo(uri, file);
    }

    @Override
    protected String getUri() {
        return StringUtils.join((Object[])new String[]{this.parentUri, "media"}, (char)'/');
    }
}

