/*
 * Decompiled with CFR 0.152.
 */
package com.bandwidth.library.model;

import com.bandwidth.library.BandwidthRestClient;
import com.bandwidth.library.model.BaseModelObject;
import com.bandwidth.library.model.Message;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;

public class Messages
extends BaseModelObject {
    public Messages(BandwidthRestClient client, String parentUri) {
        super(client, parentUri, null);
    }

    public Message getMessage(String id) throws IOException {
        String messagesUri = this.getUri();
        String uri = StringUtils.join((Object[])new String[]{messagesUri, id}, (char)'/');
        JSONObject jsonObject = this.client.getObject(uri);
        return new Message(this.client, messagesUri, jsonObject);
    }

    public NewMessageBuilder newMessageBuilder() {
        return new NewMessageBuilder();
    }

    public QueryMessagesBuilder queryMessagesBuilder() {
        return new QueryMessagesBuilder();
    }

    private List<Message> getMessages(Map<String, Object> params) throws IOException {
        String messagesUri = this.getUri();
        JSONArray jsonArray = this.client.getArray(messagesUri, params);
        ArrayList<Message> messages = new ArrayList<Message>();
        for (Object obj : jsonArray) {
            messages.add(new Message(this.client, messagesUri, (JSONObject)obj));
        }
        return messages;
    }

    private Message newMessage(Map<String, Object> params) throws IOException {
        String uri = this.getUri();
        JSONObject jsonObject = this.client.create(uri, params);
        return new Message(this.client, uri, jsonObject);
    }

    @Override
    protected String getUri() {
        return StringUtils.join((Object[])new String[]{this.parentUri, "messages"}, (char)'/');
    }

    public class NewMessageBuilder {
        private final Map<String, Object> params = new HashMap<String, Object>();

        public NewMessageBuilder from(String from) {
            this.params.put("from", from);
            return this;
        }

        public NewMessageBuilder to(String to) {
            this.params.put("to", to);
            return this;
        }

        public NewMessageBuilder text(String text) {
            this.params.put("text", text);
            return this;
        }

        public NewMessageBuilder callbackUrl(String callbackUrl) {
            this.params.put("callbackUrl", callbackUrl);
            return this;
        }

        public NewMessageBuilder tag(String tag) {
            this.params.put("tag", tag);
            return this;
        }

        public Message create() throws IOException {
            return Messages.this.newMessage(this.params);
        }
    }

    public class QueryMessagesBuilder {
        private final Map<String, Object> params = new HashMap<String, Object>();

        public QueryMessagesBuilder from(String from) {
            this.params.put("from", from);
            return this;
        }

        public QueryMessagesBuilder to(String to) {
            this.params.put("to", to);
            return this;
        }

        public QueryMessagesBuilder page(int page) {
            this.params.put("page", page);
            return this;
        }

        public QueryMessagesBuilder size(int size) {
            this.params.put("size", size);
            return this;
        }

        public List<Message> list() throws IOException {
            return Messages.this.getMessages(this.params);
        }
    }
}

