/*
 * Decompiled with CFR 0.152.
 */
package com.browserstack.automate;

import com.browserstack.automate.Automate;
import com.browserstack.automate.exception.AutomateException;
import com.browserstack.automate.exception.BuildNotFound;
import com.browserstack.automate.exception.ProjectNotFound;
import com.browserstack.automate.exception.SessionNotFound;
import com.browserstack.automate.model.AccountUsage;
import com.browserstack.automate.model.Build;
import com.browserstack.automate.model.BuildNode;
import com.browserstack.automate.model.Project;
import com.browserstack.automate.model.ProjectNode;
import com.browserstack.automate.model.Session;
import com.browserstack.automate.model.SessionNode;
import com.browserstack.client.BrowserStackClient;
import com.browserstack.client.BrowserStackRequest;
import com.browserstack.client.exception.BrowserStackException;
import com.browserstack.client.exception.BrowserStackObjectNotFound;
import com.browserstack.client.model.Browser;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class AutomateClient
extends BrowserStackClient
implements Automate {
    private static final String BASE_URL = "https://www.browserstack.com/automate";
    private static final String CACHE_KEY_BROWSERS = "browsers";

    public AutomateClient(String username, String accessKey) {
        super(System.getProperty("browserstack.automate.api", BASE_URL), username, accessKey);
    }

    @Override
    public final AccountUsage getAccountUsage() throws AutomateException {
        try {
            return this.newRequest(BrowserStackClient.Method.GET, "/plan.json").asObject(AccountUsage.class);
        }
        catch (BrowserStackException e) {
            throw new AutomateException(e);
        }
    }

    @Override
    public final List<Browser> getBrowsers() throws AutomateException {
        return this.getBrowsers(true);
    }

    @Override
    public final List<Browser> getBrowsers(boolean cache) throws AutomateException {
        try {
            List browsers;
            if (cache && this.cacheMap.containsKey(CACHE_KEY_BROWSERS) && (browsers = (List)this.cacheMap.get(CACHE_KEY_BROWSERS)) != null && browsers.size() > 0) {
                return browsers;
            }
            browsers = Arrays.asList((Object[])this.newRequest(BrowserStackClient.Method.GET, "/browsers.json").asObject(Browser[].class));
            if (cache) {
                this.cacheMap.put(CACHE_KEY_BROWSERS, browsers);
            }
            return browsers;
        }
        catch (BrowserStackException e) {
            throw new AutomateException(e);
        }
    }

    @Override
    public final List<Project> getProjects() throws AutomateException {
        ProjectNode[] projectNodes;
        ArrayList<Project> projects = new ArrayList<Project>();
        try {
            projectNodes = this.newRequest(BrowserStackClient.Method.GET, "/projects.json").asObject(ProjectNode[].class);
        }
        catch (BrowserStackException e) {
            throw new AutomateException(e);
        }
        for (ProjectNode pn : projectNodes) {
            if (pn == null || pn.getProject() == null) continue;
            projects.add((Project)pn.getProject().setClient(this));
        }
        return projects;
    }

    @Override
    public final Project getProject(int projectId) throws ProjectNotFound, AutomateException {
        try {
            ProjectNode projectNode = this.newRequest(BrowserStackClient.Method.GET, "/projects/{projectId}.json").routeParam("projectId", "" + projectId).asObject(ProjectNode.class);
            if (projectNode.getProject() == null) {
                throw new ProjectNotFound("Project not found: " + projectId);
            }
            return (Project)projectNode.getProject().setClient(this);
        }
        catch (BrowserStackObjectNotFound e) {
            throw new ProjectNotFound("Project not found: " + projectId);
        }
        catch (BrowserStackException e) {
            throw new AutomateException(e);
        }
    }

    @Override
    public final boolean deleteProject(int projectId) throws AutomateException {
        try {
            ObjectNode result = this.newRequest(BrowserStackClient.Method.DELETE, "/projects/{projectId}.json").routeParam("projectId", "" + projectId).asJsonObject();
            String status = result != null ? result.path("status").asText() : null;
            return status != null && status.equals("ok");
        }
        catch (BrowserStackException e) {
            throw new AutomateException(e);
        }
    }

    @Override
    public final List<Build> getBuilds(Automate.BuildStatus status, int limit) throws AutomateException {
        List<Object> buildNodes;
        BrowserStackRequest httpRequest;
        try {
            httpRequest = this.newRequest(BrowserStackClient.Method.GET, "/builds.json");
        }
        catch (BrowserStackException e) {
            throw new AutomateException(e);
        }
        if (limit > 0) {
            httpRequest.queryString("limit", limit);
        }
        if (status != null) {
            httpRequest.queryString("filter", status.name().toLowerCase());
        }
        try {
            buildNodes = Arrays.asList((Object[])httpRequest.asObject(BuildNode[].class));
        }
        catch (BrowserStackException e) {
            throw new AutomateException(e);
        }
        ArrayList<Build> builds = new ArrayList<Build>();
        for (BuildNode buildNode : buildNodes) {
            if (buildNode == null || buildNode.getBuild() == null) continue;
            builds.add((Build)buildNode.getBuild().setClient(this));
        }
        return builds;
    }

    @Override
    public final List<Build> getBuilds() throws AutomateException {
        return this.getBuilds(null, 0);
    }

    @Override
    public final List<Build> getBuilds(int limit) throws AutomateException {
        return this.getBuilds(null, limit);
    }

    @Override
    public final List<Build> getBuilds(Automate.BuildStatus status) throws AutomateException {
        return this.getBuilds(status, 0);
    }

    @Override
    public final Build getBuild(String buildId) throws BuildNotFound, AutomateException {
        try {
            BuildNode buildNode = this.newRequest(BrowserStackClient.Method.GET, "/builds/{buildId}.json").routeParam("buildId", buildId).asObject(BuildNode.class);
            if (buildNode == null) {
                throw new BuildNotFound("Build not found: " + buildId);
            }
            return (Build)buildNode.getBuild().setClient(this);
        }
        catch (BrowserStackObjectNotFound e) {
            throw new BuildNotFound("Build not found: " + buildId);
        }
        catch (BrowserStackException e) {
            throw new AutomateException(e);
        }
    }

    @Override
    public final boolean deleteBuild(String buildId) throws AutomateException {
        try {
            ObjectNode result = this.newRequest(BrowserStackClient.Method.DELETE, "/builds/{buildId}.json").routeParam("buildId", buildId).asJsonObject();
            String status = result != null ? result.path("status").asText() : null;
            return status != null && status.equals("ok");
        }
        catch (BrowserStackException e) {
            throw new AutomateException(e);
        }
    }

    @Override
    public final List<Session> getSessions(String buildId, Automate.BuildStatus status, int limit) throws BuildNotFound, AutomateException {
        List<Object> sessionNodes;
        BrowserStackRequest httpRequest = null;
        try {
            httpRequest = this.newRequest(BrowserStackClient.Method.GET, "/builds/{buildId}/sessions.json").routeParam("buildId", buildId);
        }
        catch (BrowserStackException e) {
            throw new AutomateException(e);
        }
        if (limit > 0) {
            httpRequest.queryString("limit", limit);
        }
        if (status != null) {
            httpRequest.queryString("filter", (Object)status);
        }
        try {
            sessionNodes = Arrays.asList((Object[])httpRequest.asObject(SessionNode[].class));
        }
        catch (BrowserStackObjectNotFound e) {
            throw new BuildNotFound("Build not found: " + buildId);
        }
        catch (BrowserStackException e) {
            throw new AutomateException(e);
        }
        ArrayList<Session> sessions = new ArrayList<Session>();
        for (SessionNode sessionNode : sessionNodes) {
            if (sessionNode == null || sessionNode.getSession() == null) continue;
            sessions.add((Session)sessionNode.getSession().setClient(this));
        }
        return sessions;
    }

    @Override
    public final List<Session> getSessions(String buildId) throws BuildNotFound, AutomateException {
        return this.getSessions(buildId, null, 0);
    }

    @Override
    public final List<Session> getSessions(String buildId, int limit) throws BuildNotFound, AutomateException {
        return this.getSessions(buildId, null, limit);
    }

    @Override
    public final List<Session> getSessions(String buildId, Automate.BuildStatus status) throws BuildNotFound, AutomateException {
        return this.getSessions(buildId, status, 0);
    }

    @Override
    public final Session getSession(String sessionId) throws SessionNotFound, AutomateException {
        try {
            SessionNode sessionNode = this.newRequest(BrowserStackClient.Method.GET, "/sessions/{sessionId}.json").routeParam("sessionId", sessionId).asObject(SessionNode.class);
            if (sessionNode.getSession() == null) {
                throw new SessionNotFound("Session not found: " + sessionId);
            }
            return (Session)sessionNode.getSession().setClient(this);
        }
        catch (BrowserStackObjectNotFound e) {
            throw new SessionNotFound("Session not found: " + sessionId);
        }
        catch (BrowserStackException e) {
            throw new AutomateException(e);
        }
    }

    @Override
    public final Session updateSessionStatus(String sessionId, Map<String, Object> data) throws AutomateException {
        try {
            return (Session)this.newRequest(BrowserStackClient.Method.PUT, "/sessions/{sessionId}.json", data).routeParam("sessionId", sessionId).asObject(SessionNode.class).getSession().setClient(this);
        }
        catch (BrowserStackException e) {
            throw new AutomateException(e);
        }
    }

    @Override
    public final Session updateSessionStatus(String sessionId, Automate.SessionStatus sessionStatus, String reason) throws SessionNotFound, AutomateException {
        HashMap<String, Object> data = new HashMap<String, Object>();
        if (sessionStatus != null) {
            data.put("status", sessionStatus.name().toLowerCase());
        }
        if (reason != null && reason.trim().length() > 0) {
            data.put("reason", reason);
        }
        return this.updateSessionStatus(sessionId, data);
    }

    @Override
    public final Session updateSessionStatus(String sessionId, Automate.SessionStatus sessionStatus) throws SessionNotFound, AutomateException {
        return this.updateSessionStatus(sessionId, sessionStatus);
    }

    @Override
    public final String getSessionLogs(String sessionId) throws SessionNotFound, AutomateException {
        return this.getSessionLogs(this.getSession(sessionId));
    }

    @Override
    public final String getSessionLogs(Session session) throws AutomateException {
        if (session == null) {
            throw new AutomateException("Invalid session", 400);
        }
        if (session.getLogUrl() == null) {
            throw new AutomateException("Session logs not found", 404);
        }
        try {
            BrowserStackRequest request = this.newRequest(BrowserStackClient.Method.GET, session.getLogUrl(), false);
            request.getHttpRequest().getHeaders().setAccept("*/*");
            return request.asString();
        }
        catch (BrowserStackException e) {
            throw new AutomateException(e);
        }
    }

    @Override
    public final String getSessionVideo(String sessionId) throws SessionNotFound, AutomateException {
        return this.getSession(sessionId).getVideoUrl();
    }

    @Override
    public final boolean deleteSession(String sessionId) throws SessionNotFound, AutomateException {
        try {
            ObjectNode result = this.newRequest(BrowserStackClient.Method.DELETE, "/sessions/{sessionId}.json").routeParam("sessionId", sessionId).asJsonObject();
            String status = result != null ? result.path("status").asText() : null;
            return status != null && status.equals("ok");
        }
        catch (BrowserStackException e) {
            throw new AutomateException(e);
        }
    }

    @Override
    public final String recycleKey() throws AutomateException {
        String newAccessKey;
        ObjectNode result;
        try {
            result = this.newRequest(BrowserStackClient.Method.PUT, "/recycle_key.json").body("{}").asJsonObject();
        }
        catch (BrowserStackException e) {
            throw new AutomateException(e);
        }
        String string = newAccessKey = result != null ? result.path("new_key").asText() : null;
        if (newAccessKey == null || newAccessKey.trim().length() == 0) {
            throw new AutomateException("Failed to recycle key", 400);
        }
        this.setAccessKey(newAccessKey);
        return newAccessKey;
    }

    private static interface Filters {
        public static final String LIMIT = "limit";
        public static final String FILTER = "filter";
    }
}

