/*
 * Decompiled with CFR 0.152.
 */
package com.browserstack.automate;

import com.browserstack.automate.Automate;
import com.browserstack.automate.exception.AutomateException;
import com.browserstack.automate.exception.BuildNotFound;
import com.browserstack.automate.exception.ProjectNotFound;
import com.browserstack.automate.exception.SessionNotFound;
import com.browserstack.automate.model.AccountUsage;
import com.browserstack.automate.model.Build;
import com.browserstack.automate.model.Project;
import com.browserstack.automate.model.ProjectNode;
import com.browserstack.automate.model.Session;
import com.browserstack.automate.model.SessionNode;
import com.browserstack.client.BrowserStackClient;
import com.browserstack.client.BrowserStackRequest;
import com.browserstack.client.exception.BrowserStackException;
import com.browserstack.client.exception.BrowserStackObjectNotFound;
import com.browserstack.client.model.Browser;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class AutomateClient
extends BrowserStackClient
implements Automate {
    private static final String BASE_URL = "https://www.browserstack.com/automate";
    private static final String CACHE_KEY_BROWSERS = "browsers";

    public AutomateClient(String username, String accessKey) {
        super(System.getProperty("browserstack.automate.api", BASE_URL), username, accessKey);
    }

    @Override
    public final AccountUsage getAccountUsage() throws AutomateException {
        try {
            return this.newRequest(BrowserStackClient.Method.GET, "/plan.json").asObject(AccountUsage.class);
        }
        catch (BrowserStackException e) {
            throw new AutomateException(e);
        }
    }

    @Override
    public final List<Browser> getBrowsers() throws AutomateException {
        return this.getBrowsers(true);
    }

    @Override
    public final List<Browser> getBrowsers(boolean cache) throws AutomateException {
        try {
            List browsers;
            if (cache && this.cacheMap.containsKey(CACHE_KEY_BROWSERS) && (browsers = (List)this.cacheMap.get(CACHE_KEY_BROWSERS)) != null && browsers.size() > 0) {
                return browsers;
            }
            browsers = Arrays.asList((Object[])this.newRequest(BrowserStackClient.Method.GET, "/browsers.json").asObject(Browser[].class));
            if (cache) {
                this.cacheMap.put(CACHE_KEY_BROWSERS, browsers);
            }
            return browsers;
        }
        catch (BrowserStackException e) {
            throw new AutomateException(e);
        }
    }

    @Override
    public final List<Project> getProjects() throws AutomateException {
        ArrayList<Project> projects = new ArrayList();
        try {
            projects = Arrays.asList((Object[])this.newRequest(BrowserStackClient.Method.GET, "/projects.json").asObject(Project[].class));
        }
        catch (BrowserStackException e) {
            throw new AutomateException(e);
        }
        return projects;
    }

    @Override
    public final Project getProject(int projectId) throws ProjectNotFound, AutomateException {
        try {
            ProjectNode projectNode = this.newRequest(BrowserStackClient.Method.GET, "/projects/{projectId}.json").routeParam("projectId", "" + projectId).asObject(ProjectNode.class);
            if (projectNode.getProject() == null) {
                throw new ProjectNotFound("Project not found: " + projectId);
            }
            return (Project)projectNode.getProject().setClient(this);
        }
        catch (BrowserStackObjectNotFound e) {
            throw new ProjectNotFound("Project not found: " + projectId);
        }
        catch (BrowserStackException e) {
            throw new AutomateException(e);
        }
    }

    @Override
    public final boolean deleteProject(int projectId) throws AutomateException {
        try {
            ObjectNode result = this.newRequest(BrowserStackClient.Method.DELETE, "/projects/{projectId}.json").routeParam("projectId", "" + projectId).asJsonObject();
            String status = result != null ? result.path("status").asText() : null;
            return status != null && status.equals("ok");
        }
        catch (BrowserStackException e) {
            throw new AutomateException(e);
        }
    }

    @Override
    public final List<Build> getBuilds(Automate.BuildStatus status, int limit) throws AutomateException {
        try {
            return super.getBuilds(status, limit);
        }
        catch (BrowserStackException e) {
            throw new AutomateException(e);
        }
    }

    @Override
    public final List<Build> getBuilds() throws AutomateException {
        return this.getBuilds(null, 0);
    }

    @Override
    public final List<Build> getBuilds(int limit) throws AutomateException {
        return this.getBuilds(null, limit);
    }

    @Override
    public final List<Build> getBuilds(Automate.BuildStatus status) throws AutomateException {
        return this.getBuilds(status, 0);
    }

    @Override
    public final Build getBuild(String buildId) throws BuildNotFound, AutomateException {
        try {
            return super.getBuild(buildId);
        }
        catch (BrowserStackException e) {
            throw new AutomateException(e);
        }
    }

    @Override
    public final boolean deleteBuild(String buildId) throws AutomateException {
        try {
            return super.deleteBuild(buildId);
        }
        catch (BrowserStackException e) {
            throw new AutomateException(e);
        }
    }

    @Override
    public final List<Session> getSessions(String buildId, Automate.BuildStatus status, int limit) throws BuildNotFound, AutomateException {
        try {
            return super.getSessions(buildId, status, limit);
        }
        catch (BrowserStackException e) {
            throw new AutomateException(e);
        }
    }

    @Override
    public final List<Session> getSessions(String buildId) throws BuildNotFound, AutomateException {
        return this.getSessions(buildId, null, 0);
    }

    @Override
    public final List<Session> getSessions(String buildId, int limit) throws BuildNotFound, AutomateException {
        return this.getSessions(buildId, null, limit);
    }

    @Override
    public final List<Session> getSessions(String buildId, Automate.BuildStatus status) throws BuildNotFound, AutomateException {
        return this.getSessions(buildId, status, 0);
    }

    @Override
    public final Session getSession(String sessionId) throws SessionNotFound, AutomateException {
        try {
            return super.getSession(sessionId);
        }
        catch (BrowserStackException e) {
            throw new AutomateException(e);
        }
    }

    @Override
    public final Session updateSessionStatus(String sessionId, Map<String, Object> data) throws AutomateException {
        try {
            return (Session)this.newRequest(BrowserStackClient.Method.PUT, "/sessions/{sessionId}.json", data).routeParam("sessionId", sessionId).asObject(SessionNode.class).getSession().setClient(this);
        }
        catch (BrowserStackException e) {
            throw new AutomateException(e);
        }
    }

    @Override
    public final Session updateSessionStatus(String sessionId, Automate.SessionStatus sessionStatus, String reason) throws SessionNotFound, AutomateException {
        HashMap<String, Object> data = new HashMap<String, Object>();
        if (sessionStatus != null) {
            data.put("status", sessionStatus.name().toLowerCase());
        }
        if (reason != null && reason.trim().length() > 0) {
            data.put("reason", reason);
        }
        return this.updateSessionStatus(sessionId, data);
    }

    @Override
    public final Session updateSessionStatus(String sessionId, Automate.SessionStatus sessionStatus) throws SessionNotFound, AutomateException {
        return this.updateSessionStatus(sessionId, sessionStatus);
    }

    @Override
    public final String getSessionLogs(String sessionId) throws SessionNotFound, AutomateException {
        return this.getSessionLogs(this.getSession(sessionId));
    }

    @Override
    public final String getSessionLogs(Session session) throws AutomateException {
        if (session == null) {
            throw new AutomateException("Invalid session", 400);
        }
        if (session.getLogUrl() == null) {
            throw new AutomateException("Session logs not found", 404);
        }
        try {
            BrowserStackRequest request = this.newRequest(BrowserStackClient.Method.GET, session.getLogUrl(), false);
            request.getHttpRequest().getHeaders().setAccept("*/*");
            return request.asString();
        }
        catch (BrowserStackException e) {
            throw new AutomateException(e);
        }
    }

    @Override
    public final String getSessionVideo(String sessionId) throws SessionNotFound, AutomateException {
        return this.getSession(sessionId).getVideoUrl();
    }

    @Override
    public final boolean deleteSession(String sessionId) throws SessionNotFound, AutomateException {
        try {
            ObjectNode result = this.newRequest(BrowserStackClient.Method.DELETE, "/sessions/{sessionId}.json").routeParam("sessionId", sessionId).asJsonObject();
            String status = result != null ? result.path("status").asText() : null;
            return status != null && status.equals("ok");
        }
        catch (BrowserStackException e) {
            throw new AutomateException(e);
        }
    }

    @Override
    public final String recycleKey() throws AutomateException {
        String newAccessKey;
        ObjectNode result;
        try {
            result = this.newRequest(BrowserStackClient.Method.PUT, "/recycle_key.json").body("{}").asJsonObject();
        }
        catch (BrowserStackException e) {
            throw new AutomateException(e);
        }
        String string = newAccessKey = result != null ? result.path("new_key").asText() : null;
        if (newAccessKey == null || newAccessKey.trim().length() == 0) {
            throw new AutomateException("Failed to recycle key", 400);
        }
        this.setAccessKey(newAccessKey);
        return newAccessKey;
    }

    private static interface Filters {
        public static final String LIMIT = "limit";
        public static final String FILTER = "filter";
    }
}

