/*
 * Decompiled with CFR 0.152.
 */
package com.cloudconvert.resource;

import com.cloudconvert.client.mapper.ObjectMapperProvider;
import com.cloudconvert.client.setttings.SettingsProvider;
import com.cloudconvert.dto.request.CaptureWebsitesTaskRequest;
import com.cloudconvert.dto.request.ConvertFilesTaskRequest;
import com.cloudconvert.dto.request.CreateArchivesTaskRequest;
import com.cloudconvert.dto.request.CreateThumbnailsTaskRequest;
import com.cloudconvert.dto.request.ExecuteCommandsTaskRequest;
import com.cloudconvert.dto.request.GetMetadataTaskRequest;
import com.cloudconvert.dto.request.MergeFilesTaskRequest;
import com.cloudconvert.dto.request.OptimizeFilesTaskRequest;
import com.cloudconvert.dto.request.WriteMetadataTaskRequest;
import com.cloudconvert.dto.response.OperationResponse;
import com.cloudconvert.dto.response.Pageable;
import com.cloudconvert.dto.response.TaskResponse;
import com.cloudconvert.dto.result.AbstractResult;
import com.cloudconvert.resource.AbstractCaptureWebsitesResource;
import com.cloudconvert.resource.AbstractConvertFilesResource;
import com.cloudconvert.resource.AbstractCreateArchivesResource;
import com.cloudconvert.resource.AbstractCreateThumbnailsResource;
import com.cloudconvert.resource.AbstractExecuteCommandsResource;
import com.cloudconvert.resource.AbstractGetMetadataResource;
import com.cloudconvert.resource.AbstractMergeFilesResource;
import com.cloudconvert.resource.AbstractOptimizeFilesResource;
import com.cloudconvert.resource.AbstractResource;
import com.cloudconvert.resource.AbstractWriteMetadataResource;
import com.cloudconvert.resource.params.Filter;
import com.cloudconvert.resource.params.Include;
import com.cloudconvert.resource.params.Pagination;
import com.cloudconvert.resource.params.converter.AlternativeToNameValuePairsConverter;
import com.cloudconvert.resource.params.converter.FiltersToNameValuePairsConverter;
import com.cloudconvert.resource.params.converter.IncludesToNameValuePairsConverter;
import com.cloudconvert.resource.params.converter.PaginationToNameValuePairsConverter;
import com.google.common.collect.ImmutableList;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.List;
import java.util.Map;
import org.apache.http.NameValuePair;
import org.apache.http.client.methods.HttpDelete;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractTasksResource<TRAR extends AbstractResult<TaskResponse>, TRPAR extends AbstractResult<Pageable<TaskResponse>>, VAR extends AbstractResult<Void>, ORPAR extends AbstractResult<Pageable<OperationResponse>>>
extends AbstractResource {
    public static final String PATH_SEGMENT_TASKS = "tasks";
    public static final String PATH_SEGMENT_OPERATIONS = "operations";
    public static final String PATH_SEGMENT_WAIT = "wait";
    public static final String PATH_SEGMENT_CANCEL = "cancel";
    public static final String PATH_SEGMENT_RETRY = "retry";
    private final AbstractConvertFilesResource<TRAR, ORPAR> abstractConvertFilesResource;
    private final AbstractOptimizeFilesResource<TRAR> abstractOptimizeFilesResource;
    private final AbstractCaptureWebsitesResource<TRAR> abstractCaptureWebsitesResource;
    private final AbstractMergeFilesResource<TRAR> abstractMergeFilesResource;
    private final AbstractCreateArchivesResource<TRAR> abstractCreateArchivesResource;
    private final AbstractExecuteCommandsResource<TRAR> abstractExecuteCommandsResource;
    private final AbstractCreateThumbnailsResource<TRAR> abstractCreateThumbnailsResource;
    private final AbstractGetMetadataResource<TRAR> abstractGetMetadataResource;
    private final AbstractWriteMetadataResource<TRAR> abstractWriteMetadataResource;
    private final IncludesToNameValuePairsConverter includesToNameValuePairsConverter;
    private final FiltersToNameValuePairsConverter filtersToNameValuePairsConverter;
    private final AlternativeToNameValuePairsConverter alternativeToNameValuePairsConverter;
    private final PaginationToNameValuePairsConverter paginationToNameValuePairsConverter;

    public AbstractTasksResource(SettingsProvider settingsProvider, ObjectMapperProvider objectMapperProvider, AbstractConvertFilesResource<TRAR, ORPAR> abstractConvertFilesResource, AbstractOptimizeFilesResource<TRAR> abstractOptimizeFilesResource, AbstractCaptureWebsitesResource<TRAR> abstractCaptureWebsitesResource, AbstractMergeFilesResource<TRAR> abstractMergeFilesResource, AbstractCreateArchivesResource<TRAR> abstractCreateArchivesResource, AbstractExecuteCommandsResource<TRAR> abstractExecuteCommandsResource, AbstractCreateThumbnailsResource<TRAR> abstractCreateThumbnailsResource, AbstractGetMetadataResource<TRAR> abstractGetMetadataResourceResource, AbstractWriteMetadataResource<TRAR> abstractWriteMetadataResourceResource) {
        super(settingsProvider, objectMapperProvider);
        this.abstractConvertFilesResource = abstractConvertFilesResource;
        this.abstractOptimizeFilesResource = abstractOptimizeFilesResource;
        this.abstractCaptureWebsitesResource = abstractCaptureWebsitesResource;
        this.abstractMergeFilesResource = abstractMergeFilesResource;
        this.abstractCreateArchivesResource = abstractCreateArchivesResource;
        this.abstractExecuteCommandsResource = abstractExecuteCommandsResource;
        this.abstractCreateThumbnailsResource = abstractCreateThumbnailsResource;
        this.abstractGetMetadataResource = abstractGetMetadataResourceResource;
        this.abstractWriteMetadataResource = abstractWriteMetadataResourceResource;
        this.includesToNameValuePairsConverter = new IncludesToNameValuePairsConverter();
        this.filtersToNameValuePairsConverter = new FiltersToNameValuePairsConverter();
        this.alternativeToNameValuePairsConverter = new AlternativeToNameValuePairsConverter();
        this.paginationToNameValuePairsConverter = new PaginationToNameValuePairsConverter();
    }

    public abstract TRAR show(@NotNull String var1) throws IOException, URISyntaxException;

    public abstract TRAR show(@NotNull String var1, @NotNull List<Include> var2) throws IOException, URISyntaxException;

    protected HttpUriRequest getShowHttpUriRequest(@NotNull String taskId, @NotNull List<Include> includes) throws URISyntaxException {
        ImmutableList nameValuePairs = ImmutableList.builder().addAll(this.includesToNameValuePairsConverter.convert(includes)).build();
        URI uri = this.getUri((List<String>)ImmutableList.of((Object)PATH_SEGMENT_TASKS, (Object)taskId), (List<NameValuePair>)nameValuePairs);
        return this.getHttpUriRequest(HttpGet.class, uri);
    }

    public abstract TRAR wait(@NotNull String var1) throws IOException, URISyntaxException;

    protected HttpUriRequest getWaitHttpUriRequest(@NotNull String taskId) throws URISyntaxException {
        URI uri = this.getUri((List<String>)ImmutableList.of((Object)PATH_SEGMENT_TASKS, (Object)taskId, (Object)PATH_SEGMENT_WAIT));
        return this.getHttpUriRequest(HttpGet.class, uri);
    }

    public abstract TRPAR list() throws IOException, URISyntaxException;

    public abstract TRPAR list(@NotNull Map<Filter, String> var1) throws IOException, URISyntaxException;

    public abstract TRPAR list(@NotNull Map<Filter, String> var1, @NotNull List<Include> var2) throws IOException, URISyntaxException;

    public abstract TRPAR list(@NotNull Map<Filter, String> var1, @NotNull List<Include> var2, @Nullable Pagination var3) throws IOException, URISyntaxException;

    protected HttpUriRequest getListHttpUriRequest(@NotNull Map<Filter, String> filters, @NotNull List<Include> includes, @Nullable Pagination pagination) throws URISyntaxException {
        ImmutableList nameValuePairs = ImmutableList.builder().addAll(this.filtersToNameValuePairsConverter.convert(filters)).addAll(this.includesToNameValuePairsConverter.convert(includes)).addAll(this.paginationToNameValuePairsConverter.convert(pagination)).build();
        URI uri = this.getUri((List<String>)ImmutableList.of((Object)PATH_SEGMENT_TASKS), (List<NameValuePair>)nameValuePairs);
        return this.getHttpUriRequest(HttpGet.class, uri);
    }

    public abstract TRAR cancel(@NotNull String var1) throws IOException, URISyntaxException;

    protected HttpUriRequest getCancelHttpUriRequest(@NotNull String taskId) throws URISyntaxException {
        URI uri = this.getUri((List<String>)ImmutableList.of((Object)PATH_SEGMENT_TASKS, (Object)taskId, (Object)PATH_SEGMENT_CANCEL));
        return this.getHttpUriRequest(HttpPost.class, uri);
    }

    public abstract TRAR retry(@NotNull String var1) throws IOException, URISyntaxException;

    protected HttpUriRequest getRetryHttpUriRequest(@NotNull String taskId) throws URISyntaxException {
        URI uri = this.getUri((List<String>)ImmutableList.of((Object)PATH_SEGMENT_TASKS, (Object)taskId, (Object)PATH_SEGMENT_RETRY));
        return this.getHttpUriRequest(HttpPost.class, uri);
    }

    public abstract VAR delete(@NotNull String var1) throws IOException, URISyntaxException;

    protected HttpUriRequest getDeleteHttpUriRequest(@NotNull String taskId) throws URISyntaxException {
        URI uri = this.getUri((List<String>)ImmutableList.of((Object)PATH_SEGMENT_TASKS, (Object)taskId));
        return this.getHttpUriRequest(HttpDelete.class, uri);
    }

    public abstract ORPAR operations() throws IOException, URISyntaxException;

    public abstract ORPAR operations(@NotNull Map<Filter, String> var1) throws IOException, URISyntaxException;

    public abstract ORPAR operations(@NotNull Map<Filter, String> var1, @NotNull List<Include> var2) throws IOException, URISyntaxException;

    public abstract ORPAR operations(@NotNull Map<Filter, String> var1, @NotNull List<Include> var2, @Nullable Boolean var3) throws IOException, URISyntaxException;

    protected HttpUriRequest getOperationsHttpUriRequest(@NotNull Map<Filter, String> filters, @NotNull List<Include> includes, @Nullable Boolean alternative) throws URISyntaxException {
        ImmutableList nameValuePairs = ImmutableList.builder().addAll(this.filtersToNameValuePairsConverter.convert(filters)).addAll(this.includesToNameValuePairsConverter.convert(includes)).addAll(this.alternativeToNameValuePairsConverter.convert(alternative)).build();
        URI uri = this.getUri((List<String>)ImmutableList.of((Object)PATH_SEGMENT_OPERATIONS), (List<NameValuePair>)nameValuePairs);
        return this.getHttpUriRequest(HttpGet.class, uri);
    }

    public abstract TRAR convert(@NotNull ConvertFilesTaskRequest var1) throws IOException, URISyntaxException;

    public abstract ORPAR convertFormats() throws IOException, URISyntaxException;

    public abstract ORPAR convertFormats(@NotNull Map<Filter, String> var1) throws IOException, URISyntaxException;

    public abstract ORPAR convertFormats(@NotNull Map<Filter, String> var1, @NotNull List<Include> var2) throws IOException, URISyntaxException;

    public abstract ORPAR convertFormats(@NotNull Map<Filter, String> var1, @NotNull List<Include> var2, @Nullable Boolean var3) throws IOException, URISyntaxException;

    public abstract TRAR optimize(@NotNull OptimizeFilesTaskRequest var1) throws IOException, URISyntaxException;

    public abstract TRAR capture(@NotNull CaptureWebsitesTaskRequest var1) throws IOException, URISyntaxException;

    public abstract TRAR merge(@NotNull MergeFilesTaskRequest var1) throws IOException, URISyntaxException;

    public abstract TRAR archive(@NotNull CreateArchivesTaskRequest var1) throws IOException, URISyntaxException;

    public abstract TRAR command(@NotNull ExecuteCommandsTaskRequest var1) throws IOException, URISyntaxException;

    public abstract TRAR thumbnail(@NotNull CreateThumbnailsTaskRequest var1) throws IOException, URISyntaxException;

    public abstract TRAR metadata(@NotNull GetMetadataTaskRequest var1) throws IOException, URISyntaxException;

    public abstract TRAR writeMetadata(@NotNull WriteMetadataTaskRequest var1) throws IOException, URISyntaxException;

    @Override
    public void close() throws IOException {
        this.abstractConvertFilesResource.close();
        this.abstractOptimizeFilesResource.close();
        this.abstractCaptureWebsitesResource.close();
        this.abstractMergeFilesResource.close();
        this.abstractCreateArchivesResource.close();
        this.abstractExecuteCommandsResource.close();
        this.abstractCreateThumbnailsResource.close();
        this.abstractGetMetadataResource.close();
        this.abstractWriteMetadataResource.close();
    }

    public AbstractConvertFilesResource<TRAR, ORPAR> getAbstractConvertFilesResource() {
        return this.abstractConvertFilesResource;
    }

    public AbstractOptimizeFilesResource<TRAR> getAbstractOptimizeFilesResource() {
        return this.abstractOptimizeFilesResource;
    }

    public AbstractCaptureWebsitesResource<TRAR> getAbstractCaptureWebsitesResource() {
        return this.abstractCaptureWebsitesResource;
    }

    public AbstractMergeFilesResource<TRAR> getAbstractMergeFilesResource() {
        return this.abstractMergeFilesResource;
    }

    public AbstractCreateArchivesResource<TRAR> getAbstractCreateArchivesResource() {
        return this.abstractCreateArchivesResource;
    }

    public AbstractExecuteCommandsResource<TRAR> getAbstractExecuteCommandsResource() {
        return this.abstractExecuteCommandsResource;
    }

    public AbstractCreateThumbnailsResource<TRAR> getAbstractCreateThumbnailsResource() {
        return this.abstractCreateThumbnailsResource;
    }

    public AbstractGetMetadataResource<TRAR> getAbstractGetMetadataResource() {
        return this.abstractGetMetadataResource;
    }

    public AbstractWriteMetadataResource<TRAR> getAbstractWriteMetadataResource() {
        return this.abstractWriteMetadataResource;
    }
}

