/*
 * Decompiled with CFR 0.152.
 */
package com.cloudconvert.resource;

import com.cloudconvert.client.mapper.ObjectMapperProvider;
import com.cloudconvert.client.setttings.SettingsProvider;
import com.cloudconvert.dto.request.Request;
import com.cloudconvert.dto.response.JobResponse;
import com.cloudconvert.dto.response.OperationResponse;
import com.cloudconvert.dto.response.Pageable;
import com.cloudconvert.dto.response.TaskResponse;
import com.cloudconvert.dto.response.UserResponse;
import com.cloudconvert.dto.response.WebhookResponse;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.io.Closeable;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import lombok.Generated;
import org.apache.http.HttpEntity;
import org.apache.http.NameValuePair;
import org.apache.http.client.methods.HttpDelete;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpHead;
import org.apache.http.client.methods.HttpOptions;
import org.apache.http.client.methods.HttpPatch;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.methods.HttpTrace;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.methods.RequestBuilder;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.entity.ByteArrayEntity;
import org.apache.http.entity.ContentType;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractResource
implements Closeable {
    public static final String HEADER_AUTHORIZATION = "Authorization";
    public static final String HEADER_USER_AGENT = "User-Agent";
    public static final String V2 = "v2";
    public static final String BEARER = "Bearer";
    public static final String VALUE_USER_AGENT = "cloudconvert-java/v2 (https://github.com/cloudconvert/cloudconvert-java)";
    public static final TypeReference<Void> VOID_TYPE_REFERENCE = new TypeReference<Void>(){};
    public static final TypeReference<InputStream> INPUT_STREAM_TYPE_REFERENCE = new TypeReference<InputStream>(){};
    public static final TypeReference<Map<String, Object>> MAP_STRING_TO_OBJECT_TYPE_REFERENCE = new TypeReference<Map<String, Object>>(){};
    public static final TypeReference<TaskResponse> TASK_RESPONSE_TYPE_REFERENCE = new TypeReference<TaskResponse>(){};
    public static final TypeReference<JobResponse> JOB_RESPONSE_TYPE_REFERENCE = new TypeReference<JobResponse>(){};
    public static final TypeReference<UserResponse> USER_RESPONSE_TYPE_REFERENCE = new TypeReference<UserResponse>(){};
    public static final TypeReference<WebhookResponse> WEBHOOKS_RESPONSE_TYPE_REFERENCE = new TypeReference<WebhookResponse>(){};
    public static final TypeReference<Pageable<OperationResponse>> OPERATION_RESPONSE_PAGEABLE_TYPE_REFERENCE = new TypeReference<Pageable<OperationResponse>>(){};
    public static final TypeReference<Pageable<TaskResponse>> TASK_RESPONSE_PAGEABLE_TYPE_REFERENCE = new TypeReference<Pageable<TaskResponse>>(){};
    public static final TypeReference<Pageable<JobResponse>> JOB_RESPONSE_PAGEABLE_TYPE_REFERENCE = new TypeReference<Pageable<JobResponse>>(){};
    public static final TypeReference<Pageable<WebhookResponse>> WEBHOOKS_RESPONSE_PAGEABLE_TYPE_REFERENCE = new TypeReference<Pageable<WebhookResponse>>(){};
    private final SettingsProvider settingsProvider;
    private final ObjectMapperProvider objectMapperProvider;
    private final Map<Class<? extends HttpRequestBase>, Supplier<RequestBuilder>> requestBuilderProviders;

    public AbstractResource(SettingsProvider settingsProvider, ObjectMapperProvider objectMapperProvider) {
        this.settingsProvider = settingsProvider;
        this.objectMapperProvider = objectMapperProvider;
        this.requestBuilderProviders = ImmutableMap.builder().put(HttpGet.class, RequestBuilder::get).put(HttpPost.class, RequestBuilder::post).put(HttpPut.class, RequestBuilder::put).put(HttpDelete.class, RequestBuilder::delete).put(HttpHead.class, RequestBuilder::head).put(HttpOptions.class, RequestBuilder::options).put(HttpPatch.class, RequestBuilder::patch).put(HttpTrace.class, RequestBuilder::trace).build();
    }

    protected Map<String, Object> requestToMap(Request request) {
        Map map = (Map)this.objectMapperProvider.provide().convertValue((Object)request, MAP_STRING_TO_OBJECT_TYPE_REFERENCE);
        request.getProperties().forEach(map::putIfAbsent);
        return map;
    }

    protected URI getUri(List<String> pathSegments) throws URISyntaxException {
        return this.getUri(pathSegments, (List<NameValuePair>)ImmutableList.of());
    }

    protected URI getUri(List<String> pathSegments, List<NameValuePair> nameValuePairs) throws URISyntaxException {
        ImmutableList v2PathSegments = ImmutableList.builder().add((Object)V2).addAll(pathSegments).build();
        return new URIBuilder(this.settingsProvider.getApiUrl()).setPathSegments((List)v2PathSegments).setParameters(nameValuePairs).build();
    }

    protected URI getSyncUri(List<String> pathSegments) throws URISyntaxException {
        return this.getSyncUri(pathSegments, (List<NameValuePair>)ImmutableList.of());
    }

    protected URI getSyncUri(List<String> pathSegments, List<NameValuePair> nameValuePairs) throws URISyntaxException {
        ImmutableList v2PathSegments = ImmutableList.builder().add((Object)V2).addAll(pathSegments).build();
        return new URIBuilder(this.settingsProvider.getSyncApiUrl()).setPathSegments((List)v2PathSegments).setParameters(nameValuePairs).build();
    }

    protected HttpEntity getHttpEntity(Request request) throws JsonProcessingException {
        return this.getHttpEntity(this.requestToMap(request));
    }

    protected HttpEntity getHttpEntity(Map<String, Object> map) throws JsonProcessingException {
        return new ByteArrayEntity(this.objectMapperProvider.provide().writeValueAsBytes(map), ContentType.APPLICATION_JSON);
    }

    protected String getJson(Map<String, Object> map) throws JsonProcessingException {
        return this.objectMapperProvider.provide().writeValueAsString(map);
    }

    protected HttpUriRequest getHttpUriRequest(Class<? extends HttpRequestBase> httpRequestBaseClass, URI uri) {
        return this.getHttpUriRequest(httpRequestBaseClass, uri, null);
    }

    protected HttpUriRequest getHttpUriRequest(Class<? extends HttpRequestBase> httpRequestBaseClass, URI uri, @Nullable HttpEntity httpEntity) {
        return this.requestBuilderProviders.get(httpRequestBaseClass).get().setUri(uri).setEntity(httpEntity).setHeader(HEADER_USER_AGENT, VALUE_USER_AGENT).setHeader(HEADER_AUTHORIZATION, "Bearer " + this.settingsProvider.getApiKey()).build();
    }

    @Generated
    public SettingsProvider getSettingsProvider() {
        return this.settingsProvider;
    }
}

