/*
 * Decompiled with CFR 0.152.
 */
package java.util;

import java.util.AbstractCollection;
import java.util.Collection;
import java.util.Iterator;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractSet<E>
extends AbstractCollection<E>
implements Set<E> {
    protected AbstractSet() {
    }

    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object instanceof Set) {
            Set s = (Set)object;
            try {
                return this.size() == s.size() && this.containsAll(s);
            }
            catch (NullPointerException ignored) {
                return false;
            }
            catch (ClassCastException ignored) {
                return false;
            }
        }
        return false;
    }

    @Override
    public int hashCode() {
        int result = 0;
        for (Object next : this) {
            result += next == null ? 0 : next.hashCode();
        }
        return result;
    }

    @Override
    public boolean removeAll(Collection<?> collection) {
        boolean result = false;
        if (this.size() <= collection.size()) {
            Iterator it = this.iterator();
            while (it.hasNext()) {
                if (!collection.contains(it.next())) continue;
                it.remove();
                result = true;
            }
        } else {
            Iterator<?> it = collection.iterator();
            while (it.hasNext()) {
                result = this.remove(it.next()) || result;
            }
        }
        return result;
    }
}

