/*
 * Decompiled with CFR 0.152.
 */
package java.util;

import java.util.AbstractCollection;
import java.util.AbstractSet;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.ConcurrentModificationException;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Map;
import java.util.MapEntry;
import java.util.NoSuchElementException;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Hashtable<K, V>
extends Dictionary<K, V>
implements Map<K, V> {
    transient int elementCount;
    transient Entry<K, V>[] elementData;
    private float loadFactor;
    private int threshold;
    transient int firstSlot;
    transient int lastSlot = -1;
    transient int modCount;
    private static final Enumeration<?> EMPTY_ENUMERATION = new Enumeration<Object>(){

        @Override
        public boolean hasMoreElements() {
            return false;
        }

        @Override
        public Object nextElement() {
            throw new NoSuchElementException();
        }
    };
    private static final Iterator<?> EMPTY_ITERATOR = new Iterator<Object>(){

        @Override
        public boolean hasNext() {
            return false;
        }

        @Override
        public Object next() {
            throw new NoSuchElementException();
        }

        @Override
        public void remove() {
            throw new IllegalStateException();
        }
    };

    private static <K, V> Entry<K, V> newEntry(K key, V value, int hash) {
        return new Entry<K, V>(key, value);
    }

    public Hashtable() {
        this(11);
    }

    public Hashtable(int capacity) {
        if (capacity < 0) {
            throw new IllegalArgumentException();
        }
        this.elementCount = 0;
        this.elementData = this.newElementArray(capacity == 0 ? 1 : capacity);
        this.firstSlot = this.elementData.length;
        this.loadFactor = 0.75f;
        this.computeMaxSize();
    }

    public Hashtable(int capacity, float loadFactor) {
        if (capacity < 0 || !(loadFactor > 0.0f)) {
            throw new IllegalArgumentException();
        }
        this.elementCount = 0;
        this.firstSlot = capacity;
        this.elementData = this.newElementArray(capacity == 0 ? 1 : capacity);
        this.loadFactor = loadFactor;
        this.computeMaxSize();
    }

    public Hashtable(Map<? extends K, ? extends V> map) {
        this(map.size() < 6 ? 11 : map.size() * 4 / 3 + 11);
        this.putAll(map);
    }

    private Entry<K, V>[] newElementArray(int size) {
        return new Entry[size];
    }

    @Override
    public synchronized void clear() {
        this.elementCount = 0;
        Arrays.fill(this.elementData, null);
        ++this.modCount;
    }

    private void computeMaxSize() {
        this.threshold = (int)((float)this.elementData.length * this.loadFactor);
    }

    public synchronized boolean contains(Object value) {
        if (value == null) {
            throw new NullPointerException();
        }
        int i = this.elementData.length;
        while (--i >= 0) {
            Entry<K, V> entry = this.elementData[i];
            while (entry != null) {
                if (entry.value.equals(value)) {
                    return true;
                }
                entry = entry.next;
            }
        }
        return false;
    }

    @Override
    public synchronized boolean containsKey(Object key) {
        return this.getEntry(key) != null;
    }

    @Override
    public boolean containsValue(Object value) {
        return this.contains(value);
    }

    @Override
    public synchronized Enumeration<V> elements() {
        if (this.elementCount == 0) {
            return EMPTY_ENUMERATION;
        }
        return new HashEnumIterator(new MapEntry.Type<V, K, V>(){

            @Override
            public V get(MapEntry<K, V> entry) {
                return entry.value;
            }
        }, true);
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        return new Collections.SynchronizedSet<Map.Entry<K, V>>(new AbstractSet<Map.Entry<K, V>>(){

            @Override
            public int size() {
                return Hashtable.this.elementCount;
            }

            @Override
            public void clear() {
                Hashtable.this.clear();
            }

            @Override
            public boolean remove(Object object) {
                if (this.contains(object)) {
                    Hashtable.this.remove(((Map.Entry)object).getKey());
                    return true;
                }
                return false;
            }

            @Override
            public boolean contains(Object object) {
                Entry entry = Hashtable.this.getEntry(((Map.Entry)object).getKey());
                return object.equals(entry);
            }

            @Override
            public Iterator<Map.Entry<K, V>> iterator() {
                return new HashIterator(new MapEntry.Type<Map.Entry<K, V>, K, V>(){

                    @Override
                    public Map.Entry<K, V> get(MapEntry<K, V> entry) {
                        return entry;
                    }
                });
            }
        }, (Object)this);
    }

    @Override
    public synchronized boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object instanceof Map) {
            Map map = (Map)object;
            if (this.size() != map.size()) {
                return false;
            }
            Set<Map.Entry<K, V>> entries = this.entrySet();
            for (Map.Entry e : map.entrySet()) {
                if (entries.contains(e)) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    @Override
    public synchronized V get(Object key) {
        int hash = key.hashCode();
        int index = (hash & Integer.MAX_VALUE) % this.elementData.length;
        Entry<K, V> entry = this.elementData[index];
        while (entry != null) {
            if (entry.equalsKey(key, hash)) {
                return (V)entry.value;
            }
            entry = entry.next;
        }
        return null;
    }

    Entry<K, V> getEntry(Object key) {
        int hash = key.hashCode();
        int index = (hash & Integer.MAX_VALUE) % this.elementData.length;
        Entry<K, V> entry = this.elementData[index];
        while (entry != null) {
            if (entry.equalsKey(key, hash)) {
                return entry;
            }
            entry = entry.next;
        }
        return null;
    }

    @Override
    public synchronized int hashCode() {
        int result = 0;
        for (Map.Entry<K, V> entry : this.entrySet()) {
            V value;
            K key = entry.getKey();
            if (key == this || (value = entry.getValue()) == this) continue;
            int hash = (key != null ? key.hashCode() : 0) ^ (value != null ? value.hashCode() : 0);
            result += hash;
        }
        return result;
    }

    @Override
    public synchronized boolean isEmpty() {
        return this.elementCount == 0;
    }

    @Override
    public synchronized Enumeration<K> keys() {
        if (this.elementCount == 0) {
            return EMPTY_ENUMERATION;
        }
        return new HashEnumIterator(new MapEntry.Type<K, K, V>(){

            @Override
            public K get(MapEntry<K, V> entry) {
                return entry.key;
            }
        }, true);
    }

    @Override
    public Set<K> keySet() {
        return new Collections.SynchronizedSet(new AbstractSet<K>(){

            @Override
            public boolean contains(Object object) {
                return Hashtable.this.containsKey(object);
            }

            @Override
            public int size() {
                return Hashtable.this.elementCount;
            }

            @Override
            public void clear() {
                Hashtable.this.clear();
            }

            @Override
            public boolean remove(Object key) {
                if (Hashtable.this.containsKey(key)) {
                    Hashtable.this.remove(key);
                    return true;
                }
                return false;
            }

            @Override
            public Iterator<K> iterator() {
                if (this.size() == 0) {
                    return EMPTY_ITERATOR;
                }
                return new HashEnumIterator(new MapEntry.Type<K, K, V>(){

                    @Override
                    public K get(MapEntry<K, V> entry) {
                        return entry.key;
                    }
                });
            }
        }, (Object)this);
    }

    @Override
    public synchronized V put(K key, V value) {
        if (key != null && value != null) {
            int hash = key.hashCode();
            int index = (hash & Integer.MAX_VALUE) % this.elementData.length;
            Entry<K, V> entry = this.elementData[index];
            while (entry != null && !entry.equalsKey(key, hash)) {
                entry = entry.next;
            }
            if (entry == null) {
                ++this.modCount;
                if (++this.elementCount > this.threshold) {
                    this.rehash();
                    index = (hash & Integer.MAX_VALUE) % this.elementData.length;
                }
                if (index < this.firstSlot) {
                    this.firstSlot = index;
                }
                if (index > this.lastSlot) {
                    this.lastSlot = index;
                }
                entry = Hashtable.newEntry(key, value, hash);
                entry.next = this.elementData[index];
                this.elementData[index] = entry;
                return null;
            }
            Object result = entry.value;
            entry.value = value;
            return (V)result;
        }
        throw new NullPointerException();
    }

    @Override
    public synchronized void putAll(Map<? extends K, ? extends V> map) {
        for (Map.Entry<K, V> entry : map.entrySet()) {
            this.put(entry.getKey(), entry.getValue());
        }
    }

    protected void rehash() {
        int length = (this.elementData.length << 1) + 1;
        if (length == 0) {
            length = 1;
        }
        int newFirst = length;
        int newLast = -1;
        Entry<K, V>[] newData = this.newElementArray(length);
        int i = this.lastSlot + 1;
        while (--i >= this.firstSlot) {
            Entry<K, V> entry = this.elementData[i];
            while (entry != null) {
                int index = (entry.getKeyHash() & Integer.MAX_VALUE) % length;
                if (index < newFirst) {
                    newFirst = index;
                }
                if (index > newLast) {
                    newLast = index;
                }
                Entry next = entry.next;
                entry.next = newData[index];
                newData[index] = entry;
                entry = next;
            }
        }
        this.firstSlot = newFirst;
        this.lastSlot = newLast;
        this.elementData = newData;
        this.computeMaxSize();
    }

    @Override
    public synchronized V remove(Object key) {
        int hash = key.hashCode();
        int index = (hash & Integer.MAX_VALUE) % this.elementData.length;
        Entry<K, V> last = null;
        Entry<K, V> entry = this.elementData[index];
        while (entry != null && !entry.equalsKey(key, hash)) {
            last = entry;
            entry = entry.next;
        }
        if (entry != null) {
            ++this.modCount;
            if (last == null) {
                this.elementData[index] = entry.next;
            } else {
                last.next = entry.next;
            }
            --this.elementCount;
            Object result = entry.value;
            entry.value = null;
            return (V)result;
        }
        return null;
    }

    @Override
    public synchronized int size() {
        return this.elementCount;
    }

    public synchronized String toString() {
        if (this.isEmpty()) {
            return "{}";
        }
        StringBuffer buffer = new StringBuffer(this.size() * 28);
        buffer.append('{');
        for (int i = this.lastSlot; i >= this.firstSlot; --i) {
            Entry<K, V> entry = this.elementData[i];
            while (entry != null) {
                if (entry.key != this) {
                    buffer.append(entry.key);
                } else {
                    buffer.append("(this)");
                }
                buffer.append('=');
                if (entry.value != this) {
                    buffer.append(entry.value);
                } else {
                    buffer.append("(this)");
                }
                buffer.append(", ");
                entry = entry.next;
            }
        }
        if (this.elementCount > 0) {
            buffer.setLength(buffer.length() - 2);
        }
        buffer.append('}');
        return buffer.toString();
    }

    @Override
    public Collection<V> values() {
        return new Collections.SynchronizedCollection(new AbstractCollection<V>(){

            @Override
            public boolean contains(Object object) {
                return Hashtable.this.contains(object);
            }

            @Override
            public int size() {
                return Hashtable.this.elementCount;
            }

            @Override
            public void clear() {
                Hashtable.this.clear();
            }

            @Override
            public Iterator<V> iterator() {
                return new HashIterator(new MapEntry.Type<V, K, V>(){

                    @Override
                    public V get(MapEntry<K, V> entry) {
                        return entry.value;
                    }
                });
            }
        }, this);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class HashEnumIterator<E>
    extends HashIterator<E>
    implements Enumeration<E> {
        private boolean isEnumeration;
        int start;
        Entry<K, V> entry;

        HashEnumIterator(MapEntry.Type<E, K, V> value) {
            super(value);
            this.isEnumeration = false;
        }

        HashEnumIterator(MapEntry.Type<E, K, V> value, boolean isEnumeration) {
            super(value);
            this.isEnumeration = false;
            this.isEnumeration = isEnumeration;
            this.start = Hashtable.this.lastSlot + 1;
        }

        @Override
        public boolean hasMoreElements() {
            if (this.isEnumeration) {
                if (this.entry != null) {
                    return true;
                }
                while (this.start > Hashtable.this.firstSlot) {
                    if (Hashtable.this.elementData[--this.start] == null) continue;
                    this.entry = Hashtable.this.elementData[this.start];
                    return true;
                }
                return false;
            }
            return super.hasNext();
        }

        @Override
        public boolean hasNext() {
            if (this.isEnumeration) {
                return this.hasMoreElements();
            }
            return super.hasNext();
        }

        @Override
        public E next() {
            if (this.isEnumeration) {
                if (this.expectedModCount == Hashtable.this.modCount) {
                    return this.nextElement();
                }
                throw new ConcurrentModificationException();
            }
            return super.next();
        }

        @Override
        public E nextElement() {
            if (this.isEnumeration) {
                if (this.hasMoreElements()) {
                    Object result = this.type.get(this.entry);
                    this.entry = this.entry.next;
                    return (E)result;
                }
                throw new NoSuchElementException();
            }
            return super.next();
        }

        @Override
        public void remove() {
            if (this.isEnumeration) {
                throw new UnsupportedOperationException();
            }
            super.remove();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class HashIterator<E>
    implements Iterator<E> {
        int position;
        int expectedModCount;
        final MapEntry.Type<E, K, V> type;
        Entry<K, V> lastEntry;
        int lastPosition;
        boolean canRemove = false;

        HashIterator(MapEntry.Type<E, K, V> value) {
            this.type = value;
            this.position = Hashtable.this.lastSlot;
            this.expectedModCount = Hashtable.this.modCount;
        }

        @Override
        public boolean hasNext() {
            if (this.lastEntry != null && this.lastEntry.next != null) {
                return true;
            }
            while (this.position >= Hashtable.this.firstSlot) {
                if (Hashtable.this.elementData[this.position] == null) {
                    --this.position;
                    continue;
                }
                return true;
            }
            return false;
        }

        @Override
        public E next() {
            if (this.expectedModCount == Hashtable.this.modCount) {
                if (this.lastEntry != null) {
                    this.lastEntry = this.lastEntry.next;
                }
                if (this.lastEntry == null) {
                    while (this.position >= Hashtable.this.firstSlot && (this.lastEntry = Hashtable.this.elementData[this.position]) == null) {
                        --this.position;
                    }
                    if (this.lastEntry != null) {
                        this.lastPosition = this.position--;
                    }
                }
                if (this.lastEntry != null) {
                    this.canRemove = true;
                    return this.type.get(this.lastEntry);
                }
                throw new NoSuchElementException();
            }
            throw new ConcurrentModificationException();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void remove() {
            if (this.expectedModCount == Hashtable.this.modCount) {
                if (this.canRemove) {
                    this.canRemove = false;
                    Hashtable hashtable = Hashtable.this;
                    synchronized (hashtable) {
                        boolean removed = false;
                        Entry entry = Hashtable.this.elementData[this.lastPosition];
                        if (entry == this.lastEntry) {
                            Hashtable.this.elementData[this.lastPosition] = entry.next;
                            removed = true;
                        } else {
                            while (entry != null && entry.next != this.lastEntry) {
                                entry = entry.next;
                            }
                            if (entry != null) {
                                entry.next = this.lastEntry.next;
                                removed = true;
                            }
                        }
                        if (removed) {
                            ++Hashtable.this.modCount;
                            --Hashtable.this.elementCount;
                            ++this.expectedModCount;
                            return;
                        }
                    }
                } else {
                    throw new IllegalStateException();
                }
            }
            throw new ConcurrentModificationException();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class Entry<K, V>
    extends MapEntry<K, V> {
        Entry<K, V> next;
        final int hashcode;

        Entry(K theKey, V theValue) {
            super(theKey, theValue);
            this.hashcode = theKey.hashCode();
        }

        @Override
        public V setValue(V object) {
            if (object == null) {
                throw new NullPointerException();
            }
            Object result = this.value;
            this.value = object;
            return (V)result;
        }

        public int getKeyHash() {
            return this.key.hashCode();
        }

        public boolean equalsKey(Object aKey, int hash) {
            return this.hashcode == aKey.hashCode() && this.key.equals(aKey);
        }

        @Override
        public String toString() {
            return this.key + "=" + this.value;
        }
    }
}

