/*
 * Decompiled with CFR 0.152.
 */
package java.util;

import java.lang.reflect.Array;
import java.util.AbstractList;
import java.util.Comparator;
import java.util.List;
import java.util.RandomAccess;

public class Arrays {
    private static final int SIMPLE_LENGTH = 7;

    private Arrays() {
    }

    public static <T> List<T> asList(T ... array) {
        return new ArrayList<T>(array);
    }

    public static int binarySearch(byte[] array, byte value) {
        return Arrays.binarySearch(array, 0, array.length, value);
    }

    public static int binarySearch(char[] array, char value) {
        return Arrays.binarySearch(array, 0, array.length, value);
    }

    public static int binarySearch(double[] array, double value) {
        return Arrays.binarySearch(array, 0, array.length, value);
    }

    public static int binarySearch(float[] array, float value) {
        return Arrays.binarySearch(array, 0, array.length, value);
    }

    public static int binarySearch(int[] array, int value) {
        return Arrays.binarySearch(array, 0, array.length, value);
    }

    public static int binarySearch(long[] array, long value) {
        return Arrays.binarySearch(array, 0, array.length, value);
    }

    public static int binarySearch(Object[] array, Object object) {
        return Arrays.binarySearch(array, 0, array.length, object);
    }

    public static <T> int binarySearch(T[] array, T object, Comparator<? super T> comparator) {
        return Arrays.binarySearch(array, 0, array.length, object, comparator);
    }

    public static int binarySearch(short[] array, short value) {
        return Arrays.binarySearch(array, 0, array.length, value);
    }

    public static int binarySearch(byte[] array, int startIndex, int endIndex, byte value) {
        Arrays.checkIndexForBinarySearch(array.length, startIndex, endIndex);
        int low = startIndex;
        int mid = -1;
        int high = endIndex - 1;
        while (low <= high) {
            mid = low + high >>> 1;
            if (value > array[mid]) {
                low = mid + 1;
                continue;
            }
            if (value == array[mid]) {
                return mid;
            }
            high = mid - 1;
        }
        if (mid < 0) {
            int insertPoint = endIndex;
            for (int index = startIndex; index < endIndex; ++index) {
                if (value >= array[index]) continue;
                insertPoint = index;
            }
            return -insertPoint - 1;
        }
        return -mid - (value < array[mid] ? 1 : 2);
    }

    public static int binarySearch(char[] array, int startIndex, int endIndex, char value) {
        Arrays.checkIndexForBinarySearch(array.length, startIndex, endIndex);
        int low = startIndex;
        int mid = -1;
        int high = endIndex - 1;
        while (low <= high) {
            mid = low + high >>> 1;
            if (value > array[mid]) {
                low = mid + 1;
                continue;
            }
            if (value == array[mid]) {
                return mid;
            }
            high = mid - 1;
        }
        if (mid < 0) {
            int insertPoint = endIndex;
            for (int index = startIndex; index < endIndex; ++index) {
                if (value >= array[index]) continue;
                insertPoint = index;
            }
            return -insertPoint - 1;
        }
        return -mid - (value < array[mid] ? 1 : 2);
    }

    public static int binarySearch(double[] array, int startIndex, int endIndex, double value) {
        Arrays.checkIndexForBinarySearch(array.length, startIndex, endIndex);
        long longBits = Double.doubleToLongBits(value);
        int low = startIndex;
        int mid = -1;
        int high = endIndex - 1;
        while (low <= high) {
            mid = low + high >>> 1;
            if (Arrays.lessThan(array[mid], value)) {
                low = mid + 1;
                continue;
            }
            if (longBits == Double.doubleToLongBits(array[mid])) {
                return mid;
            }
            high = mid - 1;
        }
        if (mid < 0) {
            int insertPoint = endIndex;
            for (int index = startIndex; index < endIndex; ++index) {
                if (!(value < array[index])) continue;
                insertPoint = index;
            }
            return -insertPoint - 1;
        }
        return -mid - (Arrays.lessThan(value, array[mid]) ? 1 : 2);
    }

    public static int binarySearch(float[] array, int startIndex, int endIndex, float value) {
        Arrays.checkIndexForBinarySearch(array.length, startIndex, endIndex);
        int intBits = Float.floatToIntBits(value);
        int low = startIndex;
        int mid = -1;
        int high = endIndex - 1;
        while (low <= high) {
            mid = low + high >>> 1;
            if (Arrays.lessThan(array[mid], value)) {
                low = mid + 1;
                continue;
            }
            if (intBits == Float.floatToIntBits(array[mid])) {
                return mid;
            }
            high = mid - 1;
        }
        if (mid < 0) {
            int insertPoint = endIndex;
            for (int index = startIndex; index < endIndex; ++index) {
                if (!(value < array[index])) continue;
                insertPoint = index;
            }
            return -insertPoint - 1;
        }
        return -mid - (Arrays.lessThan(value, array[mid]) ? 1 : 2);
    }

    public static int binarySearch(int[] array, int startIndex, int endIndex, int value) {
        Arrays.checkIndexForBinarySearch(array.length, startIndex, endIndex);
        int low = startIndex;
        int mid = -1;
        int high = endIndex - 1;
        while (low <= high) {
            mid = low + high >>> 1;
            if (value > array[mid]) {
                low = mid + 1;
                continue;
            }
            if (value == array[mid]) {
                return mid;
            }
            high = mid - 1;
        }
        if (mid < 0) {
            int insertPoint = endIndex;
            for (int index = startIndex; index < endIndex; ++index) {
                if (value >= array[index]) continue;
                insertPoint = index;
            }
            return -insertPoint - 1;
        }
        return -mid - (value < array[mid] ? 1 : 2);
    }

    public static int binarySearch(long[] array, int startIndex, int endIndex, long value) {
        Arrays.checkIndexForBinarySearch(array.length, startIndex, endIndex);
        int low = startIndex;
        int mid = -1;
        int high = endIndex - 1;
        while (low <= high) {
            mid = low + high >>> 1;
            if (value > array[mid]) {
                low = mid + 1;
                continue;
            }
            if (value == array[mid]) {
                return mid;
            }
            high = mid - 1;
        }
        if (mid < 0) {
            int insertPoint = endIndex;
            for (int index = startIndex; index < endIndex; ++index) {
                if (value >= array[index]) continue;
                insertPoint = index;
            }
            return -insertPoint - 1;
        }
        return -mid - (value < array[mid] ? 1 : 2);
    }

    public static int binarySearch(Object[] array, int startIndex, int endIndex, Object object) {
        Arrays.checkIndexForBinarySearch(array.length, startIndex, endIndex);
        if (array.length == 0) {
            return -1;
        }
        int low = startIndex;
        int mid = -1;
        int high = endIndex - 1;
        int result = 0;
        while (low <= high) {
            mid = low + high >>> 1;
            result = ((Comparable)array[mid]).compareTo(object);
            if (result < 0) {
                low = mid + 1;
                continue;
            }
            if (result == 0) {
                return mid;
            }
            high = mid - 1;
        }
        if (mid < 0) {
            int insertPoint = endIndex;
            for (int index = startIndex; index < endIndex; ++index) {
                if (((Comparable)object).compareTo(array[index]) >= 0) continue;
                insertPoint = index;
            }
            return -insertPoint - 1;
        }
        return -mid - (result >= 0 ? 1 : 2);
    }

    public static <T> int binarySearch(T[] array, int startIndex, int endIndex, T object, Comparator<? super T> comparator) {
        Arrays.checkIndexForBinarySearch(array.length, startIndex, endIndex);
        if (comparator == null) {
            return Arrays.binarySearch(array, startIndex, endIndex, object);
        }
        int low = startIndex;
        int mid = -1;
        int high = endIndex - 1;
        int result = 0;
        while (low <= high) {
            mid = low + high >>> 1;
            result = comparator.compare(array[mid], object);
            if (result < 0) {
                low = mid + 1;
                continue;
            }
            if (result == 0) {
                return mid;
            }
            high = mid - 1;
        }
        if (mid < 0) {
            int insertPoint = endIndex;
            for (int index = startIndex; index < endIndex; ++index) {
                if (comparator.compare(object, array[index]) >= 0) continue;
                insertPoint = index;
            }
            return -insertPoint - 1;
        }
        return -mid - (result >= 0 ? 1 : 2);
    }

    public static int binarySearch(short[] array, int startIndex, int endIndex, short value) {
        Arrays.checkIndexForBinarySearch(array.length, startIndex, endIndex);
        int low = startIndex;
        int mid = -1;
        int high = endIndex - 1;
        while (low <= high) {
            mid = low + high >>> 1;
            if (value > array[mid]) {
                low = mid + 1;
                continue;
            }
            if (value == array[mid]) {
                return mid;
            }
            high = mid - 1;
        }
        if (mid < 0) {
            int insertPoint = endIndex;
            for (int index = startIndex; index < endIndex; ++index) {
                if (value >= array[index]) continue;
                insertPoint = index;
            }
            return -insertPoint - 1;
        }
        return -mid - (value < array[mid] ? 1 : 2);
    }

    private static void checkIndexForBinarySearch(int length, int start, int end) {
        if (start > end) {
            throw new IllegalArgumentException();
        }
        if (length < end || 0 > start) {
            throw new ArrayIndexOutOfBoundsException();
        }
    }

    public static void fill(byte[] array, byte value) {
        for (int i = 0; i < array.length; ++i) {
            array[i] = value;
        }
    }

    public static void fill(byte[] array, int start, int end, byte value) {
        Arrays.checkBounds(array.length, start, end);
        for (int i = start; i < end; ++i) {
            array[i] = value;
        }
    }

    public static void fill(short[] array, short value) {
        for (int i = 0; i < array.length; ++i) {
            array[i] = value;
        }
    }

    public static void fill(short[] array, int start, int end, short value) {
        Arrays.checkBounds(array.length, start, end);
        for (int i = start; i < end; ++i) {
            array[i] = value;
        }
    }

    public static void fill(char[] array, char value) {
        for (int i = 0; i < array.length; ++i) {
            array[i] = value;
        }
    }

    public static void fill(char[] array, int start, int end, char value) {
        Arrays.checkBounds(array.length, start, end);
        for (int i = start; i < end; ++i) {
            array[i] = value;
        }
    }

    public static void fill(int[] array, int value) {
        for (int i = 0; i < array.length; ++i) {
            array[i] = value;
        }
    }

    public static void fill(int[] array, int start, int end, int value) {
        Arrays.checkBounds(array.length, start, end);
        for (int i = start; i < end; ++i) {
            array[i] = value;
        }
    }

    public static void fill(long[] array, long value) {
        for (int i = 0; i < array.length; ++i) {
            array[i] = value;
        }
    }

    public static void fill(long[] array, int start, int end, long value) {
        Arrays.checkBounds(array.length, start, end);
        for (int i = start; i < end; ++i) {
            array[i] = value;
        }
    }

    public static void fill(float[] array, float value) {
        for (int i = 0; i < array.length; ++i) {
            array[i] = value;
        }
    }

    public static void fill(float[] array, int start, int end, float value) {
        Arrays.checkBounds(array.length, start, end);
        for (int i = start; i < end; ++i) {
            array[i] = value;
        }
    }

    public static void fill(double[] array, double value) {
        for (int i = 0; i < array.length; ++i) {
            array[i] = value;
        }
    }

    public static void fill(double[] array, int start, int end, double value) {
        Arrays.checkBounds(array.length, start, end);
        for (int i = start; i < end; ++i) {
            array[i] = value;
        }
    }

    public static void fill(boolean[] array, boolean value) {
        for (int i = 0; i < array.length; ++i) {
            array[i] = value;
        }
    }

    public static void fill(boolean[] array, int start, int end, boolean value) {
        Arrays.checkBounds(array.length, start, end);
        for (int i = start; i < end; ++i) {
            array[i] = value;
        }
    }

    public static void fill(Object[] array, Object value) {
        for (int i = 0; i < array.length; ++i) {
            array[i] = value;
        }
    }

    public static void fill(Object[] array, int start, int end, Object value) {
        Arrays.checkBounds(array.length, start, end);
        for (int i = start; i < end; ++i) {
            array[i] = value;
        }
    }

    public static int hashCode(boolean[] array) {
        if (array == null) {
            return 0;
        }
        int hashCode = 1;
        for (boolean element : array) {
            hashCode = 31 * hashCode + (element ? 1231 : 1237);
        }
        return hashCode;
    }

    public static int hashCode(int[] array) {
        if (array == null) {
            return 0;
        }
        int hashCode = 1;
        for (int element : array) {
            hashCode = 31 * hashCode + element;
        }
        return hashCode;
    }

    public static int hashCode(short[] array) {
        if (array == null) {
            return 0;
        }
        int hashCode = 1;
        for (short element : array) {
            hashCode = 31 * hashCode + element;
        }
        return hashCode;
    }

    public static int hashCode(char[] array) {
        if (array == null) {
            return 0;
        }
        int hashCode = 1;
        for (char element : array) {
            hashCode = 31 * hashCode + element;
        }
        return hashCode;
    }

    public static int hashCode(byte[] array) {
        if (array == null) {
            return 0;
        }
        int hashCode = 1;
        for (byte element : array) {
            hashCode = 31 * hashCode + element;
        }
        return hashCode;
    }

    public static int hashCode(long[] array) {
        if (array == null) {
            return 0;
        }
        int hashCode = 1;
        for (long elementValue : array) {
            hashCode = 31 * hashCode + (int)(elementValue ^ elementValue >>> 32);
        }
        return hashCode;
    }

    public static int hashCode(float[] array) {
        if (array == null) {
            return 0;
        }
        int hashCode = 1;
        for (float element : array) {
            hashCode = 31 * hashCode + Float.floatToIntBits(element);
        }
        return hashCode;
    }

    public static int hashCode(double[] array) {
        if (array == null) {
            return 0;
        }
        int hashCode = 1;
        for (double element : array) {
            long v = Double.doubleToLongBits(element);
            hashCode = 31 * hashCode + (int)(v ^ v >>> 32);
        }
        return hashCode;
    }

    public static int hashCode(Object[] array) {
        if (array == null) {
            return 0;
        }
        int hashCode = 1;
        for (Object element : array) {
            int elementHashCode = element == null ? 0 : element.hashCode();
            hashCode = 31 * hashCode + elementHashCode;
        }
        return hashCode;
    }

    public static int deepHashCode(Object[] array) {
        if (array == null) {
            return 0;
        }
        int hashCode = 1;
        for (Object element : array) {
            int elementHashCode = Arrays.deepHashCodeElement(element);
            hashCode = 31 * hashCode + elementHashCode;
        }
        return hashCode;
    }

    private static int deepHashCodeElement(Object element) {
        if (element == null) {
            return 0;
        }
        return element.hashCode();
    }

    public static boolean equals(byte[] array1, byte[] array2) {
        if (array1 == array2) {
            return true;
        }
        if (array1 == null || array2 == null || array1.length != array2.length) {
            return false;
        }
        for (int i = 0; i < array1.length; ++i) {
            if (array1[i] == array2[i]) continue;
            return false;
        }
        return true;
    }

    public static boolean equals(short[] array1, short[] array2) {
        if (array1 == array2) {
            return true;
        }
        if (array1 == null || array2 == null || array1.length != array2.length) {
            return false;
        }
        for (int i = 0; i < array1.length; ++i) {
            if (array1[i] == array2[i]) continue;
            return false;
        }
        return true;
    }

    public static boolean equals(char[] array1, char[] array2) {
        if (array1 == array2) {
            return true;
        }
        if (array1 == null || array2 == null || array1.length != array2.length) {
            return false;
        }
        for (int i = 0; i < array1.length; ++i) {
            if (array1[i] == array2[i]) continue;
            return false;
        }
        return true;
    }

    public static boolean equals(int[] array1, int[] array2) {
        if (array1 == array2) {
            return true;
        }
        if (array1 == null || array2 == null || array1.length != array2.length) {
            return false;
        }
        for (int i = 0; i < array1.length; ++i) {
            if (array1[i] == array2[i]) continue;
            return false;
        }
        return true;
    }

    public static boolean equals(long[] array1, long[] array2) {
        if (array1 == array2) {
            return true;
        }
        if (array1 == null || array2 == null || array1.length != array2.length) {
            return false;
        }
        for (int i = 0; i < array1.length; ++i) {
            if (array1[i] == array2[i]) continue;
            return false;
        }
        return true;
    }

    public static boolean equals(float[] array1, float[] array2) {
        if (array1 == array2) {
            return true;
        }
        if (array1 == null || array2 == null || array1.length != array2.length) {
            return false;
        }
        for (int i = 0; i < array1.length; ++i) {
            if (Float.floatToIntBits(array1[i]) == Float.floatToIntBits(array2[i])) continue;
            return false;
        }
        return true;
    }

    public static boolean equals(double[] array1, double[] array2) {
        if (array1 == array2) {
            return true;
        }
        if (array1 == null || array2 == null || array1.length != array2.length) {
            return false;
        }
        for (int i = 0; i < array1.length; ++i) {
            if (Double.doubleToLongBits(array1[i]) == Double.doubleToLongBits(array2[i])) continue;
            return false;
        }
        return true;
    }

    public static boolean equals(boolean[] array1, boolean[] array2) {
        if (array1 == array2) {
            return true;
        }
        if (array1 == null || array2 == null || array1.length != array2.length) {
            return false;
        }
        for (int i = 0; i < array1.length; ++i) {
            if (array1[i] == array2[i]) continue;
            return false;
        }
        return true;
    }

    public static boolean equals(Object[] array1, Object[] array2) {
        if (array1 == array2) {
            return true;
        }
        if (array1 == null || array2 == null || array1.length != array2.length) {
            return false;
        }
        for (int i = 0; i < array1.length; ++i) {
            Object e1 = array1[i];
            Object e2 = array2[i];
            if (e1 != null ? e1.equals(e2) : e2 == null) continue;
            return false;
        }
        return true;
    }

    public static boolean deepEquals(Object[] array1, Object[] array2) {
        if (array1 == array2) {
            return true;
        }
        if (array1 == null || array2 == null || array1.length != array2.length) {
            return false;
        }
        for (int i = 0; i < array1.length; ++i) {
            Object e1 = array1[i];
            Object e2 = array2[i];
            if (Arrays.deepEqualsElements(e1, e2)) continue;
            return false;
        }
        return true;
    }

    private static boolean deepEqualsElements(Object e1, Object e2) {
        if (e1 == e2) {
            return true;
        }
        if (e1 == null || e2 == null) {
            return false;
        }
        return e1.equals(e2);
    }

    private static boolean isSame(double double1, double double2) {
        if (double1 == double2 && 0.0 != double1) {
            return true;
        }
        if (Double.isNaN(double1)) {
            return Double.isNaN(double2);
        }
        if (Double.isNaN(double2)) {
            return false;
        }
        return false;
    }

    private static boolean lessThan(double double1, double double2) {
        if (double1 < double2) {
            return true;
        }
        if (double1 > double2) {
            return false;
        }
        if (double1 == double2 && 0.0 != double1) {
            return false;
        }
        if (Double.isNaN(double1)) {
            return false;
        }
        if (Double.isNaN(double2)) {
            return true;
        }
        return double1 < double2;
    }

    private static boolean isSame(float float1, float float2) {
        if (float1 == float2 && 0.0 != (double)float1) {
            return true;
        }
        if (Float.isNaN(float1)) {
            return Float.isNaN(float2);
        }
        if (Float.isNaN(float2)) {
            return false;
        }
        return false;
    }

    private static boolean lessThan(float float1, float float2) {
        if (float1 < float2) {
            return true;
        }
        if (float1 > float2) {
            return false;
        }
        if (float1 == float2 && 0.0f != float1) {
            return false;
        }
        if (Float.isNaN(float1)) {
            return false;
        }
        if (Float.isNaN(float2)) {
            return true;
        }
        return float1 < float2;
    }

    private static int med3(byte[] array, int a, int b, int c) {
        byte x = array[a];
        byte y = array[b];
        byte z = array[c];
        return x < y ? (y < z ? b : (x < z ? c : a)) : (y > z ? b : (x > z ? c : a));
    }

    private static int med3(char[] array, int a, int b, int c) {
        char x = array[a];
        char y = array[b];
        char z = array[c];
        return x < y ? (y < z ? b : (x < z ? c : a)) : (y > z ? b : (x > z ? c : a));
    }

    private static int med3(double[] array, int a, int b, int c) {
        double x = array[a];
        double y = array[b];
        double z = array[c];
        return Arrays.lessThan(x, y) ? (Arrays.lessThan(y, z) ? b : (Arrays.lessThan(x, z) ? c : a)) : (Arrays.lessThan(z, y) ? b : (Arrays.lessThan(z, x) ? c : a));
    }

    private static int med3(float[] array, int a, int b, int c) {
        float x = array[a];
        float y = array[b];
        float z = array[c];
        return Arrays.lessThan(x, y) ? (Arrays.lessThan(y, z) ? b : (Arrays.lessThan(x, z) ? c : a)) : (Arrays.lessThan(z, y) ? b : (Arrays.lessThan(z, x) ? c : a));
    }

    private static int med3(int[] array, int a, int b, int c) {
        int x = array[a];
        int y = array[b];
        int z = array[c];
        return x < y ? (y < z ? b : (x < z ? c : a)) : (y > z ? b : (x > z ? c : a));
    }

    private static int med3(long[] array, int a, int b, int c) {
        long x = array[a];
        long y = array[b];
        long z = array[c];
        return x < y ? (y < z ? b : (x < z ? c : a)) : (y > z ? b : (x > z ? c : a));
    }

    private static int med3(short[] array, int a, int b, int c) {
        short x = array[a];
        short y = array[b];
        short z = array[c];
        return x < y ? (y < z ? b : (x < z ? c : a)) : (y > z ? b : (x > z ? c : a));
    }

    public static void sort(byte[] array) {
        Arrays.sort(0, array.length, array);
    }

    public static void sort(byte[] array, int start, int end) {
        if (array == null) {
            throw new NullPointerException();
        }
        Arrays.checkBounds(array.length, start, end);
        Arrays.sort(start, end, array);
    }

    private static void checkBounds(int arrLength, int start, int end) {
        if (start > end) {
            throw new IndexOutOfBoundsException("" + start + " out of: " + end);
        }
        if (start < 0) {
            throw new IndexOutOfBoundsException("" + start);
        }
        if (end > arrLength) {
            throw new IndexOutOfBoundsException("" + end);
        }
    }

    private static void sort(int start, int end, byte[] array) {
        byte temp;
        int d;
        int b;
        int length = end - start;
        if (length < 7) {
            for (int i = start + 1; i < end; ++i) {
                for (int j = i; j > start && array[j - 1] > array[j]; --j) {
                    byte temp2 = array[j];
                    array[j] = array[j - 1];
                    array[j - 1] = temp2;
                }
            }
            return;
        }
        int middle = (start + end) / 2;
        if (length > 7) {
            int bottom = start;
            int top = end - 1;
            if (length > 40) {
                bottom = Arrays.med3(array, bottom, bottom + (length /= 8), bottom + 2 * length);
                middle = Arrays.med3(array, middle - length, middle, middle + length);
                top = Arrays.med3(array, top - 2 * length, top - length, top);
            }
            middle = Arrays.med3(array, bottom, middle, top);
        }
        byte partionValue = array[middle];
        int a = b = start;
        int c = d = end - 1;
        while (true) {
            if (b <= c && array[b] <= partionValue) {
                if (array[b] == partionValue) {
                    temp = array[a];
                    array[a++] = array[b];
                    array[b] = temp;
                }
                ++b;
                continue;
            }
            while (c >= b && array[c] >= partionValue) {
                if (array[c] == partionValue) {
                    temp = array[c];
                    array[c] = array[d];
                    array[d--] = temp;
                }
                --c;
            }
            if (b > c) break;
            temp = array[b];
            array[b++] = array[c];
            array[c--] = temp;
        }
        length = a - start < b - a ? a - start : b - a;
        int l = start;
        int h = b - length;
        while (length-- > 0) {
            temp = array[l];
            array[l++] = array[h];
            array[h++] = temp;
        }
        length = d - c < end - 1 - d ? d - c : end - 1 - d;
        l = b;
        h = end - length;
        while (length-- > 0) {
            temp = array[l];
            array[l++] = array[h];
            array[h++] = temp;
        }
        length = b - a;
        if (length > 0) {
            Arrays.sort(start, start + length, array);
        }
        if ((length = d - c) > 0) {
            Arrays.sort(end - length, end, array);
        }
    }

    public static void sort(char[] array) {
        Arrays.sort(0, array.length, array);
    }

    public static void sort(char[] array, int start, int end) {
        if (array == null) {
            throw new NullPointerException();
        }
        Arrays.checkBounds(array.length, start, end);
        Arrays.sort(start, end, array);
    }

    private static void sort(int start, int end, char[] array) {
        char temp;
        int d;
        int b;
        int length = end - start;
        if (length < 7) {
            for (int i = start + 1; i < end; ++i) {
                for (int j = i; j > start && array[j - 1] > array[j]; --j) {
                    char temp2 = array[j];
                    array[j] = array[j - 1];
                    array[j - 1] = temp2;
                }
            }
            return;
        }
        int middle = (start + end) / 2;
        if (length > 7) {
            int bottom = start;
            int top = end - 1;
            if (length > 40) {
                bottom = Arrays.med3(array, bottom, bottom + (length /= 8), bottom + 2 * length);
                middle = Arrays.med3(array, middle - length, middle, middle + length);
                top = Arrays.med3(array, top - 2 * length, top - length, top);
            }
            middle = Arrays.med3(array, bottom, middle, top);
        }
        char partionValue = array[middle];
        int a = b = start;
        int c = d = end - 1;
        while (true) {
            if (b <= c && array[b] <= partionValue) {
                if (array[b] == partionValue) {
                    temp = array[a];
                    array[a++] = array[b];
                    array[b] = temp;
                }
                ++b;
                continue;
            }
            while (c >= b && array[c] >= partionValue) {
                if (array[c] == partionValue) {
                    temp = array[c];
                    array[c] = array[d];
                    array[d--] = temp;
                }
                --c;
            }
            if (b > c) break;
            temp = array[b];
            array[b++] = array[c];
            array[c--] = temp;
        }
        length = a - start < b - a ? a - start : b - a;
        int l = start;
        int h = b - length;
        while (length-- > 0) {
            temp = array[l];
            array[l++] = array[h];
            array[h++] = temp;
        }
        length = d - c < end - 1 - d ? d - c : end - 1 - d;
        l = b;
        h = end - length;
        while (length-- > 0) {
            temp = array[l];
            array[l++] = array[h];
            array[h++] = temp;
        }
        length = b - a;
        if (length > 0) {
            Arrays.sort(start, start + length, array);
        }
        if ((length = d - c) > 0) {
            Arrays.sort(end - length, end, array);
        }
    }

    public static void sort(double[] array) {
        Arrays.sort(0, array.length, array);
    }

    public static void sort(double[] array, int start, int end) {
        if (array == null) {
            throw new NullPointerException();
        }
        Arrays.checkBounds(array.length, start, end);
        Arrays.sort(start, end, array);
    }

    private static void sort(int start, int end, double[] array) {
        double temp;
        int d;
        int b;
        int length = end - start;
        if (length < 7) {
            for (int i = start + 1; i < end; ++i) {
                for (int j = i; j > start && Arrays.lessThan(array[j], array[j - 1]); --j) {
                    double temp2 = array[j];
                    array[j] = array[j - 1];
                    array[j - 1] = temp2;
                }
            }
            return;
        }
        int middle = (start + end) / 2;
        if (length > 7) {
            int bottom = start;
            int top = end - 1;
            if (length > 40) {
                bottom = Arrays.med3(array, bottom, bottom + (length /= 8), bottom + 2 * length);
                middle = Arrays.med3(array, middle - length, middle, middle + length);
                top = Arrays.med3(array, top - 2 * length, top - length, top);
            }
            middle = Arrays.med3(array, bottom, middle, top);
        }
        double partionValue = array[middle];
        int a = b = start;
        int c = d = end - 1;
        while (true) {
            if (b <= c && !Arrays.lessThan(partionValue, array[b])) {
                if (Arrays.isSame(array[b], partionValue)) {
                    temp = array[a];
                    array[a++] = array[b];
                    array[b] = temp;
                }
                ++b;
                continue;
            }
            while (c >= b && !Arrays.lessThan(array[c], partionValue)) {
                if (Arrays.isSame(array[c], partionValue)) {
                    temp = array[c];
                    array[c] = array[d];
                    array[d--] = temp;
                }
                --c;
            }
            if (b > c) break;
            temp = array[b];
            array[b++] = array[c];
            array[c--] = temp;
        }
        length = a - start < b - a ? a - start : b - a;
        int l = start;
        int h = b - length;
        while (length-- > 0) {
            temp = array[l];
            array[l++] = array[h];
            array[h++] = temp;
        }
        length = d - c < end - 1 - d ? d - c : end - 1 - d;
        l = b;
        h = end - length;
        while (length-- > 0) {
            temp = array[l];
            array[l++] = array[h];
            array[h++] = temp;
        }
        length = b - a;
        if (length > 0) {
            Arrays.sort(start, start + length, array);
        }
        if ((length = d - c) > 0) {
            Arrays.sort(end - length, end, array);
        }
    }

    public static void sort(float[] array) {
        Arrays.sort(0, array.length, array);
    }

    public static void sort(float[] array, int start, int end) {
        if (array == null) {
            throw new NullPointerException();
        }
        Arrays.checkBounds(array.length, start, end);
        Arrays.sort(start, end, array);
    }

    private static void sort(int start, int end, float[] array) {
        float temp;
        int d;
        int b;
        int length = end - start;
        if (length < 7) {
            for (int i = start + 1; i < end; ++i) {
                for (int j = i; j > start && Arrays.lessThan(array[j], array[j - 1]); --j) {
                    float temp2 = array[j];
                    array[j] = array[j - 1];
                    array[j - 1] = temp2;
                }
            }
            return;
        }
        int middle = (start + end) / 2;
        if (length > 7) {
            int bottom = start;
            int top = end - 1;
            if (length > 40) {
                bottom = Arrays.med3(array, bottom, bottom + (length /= 8), bottom + 2 * length);
                middle = Arrays.med3(array, middle - length, middle, middle + length);
                top = Arrays.med3(array, top - 2 * length, top - length, top);
            }
            middle = Arrays.med3(array, bottom, middle, top);
        }
        float partionValue = array[middle];
        int a = b = start;
        int c = d = end - 1;
        while (true) {
            if (b <= c && !Arrays.lessThan(partionValue, array[b])) {
                if (Arrays.isSame(array[b], partionValue)) {
                    temp = array[a];
                    array[a++] = array[b];
                    array[b] = temp;
                }
                ++b;
                continue;
            }
            while (c >= b && !Arrays.lessThan(array[c], partionValue)) {
                if (Arrays.isSame(array[c], partionValue)) {
                    temp = array[c];
                    array[c] = array[d];
                    array[d--] = temp;
                }
                --c;
            }
            if (b > c) break;
            temp = array[b];
            array[b++] = array[c];
            array[c--] = temp;
        }
        length = a - start < b - a ? a - start : b - a;
        int l = start;
        int h = b - length;
        while (length-- > 0) {
            temp = array[l];
            array[l++] = array[h];
            array[h++] = temp;
        }
        length = d - c < end - 1 - d ? d - c : end - 1 - d;
        l = b;
        h = end - length;
        while (length-- > 0) {
            temp = array[l];
            array[l++] = array[h];
            array[h++] = temp;
        }
        length = b - a;
        if (length > 0) {
            Arrays.sort(start, start + length, array);
        }
        if ((length = d - c) > 0) {
            Arrays.sort(end - length, end, array);
        }
    }

    public static void sort(int[] array) {
        Arrays.sort(0, array.length, array);
    }

    public static void sort(int[] array, int start, int end) {
        if (array == null) {
            throw new NullPointerException();
        }
        Arrays.checkBounds(array.length, start, end);
        Arrays.sort(start, end, array);
    }

    private static void sort(int start, int end, int[] array) {
        int temp;
        int d;
        int b;
        int length = end - start;
        if (length < 7) {
            for (int i = start + 1; i < end; ++i) {
                for (int j = i; j > start && array[j - 1] > array[j]; --j) {
                    int temp2 = array[j];
                    array[j] = array[j - 1];
                    array[j - 1] = temp2;
                }
            }
            return;
        }
        int middle = (start + end) / 2;
        if (length > 7) {
            int bottom = start;
            int top = end - 1;
            if (length > 40) {
                bottom = Arrays.med3(array, bottom, bottom + (length /= 8), bottom + 2 * length);
                middle = Arrays.med3(array, middle - length, middle, middle + length);
                top = Arrays.med3(array, top - 2 * length, top - length, top);
            }
            middle = Arrays.med3(array, bottom, middle, top);
        }
        int partionValue = array[middle];
        int a = b = start;
        int c = d = end - 1;
        while (true) {
            if (b <= c && array[b] <= partionValue) {
                if (array[b] == partionValue) {
                    temp = array[a];
                    array[a++] = array[b];
                    array[b] = temp;
                }
                ++b;
                continue;
            }
            while (c >= b && array[c] >= partionValue) {
                if (array[c] == partionValue) {
                    temp = array[c];
                    array[c] = array[d];
                    array[d--] = temp;
                }
                --c;
            }
            if (b > c) break;
            temp = array[b];
            array[b++] = array[c];
            array[c--] = temp;
        }
        length = a - start < b - a ? a - start : b - a;
        int l = start;
        int h = b - length;
        while (length-- > 0) {
            temp = array[l];
            array[l++] = array[h];
            array[h++] = temp;
        }
        length = d - c < end - 1 - d ? d - c : end - 1 - d;
        l = b;
        h = end - length;
        while (length-- > 0) {
            temp = array[l];
            array[l++] = array[h];
            array[h++] = temp;
        }
        length = b - a;
        if (length > 0) {
            Arrays.sort(start, start + length, array);
        }
        if ((length = d - c) > 0) {
            Arrays.sort(end - length, end, array);
        }
    }

    public static void sort(long[] array) {
        Arrays.sort(0, array.length, array);
    }

    public static void sort(long[] array, int start, int end) {
        if (array == null) {
            throw new NullPointerException();
        }
        Arrays.checkBounds(array.length, start, end);
        Arrays.sort(start, end, array);
    }

    private static void sort(int start, int end, long[] array) {
        long temp;
        int d;
        int b;
        int length = end - start;
        if (length < 7) {
            for (int i = start + 1; i < end; ++i) {
                for (int j = i; j > start && array[j - 1] > array[j]; --j) {
                    long temp2 = array[j];
                    array[j] = array[j - 1];
                    array[j - 1] = temp2;
                }
            }
            return;
        }
        int middle = (start + end) / 2;
        if (length > 7) {
            int bottom = start;
            int top = end - 1;
            if (length > 40) {
                bottom = Arrays.med3(array, bottom, bottom + (length /= 8), bottom + 2 * length);
                middle = Arrays.med3(array, middle - length, middle, middle + length);
                top = Arrays.med3(array, top - 2 * length, top - length, top);
            }
            middle = Arrays.med3(array, bottom, middle, top);
        }
        long partionValue = array[middle];
        int a = b = start;
        int c = d = end - 1;
        while (true) {
            if (b <= c && array[b] <= partionValue) {
                if (array[b] == partionValue) {
                    temp = array[a];
                    array[a++] = array[b];
                    array[b] = temp;
                }
                ++b;
                continue;
            }
            while (c >= b && array[c] >= partionValue) {
                if (array[c] == partionValue) {
                    temp = array[c];
                    array[c] = array[d];
                    array[d--] = temp;
                }
                --c;
            }
            if (b > c) break;
            temp = array[b];
            array[b++] = array[c];
            array[c--] = temp;
        }
        length = a - start < b - a ? a - start : b - a;
        int l = start;
        int h = b - length;
        while (length-- > 0) {
            temp = array[l];
            array[l++] = array[h];
            array[h++] = temp;
        }
        length = d - c < end - 1 - d ? d - c : end - 1 - d;
        l = b;
        h = end - length;
        while (length-- > 0) {
            temp = array[l];
            array[l++] = array[h];
            array[h++] = temp;
        }
        length = b - a;
        if (length > 0) {
            Arrays.sort(start, start + length, array);
        }
        if ((length = d - c) > 0) {
            Arrays.sort(end - length, end, array);
        }
    }

    public static void sort(Object[] array) {
        Arrays.sort(0, array.length, array);
    }

    public static void sort(Object[] array, int start, int end) {
        if (array == null) {
            throw new NullPointerException();
        }
        Arrays.checkBounds(array.length, start, end);
        Arrays.sort(start, end, array);
    }

    private static void sort(int start, int end, Object[] array) {
        int length = end - start;
        if (length <= 0) {
            return;
        }
        if (array instanceof String[]) {
            Arrays.stableStringSort((String[])array, start, end);
        } else {
            Object[] out = new Object[end];
            System.arraycopy(array, start, out, start, length);
            Arrays.mergeSort(out, array, start, end);
        }
    }

    private static void swap(int a, int b, Object[] arr) {
        Object tmp = arr[a];
        arr[a] = arr[b];
        arr[b] = tmp;
    }

    private static void mergeSort(Object[] in, Object[] out, int start, int end) {
        int len = end - start;
        if (len <= 7) {
            for (int i = start + 1; i < end; ++i) {
                Comparable current = (Comparable)out[i];
                Object prev = out[i - 1];
                if (current.compareTo(prev) >= 0) continue;
                int j = i;
                do {
                    out[j--] = prev;
                } while (j > start && current.compareTo(prev = out[j - 1]) < 0);
                out[j] = current;
            }
            return;
        }
        int med = end + start >>> 1;
        Arrays.mergeSort(out, in, start, med);
        Arrays.mergeSort(out, in, med, end);
        if (((Comparable)in[med - 1]).compareTo(in[med]) <= 0) {
            System.arraycopy(in, start, out, start, len);
            return;
        }
        int r = med;
        int i = start;
        do {
            int toCopy;
            Comparable rVal;
            Comparable fromVal;
            if ((fromVal = (Comparable)in[start]).compareTo(rVal = (Comparable)in[r]) <= 0) {
                int l_1 = Arrays.find(in, rVal, -1, start + 1, med - 1);
                toCopy = l_1 - start + 1;
                System.arraycopy(in, start, out, i, toCopy);
                i += toCopy;
                out[i++] = rVal;
                ++r;
                start = l_1 + 1;
                continue;
            }
            int r_1 = Arrays.find(in, fromVal, 0, r + 1, end - 1);
            toCopy = r_1 - r + 1;
            System.arraycopy(in, r, out, i, toCopy);
            i += toCopy;
            out[i++] = fromVal;
            ++start;
            r = r_1 + 1;
        } while (end - r > 0 && med - start > 0);
        if (end - r <= 0) {
            System.arraycopy(in, start, out, i, med - start);
        } else {
            System.arraycopy(in, r, out, i, end - r);
        }
    }

    private static void mergeSort(Object[] in, Object[] out, int start, int end, Comparator c) {
        int len = end - start;
        if (len <= 7) {
            for (int i = start + 1; i < end; ++i) {
                Object prev = out[i - 1];
                Object current = out[i];
                if (c.compare(prev, current) <= 0) continue;
                int j = i;
                do {
                    out[j--] = prev;
                } while (j > start && c.compare(prev = out[j - 1], current) > 0);
                out[j] = current;
            }
            return;
        }
        int med = end + start >>> 1;
        Arrays.mergeSort(out, in, start, med, c);
        Arrays.mergeSort(out, in, med, end, c);
        if (c.compare(in[med - 1], in[med]) <= 0) {
            System.arraycopy(in, start, out, start, len);
            return;
        }
        int r = med;
        int i = start;
        do {
            int toCopy;
            Object rVal;
            Object fromVal;
            if (c.compare(fromVal = in[start], rVal = in[r]) <= 0) {
                int l_1 = Arrays.find(in, rVal, -1, start + 1, med - 1, c);
                toCopy = l_1 - start + 1;
                System.arraycopy(in, start, out, i, toCopy);
                i += toCopy;
                out[i++] = rVal;
                ++r;
                start = l_1 + 1;
                continue;
            }
            int r_1 = Arrays.find(in, fromVal, 0, r + 1, end - 1, c);
            toCopy = r_1 - r + 1;
            System.arraycopy(in, r, out, i, toCopy);
            i += toCopy;
            out[i++] = fromVal;
            ++start;
            r = r_1 + 1;
        } while (end - r > 0 && med - start > 0);
        if (end - r <= 0) {
            System.arraycopy(in, start, out, i, med - start);
        } else {
            System.arraycopy(in, r, out, i, end - r);
        }
    }

    private static int find(Object[] arr, Comparable val, int bnd, int l, int r) {
        int m = l;
        int d = 1;
        while (m <= r) {
            if (val.compareTo(arr[m]) <= bnd) {
                r = m - 1;
                break;
            }
            l = m + 1;
            m += d;
            d <<= 1;
        }
        while (l <= r) {
            m = l + r >>> 1;
            if (val.compareTo(arr[m]) > bnd) {
                l = m + 1;
                continue;
            }
            r = m - 1;
        }
        return l - 1;
    }

    private static int find(Object[] arr, Object val, int bnd, int l, int r, Comparator c) {
        int m = l;
        int d = 1;
        while (m <= r) {
            if (c.compare(val, arr[m]) <= bnd) {
                r = m - 1;
                break;
            }
            l = m + 1;
            m += d;
            d <<= 1;
        }
        while (l <= r) {
            m = l + r >>> 1;
            if (c.compare(val, arr[m]) > bnd) {
                l = m + 1;
                continue;
            }
            r = m - 1;
        }
        return l - 1;
    }

    private static int medChar(int a, int b, int c, String[] arr, int id) {
        int ac = Arrays.charAt(arr[a], id);
        int bc = Arrays.charAt(arr[b], id);
        int cc = Arrays.charAt(arr[c], id);
        return ac < bc ? (bc < cc ? b : (ac < cc ? c : a)) : (bc < cc ? (ac < cc ? a : c) : b);
    }

    private static int charAt(String str, int i) {
        if (i >= str.length()) {
            return -1;
        }
        return str.charAt(i);
    }

    private static void copySwap(Object[] src, int from, Object[] dst, int to, int len) {
        if (src == dst && from + len > to) {
            int new_to = to + len - 1;
            while (from < to) {
                dst[new_to] = src[from];
                ++from;
                --new_to;
                --len;
            }
            while (len > 1) {
                Arrays.swap(from, new_to, dst);
                ++from;
                --new_to;
                len -= 2;
            }
        } else {
            to = to + len - 1;
            while (len > 0) {
                dst[to] = src[from];
                ++from;
                --to;
                --len;
            }
        }
    }

    private static void stableStringSort(String[] arr, int start, int end) {
        Arrays.stableStringSort(arr, arr, new String[end], start, end, 0);
    }

    private static void stableStringSort(String[] arr, String[] src, String[] dst, int start, int end, int chId) {
        int b;
        int s;
        int length = end - start;
        if (length < 7) {
            if (src == arr) {
                for (int i = start + 1; i < end; ++i) {
                    String current = arr[i];
                    String prev = arr[i - 1];
                    if (current.compareTo(prev) >= 0) continue;
                    int j = i;
                    do {
                        arr[j--] = prev;
                    } while (j > start && current.compareTo(prev = arr[j - 1]) < 0);
                    arr[j] = current;
                }
            } else {
                int actualEnd = end - 1;
                dst[start] = src[actualEnd--];
                int i = start + 1;
                while (i < end) {
                    String prev;
                    String current = src[actualEnd];
                    int j = i;
                    while (j > start && current.compareTo(prev = dst[j - 1]) < 0) {
                        dst[j--] = prev;
                    }
                    dst[j] = current;
                    ++i;
                    --actualEnd;
                }
            }
            return;
        }
        int mid = start + length / 2;
        int lo = start;
        int hi = end - 1;
        if (length > 40) {
            s = length / 8;
            lo = Arrays.medChar(lo, lo + s, lo + s * 2, src, chId);
            mid = Arrays.medChar(mid - s, mid, mid + s, src, chId);
            hi = Arrays.medChar(hi, hi - s, hi - s * 2, src, chId);
        }
        mid = Arrays.medChar(lo, mid, hi, src, chId);
        int midVal = Arrays.charAt(src[mid], chId);
        int a = b = start;
        int c = end - 1;
        for (int i = start; i < end; ++i) {
            String el = src[i];
            int cmp = Arrays.charAt(el, chId) - midVal;
            if (cmp < 0) {
                src[a] = el;
                ++a;
                continue;
            }
            if (cmp > 0) {
                dst[c] = el;
                --c;
                continue;
            }
            dst[b] = el;
            ++b;
        }
        s = b - start;
        if (s > 0) {
            if (arr == src) {
                System.arraycopy(dst, start, arr, a, s);
            } else {
                Arrays.copySwap(dst, start, arr, a, s);
            }
            if (b >= end && midVal == -1) {
                return;
            }
            Arrays.stableStringSort(arr, arr, arr == dst ? src : dst, a, a + s, chId + 1);
        }
        if ((s = a - start) > 0) {
            Arrays.stableStringSort(arr, src, dst, start, a, chId);
        }
        if ((s = end - ++c) > 0) {
            Arrays.stableStringSort(arr, dst, src, c, end, chId);
        }
    }

    public static <T> void sort(T[] array, int start, int end, Comparator<? super T> comparator) {
        if (array == null) {
            throw new NullPointerException();
        }
        Arrays.checkBounds(array.length, start, end);
        Arrays.sort(start, end, array, comparator);
    }

    private static <T> void sort(int start, int end, T[] array, Comparator<? super T> comparator) {
        if (comparator == null) {
            Arrays.sort(start, end, array);
        } else {
            int length = end - start;
            Object[] out = new Object[end];
            System.arraycopy(array, start, out, start, length);
            Arrays.mergeSort(out, array, start, end, comparator);
        }
    }

    public static <T> void sort(T[] array, Comparator<? super T> comparator) {
        Arrays.sort(0, array.length, array, comparator);
    }

    public static void sort(short[] array) {
        Arrays.sort(0, array.length, array);
    }

    public static void sort(short[] array, int start, int end) {
        if (array == null) {
            throw new NullPointerException();
        }
        Arrays.checkBounds(array.length, start, end);
        Arrays.sort(start, end, array);
    }

    private static void sort(int start, int end, short[] array) {
        short temp;
        int d;
        int b;
        int length = end - start;
        if (length < 7) {
            for (int i = start + 1; i < end; ++i) {
                for (int j = i; j > start && array[j - 1] > array[j]; --j) {
                    short temp2 = array[j];
                    array[j] = array[j - 1];
                    array[j - 1] = temp2;
                }
            }
            return;
        }
        int middle = (start + end) / 2;
        if (length > 7) {
            int bottom = start;
            int top = end - 1;
            if (length > 40) {
                bottom = Arrays.med3(array, bottom, bottom + (length /= 8), bottom + 2 * length);
                middle = Arrays.med3(array, middle - length, middle, middle + length);
                top = Arrays.med3(array, top - 2 * length, top - length, top);
            }
            middle = Arrays.med3(array, bottom, middle, top);
        }
        short partionValue = array[middle];
        int a = b = start;
        int c = d = end - 1;
        while (true) {
            if (b <= c && array[b] <= partionValue) {
                if (array[b] == partionValue) {
                    temp = array[a];
                    array[a++] = array[b];
                    array[b] = temp;
                }
                ++b;
                continue;
            }
            while (c >= b && array[c] >= partionValue) {
                if (array[c] == partionValue) {
                    temp = array[c];
                    array[c] = array[d];
                    array[d--] = temp;
                }
                --c;
            }
            if (b > c) break;
            temp = array[b];
            array[b++] = array[c];
            array[c--] = temp;
        }
        length = a - start < b - a ? a - start : b - a;
        int l = start;
        int h = b - length;
        while (length-- > 0) {
            temp = array[l];
            array[l++] = array[h];
            array[h++] = temp;
        }
        length = d - c < end - 1 - d ? d - c : end - 1 - d;
        l = b;
        h = end - length;
        while (length-- > 0) {
            temp = array[l];
            array[l++] = array[h];
            array[h++] = temp;
        }
        length = b - a;
        if (length > 0) {
            Arrays.sort(start, start + length, array);
        }
        if ((length = d - c) > 0) {
            Arrays.sort(end - length, end, array);
        }
    }

    public static String toString(boolean[] array) {
        if (array == null) {
            return "null";
        }
        if (array.length == 0) {
            return "[]";
        }
        StringBuffer sb = new StringBuffer(2 + array.length * 5);
        sb.append('[');
        sb.append(array[0]);
        for (int i = 1; i < array.length; ++i) {
            sb.append(", ");
            sb.append(array[i]);
        }
        sb.append(']');
        return sb.toString();
    }

    public static String toString(byte[] array) {
        if (array == null) {
            return "null";
        }
        if (array.length == 0) {
            return "[]";
        }
        StringBuffer sb = new StringBuffer(2 + array.length * 3);
        sb.append('[');
        sb.append(array[0]);
        for (int i = 1; i < array.length; ++i) {
            sb.append(", ");
            sb.append(array[i]);
        }
        sb.append(']');
        return sb.toString();
    }

    public static String toString(char[] array) {
        if (array == null) {
            return "null";
        }
        if (array.length == 0) {
            return "[]";
        }
        StringBuffer sb = new StringBuffer(2 + array.length * 2);
        sb.append('[');
        sb.append(array[0]);
        for (int i = 1; i < array.length; ++i) {
            sb.append(", ");
            sb.append(array[i]);
        }
        sb.append(']');
        return sb.toString();
    }

    public static String toString(double[] array) {
        if (array == null) {
            return "null";
        }
        if (array.length == 0) {
            return "[]";
        }
        StringBuffer sb = new StringBuffer(2 + array.length * 5);
        sb.append('[');
        sb.append(array[0]);
        for (int i = 1; i < array.length; ++i) {
            sb.append(", ");
            sb.append(array[i]);
        }
        sb.append(']');
        return sb.toString();
    }

    public static String toString(float[] array) {
        if (array == null) {
            return "null";
        }
        if (array.length == 0) {
            return "[]";
        }
        StringBuffer sb = new StringBuffer(2 + array.length * 5);
        sb.append('[');
        sb.append(array[0]);
        for (int i = 1; i < array.length; ++i) {
            sb.append(", ");
            sb.append(array[i]);
        }
        sb.append(']');
        return sb.toString();
    }

    public static String toString(int[] array) {
        if (array == null) {
            return "null";
        }
        if (array.length == 0) {
            return "[]";
        }
        StringBuffer sb = new StringBuffer(2 + array.length * 4);
        sb.append('[');
        sb.append(array[0]);
        for (int i = 1; i < array.length; ++i) {
            sb.append(", ");
            sb.append(array[i]);
        }
        sb.append(']');
        return sb.toString();
    }

    public static String toString(long[] array) {
        if (array == null) {
            return "null";
        }
        if (array.length == 0) {
            return "[]";
        }
        StringBuffer sb = new StringBuffer(2 + array.length * 4);
        sb.append('[');
        sb.append(array[0]);
        for (int i = 1; i < array.length; ++i) {
            sb.append(", ");
            sb.append(array[i]);
        }
        sb.append(']');
        return sb.toString();
    }

    public static String toString(short[] array) {
        if (array == null) {
            return "null";
        }
        if (array.length == 0) {
            return "[]";
        }
        StringBuffer sb = new StringBuffer(2 + array.length * 4);
        sb.append('[');
        sb.append(array[0]);
        for (int i = 1; i < array.length; ++i) {
            sb.append(", ");
            sb.append(array[i]);
        }
        sb.append(']');
        return sb.toString();
    }

    public static String toString(Object[] array) {
        if (array == null) {
            return "null";
        }
        if (array.length == 0) {
            return "[]";
        }
        StringBuffer sb = new StringBuffer(2 + array.length * 5);
        sb.append('[');
        sb.append(array[0]);
        for (int i = 1; i < array.length; ++i) {
            sb.append(", ");
            sb.append(array[i]);
        }
        sb.append(']');
        return sb.toString();
    }

    public static String deepToString(Object[] array) {
        return Arrays.deepToStringImpl(array, new Object[]{array}, null);
    }

    private static String deepToStringImpl(Object[] array, Object[] origArrays, StringBuffer sb) {
        if (array == null) {
            return "null";
        }
        if (array.length == 0) {
            return "[]";
        }
        if (sb == null) {
            sb = new StringBuffer(2 + array.length * 5);
        }
        sb.append('[');
        for (int i = 0; i < array.length; ++i) {
            Object elem;
            if (i != 0) {
                sb.append(", ");
            }
            if ((elem = array[i]) == null) {
                sb.append("null");
                continue;
            }
            Class elemClass = elem.getClass();
            if (elemClass.isArray()) {
                if (Arrays.deepToStringImplContains(origArrays, elem)) {
                    sb.append("[...]");
                    continue;
                }
                Object[] newArray = (Object[])elem;
                Object[] newOrigArrays = new Object[origArrays.length + 1];
                System.arraycopy(origArrays, 0, newOrigArrays, 0, origArrays.length);
                newOrigArrays[origArrays.length] = newArray;
                Arrays.deepToStringImpl(newArray, newOrigArrays, sb);
                continue;
            }
            sb.append(array[i]);
        }
        sb.append(']');
        return sb.toString();
    }

    private static boolean deepToStringImplContains(Object[] origArrays, Object array) {
        if (origArrays == null || origArrays.length == 0) {
            return false;
        }
        for (Object element : origArrays) {
            if (element != array) continue;
            return true;
        }
        return false;
    }

    public static boolean[] copyOfRange(boolean[] original, int start, int end) {
        if (start <= end) {
            if (original.length >= start && 0 <= start) {
                int length = end - start;
                int copyLength = Math.min(length, original.length - start);
                boolean[] copy = new boolean[length];
                System.arraycopy(original, start, copy, 0, copyLength);
                return copy;
            }
            throw new ArrayIndexOutOfBoundsException();
        }
        throw new IllegalArgumentException();
    }

    public static byte[] copyOfRange(byte[] original, int start, int end) {
        if (start <= end) {
            if (original.length >= start && 0 <= start) {
                int length = end - start;
                int copyLength = Math.min(length, original.length - start);
                byte[] copy = new byte[length];
                System.arraycopy(original, start, copy, 0, copyLength);
                return copy;
            }
            throw new ArrayIndexOutOfBoundsException();
        }
        throw new IllegalArgumentException();
    }

    public static char[] copyOfRange(char[] original, int start, int end) {
        if (start <= end) {
            if (original.length >= start && 0 <= start) {
                int length = end - start;
                int copyLength = Math.min(length, original.length - start);
                char[] copy = new char[length];
                System.arraycopy(original, start, copy, 0, copyLength);
                return copy;
            }
            throw new ArrayIndexOutOfBoundsException();
        }
        throw new IllegalArgumentException();
    }

    public static double[] copyOfRange(double[] original, int start, int end) {
        if (start <= end) {
            if (original.length >= start && 0 <= start) {
                int length = end - start;
                int copyLength = Math.min(length, original.length - start);
                double[] copy = new double[length];
                System.arraycopy(original, start, copy, 0, copyLength);
                return copy;
            }
            throw new ArrayIndexOutOfBoundsException();
        }
        throw new IllegalArgumentException();
    }

    public static float[] copyOfRange(float[] original, int start, int end) {
        if (start <= end) {
            if (original.length >= start && 0 <= start) {
                int length = end - start;
                int copyLength = Math.min(length, original.length - start);
                float[] copy = new float[length];
                System.arraycopy(original, start, copy, 0, copyLength);
                return copy;
            }
            throw new ArrayIndexOutOfBoundsException();
        }
        throw new IllegalArgumentException();
    }

    public static int[] copyOfRange(int[] original, int start, int end) {
        if (start <= end) {
            if (original.length >= start && 0 <= start) {
                int length = end - start;
                int copyLength = Math.min(length, original.length - start);
                int[] copy = new int[length];
                System.arraycopy(original, start, copy, 0, copyLength);
                return copy;
            }
            throw new ArrayIndexOutOfBoundsException();
        }
        throw new IllegalArgumentException();
    }

    public static long[] copyOfRange(long[] original, int start, int end) {
        if (start <= end) {
            if (original.length >= start && 0 <= start) {
                int length = end - start;
                int copyLength = Math.min(length, original.length - start);
                long[] copy = new long[length];
                System.arraycopy(original, start, copy, 0, copyLength);
                return copy;
            }
            throw new ArrayIndexOutOfBoundsException();
        }
        throw new IllegalArgumentException();
    }

    public static short[] copyOfRange(short[] original, int start, int end) {
        if (start <= end) {
            if (original.length >= start && 0 <= start) {
                int length = end - start;
                int copyLength = Math.min(length, original.length - start);
                short[] copy = new short[length];
                System.arraycopy(original, start, copy, 0, copyLength);
                return copy;
            }
            throw new ArrayIndexOutOfBoundsException();
        }
        throw new IllegalArgumentException();
    }

    public static <T, U> T[] copyOfRange(U[] original, int from, int to, Class<? extends T[]> newType) {
        return null;
    }

    public static <T> T[] copyOfRange(T[] original, int from, int to) {
        return null;
    }

    public static <T> T[] copyOf(T[] original, int newLength, Class<? extends T[]> newType) {
        Object[] arr = (Object[])Array.newInstance(newType.getComponentType(), newLength);
        int len = Math.min(original.length, newLength);
        System.arraycopy(original, 0, arr, 0, len);
        return arr;
    }

    public static <T> T[] copyOf(T[] original, int newLength) {
        return Arrays.copyOf(original, newLength, original.getClass());
    }

    public static boolean[] copyOf(boolean[] original) {
        return Arrays.copyOfRange(original, 0, original.length);
    }

    public static boolean[] copyOf(boolean[] original, int newlen) {
        return Arrays.copyOfRange(original, 0, newlen);
    }

    public static char[] copyOf(char[] original) {
        return Arrays.copyOfRange(original, 0, original.length);
    }

    public static char[] copyOf(char[] original, int newlen) {
        return Arrays.copyOfRange(original, 0, newlen);
    }

    public static double[] copyOf(double[] original) {
        return Arrays.copyOfRange(original, 0, original.length);
    }

    public static double[] copyOf(double[] original, int newlen) {
        return Arrays.copyOfRange(original, 0, newlen);
    }

    public static float[] copyOf(float[] original) {
        return Arrays.copyOfRange(original, 0, original.length);
    }

    public static float[] copyOf(float[] original, int newlen) {
        return Arrays.copyOfRange(original, 0, newlen);
    }

    public static long[] copyOf(long[] original) {
        return Arrays.copyOfRange(original, 0, original.length);
    }

    public static long[] copyOf(long[] original, int newlen) {
        return Arrays.copyOfRange(original, 0, newlen);
    }

    public static int[] copyOf(int[] original) {
        return Arrays.copyOfRange(original, 0, original.length);
    }

    public static int[] copyOf(int[] original, int newlen) {
        return Arrays.copyOfRange(original, 0, newlen);
    }

    public static byte[] copyOf(byte[] original) {
        return Arrays.copyOfRange(original, 0, original.length);
    }

    public static byte[] copyOf(byte[] original, int newlen) {
        return Arrays.copyOfRange(original, 0, newlen);
    }

    public static short[] copyOf(short[] original) {
        return Arrays.copyOfRange(original, 0, original.length);
    }

    public static short[] copyOf(short[] original, int len) {
        return Arrays.copyOfRange(original, 0, len);
    }

    private static class ArrayList<E>
    extends AbstractList<E>
    implements List<E>,
    RandomAccess {
        private final E[] a;

        ArrayList(E[] storage) {
            if (storage == null) {
                throw new NullPointerException();
            }
            this.a = storage;
        }

        @Override
        public boolean contains(Object object) {
            if (object != null) {
                for (E element : this.a) {
                    if (!object.equals(element)) continue;
                    return true;
                }
            } else {
                for (E element : this.a) {
                    if (element != null) continue;
                    return true;
                }
            }
            return false;
        }

        @Override
        public E get(int location) {
            try {
                return this.a[location];
            }
            catch (ArrayIndexOutOfBoundsException e) {
                throw new IndexOutOfBoundsException();
            }
        }

        @Override
        public int indexOf(Object object) {
            if (object != null) {
                for (int i = 0; i < this.a.length; ++i) {
                    if (!object.equals(this.a[i])) continue;
                    return i;
                }
            } else {
                for (int i = 0; i < this.a.length; ++i) {
                    if (this.a[i] != null) continue;
                    return i;
                }
            }
            return -1;
        }

        @Override
        public int lastIndexOf(Object object) {
            if (object != null) {
                for (int i = this.a.length - 1; i >= 0; --i) {
                    if (!object.equals(this.a[i])) continue;
                    return i;
                }
            } else {
                for (int i = this.a.length - 1; i >= 0; --i) {
                    if (this.a[i] != null) continue;
                    return i;
                }
            }
            return -1;
        }

        @Override
        public E set(int location, E object) {
            try {
                E result = this.a[location];
                this.a[location] = object;
                return result;
            }
            catch (ArrayIndexOutOfBoundsException e) {
                throw new IndexOutOfBoundsException();
            }
            catch (ArrayStoreException e) {
                throw new ClassCastException();
            }
        }

        @Override
        public int size() {
            return this.a.length;
        }
    }
}

