/*
 * Decompiled with CFR 0.152.
 */
package com.daikit.graphql.builder.custommethod;

import com.daikit.graphql.builder.GQLAbstractSchemaSubBuilder;
import com.daikit.graphql.builder.GQLSchemaBuilderCache;
import com.daikit.graphql.meta.custommethod.GQLAbstractMethodArgumentMetaData;
import com.daikit.graphql.meta.custommethod.GQLAbstractMethodMetaData;
import com.daikit.graphql.meta.custommethod.GQLMethodArgumentEntityMetaData;
import com.daikit.graphql.meta.custommethod.GQLMethodArgumentEnumMetaData;
import com.daikit.graphql.meta.custommethod.GQLMethodArgumentListEntityMetaData;
import com.daikit.graphql.meta.custommethod.GQLMethodArgumentListEnumMetaData;
import com.daikit.graphql.meta.custommethod.GQLMethodArgumentListScalarMetaData;
import com.daikit.graphql.meta.custommethod.GQLMethodArgumentScalarMetaData;
import com.daikit.graphql.meta.custommethod.GQLMethodEntityMetaData;
import com.daikit.graphql.meta.custommethod.GQLMethodEnumMetaData;
import com.daikit.graphql.meta.custommethod.GQLMethodListEntityMetaData;
import com.daikit.graphql.meta.custommethod.GQLMethodListEnumMetaData;
import com.daikit.graphql.meta.custommethod.GQLMethodListScalarMetaData;
import com.daikit.graphql.meta.custommethod.GQLMethodScalarMetaData;
import com.daikit.graphql.utils.Message;
import graphql.schema.GraphQLArgument;
import graphql.schema.GraphQLFieldDefinition;
import graphql.schema.GraphQLInputType;
import graphql.schema.GraphQLList;
import graphql.schema.GraphQLOutputType;
import graphql.schema.GraphQLScalarType;
import graphql.schema.GraphQLType;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class GQLCustomMethodBuilder
extends GQLAbstractSchemaSubBuilder {
    public GQLCustomMethodBuilder(GQLSchemaBuilderCache cache) {
        super(cache);
    }

    public Map<GQLAbstractMethodMetaData, GraphQLFieldDefinition> buildMethods(List<GQLAbstractMethodMetaData> methods) {
        this.checkDuplicates(methods);
        return methods.stream().collect(LinkedHashMap::new, (map, method) -> map.put(method, this.buildMethod((GQLAbstractMethodMetaData)method)), Map::putAll);
    }

    private void checkDuplicates(List<GQLAbstractMethodMetaData> methods) {
        HashSet names = new HashSet();
        methods.stream().forEach(method -> {
            if (!names.add(method.getName())) {
                throw new IllegalArgumentException(Message.format("Multiple methods set with name [{}]", method.getName()));
            }
        });
    }

    private GraphQLFieldDefinition buildMethod(GQLAbstractMethodMetaData method) {
        this.logger.debug(Message.format("Build query custom method [{}]", method.getName()));
        GraphQLFieldDefinition.Builder builder = GraphQLFieldDefinition.newFieldDefinition();
        builder.name(method.getName());
        builder.description("Query custom method [" + method.getName() + "]");
        method.getArguments().forEach(argument -> builder.argument(this.buildQueryArgument((GQLAbstractMethodArgumentMetaData)argument)));
        builder.type(this.getOutputType(method));
        return builder.build();
    }

    private GraphQLOutputType getOutputType(GQLAbstractMethodMetaData dynamicMethod) {
        GraphQLScalarType outputType;
        if (dynamicMethod instanceof GQLMethodScalarMetaData) {
            outputType = this.getCache().getScalarType(((GQLMethodScalarMetaData)dynamicMethod).getScalarType());
        } else if (dynamicMethod instanceof GQLMethodEnumMetaData) {
            outputType = this.getCache().getEnumType(((GQLMethodEnumMetaData)dynamicMethod).getEnumClass());
        } else if (dynamicMethod instanceof GQLMethodEntityMetaData) {
            outputType = this.getCache().getEntityType(((GQLMethodEntityMetaData)dynamicMethod).getEntityClass());
        } else if (dynamicMethod instanceof GQLMethodListEnumMetaData) {
            outputType = new GraphQLList((GraphQLType)this.getCache().getEnumType(((GQLMethodListEnumMetaData)dynamicMethod).getEnumClass()));
        } else if (dynamicMethod instanceof GQLMethodListEntityMetaData) {
            outputType = new GraphQLList((GraphQLType)this.getCache().getEntityType(((GQLMethodListEntityMetaData)dynamicMethod).getForeignClass()));
        } else if (dynamicMethod instanceof GQLMethodListScalarMetaData) {
            outputType = new GraphQLList((GraphQLType)this.getCache().getScalarType(((GQLMethodScalarMetaData)dynamicMethod).getScalarType()));
        } else {
            throw new IllegalArgumentException(Message.format("Dynamic method output type not handled for [{}]", dynamicMethod));
        }
        return outputType;
    }

    private GraphQLArgument buildQueryArgument(GQLAbstractMethodArgumentMetaData argumentMetaData) {
        this.logger.debug(Message.format("Build query dynamic method argument [{}]", argumentMetaData.getName()));
        GraphQLArgument.Builder builder = GraphQLArgument.newArgument();
        builder.name(argumentMetaData.getName());
        builder.description("Query dynamic method argument [" + argumentMetaData.getName() + "]");
        builder.type(this.getArgumentType(argumentMetaData));
        GraphQLArgument ret = builder.build();
        return ret;
    }

    private GraphQLInputType getArgumentType(GQLAbstractMethodArgumentMetaData argumentMetaData) {
        GraphQLScalarType argumentType;
        if (argumentMetaData instanceof GQLMethodArgumentScalarMetaData) {
            argumentType = this.getCache().getScalarType(((GQLMethodArgumentScalarMetaData)argumentMetaData).getScalarType());
        } else if (argumentMetaData instanceof GQLMethodArgumentEnumMetaData) {
            argumentType = this.getCache().getEnumType(((GQLMethodArgumentEnumMetaData)argumentMetaData).getEnumClass());
        } else if (argumentMetaData instanceof GQLMethodArgumentEntityMetaData) {
            argumentType = this.getCache().getInputEntityType(((GQLMethodArgumentEntityMetaData)argumentMetaData).getEntityClass());
        } else if (argumentMetaData instanceof GQLMethodArgumentListEnumMetaData) {
            argumentType = new GraphQLList((GraphQLType)this.getCache().getEnumType(((GQLMethodArgumentListEnumMetaData)argumentMetaData).getEnumClass()));
        } else if (argumentMetaData instanceof GQLMethodArgumentListEntityMetaData) {
            argumentType = new GraphQLList((GraphQLType)this.getCache().getInputEntityType(((GQLMethodArgumentListEntityMetaData)argumentMetaData).getForeignClass()));
        } else if (argumentMetaData instanceof GQLMethodArgumentListScalarMetaData) {
            argumentType = new GraphQLList((GraphQLType)this.getCache().getScalarType(((GQLMethodArgumentListScalarMetaData)argumentMetaData).getScalarType()));
        } else {
            throw new IllegalArgumentException(Message.format("Dynamic method argument type not handled for [{}]", argumentMetaData));
        }
        return argumentType;
    }
}

