/*
 * Decompiled with CFR 0.152.
 */
package com.daikit.graphql.builder.types;

import com.daikit.graphql.builder.GQLSchemaBuilderCache;
import com.daikit.graphql.builder.types.GQLAbstractTypesBuilder;
import com.daikit.graphql.constants.GQLSchemaConstants;
import graphql.Scalars;
import graphql.schema.GraphQLInputObjectField;
import graphql.schema.GraphQLInputObjectType;
import graphql.schema.GraphQLInputType;
import graphql.schema.GraphQLNonNull;
import graphql.schema.GraphQLType;
import org.apache.commons.lang3.StringUtils;

public class GQLQueryOrderByInputTypeBuilder
extends GQLAbstractTypesBuilder {
    public GQLQueryOrderByInputTypeBuilder(GQLSchemaBuilderCache cache) {
        super(cache);
    }

    public void buildOrderByInputType() {
        this.logger.debug("Build orderBy input type");
        this.getCache().setOrderByInputObjectType(this.buildOrderByInputObjectType());
    }

    private GraphQLInputObjectType buildOrderByInputObjectType() {
        GraphQLInputObjectType.Builder builder = GraphQLInputObjectType.newInputObject();
        builder.name(StringUtils.capitalize((String)"orderBy") + "InputType");
        builder.description("Sort configuration for returned list of objects.");
        GraphQLInputObjectField.Builder attributeFieldBuilder = GraphQLInputObjectField.newInputObjectField();
        attributeFieldBuilder.name("field");
        attributeFieldBuilder.description("The field in which to order objects by.");
        attributeFieldBuilder.type((GraphQLInputType)new GraphQLNonNull((GraphQLType)Scalars.GraphQLString));
        builder.field(attributeFieldBuilder.build());
        GraphQLInputObjectField.Builder directionFieldBuilder = GraphQLInputObjectField.newInputObjectField();
        directionFieldBuilder.name("direction");
        directionFieldBuilder.description("The direction in which to order objects by the specified field.");
        directionFieldBuilder.type((GraphQLInputType)this.getCache().getOrderByDirectionEnumType());
        directionFieldBuilder.defaultValue((Object)GQLSchemaConstants.ORDER_BY_DIRECTION_DEFAULT_VALUE);
        builder.field(directionFieldBuilder.build());
        return builder.build();
    }
}

