/*
 * Decompiled with CFR 0.152.
 */
package com.daikit.graphql.data.input;

import com.daikit.graphql.data.input.GQLFilterEntry;
import com.daikit.graphql.data.output.GQLOrderByEntry;
import com.daikit.graphql.dynamicattribute.IGQLDynamicAttributeFilter;
import com.daikit.graphql.enums.GQLFilterOperatorEnum;
import com.daikit.graphql.enums.GQLOrderByDirectionEnum;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class GQLListLoadConfig {
    private final List<GQLOrderByEntry> orderBy = new ArrayList<GQLOrderByEntry>();
    private final List<GQLFilterEntry> filters = new ArrayList<GQLFilterEntry>();
    private int limit = 0;
    private int offset = 0;

    public void setPaging(int limit, int offset) {
        this.setLimit(limit);
        this.setOffset(offset);
    }

    public void addOrderBys(Map<String, GQLOrderByDirectionEnum> orderBys) {
        for (Map.Entry<String, GQLOrderByDirectionEnum> entry : orderBys.entrySet()) {
            this.addOrderBy(entry.getKey(), entry.getValue());
        }
    }

    public void addOrderBy(String field, GQLOrderByDirectionEnum direction) {
        this.addOrReplace(new GQLOrderByEntry(field, direction));
    }

    public void addFilter(String field, GQLFilterOperatorEnum operator, Object value) {
        this.filters.add(new GQLFilterEntry(field, operator, value));
    }

    public void addFilter(String field, GQLFilterOperatorEnum operator, Object value, IGQLDynamicAttributeFilter<?, ?, ?> fieldFilter) {
        this.filters.add(new GQLFilterEntry(field, operator, value, fieldFilter));
    }

    public boolean isPaged() {
        return this.getLimit() > 0 || this.getOffset() > 0;
    }

    public boolean isOrdered() {
        return !this.getOrderBy().isEmpty();
    }

    protected void addOrReplace(GQLOrderByEntry order) {
        boolean removed = false;
        Iterator<GQLOrderByEntry> ordersIterator = this.orderBy.iterator();
        while (!removed && ordersIterator.hasNext()) {
            GQLOrderByEntry next = ordersIterator.next();
            if (!Objects.equals(order.getField(), next.getField())) continue;
            ordersIterator.remove();
            removed = true;
        }
        this.orderBy.add(order);
    }

    public List<GQLOrderByEntry> getOrderBy() {
        return this.orderBy;
    }

    public void setLimit(int limit) {
        this.limit = limit;
    }

    public int getLimit() {
        return this.limit;
    }

    public int getOffset() {
        return this.offset;
    }

    public void setOffset(int offset) {
        this.offset = offset;
    }
}

