/*
 * Decompiled with CFR 0.152.
 */
package com.daikit.graphql.datafetcher;

import com.daikit.graphql.constants.GQLSchemaConstants;
import com.daikit.graphql.data.input.GQLListLoadConfig;
import com.daikit.graphql.data.output.GQLListLoadResult;
import com.daikit.graphql.datafetcher.GQLAbstractDataFetcher;
import com.daikit.graphql.dynamicattribute.IGQLAbstractDynamicAttribute;
import com.daikit.graphql.dynamicattribute.IGQLDynamicAttributeFilter;
import com.daikit.graphql.enums.GQLFilterOperatorEnum;
import com.daikit.graphql.enums.GQLOrderByDirectionEnum;
import graphql.language.Argument;
import graphql.language.ArrayValue;
import graphql.language.Field;
import graphql.language.Node;
import graphql.language.ObjectField;
import graphql.language.ObjectValue;
import graphql.schema.DataFetchingEnvironment;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;

public abstract class GQLAbstractGetListDataFetcher
extends GQLAbstractDataFetcher<GQLListLoadResult> {
    private final Map<String, Map<String, IGQLDynamicAttributeFilter<?, ?, ?>>> dynamicAttributeFiltersMap = new HashMap();

    protected abstract GQLListLoadResult getAll(String var1, GQLListLoadConfig var2);

    protected abstract Object getById(String var1, String var2);

    public GQLAbstractGetListDataFetcher() {
    }

    public GQLAbstractGetListDataFetcher(Collection<IGQLDynamicAttributeFilter<?, ?, ?>> dynamicAttributeFilters) {
        Map<String, List<IGQLDynamicAttributeFilter>> map = dynamicAttributeFilters.stream().collect(Collectors.groupingBy(filter -> filter.getEntityType().getSimpleName()));
        map.entrySet().forEach(entry -> this.dynamicAttributeFiltersMap.put((String)entry.getKey(), ((List)entry.getValue()).stream().collect(Collectors.toMap(IGQLAbstractDynamicAttribute::getName, Function.identity()))));
    }

    public GQLListLoadResult get(DataFetchingEnvironment environment) {
        Optional<Argument> filterConfig;
        Optional<Argument> orderByConfig;
        GQLListLoadConfig listLoadConfig = this.createListLoadConfig();
        Map arguments = environment.getArguments();
        Field queryField = environment.getField();
        String entityName = this.getEntityName("getAll", queryField.getName());
        Map<String, IGQLDynamicAttributeFilter<?, ?, ?>> filters = this.dynamicAttributeFiltersMap.get(entityName);
        Optional<Argument> pagingConfig = queryField.getArguments().stream().filter(argument -> "paging".equals(argument.getName())).findFirst();
        if (pagingConfig.isPresent()) {
            Map<String, Object> contextArguments = this.getArgumentsForContext(arguments, pagingConfig.get().getName());
            Optional<ObjectField> limitField = ((ObjectValue)pagingConfig.get().getValue()).getObjectFields().stream().filter(field -> "limit".equals(field.getName())).findFirst();
            Optional<ObjectField> offsetField = ((ObjectValue)pagingConfig.get().getValue()).getObjectFields().stream().filter(field -> "offset".equals(field.getName())).findFirst();
            int limit = limitField.isPresent() ? (Integer)this.mapValue((ObjectField)limitField.get(), contextArguments) : 25;
            int offset = offsetField.isPresent() ? (Integer)this.mapValue(offsetField.get(), contextArguments) : 0;
            listLoadConfig.setPaging(limit, offset);
        }
        if ((orderByConfig = queryField.getArguments().stream().filter(argument -> "orderBy".equals(argument.getName())).findFirst()).isPresent()) {
            for (Node sortInfoNode : ((ArrayValue)orderByConfig.get().getValue()).getChildren()) {
                List<Map<String, Object>> subArgumentsList = this.getArgumentsForContextAsList(arguments, orderByConfig.get().getName());
                for (Map<String, Object> subArguments : subArgumentsList) {
                    Optional<ObjectField> fieldField = ((ObjectValue)sortInfoNode).getObjectFields().stream().filter(field -> "field".equals(field.getName())).findFirst();
                    Optional<ObjectField> directionField = ((ObjectValue)sortInfoNode).getObjectFields().stream().filter(field -> "direction".equals(field.getName())).findFirst();
                    String field2 = (String)this.mapValue(fieldField.get(), subArguments);
                    Object directionObj = this.mapValue(directionField.get(), subArguments);
                    GQLOrderByDirectionEnum direction = directionField.isPresent() ? (directionObj instanceof String ? GQLOrderByDirectionEnum.valueOf((String)directionObj) : (GQLOrderByDirectionEnum)((Object)directionObj)) : GQLSchemaConstants.ORDER_BY_DIRECTION_DEFAULT_VALUE;
                    listLoadConfig.addOrderBy(field2, direction);
                }
            }
        }
        if ((filterConfig = queryField.getArguments().stream().filter(argument -> "filter".equals(argument.getName())).findFirst()).isPresent()) {
            Map<String, Object> contextArguments = this.getArgumentsForContext(arguments, filterConfig.get().getName());
            for (ObjectField filterField : ((ObjectValue)filterConfig.get().getValue()).getObjectFields()) {
                Object value;
                GQLFilterOperatorEnum operator;
                String name = GQLSchemaConstants.removePropertyIdSuffix(filterField.getName());
                if (filterField.getValue() instanceof ObjectValue) {
                    Optional<ObjectField> operatorField = ((ObjectValue)filterField.getValue()).getObjectFields().stream().filter(field -> "operator".equals(field.getName())).findFirst();
                    Optional<ObjectField> optionalValueField = ((ObjectValue)filterField.getValue()).getObjectFields().stream().filter(field -> "value".equals(field.getName())).findFirst();
                    Map<String, Object> filterArguments = this.getArgumentsForContext(contextArguments, filterField.getName());
                    operator = GQLFilterOperatorEnum.forCode((String)this.mapValue(operatorField.get(), filterArguments));
                    value = optionalValueField.isPresent() ? this.mapValue(optionalValueField.get(), filterArguments) : null;
                } else {
                    operator = GQLFilterOperatorEnum.EQUAL;
                    value = this.getById(entityName, (String)this.mapValue(filterField, contextArguments));
                }
                IGQLDynamicAttributeFilter<?, ?, ?> filter = filters == null ? null : filters.get(name);
                listLoadConfig.addFilter(filter == null ? name : filter.getFilteredPropertyQueryPath(), operator, value, filter);
            }
        }
        return this.getAll(entityName, listLoadConfig);
    }

    protected GQLListLoadConfig createListLoadConfig() {
        return new GQLListLoadConfig();
    }
}

