/*
 * Decompiled with CFR 0.152.
 */
package com.daikit.graphql.datafetcher;

import com.daikit.graphql.utils.Message;
import graphql.language.Argument;
import graphql.language.ArrayValue;
import graphql.language.BooleanValue;
import graphql.language.EnumValue;
import graphql.language.Field;
import graphql.language.FloatValue;
import graphql.language.IntValue;
import graphql.language.ObjectField;
import graphql.language.ObjectValue;
import graphql.language.StringValue;
import graphql.language.Value;
import graphql.language.VariableReference;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;

public abstract class GQLDataFetcherUtils {
    public static String getEntityName(String prefix, String queryName) {
        if (!queryName.startsWith(prefix)) {
            throw new IllegalArgumentException(Message.format("Query name [{}] should start with [{}] prefix.", queryName, prefix));
        }
        return queryName.substring(prefix.length());
    }

    public static <T> T mapValue(ObjectField field, Map<String, Object> arguments, Collection<String> providedVariableNames) {
        return (T)GQLDataFetcherUtils.mapValue(field.getValue(), field.getName(), arguments, providedVariableNames);
    }

    public static <T> T mapValue(Argument argument, Map<String, Object> arguments, Collection<String> providedVariableNames) {
        return (T)GQLDataFetcherUtils.mapValue(argument.getValue(), argument.getName(), arguments, providedVariableNames);
    }

    public static Map<String, Object> getArgumentsForContext(Map<String, Object> arguments, String argumentContext) {
        return arguments.containsKey(argumentContext) ? (Map)arguments.get(argumentContext) : Collections.emptyMap();
    }

    public static List<Map<String, Object>> getArgumentsForContextAsList(Map<String, Object> arguments, String argumentContext) {
        return arguments.containsKey(argumentContext) ? (List)arguments.get(argumentContext) : Collections.emptyList();
    }

    public static Map<String, Object> convertObjectValue(ObjectValue objectValue, Map<String, Object> arguments, Collection<String> providedVariableNames) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        for (ObjectField objectField : objectValue.getObjectFields()) {
            if (objectField.getValue() instanceof ObjectValue) {
                map.put(objectField.getName(), GQLDataFetcherUtils.convertObjectValue((ObjectValue)objectField.getValue(), GQLDataFetcherUtils.getArgumentsForContext(arguments, objectField.getName()), providedVariableNames));
                continue;
            }
            Object value = GQLDataFetcherUtils.mapValue(objectField, arguments, providedVariableNames);
            if (value == null && (!(objectField.getValue() instanceof VariableReference) || !arguments.containsKey(objectField.getName())) && (objectField.getValue() instanceof VariableReference || providedVariableNames.contains(objectField.getName()))) continue;
            map.put(objectField.getName(), value);
        }
        Set propNames = map.keySet().stream().collect(Collectors.toSet());
        for (String propName : propNames) {
            String propNamePlural;
            if (!propName.endsWith("Ids") || !map.containsKey(propNamePlural = propName.substring(0, propName.length() - "Ids".length()) + "s")) continue;
            Object propValuePlural = map.get(propNamePlural);
            if (propValuePlural instanceof Collection && !((Collection)propValuePlural).isEmpty()) {
                map.remove(propName);
                continue;
            }
            Object propValueIds = map.get(propName);
            if (!(propValueIds instanceof Collection) || ((Collection)propValueIds).isEmpty()) continue;
            map.remove(propNamePlural);
        }
        return map;
    }

    public static Object getArgumentValue(Field queryField, String name, Map<String, Object> arguments, Collection<String> providedVariableNames) {
        Optional<Argument> argumentOpt = queryField.getArguments().stream().filter(argument -> name.equals(argument.getName())).findFirst();
        if (!argumentOpt.isPresent()) {
            throw new IllegalArgumentException(Message.format("Argument not found with name [{}]", name));
        }
        Object ret = GQLDataFetcherUtils.mapValue(argumentOpt.get(), arguments, providedVariableNames);
        return ret;
    }

    private static <X> X mapValue(Value<?> value, String argumentName, Map<String, Object> arguments, Collection<String> providedVariableNames) {
        Map<String, Object> mappedValue = null;
        if (value instanceof ArrayValue) {
            throw new IllegalArgumentException(Message.format("Unsupported value type [{}]", value));
        }
        if (value instanceof BooleanValue) {
            mappedValue = ((BooleanValue)value).isValue();
        } else if (value instanceof EnumValue) {
            mappedValue = ((EnumValue)value).getName();
        } else if (value instanceof FloatValue) {
            mappedValue = ((FloatValue)value).getValue().doubleValue();
        } else if (value instanceof IntValue) {
            mappedValue = ((IntValue)value).getValue().intValue();
        } else if (value instanceof StringValue) {
            mappedValue = ((StringValue)value).getValue();
        } else if (value instanceof VariableReference) {
            mappedValue = arguments.get(argumentName);
        } else if (value instanceof ObjectValue) {
            mappedValue = GQLDataFetcherUtils.convertObjectValue((ObjectValue)value, GQLDataFetcherUtils.getArgumentsForContext(arguments, argumentName), providedVariableNames);
        }
        return (X)mappedValue;
    }
}

